/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.omegat.core.data.EntryKey;
import org.omegat.util.Preferences;
import org.omegat.util.TMXProp;

public class NearString {
    public EntryKey key;
    public String source;
    public String translation;
    public MATCH_SOURCE comesFrom;
    public boolean fuzzyMark;
    public Scores[] scores;
    public byte[] attr;
    public String[] projs;
    public List<TMXProp> props;
    public String creator;
    public long creationDate;
    public String changer;
    public long changedDate;

    public NearString(EntryKey key, String source, String translation, MATCH_SOURCE comesFrom, boolean fuzzyMark, int nearScore, int nearScoreNoStem, int adjustedScore, byte[] nearData, String projName, String creator, long creationDate, String changer, long changedDate, List<TMXProp> props) {
        this.key = key;
        this.source = source;
        this.translation = translation;
        this.comesFrom = comesFrom;
        this.fuzzyMark = fuzzyMark;
        this.scores = new Scores[]{new Scores(nearScore, nearScoreNoStem, adjustedScore)};
        this.attr = nearData;
        this.projs = new String[]{projName == null ? "" : projName};
        this.props = props;
        this.creator = creator;
        this.creationDate = creationDate;
        this.changer = changer;
        this.changedDate = changedDate;
    }

    public static NearString merge(NearString ns, EntryKey key, String source, String translation, MATCH_SOURCE comesFrom, boolean fuzzyMark, int nearScore, int nearScoreNoStem, int adjustedScore, byte[] nearData, String projName, String creator, long creationDate, String changer, long changedDate, List<TMXProp> props) {
        ArrayList<String> projs = new ArrayList<String>();
        ArrayList<Object> scores = new ArrayList<Object>();
        for (String p : ns.projs) {
            projs.add(p);
        }
        for (Scores s : ns.scores) {
            scores.add(s);
        }
        if (nearScore > ns.scores[0].score) {
            projs.add(0, projName);
            NearString merged = new NearString(key, source, translation, comesFrom, fuzzyMark, nearScore, nearScoreNoStem, adjustedScore, nearData, null, creator, creationDate, changer, changedDate, props);
            scores.add(0, merged.scores[0]);
            merged.projs = projs.toArray(new String[projs.size()]);
            merged.scores = scores.toArray(new Scores[scores.size()]);
            return merged;
        }
        projs.add(projName);
        scores.add(new Scores(nearScore, nearScoreNoStem, adjustedScore));
        ns.projs = projs.toArray(new String[projs.size()]);
        ns.scores = scores.toArray(new Scores[scores.size()]);
        return ns;
    }

    public static class NearStringComparator
    implements Comparator<NearString> {
        private final SORT_KEY key;
        private final ScoresComparator c;

        public NearStringComparator() {
            this.key = Preferences.getPreferenceEnumDefault("ext_tmx_sort_key", SORT_KEY.SCORE);
            this.c = new ScoresComparator(this.key);
        }

        public NearStringComparator(SORT_KEY key) {
            this.key = key;
            this.c = new ScoresComparator(key);
        }

        @Override
        public int compare(NearString o1, NearString o2) {
            return this.c.compare(o1.scores[0], o2.scores[0]);
        }
    }

    public static class ScoresComparator
    implements Comparator<Scores> {
        private final SORT_KEY key;

        public ScoresComparator() {
            this.key = Preferences.getPreferenceEnumDefault("ext_tmx_sort_key", SORT_KEY.SCORE);
        }

        public ScoresComparator(SORT_KEY key) {
            this.key = key;
        }

        @Override
        public int compare(Scores o1, Scores o2) {
            int s2;
            int s1 = this.primaryScore(o1);
            if (s1 != (s2 = this.primaryScore(o2))) {
                return s1 > s2 ? 1 : -1;
            }
            s1 = this.secondaryScore(o1);
            if (s1 != (s2 = this.secondaryScore(o2))) {
                return s1 > s2 ? 1 : -1;
            }
            s1 = this.ternaryScore(o1);
            if (s1 != (s2 = this.ternaryScore(o2))) {
                return s1 > s2 ? 1 : -1;
            }
            return 0;
        }

        private int primaryScore(Scores s) {
            switch (this.key) {
                case SCORE: {
                    return s.score;
                }
                case SCORE_NO_STEM: {
                    return s.scoreNoStem;
                }
            }
            return s.adjustedScore;
        }

        private int secondaryScore(Scores s) {
            switch (this.key) {
                case SCORE: {
                    return s.scoreNoStem;
                }
                case SCORE_NO_STEM: {
                    return s.score;
                }
            }
            return s.score;
        }

        private int ternaryScore(Scores s) {
            switch (this.key) {
                case SCORE: {
                    return s.adjustedScore;
                }
                case SCORE_NO_STEM: {
                    return s.adjustedScore;
                }
            }
            return s.scoreNoStem;
        }
    }

    public static class Scores {
        public final int score;
        public final int scoreNoStem;
        public final int adjustedScore;

        public Scores(int score, int scoreNoStem, int adjustedScore) {
            this.score = score;
            this.scoreNoStem = scoreNoStem;
            this.adjustedScore = adjustedScore;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("(");
            b.append(this.score);
            b.append("/");
            b.append(this.scoreNoStem);
            b.append("/");
            b.append(this.adjustedScore);
            b.append("%)");
            return b.toString();
        }
    }

    public static enum SORT_KEY {
        SCORE,
        SCORE_NO_STEM,
        ADJUSTED_SCORE;

    }

    public static enum MATCH_SOURCE {
        MEMORY,
        TM,
        FILES;

    }
}

