/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.spellchecker;

import java.io.File;
import java.util.List;
import java.util.logging.Logger;
import org.dts.spell.SpellChecker;
import org.dts.spell.dictionary.OpenOfficeSpellDictionary;
import org.omegat.core.spellchecker.ISpellCheckerProvider;

public class SpellCheckerJMySpell
implements ISpellCheckerProvider {
    private static final Logger LOGGER = Logger.getLogger(SpellCheckerJMySpell.class.getName());
    private SpellChecker jmyspell;

    public SpellCheckerJMySpell(String language, String dictionaryName, String affixName) throws Exception {
        OpenOfficeSpellDictionary dict = new OpenOfficeSpellDictionary(new File(dictionaryName), new File(affixName), false);
        this.jmyspell = new SpellChecker(dict);
        this.jmyspell.setCaseSensitive(false);
        LOGGER.finer("Initialize SpellChecker by JMySpell for language '" + language + "' dictionary " + dictionaryName);
    }

    @Override
    public void destroy() {
        this.jmyspell = null;
    }

    @Override
    public boolean isCorrect(String word) {
        return this.jmyspell.isCorrect(word);
    }

    @Override
    public List<String> suggest(String word) {
        return this.jmyspell.getDictionary().getSuggestions(word, 20);
    }

    @Override
    public void learnWord(String word) {
    }
}

