/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.spellchecker;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Highlighter;
import org.omegat.core.Core;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.gui.editor.UnderlineFactory;
import org.omegat.gui.editor.mark.IMarker;
import org.omegat.gui.editor.mark.Mark;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.Token;
import org.omegat.util.gui.Styles;

public class SpellCheckerMarker
implements IMarker {
    protected static final Highlighter.HighlightPainter PAINTER = new UnderlineFactory.WaveUnderline(Styles.EditorColor.COLOR_SPELLCHECK.getColor());

    @Override
    public List<Mark> getMarksForEntry(SourceTextEntry ste, String sourceText, String translationText, boolean isActive) throws Exception {
        if (translationText == null) {
            return null;
        }
        if (!Core.getEditor().getSettings().isAutoSpellChecking()) {
            return null;
        }
        ArrayList<Mark> result = new ArrayList<Mark>();
        for (Token tok : Core.getProject().getTargetTokenizer().tokenizeWords(translationText, ITokenizer.StemmingMode.NONE)) {
            String word = tok.getTextFromString(translationText);
            if (Core.getSpellChecker().isCorrect(word)) continue;
            int st = tok.getOffset();
            int en = st + tok.getLength();
            Mark m = new Mark(Mark.ENTRY_PART.TRANSLATION, st, en);
            m.painter = PAINTER;
            result.add(m);
        }
        return result;
    }
}

