/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.hhc;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import org.htmlparser.Parser;
import org.htmlparser.util.ParserException;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.Instance;
import org.omegat.filters2.TranslationException;
import org.omegat.filters2.hhc.HHCFilterVisitor;
import org.omegat.filters2.html2.HTMLFilter2;
import org.omegat.util.OStrings;

public class HHCFilter2
extends HTMLFilter2 {
    @Override
    protected boolean requirePrevNextFields() {
        return true;
    }

    @Override
    public void processFile(BufferedReader infile, BufferedWriter outfile, FilterContext fc) throws IOException, TranslationException {
        StringBuilder all = null;
        try {
            all = new StringBuilder();
            char[] cbuf = new char[1000];
            int len = -1;
            while ((len = infile.read(cbuf)) > 0) {
                all.append(cbuf, 0, len);
            }
        }
        catch (OutOfMemoryError e) {
            all = null;
            System.gc();
            throw new IOException(OStrings.getString("HHC__FILE_TOO_BIG"));
        }
        Parser parser = new Parser();
        try {
            parser.setInputHTML(all.toString());
            parser.visitAllNodesWith(new HHCFilterVisitor(this, outfile));
        }
        catch (ParserException pe) {
            System.out.println(pe);
        }
    }

    @Override
    public String getFileFormatName() {
        return OStrings.getString("HHC__FILTER_NAME");
    }

    @Override
    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.hhc"), new Instance("*.hhk")};
    }

    @Override
    public String getHint() {
        return OStrings.getString("HHC_NOTE");
    }

    @Override
    public boolean hasOptions() {
        return false;
    }
}

