/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;
import org.omegat.util.gui.DockingUI;
import org.omegat.util.gui.StaticUIUtils;
import org.openide.awt.Mnemonics;

public class FontSelectionDialog
extends JDialog {
    public static final int RET_CANCEL_OR_UNCHANGED = 0;
    public static final int RET_OK_CHANGED = 1;
    private final Font oldFont;
    private JCheckBox applyToProjectFilesCheckBox;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JComboBox fontComboBox;
    private JLabel fontLabel;
    private JPanel jPanel1;
    private JButton okButton;
    private JTextArea previewTextArea;
    private JLabel sizeLabel;
    private JSpinner sizeSpinner;
    private int returnStatus = 0;

    public Font getSelectedFont() {
        return new Font((String)this.fontComboBox.getSelectedItem(), 0, ((Number)this.sizeSpinner.getValue()).intValue());
    }

    public FontSelectionDialog(Frame parent, Font font) {
        super(parent, true);
        StaticUIUtils.setEscapeClosable(this);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okButton);
        this.oldFont = font;
        this.previewTextArea.setFont(this.oldFont);
        this.fontComboBox.setSelectedItem(this.oldFont.getName());
        this.sizeSpinner.setValue(this.oldFont.getSize());
        this.applyToProjectFilesCheckBox.setSelected(Preferences.isPreference("project_files_use_font"));
        DockingUI.displayCentered(this);
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.fontComboBox = new JComboBox<String>(StaticUtils.getFontNames());
        this.fontLabel = new JLabel();
        this.sizeSpinner = new JSpinner();
        this.sizeLabel = new JLabel();
        this.previewTextArea = new JTextArea();
        this.jPanel1 = new JPanel();
        this.applyToProjectFilesCheckBox = new JCheckBox();
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setTitle(OStrings.getString("TF_SELECT_FONTS_TITLE"));
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                FontSelectionDialog.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.fontComboBox.setMaximumRowCount(20);
        this.fontComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontSelectionDialog.this.fontComboBoxActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.fontComboBox, gridBagConstraints);
        Mnemonics.setLocalizedText(this.fontLabel, OStrings.getString("TF_SELECT_SOURCE_FONT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.fontLabel, gridBagConstraints);
        this.sizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FontSelectionDialog.this.sizeSpinnerStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.sizeSpinner, gridBagConstraints);
        Mnemonics.setLocalizedText(this.sizeLabel, OStrings.getString("TF_SELECT_FONTSIZE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.sizeLabel, gridBagConstraints);
        this.previewTextArea.setEditable(false);
        this.previewTextArea.setLineWrap(true);
        this.previewTextArea.setText(OStrings.getString("TF_FONT_SAMPLE_TEXT"));
        this.previewTextArea.setWrapStyleWord(true);
        this.previewTextArea.setBorder(BorderFactory.createTitledBorder(null, OStrings.getString("TF_FONT_SAMPLE_TITLE"), 0, 0, this.fontLabel.getFont()));
        this.previewTextArea.setOpaque(false);
        this.previewTextArea.setPreferredSize(new Dimension(116, 100));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.previewTextArea, gridBagConstraints);
        this.jPanel1.setLayout(new FlowLayout(0));
        Mnemonics.setLocalizedText(this.applyToProjectFilesCheckBox, OStrings.getString("TF_APPLY_TO_PROJECT_FILES"));
        this.applyToProjectFilesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontSelectionDialog.this.applyToProjectFilesCheckBoxActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.applyToProjectFilesCheckBox);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.buttonPanel.setLayout(new FlowLayout(2));
        Mnemonics.setLocalizedText(this.okButton, OStrings.getString("BUTTON_OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontSelectionDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.okButton);
        Mnemonics.setLocalizedText(this.cancelButton, OStrings.getString("BUTTON_CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontSelectionDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.pack();
    }

    private void fontComboBoxActionPerformed(ActionEvent evt) {
        this.previewTextArea.setFont(this.getSelectedFont());
    }

    private void sizeSpinnerStateChanged(ChangeEvent evt) {
        this.previewTextArea.setFont(this.getSelectedFont());
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (!this.getSelectedFont().equals(this.oldFont) || this.applyToProjectFilesCheckBox.isSelected() != Preferences.isPreference("project_files_use_font")) {
            Preferences.setPreference("project_files_use_font", this.applyToProjectFilesCheckBox.isSelected());
            this.doClose(1);
        } else {
            this.doClose(0);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void applyToProjectFilesCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }
}

