/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor;

import java.awt.Color;
import javax.swing.text.AttributeSet;
import org.omegat.core.Core;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.spellchecker.SpellCheckerMarker;
import org.omegat.gui.editor.EditorController;
import org.omegat.util.Preferences;
import org.omegat.util.gui.Styles;
import org.omegat.util.gui.UIThreadsUtil;

public class EditorSettings {
    private final EditorController parent;
    private boolean useTabForAdvance;
    private boolean markTranslated;
    private boolean markUntranslated;
    private boolean markAutoPopulated;
    private boolean displaySegmentSources;
    private boolean markNonUniqueSegments;
    private boolean markNoted;
    private boolean markNBSP;
    private boolean markWhitespace;
    private boolean markBidi;
    private String displayModificationInfo;
    private boolean autoSpellChecking;
    private boolean viewSourceBold;
    private boolean markFirstNonUnique;
    private boolean doFontFallback;
    public static String DISPLAY_MODIFICATION_INFO_NONE = "none";
    public static String DISPLAY_MODIFICATION_INFO_SELECTED = "selected";
    public static String DISPLAY_MODIFICATION_INFO_ALL = "all";

    protected EditorSettings(EditorController parent) {
        this.parent = parent;
        this.useTabForAdvance = Preferences.isPreference("tab_advance");
        this.markTranslated = Preferences.isPreference("mark_translated_segments");
        this.markUntranslated = Preferences.isPreference("mark_untranslated_segments");
        this.displaySegmentSources = Preferences.isPreference("display_segment_sources");
        this.markNonUniqueSegments = Preferences.isPreference("mark_non_unique_segments");
        this.markNoted = Preferences.isPreference("mark_noted_segments");
        this.markNBSP = Preferences.isPreference("mark_nbsp");
        this.markWhitespace = Preferences.isPreference("mark_whitespace");
        this.markBidi = Preferences.isPreference("mark_bidi");
        this.displayModificationInfo = Preferences.getPreferenceDefault("display_modification_info", DISPLAY_MODIFICATION_INFO_NONE);
        this.autoSpellChecking = Preferences.isPreference("allow_auto_spellchecking");
        this.markAutoPopulated = Preferences.isPreference("mark_autopopulated");
        this.viewSourceBold = Preferences.isPreference("view_option_source_all_bold");
        this.markFirstNonUnique = Preferences.isPreference("view_option_unique_first");
        this.doFontFallback = Preferences.isPreference("font_fallback");
    }

    public char getAdvancerChar() {
        if (this.useTabForAdvance) {
            return '\t';
        }
        return '\n';
    }

    public boolean isUseTabForAdvance() {
        return this.useTabForAdvance;
    }

    public void setUseTabForAdvance(boolean useTabForAdvance) {
        this.useTabForAdvance = useTabForAdvance;
        Preferences.setPreference("tab_advance", useTabForAdvance);
    }

    public boolean isMarkTranslated() {
        return this.markTranslated;
    }

    public void setMarkTranslated(boolean markTranslated) {
        UIThreadsUtil.mustBeSwingThread();
        this.parent.commitAndDeactivate();
        this.markTranslated = markTranslated;
        Preferences.setPreference("mark_translated_segments", markTranslated);
        if (Core.getProject().isProjectLoaded()) {
            this.parent.loadDocument();
            this.parent.activateEntry();
        }
    }

    public boolean isMarkUntranslated() {
        return this.markUntranslated;
    }

    public boolean isMarkAutoPopulated() {
        return this.markAutoPopulated;
    }

    public void setMarkAutoPopulated(boolean val) {
        UIThreadsUtil.mustBeSwingThread();
        this.parent.commitAndDeactivate();
        this.markAutoPopulated = val;
        Preferences.setPreference("mark_autopopulated", this.markAutoPopulated);
        if (Core.getProject().isProjectLoaded()) {
            this.parent.loadDocument();
            this.parent.activateEntry();
        }
    }

    public void setMarkUntranslated(boolean markUntranslated) {
        UIThreadsUtil.mustBeSwingThread();
        this.parent.commitAndDeactivate();
        this.markUntranslated = markUntranslated;
        Preferences.setPreference("mark_untranslated_segments", markUntranslated);
        if (Core.getProject().isProjectLoaded()) {
            this.parent.loadDocument();
            this.parent.activateEntry();
        }
    }

    public boolean isDisplaySegmentSources() {
        return this.displaySegmentSources;
    }

    public boolean isMarkNonUniqueSegments() {
        return this.markNonUniqueSegments;
    }

    public boolean isHideDuplicateSegments() {
        return true;
    }

    public boolean isMarkNotedSegments() {
        return this.markNoted;
    }

    public boolean isMarkNBSP() {
        return this.markNBSP;
    }

    public boolean isMarkWhitespace() {
        return this.markWhitespace;
    }

    public boolean isMarkBidi() {
        return this.markBidi;
    }

    public boolean isDoFontFallback() {
        return this.doFontFallback;
    }

    public void setDisplaySegmentSources(boolean displaySegmentSources) {
        UIThreadsUtil.mustBeSwingThread();
        this.parent.commitAndDeactivate();
        this.displaySegmentSources = displaySegmentSources;
        Preferences.setPreference("display_segment_sources", displaySegmentSources);
        if (Core.getProject().isProjectLoaded()) {
            this.parent.loadDocument();
            this.parent.activateEntry();
        }
    }

    public void setMarkNonUniqueSegments(boolean markNonUniqueSegments) {
        UIThreadsUtil.mustBeSwingThread();
        this.parent.commitAndDeactivate();
        this.markNonUniqueSegments = markNonUniqueSegments;
        Preferences.setPreference("mark_non_unique_segments", markNonUniqueSegments);
        if (Core.getProject().isProjectLoaded()) {
            this.parent.loadDocument();
            this.parent.activateEntry();
        }
    }

    public void setMarkNotedSegments(boolean markNotedSegments) {
        UIThreadsUtil.mustBeSwingThread();
        this.parent.commitAndDeactivate();
        this.markNoted = markNotedSegments;
        Preferences.setPreference("mark_noted_segments", this.markNoted);
        if (Core.getProject().isProjectLoaded()) {
            this.parent.loadDocument();
            this.parent.activateEntry();
        }
    }

    public void setMarkNBSP(boolean markNBSP) {
        UIThreadsUtil.mustBeSwingThread();
        this.parent.commitAndDeactivate();
        this.markNBSP = markNBSP;
        Preferences.setPreference("mark_nbsp", markNBSP);
        if (Core.getProject().isProjectLoaded()) {
            this.parent.loadDocument();
            this.parent.activateEntry();
        }
    }

    public void setMarkWhitespace(boolean markWhitespace) {
        UIThreadsUtil.mustBeSwingThread();
        this.parent.commitAndDeactivate();
        this.markWhitespace = markWhitespace;
        Preferences.setPreference("mark_whitespace", markWhitespace);
        if (Core.getProject().isProjectLoaded()) {
            this.parent.loadDocument();
            this.parent.activateEntry();
        }
    }

    public void setMarkBidi(boolean markBidi) {
        UIThreadsUtil.mustBeSwingThread();
        this.parent.commitAndDeactivate();
        this.markBidi = markBidi;
        Preferences.setPreference("mark_bidi", markBidi);
        if (Core.getProject().isProjectLoaded()) {
            this.parent.loadDocument();
            this.parent.activateEntry();
        }
    }

    public void setDoFontFallback(boolean doFontFalback) {
        UIThreadsUtil.mustBeSwingThread();
        this.parent.commitAndDeactivate();
        this.doFontFallback = doFontFalback;
        Preferences.setPreference("font_fallback", doFontFalback);
        if (Core.getProject().isProjectLoaded()) {
            this.parent.loadDocument();
            this.parent.activateEntry();
        }
    }

    public String getDisplayModificationInfo() {
        return this.displayModificationInfo;
    }

    public void setDisplayModificationInfo(String displayModificationInfo) {
        UIThreadsUtil.mustBeSwingThread();
        this.parent.commitAndDeactivate();
        this.displayModificationInfo = displayModificationInfo;
        Preferences.setPreference("display_modification_info", displayModificationInfo);
        if (Core.getProject().isProjectLoaded()) {
            this.parent.loadDocument();
            this.parent.activateEntry();
        }
    }

    public boolean isAutoSpellChecking() {
        return this.autoSpellChecking;
    }

    public void setAutoSpellChecking(boolean autoSpellChecking) {
        UIThreadsUtil.mustBeSwingThread();
        if (Core.getProject().isProjectLoaded()) {
            this.parent.commitAndDeactivate();
        }
        this.autoSpellChecking = autoSpellChecking;
        if (Core.getProject().isProjectLoaded()) {
            this.parent.activateEntry();
            this.parent.remarkOneMarker(SpellCheckerMarker.class.getName());
        }
    }

    public void updateViewPreferences() {
        UIThreadsUtil.mustBeSwingThread();
        this.parent.commitAndDeactivate();
        this.viewSourceBold = Preferences.isPreference("view_option_source_all_bold");
        this.markFirstNonUnique = Preferences.isPreference("view_option_unique_first");
        if (Core.getProject().isProjectLoaded()) {
            this.parent.loadDocument();
            this.parent.activateEntry();
        }
    }

    public void updateTagValidationPreferences() {
        UIThreadsUtil.mustBeSwingThread();
        this.parent.commitAndDeactivate();
        if (Core.getProject().isProjectLoaded()) {
            this.parent.loadDocument();
            this.parent.activateEntry();
        }
    }

    public AttributeSet getAttributeSet(boolean isSource, boolean isPlaceholder, boolean isRemoveText, SourceTextEntry.DUPLICATE duplicate, boolean active, boolean translationExists, boolean hasNote, boolean isNBSP) {
        Color fg = null;
        if (active) {
            fg = isSource ? Styles.EditorColor.COLOR_ACTIVE_SOURCE_FG.getColor() : Styles.EditorColor.COLOR_ACTIVE_TARGET_FG.getColor();
        } else if (isSource) {
            if (this.isMarkNotedSegments() && hasNote && !translationExists) {
                fg = Styles.EditorColor.COLOR_NOTED_FG.getColor();
            } else if (this.markUntranslated && !translationExists) {
                fg = Styles.EditorColor.COLOR_UNTRANSLATED_FG.getColor();
            } else if (this.isDisplaySegmentSources()) {
                fg = Styles.EditorColor.COLOR_SOURCE_FG.getColor();
            }
        } else if (this.isMarkNotedSegments() && hasNote) {
            fg = Styles.EditorColor.COLOR_NOTED_FG.getColor();
        } else if (this.markTranslated) {
            fg = Styles.EditorColor.COLOR_TRANSLATED_FG.getColor();
        }
        if (this.markNonUniqueSegments) {
            switch (duplicate) {
                case NONE: {
                    break;
                }
                case FIRST: {
                    if (!this.markFirstNonUnique) break;
                    fg = Styles.EditorColor.COLOR_NON_UNIQUE.getColor();
                    break;
                }
                case NEXT: {
                    fg = Styles.EditorColor.COLOR_NON_UNIQUE.getColor();
                }
            }
        }
        if (isPlaceholder) {
            fg = Styles.EditorColor.COLOR_PLACEHOLDER.getColor();
        }
        if (isRemoveText && !isSource) {
            fg = Styles.EditorColor.COLOR_REMOVETEXT_TARGET.getColor();
        }
        Color bg = null;
        if (active) {
            bg = isSource ? Styles.EditorColor.COLOR_ACTIVE_SOURCE.getColor() : Styles.EditorColor.COLOR_ACTIVE_TARGET.getColor();
        } else if (isSource) {
            if (this.isMarkNotedSegments() && hasNote && !translationExists) {
                bg = Styles.EditorColor.COLOR_NOTED.getColor();
            } else if (this.markUntranslated && !translationExists) {
                bg = Styles.EditorColor.COLOR_UNTRANSLATED.getColor();
            } else if (this.isDisplaySegmentSources()) {
                bg = Styles.EditorColor.COLOR_SOURCE.getColor();
            }
        } else if (this.isMarkNotedSegments() && hasNote) {
            bg = Styles.EditorColor.COLOR_NOTED.getColor();
        } else if (this.markTranslated) {
            bg = Styles.EditorColor.COLOR_TRANSLATED.getColor();
        }
        Color nonUniqueBg = Styles.EditorColor.COLOR_NON_UNIQUE_BG.getColor();
        if (this.markNonUniqueSegments && nonUniqueBg != null) {
            switch (duplicate) {
                case NONE: {
                    break;
                }
                case FIRST: {
                    if (!this.markFirstNonUnique) break;
                    bg = nonUniqueBg;
                    break;
                }
                case NEXT: {
                    bg = nonUniqueBg;
                }
            }
        }
        if (isNBSP && this.isMarkNBSP()) {
            bg = Styles.EditorColor.COLOR_NBSP.getColor();
        }
        Boolean bold = false;
        if (isSource && (active || this.viewSourceBold && this.isDisplaySegmentSources())) {
            bold = true;
        }
        Boolean italic = false;
        if (isRemoveText && isSource) {
            italic = true;
        }
        return Styles.createAttributeSet(fg, bg, bold, italic);
    }

    public AttributeSet getModificationInfoAttributeSet() {
        return Styles.createAttributeSet(Styles.EditorColor.COLOR_MOD_INFO_FG.getColor(), Styles.EditorColor.COLOR_MOD_INFO.getColor(), false, true);
    }

    public AttributeSet getSegmentMarkerAttributeSet() {
        return Styles.createAttributeSet(Styles.EditorColor.COLOR_SEGMENT_MARKER_FG.getColor(), Styles.EditorColor.COLOR_SEGMENT_MARKER_BG.getColor(), true, false);
    }

    public AttributeSet getOtherLanguageTranslationAttributeSet() {
        return Styles.createAttributeSet(Styles.EditorColor.COLOR_SOURCE_FG.getColor(), Styles.EditorColor.COLOR_SOURCE.getColor(), false, true);
    }
}

