/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor;

import java.awt.Cursor;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.JPopupMenu;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.ProtectedPart;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.gui.editor.Document3;
import org.omegat.gui.editor.EditorController;
import org.omegat.gui.editor.EditorUtils;
import org.omegat.gui.editor.IPopupMenuConstructor;
import org.omegat.gui.editor.SegmentBuilder;
import org.omegat.gui.editor.TranslationUndoManager;
import org.omegat.gui.editor.ViewLabel;
import org.omegat.gui.editor.ViewParagraph;
import org.omegat.gui.editor.autocompleter.AutoCompleter;
import org.omegat.gui.main.IMainWindow;
import org.omegat.gui.main.MainWindow;
import org.omegat.util.Platform;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.DockingUI;

public class EditorTextArea3
extends JEditorPane {
    protected final TranslationUndoManager undoManager = new TranslationUndoManager(this);
    protected final EditorController controller;
    protected final List<PopupMenuConstructorInfo> popupConstructors = new ArrayList<PopupMenuConstructorInfo>();
    protected String currentWord;
    protected AutoCompleter autoCompleter = new AutoCompleter(this);
    protected MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            JPopupMenu popup;
            int mousepos;
            EditorTextArea3.this.autoCompleter.setVisible(false);
            if (e.getButton() == 1 && e.getClickCount() == 2) {
                mousepos = EditorTextArea3.this.viewToModel(e.getPoint());
                boolean changed = EditorTextArea3.this.controller.goToSegmentAtLocation(EditorTextArea3.this.getCaretPosition());
                if (!changed && EditorTextArea3.this.selectTag(mousepos)) {
                    e.consume();
                }
            }
            if ((e.isPopupTrigger() || e.getButton() == 3) && (popup = EditorTextArea3.this.makePopupMenu(mousepos = EditorTextArea3.this.viewToModel(e.getPoint()))).getComponentCount() > 0) {
                popup.show(EditorTextArea3.this, (int)e.getPoint().getX(), (int)e.getPoint().getY());
            }
        }
    };
    public static ViewFactory factory3 = new ViewFactory(){

        @Override
        public View create(Element elem) {
            String kind = elem.getName();
            if (kind != null) {
                if (kind.equals("content")) {
                    return new ViewLabel(elem);
                }
                if (kind.equals("paragraph")) {
                    return new ViewParagraph(elem);
                }
                if (kind.equals("section")) {
                    return new BoxView(elem, 1);
                }
                if (kind.equals("component")) {
                    return new ComponentView(elem);
                }
                if (kind.equals("icon")) {
                    return new IconView(elem);
                }
            }
            return new ViewLabel(elem);
        }
    };

    public EditorTextArea3(EditorController controller) {
        this.controller = controller;
        this.setEditorKit(new StyledEditorKit(){

            @Override
            public ViewFactory getViewFactory() {
                return factory3;
            }

            @Override
            protected void createInputAttributes(Element element, MutableAttributeSet set) {
                set.removeAttributes(set);
                EditorController c = EditorTextArea3.this.controller;
                try {
                    c.m_docSegList[c.displayedEntryIndex].createInputAttributes(element, set);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        });
        this.addMouseListener(this.mouseListener);
        this.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                try {
                    int start = EditorUtils.getWordStart(EditorTextArea3.this, e.getMark());
                    int end = EditorUtils.getWordEnd(EditorTextArea3.this, e.getMark());
                    if (end - start <= 0) {
                        return;
                    }
                    String newWord = EditorTextArea3.this.getText(start, end - start);
                    if (!newWord.equals(EditorTextArea3.this.currentWord)) {
                        EditorTextArea3.this.currentWord = newWord;
                        CoreEvents.fireEditorNewWord(newWord);
                    }
                }
                catch (BadLocationException ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.setToolTipText("");
        this.setDragEnabled(true);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        Document3 doc = this.getOmDocument();
        if (doc != null) {
            doc.setFont(font);
        }
    }

    public Document3 getOmDocument() {
        try {
            return (Document3)this.getDocument();
        }
        catch (ClassCastException ex) {
            return null;
        }
    }

    public boolean isInActiveTranslation(int position) {
        return position >= this.getOmDocument().getTranslationStart() && position <= this.getOmDocument().getTranslationEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JPopupMenu makePopupMenu(int pos) {
        PopupMenuConstructorInfo[] cons;
        List<PopupMenuConstructorInfo> list = this.popupConstructors;
        synchronized (list) {
            cons = this.popupConstructors.toArray(new PopupMenuConstructorInfo[this.popupConstructors.size()]);
        }
        int ae = this.controller.displayedEntryIndex;
        SegmentBuilder sb = this.controller.m_docSegList[ae];
        boolean isInActiveEntry = sb.isActive() ? pos >= sb.getStartPosition() && pos <= sb.getEndPosition() : false;
        JPopupMenu popup = new JPopupMenu();
        for (PopupMenuConstructorInfo c : cons) {
            c.constructor.addItems(popup, this, pos, isInActiveEntry, this.isInActiveTranslation(pos), sb);
        }
        DockingUI.removeUnusedMenuSeparators(popup);
        return popup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerPopupMenuConstructors(int priority, IPopupMenuConstructor constructor) {
        List<PopupMenuConstructorInfo> list = this.popupConstructors;
        synchronized (list) {
            this.popupConstructors.add(new PopupMenuConstructorInfo(priority, constructor));
            Collections.sort(this.popupConstructors, new Comparator<PopupMenuConstructorInfo>(){

                @Override
                public int compare(PopupMenuConstructorInfo o1, PopupMenuConstructorInfo o2) {
                    return o1.priority - o2.priority;
                }
            });
        }
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        int keyEvent = e.getID();
        if (keyEvent == 402) {
            super.processKeyEvent(e);
            return;
        }
        if (keyEvent == 400) {
            super.processKeyEvent(e);
            return;
        }
        boolean processed = false;
        boolean mac = Platform.isMacOSX();
        Document3 doc = this.getOmDocument();
        if (this.autoCompleter.processKeys(e)) {
            processed = true;
        } else if (StaticUtils.isKey(e, 525, 0) || mac && StaticUtils.isKey(e, 27, 1)) {
            JPopupMenu popup = this.makePopupMenu(this.getCaretPosition());
            if (popup.getComponentCount() > 0) {
                popup.show(this, (int)this.getCaret().getMagicCaretPosition().getX(), (int)this.getCaret().getMagicCaretPosition().getY());
                processed = true;
            }
        } else if (StaticUtils.isKey(e, 9, 0)) {
            if (this.controller.settings.isUseTabForAdvance()) {
                this.controller.nextEntry();
                processed = true;
            }
        } else if (StaticUtils.isKey(e, 9, 1)) {
            if (this.controller.settings.isUseTabForAdvance()) {
                this.controller.prevEntry();
                processed = true;
            }
        } else if (StaticUtils.isKey(e, 10, 0)) {
            if (!this.controller.settings.isUseTabForAdvance()) {
                this.controller.nextEntry();
                processed = true;
            } else {
                IMainWindow mainWindow = Core.getMainWindow();
                if (mainWindow instanceof MainWindow) {
                    MainWindow window = (MainWindow)mainWindow;
                    window.showTimedStatusMessageRB("ETA_WARNING_TAB_ADVANCE", new Object[0]);
                }
                processed = true;
            }
        } else if (StaticUtils.isKey(e, 10, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())) {
            if (!this.controller.settings.isUseTabForAdvance()) {
                this.controller.prevEntry();
                processed = true;
            }
        } else if (StaticUtils.isKey(e, 10, 1)) {
            KeyEvent ke = new KeyEvent(e.getComponent(), e.getID(), e.getWhen(), 0, 10, '\n');
            super.processKeyEvent(ke);
            processed = true;
        } else if (StaticUtils.isKey(e, 65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())) {
            this.setSelectionStart(doc.getTranslationStart());
            this.setSelectionEnd(doc.getTranslationEnd());
            processed = true;
        } else if (StaticUtils.isKey(e, 79, 3)) {
            Cursor oldCursor = this.getCursor();
            this.setCursor(new Cursor(3));
            this.controller.toggleOrientation();
            this.setCursor(oldCursor);
            IMainWindow mainWindow = Core.getMainWindow();
            if (mainWindow instanceof MainWindow) {
                MainWindow window = (MainWindow)mainWindow;
                window.showTimedStatusMessageRB("ETA_INFO_TOGGLE_LTR_RTL", new Object[0]);
            }
            processed = true;
        } else if (StaticUtils.isKey(e, 8, mac ? 8 : 2)) {
            try {
                processed = this.wholeTagDelete(false);
                if (!processed) {
                    int offset = this.getCaretPosition();
                    int prevWord = Utilities.getPreviousWord(this, offset);
                    int c = Math.max(prevWord, doc.getTranslationStart());
                    this.setSelectionStart(c);
                    this.setSelectionEnd(offset);
                    this.replaceSelection("");
                    processed = true;
                }
            }
            catch (BadLocationException ex) {}
        } else if (StaticUtils.isKey(e, 127, mac ? 8 : 2)) {
            try {
                processed = this.wholeTagDelete(true);
                if (!processed) {
                    int offset = this.getCaretPosition();
                    int nextWord = Utilities.getNextWord(this, offset);
                    int c = Math.min(nextWord, doc.getTranslationEnd());
                    this.setSelectionStart(offset);
                    this.setSelectionEnd(c);
                    this.replaceSelection("");
                    processed = true;
                }
            }
            catch (BadLocationException ex) {}
        } else if (StaticUtils.isKey(e, 33, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())) {
            this.setCaretPosition(0);
            processed = true;
        } else if (StaticUtils.isKey(e, 34, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())) {
            this.setCaretPosition(this.getOmDocument().getLength());
            processed = true;
        } else if (StaticUtils.isKey(e, 37, mac ? 8 : 2) || StaticUtils.isKey(e, 37, (mac ? 8 : 2) | 1)) {
            processed = this.moveCursorOverTag((e.getModifiers() & 1) != 0, false);
        } else if (StaticUtils.isKey(e, 39, mac ? 8 : 2) || StaticUtils.isKey(e, 39, (mac ? 8 : 2) | 1)) {
            processed = this.moveCursorOverTag((e.getModifiers() & 1) != 0, true);
        }
        if (processed) {
            e.consume();
        } else {
            if ((e.getModifiers() & 0xE) == 0 && e.getKeyCode() != 16) {
                this.checkAndFixCaret();
            }
            super.processKeyEvent(e);
        }
        if (!processed && e.getKeyChar() != '\u0000') {
            switch (e.getKeyCode()) {
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 224: 
                case 225: 
                case 226: 
                case 227: {
                    this.checkAndFixCaret();
                    this.autoCompleter.updatePopup();
                }
            }
        }
    }

    boolean moveCursorOverTag(boolean withShift, boolean checkTagStart) {
        Document3 doc = this.getOmDocument();
        SourceTextEntry ste = doc.controller.getCurrentEntry();
        String text = doc.extractTranslation();
        int off = this.getCaretPosition() - doc.getTranslationStart();
        if (ste != null) {
            for (ProtectedPart pp : ste.getProtectedParts()) {
                if (checkTagStart) {
                    if (!StringUtil.isSubstringAfter(text, off, pp.getTextInSourceSegment())) continue;
                    int pos = off + doc.getTranslationStart() + pp.getTextInSourceSegment().length();
                    if (withShift) {
                        this.getCaret().moveDot(pos);
                    } else {
                        this.getCaret().setDot(pos);
                    }
                    return true;
                }
                if (!StringUtil.isSubstringBefore(text, off, pp.getTextInSourceSegment())) continue;
                int pos = off + doc.getTranslationStart() - pp.getTextInSourceSegment().length();
                if (withShift) {
                    this.getCaret().moveDot(pos);
                } else {
                    this.getCaret().setDot(pos);
                }
                return true;
            }
        }
        return false;
    }

    boolean wholeTagDelete(boolean checkTagStart) throws BadLocationException {
        Document3 doc = this.getOmDocument();
        SourceTextEntry ste = doc.controller.getCurrentEntry();
        String text = doc.extractTranslation();
        int off = this.getCaretPosition() - doc.getTranslationStart();
        if (ste != null) {
            for (ProtectedPart pp : ste.getProtectedParts()) {
                if (checkTagStart) {
                    if (!StringUtil.isSubstringAfter(text, off, pp.getTextInSourceSegment())) continue;
                    int pos = off + doc.getTranslationStart();
                    doc.remove(pos, pp.getTextInSourceSegment().length());
                    return true;
                }
                if (!StringUtil.isSubstringBefore(text, off, pp.getTextInSourceSegment())) continue;
                int pos = off + doc.getTranslationStart() - pp.getTextInSourceSegment().length();
                doc.remove(pos, pp.getTextInSourceSegment().length());
                return true;
            }
        }
        return false;
    }

    boolean selectTag(int pos) {
        int s = this.controller.getSegmentIndexAtLocation(pos);
        if (s < 0) {
            return false;
        }
        SegmentBuilder segment = this.controller.m_docSegList[s];
        if (pos < segment.getStartPosition() || pos >= segment.getEndPosition()) {
            return false;
        }
        SourceTextEntry ste = this.getOmDocument().controller.getCurrentEntry();
        if (ste != null) {
            try {
                String text = this.getOmDocument().getText(segment.getStartPosition(), segment.getEndPosition() - segment.getStartPosition());
                int off = pos - segment.getStartPosition();
                if (off < 0 || off >= text.length()) {
                    return false;
                }
                for (ProtectedPart pp : ste.getProtectedParts()) {
                    int p = -1;
                    while ((p = text.indexOf(pp.getTextInSourceSegment(), p + 1)) >= 0) {
                        if (p > off || off >= p + pp.getTextInSourceSegment().length()) continue;
                        this.select(p += segment.getStartPosition(), p + pp.getTextInSourceSegment().length());
                        return true;
                    }
                }
            }
            catch (BadLocationException ex) {
                // empty catch block
            }
        }
        return false;
    }

    void setCaretUpdateEnabled(boolean updateEnabled) {
        DefaultCaret caret = (DefaultCaret)this.getCaret();
        caret.setUpdatePolicy(updateEnabled ? 0 : 1);
    }

    void checkAndFixCaret() {
        Document3 doc = this.getOmDocument();
        if (doc == null) {
            return;
        }
        if (!doc.isEditMode()) {
            return;
        }
        int spos = this.getSelectionStart();
        int epos = this.getSelectionEnd();
        int start = doc.getTranslationStart();
        int end = doc.getTranslationEnd();
        if (spos != epos) {
            if (spos < start) {
                this.fixSelectionStart(start);
            } else if (spos > end) {
                this.fixSelectionStart(end);
            }
            if (epos > end) {
                this.fixSelectionEnd(end);
            } else if (epos < start) {
                this.fixSelectionStart(start);
            }
        } else if (spos < start) {
            this.setCaretPosition(start);
        } else if (spos > end) {
            this.setCaretPosition(end);
        }
    }

    private void fixSelectionStart(int start) {
        if (this.getCaretPosition() <= start) {
            this.setCaretPosition(this.getSelectionEnd());
            this.moveCaretPosition(start);
        } else {
            this.setSelectionStart(start);
        }
    }

    private void fixSelectionEnd(int end) {
        this.setSelectionEnd(end);
    }

    @Override
    public void paste() {
        this.checkAndFixCaret();
        super.paste();
    }

    @Override
    public void cut() {
        this.checkAndFixCaret();
        super.cut();
    }

    @Override
    public String getSelectedText() {
        String st = super.getSelectedText();
        return st != null ? EditorUtils.removeDirectionChars(st) : null;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        int pos = this.viewToModel(event.getPoint());
        int s = this.controller.getSegmentIndexAtLocation(pos);
        return this.controller.markerController.getToolTips(s, pos);
    }

    private static class PopupMenuConstructorInfo {
        final int priority;
        final IPopupMenuConstructor constructor;

        public PopupMenuConstructorInfo(int priority, IPopupMenuConstructor constructor) {
            this.priority = priority;
            this.constructor = constructor;
        }
    }
}

