/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor.autotext;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.omegat.gui.editor.autotext.AutotextPair;
import org.omegat.util.StaticUtils;

public class Autotext {
    private List<AutotextPair> list = new ArrayList<AutotextPair>();

    public Autotext(String name) {
        if (name != null) {
            this.load(name);
        }
    }

    public List<AutotextPair> getList() {
        return this.list;
    }

    public void processLine(String thisLine) {
        if (thisLine == null || thisLine.isEmpty() || thisLine.trim().isEmpty()) {
            return;
        }
        String[] parts = thisLine.split("\t");
        if (parts.length == 2) {
            this.list.add(new AutotextPair(parts[0], parts[1], ""));
        }
        if (parts.length == 3) {
            this.list.add(new AutotextPair(parts[0], parts[1], parts[2]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String fileName) {
        this.list.clear();
        BufferedReader br = null;
        try {
            String thisLine;
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "UTF-8"));
            while ((thisLine = br.readLine()) != null) {
                this.processLine(thisLine);
            }
        }
        catch (FileNotFoundException ex) {
        }
        catch (IOException ex) {
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    public void save(String filename) throws IOException {
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "UTF-8"));
        StringBuilder builder = new StringBuilder();
        for (AutotextPair pair : this.list) {
            builder.replace(0, builder.length(), "");
            builder.append(pair.source).append("\t");
            builder.append(pair.target).append("\t");
            builder.append(pair.comment).append("\n");
            out.write(builder.toString());
        }
        out.close();
    }

    public void save() throws IOException {
        this.save(StaticUtils.getConfigDir() + "omegat.autotext");
    }
}

