/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor.mark;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.Highlighter;
import org.omegat.core.Core;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.gui.editor.mark.IMarker;
import org.omegat.gui.editor.mark.Mark;

public abstract class AbstractMarker
implements IMarker {
    protected Highlighter.HighlightPainter PAINTER;
    protected String toolTip;
    protected AttributeSet ATTRIBUTES;
    protected Pattern pattern;
    protected int patternChar;

    protected abstract boolean isEnabled();

    @Override
    public List<Mark> getMarksForEntry(SourceTextEntry ste, String sourceText, String translationText, boolean isActive) throws Exception {
        Mark m;
        int next;
        Matcher match;
        if (!this.isEnabled()) {
            return null;
        }
        if (this.pattern == null && this.patternChar == 0) {
            return null;
        }
        ArrayList<Mark> r = new ArrayList<Mark>();
        if (isActive || Core.getEditor().getSettings().isDisplaySegmentSources() || translationText == null) {
            this.initDrawers(true, isActive);
            if (this.pattern != null) {
                match = this.pattern.matcher(sourceText);
                while (match.find()) {
                    Mark m2 = new Mark(Mark.ENTRY_PART.SOURCE, match.start(), match.end());
                    m2.painter = this.PAINTER;
                    m2.toolTipText = this.toolTip;
                    m2.attributes = this.ATTRIBUTES;
                    r.add(m2);
                }
            }
            if (this.patternChar != 0) {
                int pos = 0;
                while ((pos = sourceText.indexOf(this.patternChar, pos)) >= 0) {
                    next = sourceText.offsetByCodePoints(pos, 1);
                    m = new Mark(Mark.ENTRY_PART.SOURCE, pos, next);
                    m.painter = this.PAINTER;
                    m.toolTipText = this.toolTip;
                    m.attributes = this.ATTRIBUTES;
                    r.add(m);
                    pos = next;
                }
            }
        }
        if (translationText != null) {
            this.initDrawers(false, isActive);
            if (this.pattern != null) {
                match = this.pattern.matcher(translationText);
                while (match.find()) {
                    Mark m3 = new Mark(Mark.ENTRY_PART.TRANSLATION, match.start(), match.end());
                    m3.painter = this.PAINTER;
                    m3.toolTipText = this.toolTip;
                    m3.attributes = this.ATTRIBUTES;
                    r.add(m3);
                }
            }
            if (this.patternChar != 0) {
                int pos = 0;
                while ((pos = translationText.indexOf(this.patternChar, pos)) >= 0) {
                    next = translationText.offsetByCodePoints(pos, 1);
                    m = new Mark(Mark.ENTRY_PART.TRANSLATION, pos, next);
                    m.painter = this.PAINTER;
                    m.toolTipText = this.toolTip;
                    m.attributes = this.ATTRIBUTES;
                    r.add(m);
                    pos = next;
                }
            }
        }
        return r;
    }

    protected void initDrawers(boolean isSource, boolean isActive) {
    }
}

