/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.exttrans;

import java.awt.Dimension;
import java.util.ArrayList;
import org.omegat.core.Core;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.filters2.master.PluginUtils;
import org.omegat.gui.common.EntryInfoSearchThread;
import org.omegat.gui.common.EntryInfoThreadPane;
import org.omegat.gui.exttrans.IMachineTranslation;
import org.omegat.gui.exttrans.MachineTranslationInfo;
import org.omegat.gui.main.DockableScrollPane;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.gui.AlwaysVisibleCaret;
import org.omegat.util.gui.UIThreadsUtil;

public class MachineTranslateTextArea
extends EntryInfoThreadPane<MachineTranslationInfo> {
    private static final String EXPLANATION = OStrings.getString("GUI_MACHINETRANSLATESWINDOW_explanation");
    protected final IMachineTranslation[] translators;
    protected String displayed;

    public MachineTranslateTextArea() {
        super(true);
        this.setEditable(false);
        AlwaysVisibleCaret.apply(this);
        this.setText(EXPLANATION);
        this.setMinimumSize(new Dimension(100, 50));
        String title = OStrings.getString("GUI_MATCHWINDOW_SUBWINDOWTITLE_MachineTranslate");
        Core.getMainWindow().addDockable(new DockableScrollPane("MACHINE_TRANSLATE", title, this, true));
        ArrayList<IMachineTranslation> tr = new ArrayList<IMachineTranslation>();
        for (Class<?> mtc : PluginUtils.getMachineTranslationClasses()) {
            try {
                tr.add((IMachineTranslation)mtc.newInstance());
            }
            catch (Exception ex) {
                Log.log(ex);
            }
        }
        this.translators = tr.toArray(new IMachineTranslation[tr.size()]);
    }

    public String getDisplayedTranslation() {
        return this.displayed;
    }

    @Override
    protected void onProjectClose() {
        UIThreadsUtil.mustBeSwingThread();
        this.setText(EXPLANATION);
    }

    public void forceLoad() {
        this.startSearchThread(this.currentlyProcessedEntry, true);
    }

    @Override
    protected void startSearchThread(SourceTextEntry newEntry) {
        this.startSearchThread(newEntry, false);
    }

    private void startSearchThread(SourceTextEntry newEntry, boolean force) {
        UIThreadsUtil.mustBeSwingThread();
        this.clear();
        for (IMachineTranslation mt : this.translators) {
            if (!mt.isEnabled()) continue;
            new FindThread(mt, newEntry, force).start();
        }
    }

    @Override
    protected void setFoundResult(SourceTextEntry se, MachineTranslationInfo data) {
        UIThreadsUtil.mustBeSwingThread();
        if (data != null && data.result != null) {
            if (this.displayed == null) {
                this.displayed = data.result;
            }
            this.setText(this.getText() + data.result + "\n<" + data.translatorName + ">\n\n");
        }
    }

    private void clear() {
        this.setText("");
        this.displayed = null;
    }

    protected class FindThread
    extends EntryInfoSearchThread<MachineTranslationInfo> {
        private final IMachineTranslation translator;
        private final String src;
        private final boolean force;

        public FindThread(IMachineTranslation translator, SourceTextEntry newEntry, boolean force) {
            super(MachineTranslateTextArea.this, newEntry);
            this.translator = translator;
            this.src = newEntry.getSrcText();
            this.force = force;
        }

        @Override
        protected MachineTranslationInfo search() throws Exception {
            Language source = null;
            Language target = null;
            ProjectProperties pp = Core.getProject().getProjectProperties();
            if (pp != null) {
                source = pp.getSourceLanguage();
                target = pp.getTargetLanguage();
            }
            if (source == null || target == null) {
                return null;
            }
            String result = this.getTranslation(source, target);
            return result == null ? null : new MachineTranslationInfo(this.translator.getName(), result);
        }

        private String getTranslation(Language source, Language target) throws Exception {
            if (!this.force) {
                TMXEntry entry;
                if (!Preferences.isPreferenceDefault("mt_auto_fetch", true)) {
                    return this.translator.getCachedTranslation(source, target, this.src);
                }
                if (Preferences.isPreference("mt_only_untranslated") && (entry = Core.getProject().getTranslationInfo(this.currentlyProcessedEntry)).isTranslated()) {
                    return this.translator.getCachedTranslation(source, target, this.src);
                }
            }
            return this.translator.getTranslation(source, target, this.src);
        }
    }
}

