/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.filelist;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.BadLocationException;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.IProject;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.events.IApplicationEventListener;
import org.omegat.core.events.IEntryEventListener;
import org.omegat.core.events.IFontChangedEventListener;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.core.statistics.StatisticsInfo;
import org.omegat.gui.filelist.ProjectFilesList;
import org.omegat.gui.filelist.TableFilterPanel;
import org.omegat.gui.main.MainWindow;
import org.omegat.util.OStrings;
import org.omegat.util.Platform;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.DataTableStyling;
import org.omegat.util.gui.DragTargetOverlay;
import org.omegat.util.gui.OSXIntegration;
import org.omegat.util.gui.StaticUIUtils;
import org.omegat.util.gui.TableColumnSizer;
import org.omegat.util.gui.UIThreadsUtil;

public class ProjectFilesListController {
    private ProjectFilesList list;
    private AbstractTableModel modelFiles;
    private AbstractTableModel modelTotal;
    private Sorter currentSorter;
    private TableFilterPanel filterPanel;
    private final MainWindow m_parent;
    private Font defaultFont;
    private final KeyListener filterTrigger = new KeyAdapter(){

        @Override
        public void keyTyped(KeyEvent e) {
            char c = e.getKeyChar();
            if (!(e.getModifiers() != 0 && e.getModifiers() != 1 || Character.isWhitespace(c) || Character.isISOControl(c))) {
                if (ProjectFilesListController.this.filterPanel == null) {
                    ProjectFilesListController.this.startFilter(e.getKeyChar());
                } else {
                    ProjectFilesListController.this.resumeFilter(e.getKeyChar());
                }
                e.consume();
            }
        }
    };
    ActionListener moveAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            int newPos;
            int[] selected = ((ProjectFilesListController)ProjectFilesListController.this).list.tableFiles.getSelectedRows();
            if (selected.length == 0) {
                return;
            }
            int pos = selected[0];
            if (e.getSource() == ((ProjectFilesListController)ProjectFilesListController.this).list.btnUp) {
                newPos = pos - 1;
            } else if (e.getSource() == ((ProjectFilesListController)ProjectFilesListController.this).list.btnDown) {
                newPos = pos + 1;
            } else if (e.getSource() == ((ProjectFilesListController)ProjectFilesListController.this).list.btnFirst) {
                newPos = 0;
            } else if (e.getSource() == ((ProjectFilesListController)ProjectFilesListController.this).list.btnLast) {
                newPos = Integer.MAX_VALUE;
            } else {
                return;
            }
            pos = ProjectFilesListController.this.currentSorter.moveTo(selected, newPos);
            ((ProjectFilesListController)ProjectFilesListController.this).list.tableFiles.getSelectionModel().setSelectionInterval(pos, pos + selected.length - 1);
        }
    };

    public ProjectFilesListController(MainWindow parent) {
        this.m_parent = parent;
        this.list = new ProjectFilesList();
        if (Platform.isMacOSX()) {
            OSXIntegration.enableFullScreen(this.list);
        }
        this.createTableFiles();
        this.createTableTotal();
        TableColumnSizer colSizer = TableColumnSizer.autoSize(this.list.tableFiles, 0, true);
        colSizer.addColumnAdjustmentListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectFilesListController.this.propagateTableColumns();
            }
        });
        DragTargetOverlay.apply(this.list.tableFiles, new DragTargetOverlay.FileDropInfo(this.m_parent, true){

            @Override
            public String getImportDestination() {
                return Core.getProject().getProjectProperties().getSourceRoot();
            }

            @Override
            public boolean canAcceptDrop() {
                return Core.getProject().isProjectLoaded();
            }

            @Override
            public String getOverlayMessage() {
                return OStrings.getString("DND_ADD_SOURCE_FILE");
            }

            @Override
            public boolean acceptFile(File path) {
                return true;
            }

            @Override
            public Component getComponentToOverlay() {
                return ((ProjectFilesListController)ProjectFilesListController.this).list.tablesInnerPanel;
            }
        });
        this.defaultFont = this.list.tableFiles.getFont();
        if (Preferences.isPreference("project_files_use_font")) {
            String fontName = Preferences.getPreference("source_font");
            int fontSize = Integer.parseInt(Preferences.getPreference("source_font_size"));
            this.setFont(new Font(fontName, 0, fontSize));
        } else {
            this.setFont(this.defaultFont);
        }
        this.list.tablesInnerPanel.setBorder(new JScrollPane().getBorder());
        this.initWindowLayout();
        this.list.m_addNewFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectFilesListController.this.doImportSourceFiles();
            }
        });
        this.list.m_wikiImportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectFilesListController.this.doWikiImport();
            }
        });
        this.list.m_closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectFilesListController.this.doCancel();
            }
        });
        this.list.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                ProjectFilesListController.this.doCancel();
            }

            @Override
            public void windowActivated(WindowEvent e) {
                ProjectFilesListController.this.propagateTableColumns();
            }
        });
        StaticUIUtils.setEscapeAction(this.list, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectFilesListController.this.doCancel();
            }
        });
        CoreEvents.registerProjectChangeListener(new IProjectEventListener(){

            @Override
            public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
                switch (eventType) {
                    case CLOSE: {
                        ProjectFilesListController.this.list.setVisible(false);
                        break;
                    }
                    case LOAD: 
                    case CREATE: {
                        ProjectFilesListController.this.buildDisplay(Core.getProject().getProjectFiles());
                        if (!Preferences.isPreferenceDefault("project_files_show_on_load", true)) break;
                        ProjectFilesListController.this.list.setVisible(true);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ProjectFilesListController.this.list.toFront();
                                ((ProjectFilesListController)ProjectFilesListController.this).list.tableFiles.requestFocus();
                            }
                        });
                    }
                }
            }
        });
        CoreEvents.registerEntryEventListener(new IEntryEventListener(){

            @Override
            public void onNewFile(String activeFileName) {
                ((ProjectFilesListController)ProjectFilesListController.this).list.tableFiles.repaint();
                ((ProjectFilesListController)ProjectFilesListController.this).list.tableTotal.repaint();
                ProjectFilesListController.this.modelTotal.fireTableDataChanged();
            }

            @Override
            public void onEntryActivated(SourceTextEntry newEntry) {
                UIThreadsUtil.mustBeSwingThread();
                ProjectFilesListController.this.modelTotal.fireTableDataChanged();
            }
        });
        CoreEvents.registerFontChangedEventListener(new IFontChangedEventListener(){

            @Override
            public void onFontChanged(Font newFont) {
                if (!Preferences.isPreference("project_files_use_font")) {
                    newFont = ProjectFilesListController.this.defaultFont;
                }
                ProjectFilesListController.this.setFont(newFont);
            }
        });
        CoreEvents.registerApplicationEventListener(new IApplicationEventListener(){

            @Override
            public void onApplicationStartup() {
            }

            @Override
            public void onApplicationShutdown() {
                ProjectFilesListController.this.saveWindowLayout();
            }
        });
        this.list.tableFiles.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ProjectFilesListController.this.gotoFile(((ProjectFilesListController)ProjectFilesListController.this).list.tableFiles.rowAtPoint(e.getPoint()));
            }
        });
        this.list.tableFiles.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ProjectFilesListController.this.gotoFile(((ProjectFilesListController)ProjectFilesListController.this).list.tableFiles.getSelectedRow());
                    e.consume();
                } else if (ProjectFilesListController.this.filterPanel != null && e.getKeyCode() == 27) {
                    ProjectFilesListController.this.endFilter();
                    e.consume();
                }
            }
        });
        this.list.tableFiles.addKeyListener(this.filterTrigger);
        this.list.tableTotal.addKeyListener(this.filterTrigger);
        this.list.btnUp.addKeyListener(this.filterTrigger);
        this.list.btnDown.addKeyListener(this.filterTrigger);
        this.list.btnFirst.addKeyListener(this.filterTrigger);
        this.list.btnLast.addKeyListener(this.filterTrigger);
        this.list.btnUp.addActionListener(this.moveAction);
        this.list.btnDown.addActionListener(this.moveAction);
        this.list.btnFirst.addActionListener(this.moveAction);
        this.list.btnLast.addActionListener(this.moveAction);
    }

    private void startFilter(char c) {
        if (this.filterPanel != null) {
            return;
        }
        this.filterPanel = new TableFilterPanel();
        this.list.btnDown.setEnabled(false);
        this.list.btnUp.setEnabled(false);
        this.list.btnFirst.setEnabled(false);
        this.list.btnLast.setEnabled(false);
        this.list.tablesOuterPanel.add((Component)this.filterPanel, "South");
        this.filterPanel.filterTextField.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectFilesListController.this.gotoFile(((ProjectFilesListController)ProjectFilesListController.this).list.tableFiles.getSelectedRow());
            }
        });
        this.filterPanel.filterTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    ProjectFilesListController.this.endFilter();
                    e.consume();
                } else if (e.getKeyCode() == 38) {
                    int selection = Math.max(0, ((ProjectFilesListController)ProjectFilesListController.this).list.tableFiles.getSelectedRow());
                    int total = ((ProjectFilesListController)ProjectFilesListController.this).list.tableFiles.getRowCount();
                    int up = (selection - 1 + total) % total;
                    ProjectFilesListController.this.selectRow(up);
                    e.consume();
                } else if (e.getKeyCode() == 40) {
                    int selection = ((ProjectFilesListController)ProjectFilesListController.this).list.tableFiles.getSelectedRow();
                    int down = (selection + 1) % ((ProjectFilesListController)ProjectFilesListController.this).list.tableFiles.getRowCount();
                    ProjectFilesListController.this.selectRow(down);
                    e.consume();
                }
            }
        });
        this.filterPanel.filterTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ProjectFilesListController.this.applyFilter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ProjectFilesListController.this.applyFilter();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ProjectFilesListController.this.applyFilter();
            }
        });
        this.filterPanel.filterTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ((ProjectFilesListController)ProjectFilesListController.this).filterPanel.filterTextField.setCaretPosition(((ProjectFilesListController)ProjectFilesListController.this).filterPanel.filterTextField.getText().length());
            }
        });
        this.filterPanel.filterCloseButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectFilesListController.this.endFilter();
            }
        });
        this.filterPanel.filterTextField.setText(Character.toString(c));
        this.filterPanel.filterTextField.requestFocus();
        this.list.validate();
        this.list.repaint();
    }

    private void resumeFilter(char c) {
        if (this.filterPanel == null) {
            return;
        }
        try {
            this.filterPanel.filterTextField.getDocument().insertString(this.filterPanel.filterTextField.getText().length(), Character.toString(c), null);
            this.filterPanel.filterTextField.requestFocus();
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void applyFilter() {
        if (this.filterPanel == null) {
            return;
        }
        String regex = ".*" + Pattern.quote(this.filterPanel.filterTextField.getText()) + ".*";
        this.currentSorter.setFilter(regex);
        this.selectRow(0);
    }

    private void endFilter() {
        if (this.filterPanel == null) {
            return;
        }
        this.list.tablesOuterPanel.remove(this.filterPanel);
        this.list.btnDown.setEnabled(true);
        this.list.btnUp.setEnabled(true);
        this.list.btnFirst.setEnabled(true);
        this.list.btnLast.setEnabled(true);
        this.filterPanel = null;
        this.currentSorter.setFilter(null);
        this.list.tableFiles.requestFocus();
        int currentRow = this.list.tableFiles.getSelectedRow();
        this.list.tableFiles.scrollRectToVisible(this.list.tableFiles.getCellRect(currentRow, 0, true));
        this.list.validate();
        this.list.repaint();
    }

    public boolean isActive() {
        return this.list.isActive();
    }

    public void setActive(boolean active) {
        if (active) {
            this.list.setVisible(true);
            this.list.toFront();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProjectFilesListController.this.selectCurrentFile(Core.getProject().getProjectFiles());
                }
            });
        } else {
            this.list.setVisible(false);
        }
    }

    private void selectCurrentFile(List<IProject.FileInfo> files) {
        this.list.tableFiles.getSelectionModel().clearSelection();
        String currentFile = Core.getEditor().getCurrentFile();
        for (int i = 0; i < files.size(); ++i) {
            if (!files.get((int)i).filePath.equals(currentFile)) continue;
            int pos = this.list.tableFiles.convertRowIndexToView(i);
            this.selectRow(pos);
            break;
        }
        this.list.tableFiles.requestFocus();
    }

    private void selectRow(int row) {
        this.list.tableFiles.getSelectionModel().setSelectionInterval(row, row);
        this.list.tableFiles.scrollRectToVisible(this.list.tableFiles.getCellRect(row, 0, true));
    }

    private void initWindowLayout() {
        try {
            String dx = Preferences.getPreference("project_files_window_x");
            String dy = Preferences.getPreference("project_files_window_y");
            int x = Integer.parseInt(dx);
            int y = Integer.parseInt(dy);
            this.list.setLocation(x, y);
            String dw = Preferences.getPreference("project_files_window_width");
            String dh = Preferences.getPreference("project_files_window_height");
            int w = Integer.parseInt(dw);
            int h = Integer.parseInt(dh);
            this.list.setSize(w, h);
        }
        catch (NumberFormatException nfe) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.list.setBounds((screenSize.width - 640) / 2, (screenSize.height - 400) / 2, 640, 400);
        }
    }

    private void saveWindowLayout() {
        Preferences.setPreference("project_files_window_width", this.list.getWidth());
        Preferences.setPreference("project_files_window_height", this.list.getHeight());
        Preferences.setPreference("project_files_window_x", this.list.getX());
        Preferences.setPreference("project_files_window_y", this.list.getY());
    }

    private void doCancel() {
        this.list.setVisible(false);
    }

    private void buildDisplay(List<IProject.FileInfo> files) {
        String path;
        UIThreadsUtil.mustBeSwingThread();
        String statFileName = Core.getProject().getProjectProperties().getProjectInternal() + "project_stats.txt";
        File statFile = new File(statFileName);
        try {
            path = statFile.getCanonicalPath();
        }
        catch (IOException ex) {
            path = statFile.getAbsolutePath();
        }
        String statText = MessageFormat.format(OStrings.getString("PF_STAT_PATH"), path);
        this.list.statLabel.setText(statText);
        this.uiUpdateImportButtonStatus();
        this.list.setTitle(StringUtil.format(OStrings.getString("PF_WINDOW_TITLE"), files.size()));
        OSXIntegration.setProxyIcon(this.list.getRootPane(), new File(Core.getProject().getProjectProperties().getSourceRoot()));
        this.setTableFilesModel(files);
    }

    private void createTableFiles() {
        DataTableStyling.applyColors(this.list.tableFiles);
        this.list.tableFiles.setSelectionMode(2);
    }

    private void propagateTableColumns() {
        JScrollBar scrollbar = this.list.scrollFiles.getVerticalScrollBar();
        int sbWidth = scrollbar == null || !scrollbar.isVisible() ? 0 : scrollbar.getWidth();
        this.list.tableTotal.getColumnModel().getColumn(this.list.tableTotal.getColumnCount() - 1).setPreferredWidth(sbWidth);
        for (int i = 0; i < this.list.tableFiles.getColumnCount(); ++i) {
            TableColumn srcCol = this.list.tableFiles.getColumnModel().getColumn(i);
            TableColumn trgCol = this.list.tableTotal.getColumnModel().getColumn(i);
            trgCol.setPreferredWidth(srcCol.getWidth());
        }
    }

    private void setTableFilesModel(final List<IProject.FileInfo> files) {
        this.modelFiles = new AbstractTableModel(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                IProject.FileInfo fi;
                try {
                    fi = (IProject.FileInfo)files.get(rowIndex);
                }
                catch (IndexOutOfBoundsException ex) {
                    return null;
                }
                switch (columnIndex) {
                    case 0: {
                        return fi.filePath;
                    }
                    case 1: {
                        return fi.filterFileFormatName;
                    }
                    case 2: {
                        return fi.fileEncoding;
                    }
                    case 3: {
                        return fi.entries.size();
                    }
                    case 4: {
                        StatisticsInfo stat = Core.getProject().getStatistics();
                        return stat.uniqueCountsByFile.get(fi.filePath);
                    }
                }
                return null;
            }

            @Override
            public int getColumnCount() {
                return 5;
            }

            @Override
            public int getRowCount() {
                return files.size();
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return String.class;
                    }
                    case 1: {
                        return String.class;
                    }
                    case 2: {
                        return String.class;
                    }
                    case 3: {
                        return Integer.class;
                    }
                    case 4: {
                        return Integer.class;
                    }
                }
                return null;
            }
        };
        this.list.tableFiles.setModel(this.modelFiles);
        DefaultTableColumnModel columns = new DefaultTableColumnModel();
        TableColumn cFile = new TableColumn(0, 150);
        cFile.setHeaderValue(OStrings.getString("PF_FILENAME"));
        cFile.setCellRenderer(this.getTextCellRenderer(files));
        TableColumn cFilter = new TableColumn(1, 100);
        cFilter.setHeaderValue(OStrings.getString("PF_FILTERNAME"));
        cFilter.setCellRenderer(this.getTextCellRenderer(files));
        TableColumn cEncoding = new TableColumn(2, 50);
        cEncoding.setHeaderValue(OStrings.getString("PF_ENCODING"));
        cEncoding.setCellRenderer(this.getTextCellRenderer(files));
        TableColumn cCount = new TableColumn(3, 50);
        cCount.setHeaderValue(OStrings.getString("PF_NUM_SEGMENTS"));
        cCount.setCellRenderer(this.getNumberCellRenderer(files));
        TableColumn cUnique = new TableColumn(4, 50);
        cUnique.setHeaderValue(OStrings.getString("PF_NUM_UNIQUE_SEGMENTS"));
        cUnique.setCellRenderer(this.getNumberCellRenderer(files));
        columns.addColumn(cFile);
        columns.addColumn(cFilter);
        columns.addColumn(cEncoding);
        columns.addColumn(cCount);
        columns.addColumn(cUnique);
        columns.addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
                ((ProjectFilesListController)ProjectFilesListController.this).list.tableTotal.getColumnModel().moveColumn(e.getFromIndex(), e.getToIndex());
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
        this.list.tableFiles.setColumnModel(columns);
        this.currentSorter = new Sorter(files);
        this.list.tableFiles.setRowSorter(this.currentSorter);
    }

    private void createTableTotal() {
        DataTableStyling.applyColors(this.list.tableTotal);
        this.list.tableTotal.setBorder(new MatteBorder(1, 0, 0, 0, DataTableStyling.COLOR_ALTERNATING_HILITE));
        this.modelTotal = new AbstractTableModel(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                if (columnIndex == 0) {
                    switch (rowIndex) {
                        case 0: {
                            return OStrings.getString("GUI_PROJECT_TOTAL_SEGMENTS");
                        }
                        case 1: {
                            return OStrings.getString("GUI_PROJECT_UNIQUE_SEGMENTS");
                        }
                        case 2: {
                            return OStrings.getString("GUI_PROJECT_TRANSLATED");
                        }
                    }
                } else {
                    if (columnIndex == 1) {
                        return "";
                    }
                    if (columnIndex == 2) {
                        return "";
                    }
                    if (columnIndex == 3) {
                        return "";
                    }
                    if (columnIndex == 4) {
                        StatisticsInfo stat = Core.getProject().getStatistics();
                        switch (rowIndex) {
                            case 0: {
                                return stat.numberOfSegmentsTotal;
                            }
                            case 1: {
                                return stat.numberOfUniqueSegments;
                            }
                            case 2: {
                                return stat.numberofTranslatedSegments;
                            }
                        }
                    } else if (columnIndex == 5) {
                        return "";
                    }
                }
                return null;
            }

            @Override
            public int getColumnCount() {
                return 6;
            }

            @Override
            public int getRowCount() {
                return 3;
            }
        };
        this.list.tableTotal.setModel(this.modelTotal);
        DefaultTableColumnModel columns = new DefaultTableColumnModel();
        TableColumn cFile = new TableColumn(0, 150);
        cFile.setCellRenderer(this.getTextCellRenderer(null));
        TableColumn cFilter = new TableColumn(1, 100);
        cFilter.setCellRenderer(this.getTextCellRenderer(null));
        TableColumn cEncoding = new TableColumn(2, 50);
        cEncoding.setCellRenderer(this.getTextCellRenderer(null));
        TableColumn cCount = new TableColumn(3, 50);
        cCount.setCellRenderer(this.getNumberCellRenderer(null));
        TableColumn cUnique = new TableColumn(4, 50);
        cUnique.setCellRenderer(this.getNumberCellRenderer(null));
        TableColumn cScrollbarMargin = new TableColumn(5, 0);
        cScrollbarMargin.setCellRenderer(new CustomRenderer(null, 2, null, false));
        columns.addColumn(cFile);
        columns.addColumn(cFilter);
        columns.addColumn(cEncoding);
        columns.addColumn(cCount);
        columns.addColumn(cUnique);
        columns.addColumn(cScrollbarMargin);
        this.list.tableTotal.setColumnModel(columns);
    }

    private void doImportSourceFiles() {
        this.m_parent.doPromptImportSourceFiles();
    }

    private void doWikiImport() {
        this.m_parent.doWikiImport();
    }

    private void uiUpdateImportButtonStatus() {
        this.list.m_addNewFileButton.setEnabled(Core.getProject().isProjectLoaded());
        this.list.m_wikiImportButton.setEnabled(Core.getProject().isProjectLoaded());
    }

    private void gotoFile(int row) {
        int modelRow;
        try {
            modelRow = this.list.tableFiles.convertRowIndexToModel(row);
            Core.getProject().getProjectFiles().get(modelRow);
        }
        catch (IndexOutOfBoundsException ex) {
            return;
        }
        Cursor hourglassCursor = new Cursor(3);
        Cursor oldCursor = this.list.getCursor();
        this.list.setCursor(hourglassCursor);
        Core.getEditor().gotoFile(modelRow);
        Core.getEditor().requestFocus();
        this.list.setCursor(oldCursor);
    }

    private TableCellRenderer getNumberCellRenderer(List<IProject.FileInfo> files) {
        return new CustomRenderer(files, 4, DataTableStyling.NUMBER_FORMAT, true);
    }

    private TableCellRenderer getTextCellRenderer(List<IProject.FileInfo> files) {
        return new CustomRenderer(files, 2, DataTableStyling.NUMBER_FORMAT, true);
    }

    private void setFont(Font font) {
        DataTableStyling.applyFont(this.list.tableFiles, font);
        DataTableStyling.applyFont(this.list.tableTotal, font.deriveFont(1));
        this.list.statLabel.setFont(font);
    }

    class Sorter
    extends RowSorter<IProject.FileInfo> {
        private final List<IProject.FileInfo> files;
        private RowSorter.SortKey sortKey = new RowSorter.SortKey(0, SortOrder.UNSORTED);
        private Integer[] modelToView;
        private List<Integer> viewToModel;
        private Pattern filter;

        public Sorter(List<IProject.FileInfo> files) {
            this.files = files;
            this.init();
            this.applyPrefs();
        }

        private void init() {
            int i;
            if (this.modelToView == null || this.modelToView.length != this.files.size()) {
                this.modelToView = new Integer[this.files.size()];
            }
            int excluded = 0;
            for (i = 0; i < this.modelToView.length; ++i) {
                if (this.include(this.files.get(i))) {
                    this.modelToView[i] = i - excluded;
                    continue;
                }
                this.modelToView[i] = -1;
                ++excluded;
            }
            this.viewToModel = new ArrayList<Integer>(this.modelToView.length - excluded);
            int j = 0;
            for (i = 0; i < this.modelToView.length; ++i) {
                if (this.modelToView[i] == -1) continue;
                this.viewToModel.add(j++, i);
            }
        }

        private void applyPrefs() {
            final ArrayList<String> filenames = new ArrayList<String>();
            for (IProject.FileInfo fi : this.files) {
                filenames.add(fi.filePath);
            }
            StaticUtils.sortByList(filenames, Core.getProject().getSourceFilesOrder());
            Collections.sort(this.viewToModel, new Comparator<Integer>(){

                @Override
                public int compare(Integer o1, Integer o2) {
                    int pos2;
                    int pos1 = filenames.indexOf(((IProject.FileInfo)((Sorter)Sorter.this).files.get((int)o1.intValue())).filePath);
                    if (pos1 < (pos2 = filenames.indexOf(((IProject.FileInfo)((Sorter)Sorter.this).files.get((int)o2.intValue())).filePath))) {
                        return -1;
                    }
                    if (pos1 > pos2) {
                        return 1;
                    }
                    return 0;
                }
            });
            this.recalc();
        }

        @Override
        public int getModelRowCount() {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public int getViewRowCount() {
            return this.viewToModel.size();
        }

        @Override
        public IProject.FileInfo getModel() {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public void modelStructureChanged() {
        }

        @Override
        public void allRowsChanged() {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public void rowsInserted(int firstRow, int endRow) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public void rowsUpdated(int firstRow, int endRow) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public void rowsUpdated(int firstRow, int endRow, int column) {
        }

        @Override
        public void rowsDeleted(int firstRow, int endRow) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public List<? extends RowSorter.SortKey> getSortKeys() {
            ArrayList<RowSorter.SortKey> r = new ArrayList<RowSorter.SortKey>();
            r.add(this.sortKey);
            return r;
        }

        @Override
        public void setSortKeys(List<? extends RowSorter.SortKey> keys) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public void toggleSortOrder(int column) {
            SortOrder order = SortOrder.ASCENDING;
            if (this.sortKey.getSortOrder() == SortOrder.ASCENDING) {
                order = SortOrder.DESCENDING;
            }
            this.sortKey = new RowSorter.SortKey(column, order);
            this.sort();
            this.save();
        }

        @Override
        public int convertRowIndexToModel(int index) {
            return this.viewToModel.get(index);
        }

        @Override
        public int convertRowIndexToView(int index) {
            return this.modelToView[index];
        }

        void sort() {
            if (this.sortKey.getSortOrder() == SortOrder.UNSORTED) {
                this.applyPrefs();
                return;
            }
            final StatisticsInfo stat = Core.getProject().getStatistics();
            Collections.sort(this.viewToModel, new Comparator<Integer>(){

                @Override
                public int compare(Integer o1, Integer o2) {
                    IProject.FileInfo f1 = (IProject.FileInfo)Sorter.this.files.get(o1);
                    IProject.FileInfo f2 = (IProject.FileInfo)Sorter.this.files.get(o2);
                    int c = 0;
                    switch (Sorter.this.sortKey.getColumn()) {
                        case 0: {
                            c = f1.filePath.compareToIgnoreCase(f2.filePath);
                            break;
                        }
                        case 1: {
                            c = f1.filterFileFormatName.compareToIgnoreCase(f2.filterFileFormatName);
                            break;
                        }
                        case 2: {
                            String fe1 = f1.fileEncoding == null ? "" : f1.fileEncoding;
                            String fe2 = f2.fileEncoding == null ? "" : f2.fileEncoding;
                            c = fe1.compareToIgnoreCase(fe2);
                            break;
                        }
                        case 3: {
                            int m1 = f1.entries.size();
                            int m2 = f2.entries.size();
                            c = m1 > m2 ? 1 : (m1 < m2 ? -1 : 0);
                            break;
                        }
                        case 4: {
                            int n1 = stat.uniqueCountsByFile.get(f1.filePath);
                            int n2 = stat.uniqueCountsByFile.get(f2.filePath);
                            int n = n1 > n2 ? 1 : (c = n1 < n2 ? -1 : 0);
                        }
                    }
                    if (Sorter.this.sortKey.getSortOrder() == SortOrder.DESCENDING) {
                        c = -c;
                    }
                    return c;
                }
            });
            this.recalc();
        }

        private void recalc() {
            for (int i = 0; i < this.viewToModel.size(); ++i) {
                this.modelToView[this.viewToModel.get((int)i).intValue()] = i;
            }
        }

        public int moveTo(int[] selected, int newPos) {
            int i;
            int[] temp = new int[selected.length];
            int n = selected.length;
            for (i = 0; i < selected.length; ++i) {
                temp[i] = this.viewToModel.remove(selected[--n]);
            }
            newPos = Math.max(newPos, 0);
            newPos = Math.min(newPos, this.viewToModel.size());
            for (i = 0; i < temp.length; ++i) {
                this.viewToModel.add(newPos, temp[i]);
            }
            this.recalc();
            this.save();
            ((ProjectFilesListController)ProjectFilesListController.this).list.tableFiles.scrollRectToVisible(((ProjectFilesListController)ProjectFilesListController.this).list.tableFiles.getCellRect(newPos, 0, true).union(((ProjectFilesListController)ProjectFilesListController.this).list.tableFiles.getCellRect(newPos + temp.length, 0, true)));
            ((ProjectFilesListController)ProjectFilesListController.this).list.tableFiles.repaint();
            this.sortKey = new RowSorter.SortKey(0, SortOrder.UNSORTED);
            ((ProjectFilesListController)ProjectFilesListController.this).list.tableFiles.getTableHeader().repaint();
            return newPos;
        }

        private void save() {
            ArrayList<String> filenames = new ArrayList<String>();
            for (Integer i : this.viewToModel) {
                String fn = this.files.get((int)i.intValue()).filePath;
                filenames.add(fn);
            }
            Core.getProject().setSourceFilesOrder(filenames);
        }

        public void setFilter(String regex) {
            Pattern newFilter;
            if (this.filter == null && regex == null) {
                return;
            }
            try {
                newFilter = regex == null ? null : Pattern.compile(regex, 2);
            }
            catch (PatternSyntaxException ex) {
                return;
            }
            if (this.filter != null && this.filter.equals(newFilter)) {
                return;
            }
            this.filter = newFilter;
            int[] lastViewToModel = this.getIntArrayFromIntegerList(this.viewToModel);
            this.init();
            this.sort();
            this.fireRowSorterChanged(lastViewToModel);
        }

        private boolean include(IProject.FileInfo item) {
            if (this.filter == null) {
                return true;
            }
            return this.filter.matcher(item.filePath).matches();
        }

        private int[] getIntArrayFromIntegerList(List<Integer> list) {
            int[] result = new int[list.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = list.get(i);
            }
            return result;
        }
    }

    private class CustomRenderer
    extends DataTableStyling.AlternatingHighlightRenderer {
        private final List<IProject.FileInfo> files;

        public CustomRenderer(List<IProject.FileInfo> files, int alignment, NumberFormat numberFormat, boolean doHighlight) {
            super(alignment, numberFormat, doHighlight, -1);
            this.files = files;
        }

        @Override
        protected boolean isSpecialHighlightRow(int row) {
            if (this.files == null) {
                return false;
            }
            try {
                int modelRow = ((ProjectFilesListController)ProjectFilesListController.this).list.tableFiles.convertRowIndexToModel(row);
                IProject.FileInfo fi = this.files.get(modelRow);
                return fi.filePath.equals(Core.getEditor().getCurrentFile());
            }
            catch (IndexOutOfBoundsException ex) {
                return false;
            }
        }
    }
}

