/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.omegat.util.StringUtil;

public class GlossaryEntry {
    private String m_src;
    private String[] m_loc;
    private String[] m_com;
    private boolean[] m_priority;

    public GlossaryEntry(String src, String[] loc, String[] com, boolean[] fromPriorityGlossary) {
        this.m_src = StringUtil.normalizeUnicode(src);
        this.m_loc = loc;
        this.normalize(this.m_loc);
        this.m_com = com;
        this.normalize(com);
        this.m_priority = fromPriorityGlossary;
    }

    public GlossaryEntry(String src, String loc, String com, boolean fromPriorityGlossary) {
        this(src, new String[]{loc}, new String[]{com}, new boolean[]{fromPriorityGlossary});
    }

    public String getSrcText() {
        return this.m_src;
    }

    public String getLocText() {
        return this.m_loc.length > 0 ? this.m_loc[0] : "";
    }

    public String[] getLocTerms(boolean uniqueOnly) {
        if (!uniqueOnly || this.m_loc.length == 1) {
            return this.m_loc;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.m_loc.length; ++i) {
            if (i > 0 && this.m_loc[i].equals(this.m_loc[i - 1])) continue;
            list.add(this.m_loc[i]);
        }
        return list.toArray(new String[list.size()]);
    }

    public String getCommentText() {
        return this.m_com.length > 0 ? this.m_com[0] : "";
    }

    public String[] getComments() {
        return this.m_com;
    }

    public boolean getPriority() {
        return this.m_priority.length > 0 ? this.m_priority[0] : false;
    }

    public boolean[] getPriorities() {
        return this.m_priority;
    }

    public StyledString toStyledString() {
        StyledString result = new StyledString();
        result.text.append(this.m_src);
        result.text.append(" = ");
        StringBuilder comments = new StringBuilder();
        int commentIndex = 0;
        for (int i = 0; i < this.m_loc.length; ++i) {
            if (i > 0 && this.m_loc[i].equals(this.m_loc[i - 1])) {
                if (this.m_com[i].equals("")) continue;
                comments.append("\n");
                comments.append(commentIndex);
                comments.append(". ");
                comments.append(this.m_com[i]);
                continue;
            }
            if (i > 0) {
                result.text.append(", ");
            }
            if (this.m_priority[i]) {
                result.markBoldStart();
            }
            result.text.append(this.bracketEntry(this.m_loc[i]));
            if (this.m_priority[i]) {
                result.markBoldEnd();
            }
            ++commentIndex;
            if (this.m_com[i].equals("")) continue;
            comments.append("\n");
            comments.append(commentIndex);
            comments.append(". ");
            comments.append(this.m_com[i]);
        }
        result.text.append((CharSequence)comments);
        return result;
    }

    private String bracketEntry(String entry) {
        if (entry.contains(",") && !entry.contains(";") && !entry.contains("\"")) {
            entry = '\"' + entry + '\"';
        }
        return entry;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        GlossaryEntry otherGlossaryEntry = (GlossaryEntry)o;
        return StringUtil.equalsWithNulls(this.m_src, otherGlossaryEntry.m_src) && Arrays.equals(this.m_loc, otherGlossaryEntry.m_loc) && Arrays.equals(this.m_com, otherGlossaryEntry.m_com);
    }

    public int hashCode() {
        int hash = 98;
        hash = hash * 17 + (this.m_src == null ? 0 : this.m_src.hashCode());
        hash = hash * 31 + (this.m_loc == null ? 0 : Arrays.hashCode(this.m_loc));
        hash = hash * 13 + (this.m_com == null ? 0 : Arrays.hashCode(this.m_com));
        return hash;
    }

    private void normalize(String[] strs) {
        for (int i = 0; i < strs.length; ++i) {
            strs[i] = StringUtil.normalizeUnicode(strs[i]);
        }
    }

    static class StyledString {
        public StringBuilder text = new StringBuilder();
        public List<Integer> boldStarts = new ArrayList<Integer>();
        public List<Integer> boldLengths = new ArrayList<Integer>();

        StyledString() {
        }

        void markBoldStart() {
            this.boldStarts.add(this.text.length());
        }

        void markBoldEnd() {
            int start = this.boldStarts.get(this.boldStarts.size() - 1);
            this.boldLengths.add(this.text.length() - start);
        }

        public void append(StyledString str) {
            int off = this.text.length();
            this.text.append((CharSequence)str.text);
            for (int s : str.boldStarts) {
                this.boldStarts.add(off + s);
            }
            this.boldLengths.addAll(str.boldLengths);
        }

        public void append(String str) {
            this.text.append(str);
        }
    }
}

