/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.main;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.swing.text.JTextComponent;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.KnownException;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.matching.NearString;
import org.omegat.core.search.SearchMode;
import org.omegat.core.segmentation.SRX;
import org.omegat.core.spellchecker.ISpellChecker;
import org.omegat.core.tagvalidation.ErrorReport;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.filters2.master.PluginUtils;
import org.omegat.gui.dialogs.AboutDialog;
import org.omegat.gui.dialogs.AutotextAutoCompleterOptionsDialog;
import org.omegat.gui.dialogs.CharTableAutoCompleterOptionsDialog;
import org.omegat.gui.dialogs.CustomColorSelectionDialog;
import org.omegat.gui.dialogs.ExternalTMXMatchesDialog;
import org.omegat.gui.dialogs.FontSelectionDialog;
import org.omegat.gui.dialogs.GlossaryAutoCompleterOptionsDialog;
import org.omegat.gui.dialogs.GoToSegmentDialog;
import org.omegat.gui.dialogs.LastChangesDialog;
import org.omegat.gui.dialogs.LogDialog;
import org.omegat.gui.dialogs.SaveOptionsDialog;
import org.omegat.gui.dialogs.SpellcheckerConfigurationDialog;
import org.omegat.gui.dialogs.TagProcessingOptionsDialog;
import org.omegat.gui.dialogs.TeamOptionsDialog;
import org.omegat.gui.dialogs.UserPassDialog;
import org.omegat.gui.dialogs.ViewOptionsDialog;
import org.omegat.gui.dialogs.WorkflowOptionsDialog;
import org.omegat.gui.editor.EditorSettings;
import org.omegat.gui.editor.EditorUtils;
import org.omegat.gui.editor.IEditor;
import org.omegat.gui.filters2.FiltersCustomizer;
import org.omegat.gui.help.HelpFrame;
import org.omegat.gui.main.MainWindow;
import org.omegat.gui.main.MainWindowUI;
import org.omegat.gui.main.ProjectUICommands;
import org.omegat.gui.search.SearchWindowController;
import org.omegat.gui.segmentation.SegmentationCustomizer;
import org.omegat.gui.stat.StatisticsWindow;
import org.omegat.util.Base64;
import org.omegat.util.FileUtil;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;
import org.omegat.util.TagUtil;

public class MainWindowMenuHandler {
    private final MainWindow mainWindow;

    public MainWindowMenuHandler(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
    }

    public void projectNewMenuItemActionPerformed() {
        ProjectUICommands.projectCreate();
    }

    public void projectTeamNewMenuItemActionPerformed() {
        ProjectUICommands.projectTeamCreate();
    }

    public void projectOpenMenuItemActionPerformed() {
        ProjectUICommands.projectOpen(null);
    }

    public void projectImportMenuItemActionPerformed() {
        this.mainWindow.doPromptImportSourceFiles();
    }

    public void projectWikiImportMenuItemActionPerformed() {
        this.mainWindow.doWikiImport();
    }

    public void projectReloadMenuItemActionPerformed() {
        ProjectUICommands.projectReload();
    }

    public void projectCloseMenuItemActionPerformed() {
        ProjectUICommands.projectClose();
    }

    public void projectSaveMenuItemActionPerformed() {
        ProjectUICommands.projectSave();
    }

    public void projectCompileMenuItemActionPerformed() {
        List<ErrorReport> stes;
        if (Preferences.isPreference("tags_valid_required") && (stes = Core.getTagValidation().listInvalidTags()) != null) {
            Core.getTagValidation().displayTagValidationErrors(stes, OStrings.getString("TF_MESSAGE_COMPILE"));
            return;
        }
        ProjectUICommands.projectCompile();
    }

    public void projectSingleCompileMenuItemActionPerformed() {
        List<ErrorReport> stes;
        String midName = Core.getEditor().getCurrentFile();
        if (StringUtil.isEmpty(midName)) {
            return;
        }
        String sourcePattern = StaticUtils.escapeNonRegex(midName);
        if (Preferences.isPreference("tags_valid_required") && (stes = Core.getTagValidation().listInvalidTags(sourcePattern)) != null) {
            Core.getTagValidation().displayTagValidationErrors(stes, OStrings.getString("TF_MESSAGE_COMPILE"));
            return;
        }
        ProjectUICommands.projectSingleCompile(sourcePattern);
    }

    public void projectEditMenuItemActionPerformed() {
        ProjectUICommands.projectEditProperties();
    }

    public void viewFileListMenuItemActionPerformed() {
        if (this.mainWindow.m_projWin == null) {
            this.mainWindow.menu.viewFileListMenuItem.setSelected(false);
            return;
        }
        this.mainWindow.m_projWin.setActive(!this.mainWindow.m_projWin.isActive());
    }

    private void flushExportedSegments() {
        FileUtil.writeScriptFile("", "source.txt");
        FileUtil.writeScriptFile("", "target.txt");
    }

    public void projectAccessRootMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        String path = Core.getProject().getProjectProperties().getProjectRoot();
        this.openFile(new File(path));
    }

    public void projectAccessDictionaryMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        String path = Core.getProject().getProjectProperties().getDictRoot();
        this.openFile(new File(path));
    }

    public void projectAccessGlossaryMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        String path = Core.getProject().getProjectProperties().getGlossaryRoot();
        this.openFile(new File(path));
    }

    public void projectAccessSourceMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        String path = Core.getProject().getProjectProperties().getSourceRoot();
        this.openFile(new File(path));
    }

    public void projectAccessTargetMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        String path = Core.getProject().getProjectProperties().getTargetRoot();
        this.openFile(new File(path));
    }

    public void projectAccessTMMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        String path = Core.getProject().getProjectProperties().getTMRoot();
        this.openFile(new File(path));
    }

    public void projectAccessCurrentSourceDocumentMenuItemActionPerformed(int modifier) {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        String root = Core.getProject().getProjectProperties().getSourceRoot();
        String path = Core.getEditor().getCurrentFile();
        if (StringUtil.isEmpty(path)) {
            return;
        }
        File toOpen = new File(root, path);
        if ((modifier & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
            toOpen = toOpen.getParentFile();
        }
        this.openFile(toOpen);
    }

    public void projectAccessCurrentTargetDocumentMenuItemActionPerformed(int modifier) {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        String root = Core.getProject().getProjectProperties().getTargetRoot();
        String path = Core.getEditor().getCurrentTargetFile();
        if (StringUtil.isEmpty(path)) {
            return;
        }
        File toOpen = new File(root, path);
        if ((modifier & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
            toOpen = toOpen.getParentFile();
        }
        this.openFile(toOpen);
    }

    public void projectAccessWriteableGlossaryMenuItemActionPerformed(int modifier) {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        String path = Core.getProject().getProjectProperties().getWriteableGlossary();
        if (StringUtil.isEmpty(path)) {
            return;
        }
        File toOpen = new File(path);
        if ((modifier & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
            toOpen = toOpen.getParentFile();
        }
        this.openFile(toOpen);
    }

    private void openFile(File path) {
        try {
            path = path.getCanonicalFile();
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (!path.exists()) {
            Core.getMainWindow().showStatusMessageRB("LFC_ERROR_FILE_DOESNT_EXIST", path);
            return;
        }
        try {
            Desktop.getDesktop().open(path);
        }
        catch (Exception ex) {
            Log.logErrorRB(ex, "RPF_ERROR", new Object[0]);
            Core.getMainWindow().displayErrorRB(ex, "RPF_ERROR", new Object[0]);
        }
    }

    public void projectExitMenuItemActionPerformed() {
        boolean projectModified = false;
        if (Core.getProject().isProjectLoaded()) {
            projectModified = Core.getProject().isProjectModified();
        }
        if ((projectModified || Preferences.isPreference("always_confirm_quit")) && 0 != JOptionPane.showConfirmDialog(this.mainWindow, OStrings.getString("MW_QUIT_CONFIRM"), OStrings.getString("CONFIRM_DIALOG_TITLE"), 0)) {
            return;
        }
        this.flushExportedSegments();
        new SwingWorker<Object, Void>(){

            @Override
            protected Object doInBackground() throws Exception {
                if (Core.getProject().isProjectLoaded()) {
                    ISpellChecker sc = Core.getSpellChecker();
                    sc.saveWordLists();
                    try {
                        Core.getProject().saveProject();
                    }
                    catch (KnownException knownException) {
                        // empty catch block
                    }
                }
                CoreEvents.fireApplicationShutdown();
                PluginUtils.unloadPlugins();
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                    MainWindowUI.saveScreenLayout(MainWindowMenuHandler.this.mainWindow);
                    Preferences.save();
                    System.exit(0);
                }
                catch (Exception ex) {
                    Log.logErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                    Core.getMainWindow().displayErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                }
            }
        }.execute();
    }

    public void editUndoMenuItemActionPerformed() {
        Core.getEditor().undo();
    }

    public void editRedoMenuItemActionPerformed() {
        Core.getEditor().redo();
    }

    public void editOverwriteTranslationMenuItemActionPerformed() {
        this.mainWindow.doRecycleTrans();
    }

    public void editInsertTranslationMenuItemActionPerformed() {
        this.mainWindow.doInsertTrans();
    }

    public void editOverwriteMachineTranslationMenuItemActionPerformed() {
        String tr = Core.getMachineTranslatePane().getDisplayedTranslation();
        if (tr == null) {
            Core.getMachineTranslatePane().forceLoad();
        } else if (!StringUtil.isEmpty(tr)) {
            Core.getEditor().replaceEditText(tr);
        }
    }

    public void editOverwriteSourceMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        String toInsert = Core.getEditor().getCurrentEntry().getSrcText();
        if (Preferences.isPreference("glossary_replace_on_insert")) {
            toInsert = EditorUtils.replaceGlossaryEntries(toInsert);
        }
        Core.getEditor().replaceEditText(toInsert);
    }

    public void editInsertSourceMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        String toInsert = Core.getEditor().getCurrentEntry().getSrcText();
        if (Preferences.isPreference("glossary_replace_on_insert")) {
            toInsert = EditorUtils.replaceGlossaryEntries(toInsert);
        }
        Core.getEditor().insertText(toInsert);
    }

    public void editExportSelectionMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        String selection = Core.getEditor().getSelectedText();
        if (selection == null) {
            SourceTextEntry ste = Core.getEditor().getCurrentEntry();
            TMXEntry te = Core.getProject().getTranslationInfo(ste);
            selection = te.isTranslated() ? te.translation : ste.getSrcText();
        }
        FileUtil.writeScriptFile(selection, "selection.txt");
    }

    public void editCreateGlossaryEntryMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        Core.getGlossary().showCreateGlossaryEntryDialog();
    }

    public void editFindInProjectMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        String selection = this.getTrimmedSelectedTextInMainWindow();
        SearchWindowController search = new SearchWindowController(this.mainWindow, selection, SearchMode.SEARCH);
        this.mainWindow.addSearchWindow(search);
    }

    public void editReplaceInProjectMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        String selection = this.getTrimmedSelectedTextInMainWindow();
        SearchWindowController search = new SearchWindowController(this.mainWindow, selection, SearchMode.REPLACE);
        this.mainWindow.addSearchWindow(search);
    }

    private String getTrimmedSelectedTextInMainWindow() {
        String selection = null;
        Component component = this.mainWindow.getMostRecentFocusOwner();
        if (component instanceof JTextComponent && !StringUtil.isEmpty(selection = ((JTextComponent)component).getSelectedText())) {
            selection = EditorUtils.removeDirectionChars(selection);
            selection = selection.trim();
        }
        return selection;
    }

    public void editSelectFuzzy1MenuItemActionPerformed() {
        Core.getMatcher().setActiveMatch(0);
    }

    public void editSelectFuzzy2MenuItemActionPerformed() {
        Core.getMatcher().setActiveMatch(1);
    }

    public void editSelectFuzzy3MenuItemActionPerformed() {
        Core.getMatcher().setActiveMatch(2);
    }

    public void editSelectFuzzy4MenuItemActionPerformed() {
        Core.getMatcher().setActiveMatch(3);
    }

    public void editSelectFuzzy5MenuItemActionPerformed() {
        Core.getMatcher().setActiveMatch(4);
    }

    public void editSelectFuzzyNextMenuItemActionPerformed() {
        Core.getMatcher().setNextActiveMatch();
    }

    public void editSelectFuzzyPrevMenuItemActionPerformed() {
        Core.getMatcher().setPrevActiveMatch();
    }

    public void editMultipleDefaultActionPerformed() {
        Core.getEditor().setAlternateTranslationForCurrentEntry(false);
    }

    public void editMultipleAlternateActionPerformed() {
        Core.getEditor().setAlternateTranslationForCurrentEntry(true);
    }

    public void editRegisterUntranslatedMenuItemActionPerformed() {
        Core.getEditor().registerUntranslated();
    }

    public void editRegisterEmptyMenuItemActionPerformed() {
        Core.getEditor().registerEmptyTranslation();
    }

    public void editRegisterIdenticalMenuItemActionPerformed() {
        Core.getEditor().registerIdenticalTranslation();
    }

    public void cycleSwitchCaseMenuItemActionPerformed() {
        Core.getEditor().changeCase(IEditor.CHANGE_CASE_TO.CYCLE);
    }

    public void sentenceCaseMenuItemActionPerformed() {
        Core.getEditor().changeCase(IEditor.CHANGE_CASE_TO.SENTENCE);
    }

    public void titleCaseMenuItemActionPerformed() {
        Core.getEditor().changeCase(IEditor.CHANGE_CASE_TO.TITLE);
    }

    public void upperCaseMenuItemActionPerformed() {
        Core.getEditor().changeCase(IEditor.CHANGE_CASE_TO.UPPER);
    }

    public void lowerCaseMenuItemActionPerformed() {
        Core.getEditor().changeCase(IEditor.CHANGE_CASE_TO.LOWER);
    }

    public void gotoNextUntranslatedMenuItemActionPerformed() {
        Core.getEditor().nextUntranslatedEntry();
    }

    public void gotoNextUniqueMenuItemActionPerformed() {
        Core.getEditor().nextUniqueEntry();
    }

    public void gotoNextTranslatedMenuItemActionPerformed() {
        Core.getEditor().nextTranslatedEntry();
    }

    public void gotoNextSegmentMenuItemActionPerformed() {
        Core.getEditor().nextEntry();
    }

    public void gotoPreviousSegmentMenuItemActionPerformed() {
        Core.getEditor().prevEntry();
    }

    public void gotoNextNoteMenuItemActionPerformed() {
        Core.getEditor().nextEntryWithNote();
    }

    public void gotoPreviousNoteMenuItemActionPerformed() {
        Core.getEditor().prevEntryWithNote();
    }

    public void gotoSegmentMenuItemActionPerformed() {
        GoToSegmentDialog dialog = new GoToSegmentDialog(this.mainWindow);
        dialog.setVisible(true);
        int jumpTo = dialog.getResult();
        if (jumpTo != -1) {
            Core.getEditor().gotoEntry(jumpTo);
        }
    }

    public void gotoHistoryBackMenuItemActionPerformed() {
        Core.getEditor().gotoHistoryBack();
    }

    public void gotoHistoryForwardMenuItemActionPerformed() {
        Core.getEditor().gotoHistoryForward();
    }

    public void gotoMatchSourceSegmentActionPerformed() {
        NearString ns = Core.getMatcher().getActiveMatch();
        if (ns != null && ns.comesFrom == NearString.MATCH_SOURCE.MEMORY) {
            Core.getEditor().gotoEntry(ns.source, ns.key);
        }
    }

    public void viewMarkTranslatedSegmentsCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setMarkTranslated(this.mainWindow.menu.viewMarkTranslatedSegmentsCheckBoxMenuItem.isSelected());
    }

    public void viewMarkUntranslatedSegmentsCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setMarkUntranslated(this.mainWindow.menu.viewMarkUntranslatedSegmentsCheckBoxMenuItem.isSelected());
    }

    public void viewDisplaySegmentSourceCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setDisplaySegmentSources(this.mainWindow.menu.viewDisplaySegmentSourceCheckBoxMenuItem.isSelected());
    }

    public void viewMarkNonUniqueSegmentsCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setMarkNonUniqueSegments(this.mainWindow.menu.viewMarkNonUniqueSegmentsCheckBoxMenuItem.isSelected());
    }

    public void viewMarkNotedSegmentsCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setMarkNotedSegments(this.mainWindow.menu.viewMarkNotedSegmentsCheckBoxMenuItem.isSelected());
    }

    public void viewMarkNBSPCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setMarkNBSP(this.mainWindow.menu.viewMarkNBSPCheckBoxMenuItem.isSelected());
    }

    public void viewMarkWhitespaceCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setMarkWhitespace(this.mainWindow.menu.viewMarkWhitespaceCheckBoxMenuItem.isSelected());
    }

    public void viewMarkBidiCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setMarkBidi(this.mainWindow.menu.viewMarkBidiCheckBoxMenuItem.isSelected());
    }

    public void viewMarkAutoPopulatedCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setMarkAutoPopulated(this.mainWindow.menu.viewMarkAutoPopulatedCheckBoxMenuItem.isSelected());
    }

    public void viewMarkFontFallbackCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setDoFontFallback(this.mainWindow.menu.viewMarkFontFallbackCheckBoxMenuItem.isSelected());
    }

    public void viewDisplayModificationInfoNoneRadioButtonMenuItemActionPerformed() {
        Core.getEditor().getSettings().setDisplayModificationInfo(EditorSettings.DISPLAY_MODIFICATION_INFO_NONE);
    }

    public void viewDisplayModificationInfoSelectedRadioButtonMenuItemActionPerformed() {
        Core.getEditor().getSettings().setDisplayModificationInfo(EditorSettings.DISPLAY_MODIFICATION_INFO_SELECTED);
    }

    public void viewDisplayModificationInfoAllRadioButtonMenuItemActionPerformed() {
        Core.getEditor().getSettings().setDisplayModificationInfo(EditorSettings.DISPLAY_MODIFICATION_INFO_ALL);
    }

    public void toolsValidateTagsMenuItemActionPerformed() {
        Core.getTagValidation().displayTagValidationErrors(Core.getTagValidation().listInvalidTags(), null);
    }

    public void toolsSingleValidateTagsMenuItemActionPerformed() {
        String midName = Core.getEditor().getCurrentFile();
        List<ErrorReport> stes = null;
        if (!StringUtil.isEmpty(midName)) {
            String sourcePattern = StaticUtils.escapeNonRegex(midName);
            stes = Core.getTagValidation().listInvalidTags(sourcePattern);
        }
        Core.getTagValidation().displayTagValidationErrors(stes, null);
    }

    public void editTagPainterMenuItemActionPerformed() {
        for (TagUtil.Tag tag : TagUtil.getAllTagsMissingFromTarget()) {
            Core.getEditor().insertText(tag.tag);
        }
    }

    public void editTagNextMissedMenuItemActionPerformed() {
        List<TagUtil.Tag> tags = TagUtil.getAllTagsMissingFromTarget();
        if (tags.isEmpty()) {
            return;
        }
        Core.getEditor().insertText(tags.get((int)0).tag);
    }

    public void toolsShowStatisticsStandardMenuItemActionPerformed() {
        new StatisticsWindow(StatisticsWindow.STAT_TYPE.STANDARD).setVisible(true);
    }

    public void toolsShowStatisticsMatchesMenuItemActionPerformed() {
        new StatisticsWindow(StatisticsWindow.STAT_TYPE.MATCHES).setVisible(true);
    }

    public void toolsShowStatisticsMatchesPerFileMenuItemActionPerformed() {
        new StatisticsWindow(StatisticsWindow.STAT_TYPE.MATCHES_PER_FILE).setVisible(true);
    }

    public void optionsTabAdvanceCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setUseTabForAdvance(this.mainWindow.menu.optionsTabAdvanceCheckBoxMenuItem.isSelected());
    }

    public void optionsAlwaysConfirmQuitCheckBoxMenuItemActionPerformed() {
        Preferences.setPreference("always_confirm_quit", this.mainWindow.menu.optionsAlwaysConfirmQuitCheckBoxMenuItem.isSelected());
    }

    public void optionsTransTipsEnableMenuItemActionPerformed() {
        Preferences.setPreference("transtips", this.mainWindow.menu.optionsTransTipsEnableMenuItem.isSelected());
    }

    public void optionsTransTipsExactMatchMenuItemActionPerformed() {
        Preferences.setPreference("transtips_exact_search", this.mainWindow.menu.optionsTransTipsExactMatchMenuItem.isSelected());
    }

    public void optionsAutoCompleteShowAutomaticallyItemActionPerformed() {
        Preferences.setPreference("ac_show_suggestions_automatically", this.mainWindow.menu.optionsAutoCompleteShowAutomaticallyItem.isSelected());
    }

    public void optionsAutoCompleteGlossaryMenuItemActionPerformed() {
        new GlossaryAutoCompleterOptionsDialog(this.mainWindow).setVisible(true);
    }

    public void optionsAutoCompleteAutoTextMenuItemActionPerformed() {
        new AutotextAutoCompleterOptionsDialog(this.mainWindow).setVisible(true);
    }

    public void optionsAutoCompleteCharTableMenuItemActionPerformed() {
        new CharTableAutoCompleterOptionsDialog(this.mainWindow).setVisible(true);
    }

    public void optionsMTAutoFetchCheckboxMenuItemActionPerformed() {
        boolean enabled = this.mainWindow.menu.optionsMTAutoFetchCheckboxMenuItem.isSelected();
        Preferences.setPreference("mt_auto_fetch", enabled);
        this.mainWindow.menu.optionsMTOnlyUntranslatedCheckboxMenuItem.setEnabled(enabled);
    }

    public void optionsMTOnlyUntranslatedCheckboxMenuItemActionPerformed() {
        Preferences.setPreference("mt_only_untranslated", this.mainWindow.menu.optionsMTOnlyUntranslatedCheckboxMenuItem.isSelected());
    }

    public void optionsGlossaryTBXDisplayContextCheckBoxMenuItemActionPerformed() {
        Preferences.setPreference("glossary_tbx_display_context", this.mainWindow.menu.optionsGlossaryTBXDisplayContextCheckBoxMenuItem.isSelected());
        Preferences.save();
        Core.getGlossaryManager().forceReloadTBX();
    }

    public void optionsGlossaryExactMatchCheckBoxMenuItemActionPerformed() {
        Preferences.setPreference("glossary_not_exact_match", this.mainWindow.menu.optionsGlossaryExactMatchCheckBoxMenuItem.isSelected());
        Preferences.save();
        Core.getGlossaryManager().forceUpdateGlossary();
    }

    public void optionsGlossaryStemmingCheckBoxMenuItemActionPerformed() {
        Preferences.setPreference("glossary_stemming", this.mainWindow.menu.optionsGlossaryStemmingCheckBoxMenuItem.isSelected());
        Preferences.save();
        Core.getGlossaryManager().forceUpdateGlossary();
    }

    public void optionsGlossaryReplacementCheckBoxMenuItemActionPerformed() {
        Preferences.setPreference("glossary_replace_on_insert", this.mainWindow.menu.optionsGlossaryReplacementCheckBoxMenuItem.isSelected());
    }

    public void optionsDictionaryFuzzyMatchingCheckBoxMenuItemActionPerformed() {
        Preferences.setPreference("dictionary_fuzzy_matching", this.mainWindow.menu.optionsDictionaryFuzzyMatchingCheckBoxMenuItem.isSelected());
        Preferences.save();
        Core.getDictionaries().refresh();
    }

    public void optionsFontSelectionMenuItemActionPerformed() {
        FontSelectionDialog dlg = new FontSelectionDialog((Frame)Core.getMainWindow().getApplicationFrame(), Core.getMainWindow().getApplicationFont());
        dlg.setVisible(true);
        if (dlg.getReturnStatus() == 1) {
            this.mainWindow.setApplicationFont(dlg.getSelectedFont());
        }
    }

    public void optionsColorsSelectionMenuItemActionPerformed() {
        CustomColorSelectionDialog dlg = new CustomColorSelectionDialog(Core.getMainWindow().getApplicationFrame());
        dlg.setVisible(true);
    }

    public void optionsSetupFileFiltersMenuItemActionPerformed() {
        FiltersCustomizer dlg = new FiltersCustomizer(this.mainWindow, false, FilterMaster.createDefaultFiltersConfig(), FilterMaster.loadConfig(StaticUtils.getConfigDir()), null);
        dlg.setVisible(true);
        if (dlg.getReturnStatus() == 1) {
            FilterMaster.saveConfig(dlg.result, StaticUtils.getConfigDir());
            if (Core.getProject().isProjectLoaded()) {
                if (FilterMaster.loadConfig(Core.getProject().getProjectProperties().getProjectInternal()) != null) {
                    return;
                }
                int res = JOptionPane.showConfirmDialog(this.mainWindow, OStrings.getString("MW_REOPEN_QUESTION"), OStrings.getString("MW_REOPEN_TITLE"), 0);
                if (res == 0) {
                    ProjectUICommands.projectReload();
                }
            }
        }
    }

    public void optionsSentsegMenuItemActionPerformed() {
        SegmentationCustomizer segment_window = new SegmentationCustomizer(this.mainWindow, false, SRX.getDefault(), Preferences.getSRX(), null);
        segment_window.setVisible(true);
        if (segment_window.getReturnStatus() == 1) {
            int res;
            Preferences.setSRX(segment_window.getSRX());
            if (Core.getProject().isProjectLoaded() && Core.getProject().getProjectProperties().getProjectSRX() == null && (res = JOptionPane.showConfirmDialog(this.mainWindow, OStrings.getString("MW_REOPEN_QUESTION"), OStrings.getString("MW_REOPEN_TITLE"), 0)) == 0) {
                ProjectUICommands.projectReload();
            }
        }
    }

    public void optionsSpellCheckMenuItemActionPerformed() {
        Language currentLanguage = Core.getProject().isProjectLoaded() ? Core.getProject().getProjectProperties().getTargetLanguage() : new Language(Preferences.getPreference("target_lang"));
        SpellcheckerConfigurationDialog sd = new SpellcheckerConfigurationDialog((Frame)this.mainWindow, currentLanguage);
        sd.setVisible(true);
        if (sd.getReturnStatus() == 1) {
            boolean isNeedToSpell = Preferences.isPreference("allow_auto_spellchecking");
            if (isNeedToSpell && Core.getProject().isProjectLoaded()) {
                ISpellChecker sc = Core.getSpellChecker();
                sc.destroy();
                sc.initialize();
            }
            Core.getEditor().getSettings().setAutoSpellChecking(isNeedToSpell);
        }
    }

    public void optionsWorkflowMenuItemActionPerformed() {
        new WorkflowOptionsDialog(this.mainWindow).setVisible(true);
    }

    public void optionsTagValidationMenuItemActionPerformed() {
        TagProcessingOptionsDialog tagProcessingOptionsDialog = new TagProcessingOptionsDialog(this.mainWindow);
        tagProcessingOptionsDialog.setVisible(true);
        if (tagProcessingOptionsDialog.getReturnStatus() == 1 && Core.getProject().isProjectLoaded()) {
            Core.getEditor().getSettings().updateTagValidationPreferences();
            int res = JOptionPane.showConfirmDialog(this.mainWindow, OStrings.getString("MW_REOPEN_QUESTION"), OStrings.getString("MW_REOPEN_TITLE"), 0);
            if (res == 0) {
                ProjectUICommands.projectReload();
            }
        }
    }

    public void optionsTeamMenuItemActionPerformed() {
        new TeamOptionsDialog(this.mainWindow).setVisible(true);
    }

    public void optionsExtTMXMenuItemActionPerformed() {
        int res;
        ExternalTMXMatchesDialog externalTMXOptions = new ExternalTMXMatchesDialog(this.mainWindow);
        externalTMXOptions.setVisible(true);
        if (externalTMXOptions.getReturnStatus() == 1 && Core.getProject().isProjectLoaded() && (res = JOptionPane.showConfirmDialog(this.mainWindow, OStrings.getString("MW_REOPEN_QUESTION"), OStrings.getString("MW_REOPEN_TITLE"), 0)) == 0) {
            ProjectUICommands.projectReload();
        }
    }

    public void optionsViewOptionsMenuItemActionPerformed() {
        ViewOptionsDialog viewOptions = new ViewOptionsDialog(this.mainWindow);
        viewOptions.setVisible(true);
        if (viewOptions.getReturnStatus() == 1 && Core.getProject().isProjectLoaded()) {
            Core.getEditor().getSettings().updateViewPreferences();
        }
    }

    public void optionsSaveOptionsMenuItemActionPerformed() {
        SaveOptionsDialog saveOptions = new SaveOptionsDialog(this.mainWindow);
        saveOptions.setVisible(true);
    }

    public void optionsRestoreGUIMenuItemActionPerformed() {
        MainWindowUI.resetDesktopLayout(this.mainWindow);
    }

    public void optionsAccessConfigDirMenuItemActionPerformed() {
        this.openFile(new File(StaticUtils.getConfigDir()));
    }

    public void helpContentsMenuItemActionPerformed() {
        HelpFrame hf = HelpFrame.getInstance();
        hf.setVisible(true);
        hf.toFront();
    }

    public void helpAboutMenuItemActionPerformed() {
        new AboutDialog(this.mainWindow).setVisible(true);
    }

    public void helpLastChangesMenuItemActionPerformed() {
        new LastChangesDialog(this.mainWindow).setVisible(true);
    }

    public void helpLogMenuItemActionPerformed() {
        new LogDialog(this.mainWindow).setVisible(true);
    }

    public void optionsViewOptionsMenuLoginItemActionPerformed() {
        UserPassDialog proxyOptions = new UserPassDialog(this.mainWindow);
        String encodedUser = Preferences.getPreference("proxy_user_name");
        String encodedPassword = Preferences.getPreference("proxy_password");
        try {
            proxyOptions.userText.setText(new String(Base64.decode(encodedUser)));
            proxyOptions.passwordField.setText(new String(Base64.decode(encodedPassword)));
        }
        catch (IOException ex) {
            Log.logErrorRB("LOG_DECODING_ERROR", new Object[0]);
            Log.log(ex);
        }
        proxyOptions.setVisible(true);
        if (proxyOptions.getReturnStatus() == 1) {
            encodedUser = Base64.encodeBytes(proxyOptions.userText.getText().getBytes());
            encodedPassword = Base64.encodeBytes(new String(proxyOptions.passwordField.getPassword()).getBytes());
            Preferences.setPreference("proxy_user_name", encodedUser);
            Preferences.setPreference("proxy_password", encodedPassword);
        }
    }
}

