/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.matches;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omegat.core.data.IProject;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.events.IStopped;
import org.omegat.core.matching.NearString;
import org.omegat.core.statistics.FindMatches;
import org.omegat.gui.common.EntryInfoSearchThread;
import org.omegat.gui.matches.MatchesTextArea;

public class FindMatchesThread
extends EntryInfoSearchThread<List<NearString>> {
    private static final Logger LOGGER = Logger.getLogger(FindMatchesThread.class.getName());
    private final IProject project;
    private final SourceTextEntry processedEntry;

    public FindMatchesThread(MatchesTextArea matcherPane, IProject project, SourceTextEntry entry) {
        super(matcherPane, entry);
        this.project = project;
        this.processedEntry = entry;
    }

    @Override
    protected List<NearString> search() throws Exception {
        if (!this.project.isProjectLoaded()) {
            return new ArrayList<NearString>();
        }
        if (this.project.getSourceTokenizer() == null) {
            return null;
        }
        long before = 0L;
        if (LOGGER.isLoggable(Level.FINER)) {
            before = System.currentTimeMillis();
        }
        try {
            FindMatches finder = new FindMatches(this.project.getSourceTokenizer(), 5, true, false);
            List<NearString> result = finder.search(this.project, this.processedEntry.getSrcText(), true, true, new IStopped(){

                @Override
                public boolean isStopped() {
                    return FindMatchesThread.this.isEntryChanged();
                }
            });
            if (LOGGER.isLoggable(Level.FINER)) {
                long after = System.currentTimeMillis();
                LOGGER.finer("Time for find matches: " + (after - before));
            }
            return result;
        }
        catch (FindMatches.StoppedException ex) {
            throw new EntryInfoSearchThread.EntryChangedException();
        }
    }
}

