/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.matches;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyledDocument;
import org.omegat.core.Core;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.matching.DiffDriver;
import org.omegat.core.matching.NearString;
import org.omegat.gui.common.EntryInfoThreadPane;
import org.omegat.gui.main.DockableScrollPane;
import org.omegat.gui.main.MainWindow;
import org.omegat.gui.matches.FindMatchesThread;
import org.omegat.gui.matches.IMatcher;
import org.omegat.gui.matches.MatchesVarExpansion;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;
import org.omegat.util.Token;
import org.omegat.util.gui.AlwaysVisibleCaret;
import org.omegat.util.gui.DragTargetOverlay;
import org.omegat.util.gui.Styles;
import org.omegat.util.gui.UIThreadsUtil;

public class MatchesTextArea
extends EntryInfoThreadPane<List<NearString>>
implements IMatcher {
    private static final String EXPLANATION = OStrings.getString("GUI_MATCHWINDOW_explanation");
    private static final AttributeSet ATTRIBUTES_EMPTY = Styles.createAttributeSet(null, null, null, null);
    private static final AttributeSet ATTRIBUTES_CHANGED = Styles.createAttributeSet(Styles.EditorColor.COLOR_MATCHES_CHANGED.getColor(), null, null, null);
    private static final AttributeSet ATTRIBUTES_UNCHANGED = Styles.createAttributeSet(Styles.EditorColor.COLOR_MATCHES_UNCHANGED.getColor(), null, null, null);
    private static final AttributeSet ATTRIBUTES_SELECTED = Styles.createAttributeSet(null, null, true, null);
    private static final AttributeSet ATTRIBUTES_DELETED_ACTIVE = Styles.createAttributeSet(Styles.EditorColor.COLOR_MATCHES_DEL_ACTIVE.getColor(), null, true, null, true, null);
    private static final AttributeSet ATTRIBUTES_DELETED_INACTIVE = Styles.createAttributeSet(Styles.EditorColor.COLOR_MATCHES_DEL_INACTIVE.getColor(), null, null, null, true, null);
    private static final AttributeSet ATTRIBUTES_INSERTED_ACTIVE = Styles.createAttributeSet(Styles.EditorColor.COLOR_MATCHES_INS_ACTIVE.getColor(), null, true, null, null, true);
    private static final AttributeSet ATTRIBUTES_INSERTED_INACTIVE = Styles.createAttributeSet(Styles.EditorColor.COLOR_MATCHES_INS_INACTIVE.getColor(), null, null, null, null, true);
    private final List<NearString> matches = new ArrayList<NearString>();
    private final List<Integer> delimiters = new ArrayList<Integer>();
    private final List<Integer> sourcePos = new ArrayList<Integer>();
    private final List<Map<Integer, List<DiffDriver.TextRun>>> diffInfos = new ArrayList<Map<Integer, List<DiffDriver.TextRun>>>();
    private int activeMatch;
    private final MainWindow mw;
    protected MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            if (MatchesTextArea.this.matches == null || MatchesTextArea.this.matches.isEmpty()) {
                return;
            }
            int clickedItem = -1;
            int mousepos = MatchesTextArea.this.viewToModel(e.getPoint());
            for (int i = 0; i < MatchesTextArea.this.delimiters.size() - 1; ++i) {
                int start = (Integer)MatchesTextArea.this.delimiters.get(i);
                int end = (Integer)MatchesTextArea.this.delimiters.get(i + 1);
                if (mousepos < start || mousepos >= end) continue;
                clickedItem = i;
                break;
            }
            if (clickedItem == -1) {
                clickedItem = MatchesTextArea.this.delimiters.size() - 1;
            }
            if (clickedItem >= MatchesTextArea.this.matches.size()) {
                return;
            }
            if (e.isPopupTrigger() || e.getButton() == 3) {
                MatchesTextArea.this.mouseRightClick(clickedItem, e.getPoint());
            }
            if (e.getButton() == 1 && e.getClickCount() > 1) {
                MatchesTextArea.this.setActiveMatch(clickedItem);
            }
        }
    };

    public MatchesTextArea(MainWindow mw) {
        super(true);
        this.mw = mw;
        String title = OStrings.getString("GUI_MATCHWINDOW_SUBWINDOWTITLE_Fuzzy_Matches");
        final DockableScrollPane scrollPane = new DockableScrollPane("MATCHES", title, this, true);
        Core.getMainWindow().addDockable(scrollPane);
        this.setEditable(false);
        AlwaysVisibleCaret.apply(this);
        this.setText(EXPLANATION);
        this.setMinimumSize(new Dimension(100, 50));
        this.addMouseListener(this.mouseListener);
        DragTargetOverlay.apply(this, new DragTargetOverlay.FileDropInfo(mw, false){

            @Override
            public String getImportDestination() {
                return Core.getProject().getProjectProperties().getTMRoot();
            }

            @Override
            public boolean acceptFile(File pathname) {
                return pathname.getName().toLowerCase().endsWith(".tmx");
            }

            @Override
            public String getOverlayMessage() {
                return OStrings.getString("DND_ADD_TM_FILE");
            }

            @Override
            public boolean canAcceptDrop() {
                return Core.getProject().isProjectLoaded();
            }

            @Override
            public Component getComponentToOverlay() {
                return scrollPane;
            }
        });
    }

    @Override
    protected void startSearchThread(SourceTextEntry newEntry) {
        new FindMatchesThread(this, Core.getProject(), newEntry).start();
    }

    @Override
    protected void setFoundResult(SourceTextEntry se, List<NearString> newMatches) {
        UIThreadsUtil.mustBeSwingThread();
        if (newMatches == null) {
            this.setText("");
            return;
        }
        Collections.sort(newMatches, Collections.reverseOrder(new NearString.NearStringComparator()));
        this.activeMatch = -1;
        this.matches.clear();
        this.delimiters.clear();
        this.sourcePos.clear();
        this.diffInfos.clear();
        this.matches.addAll(newMatches);
        this.delimiters.add(0);
        StringBuilder displayBuffer = new StringBuilder();
        MatchesVarExpansion template = new MatchesVarExpansion(Preferences.getPreferenceDefault("ext_tmx_match_template", "${id}. ${fuzzyFlag}${sourceText}\n${targetText}\n<${score}/${noStemScore}/${adjustedScore}% ${filePath}>"));
        for (int i = 0; i < newMatches.size(); ++i) {
            NearString match = newMatches.get(i);
            MatchesVarExpansion.Result result = template.apply(match, i + 1);
            displayBuffer.append(result.text);
            this.sourcePos.add(result.sourcePos);
            this.diffInfos.add(result.diffInfo);
            if (i < newMatches.size() - 1) {
                displayBuffer.append("\n\n");
            }
            this.delimiters.add(displayBuffer.length());
        }
        this.setText(displayBuffer.toString());
        this.setActiveMatch(0);
        this.checkForReplaceTranslation();
    }

    @Override
    protected void onProjectOpen() {
        this.clear();
    }

    @Override
    protected void onProjectClose() {
        this.clear();
        this.setText(EXPLANATION);
        StyledDocument doc = (StyledDocument)this.getDocument();
        doc.setCharacterAttributes(0, doc.getLength(), ATTRIBUTES_EMPTY, true);
    }

    @Override
    public NearString getActiveMatch() {
        UIThreadsUtil.mustBeSwingThread();
        if (this.activeMatch < 0 || this.activeMatch >= this.matches.size()) {
            return null;
        }
        return this.matches.get(this.activeMatch);
    }

    @Override
    public String substituteNumbers(String source, String sourceMatch, String targetMatch) {
        ITokenizer sourceTok = Core.getProject().getSourceTokenizer();
        ITokenizer targetTok = Core.getProject().getTargetTokenizer();
        Token[] sourceMatchStrTokensAll = sourceTok.tokenizeVerbatim(sourceMatch);
        List<String> sourceMatchNumbers = this.getNumberList(sourceMatchStrTokensAll, sourceMatch);
        Token[] targetMatchStrTokensAll = targetTok.tokenizeVerbatim(targetMatch);
        List<String> targetMatchNumbers = this.getNumberList(targetMatchStrTokensAll, targetMatch);
        Token[] sourceStrTokensAll = sourceTok.tokenizeVerbatim(source);
        List<String> sourceNumbers = this.getNumberList(sourceStrTokensAll, source);
        if (sourceMatchNumbers.size() != targetMatchNumbers.size() || sourceMatchNumbers.size() != sourceNumbers.size()) {
            return targetMatch;
        }
        ArrayList<Integer> matchingNumbers = new ArrayList<Integer>();
        ArrayList<Integer> foundLocation = new ArrayList<Integer>();
        for (String oneNumber : sourceMatchNumbers) {
            int pos = -1;
            for (Token oneToken : targetMatchStrTokensAll) {
                if (!oneNumber.equals(oneToken.getTextFromString(targetMatch)) || foundLocation.contains(++pos)) continue;
                matchingNumbers.add(pos);
                foundLocation.add(pos);
            }
            if (pos != -1) continue;
            return targetMatch;
        }
        String finalString = "";
        int pos = -1;
        for (Token oneToken : targetMatchStrTokensAll) {
            ++pos;
            boolean replaced = false;
            for (int numberRank = 0; numberRank < matchingNumbers.size(); ++numberRank) {
                if ((Integer)matchingNumbers.get(numberRank) != pos) continue;
                finalString = finalString + sourceNumbers.get(numberRank);
                replaced = true;
            }
            if (replaced) continue;
            finalString = finalString + oneToken.getTextFromString(targetMatch);
        }
        return finalString;
    }

    private List<String> getNumberList(Token[] strTokenAll, String text) {
        ArrayList<String> numberList = new ArrayList<String>();
        for (Token oneToken : strTokenAll) {
            try {
                Integer.parseInt(oneToken.getTextFromString(text));
                numberList.add(oneToken.getTextFromString(text));
            }
            catch (NumberFormatException nfe) {
                try {
                    Double.parseDouble(oneToken.getTextFromString(text));
                    numberList.add(oneToken.getTextFromString(text));
                }
                catch (NumberFormatException nfe2) {
                    // empty catch block
                }
            }
        }
        return numberList;
    }

    private void checkForReplaceTranslation() {
        if (this.matches.isEmpty()) {
            return;
        }
        if (Preferences.isPreference("wf_insertBestMatch")) {
            int percentage;
            String percentage_s = Preferences.getPreferenceDefault("wf_minimalSimilarity", "80");
            try {
                percentage = Integer.parseInt(percentage_s);
            }
            catch (Exception exception) {
                Log.log("ERROR: exception while parsing percentage:");
                Log.log("Please report to the OmegaT developers (omegat-development@lists.sourceforge.net)");
                Log.log(exception);
                return;
            }
            NearString thebest = this.matches.get(0);
            if (thebest.scores[0].score >= percentage) {
                SourceTextEntry currentEntry = Core.getEditor().getCurrentEntry();
                TMXEntry te = Core.getProject().getTranslationInfo(currentEntry);
                if (!te.isTranslated()) {
                    String prefix = "";
                    if (!Preferences.getPreferenceDefaultAllowEmptyString("wf_explanatoryText").equals("")) {
                        prefix = Preferences.getPreferenceDefault("wf_explanatoryText", OStrings.getString("WF_DEFAULT_PREFIX"));
                    }
                    String translation = thebest.translation;
                    if (Preferences.isPreference("wf_convertNumbers")) {
                        translation = this.substituteNumbers(currentEntry.getSrcText(), thebest.source, thebest.translation);
                    }
                    Core.getEditor().replaceEditText(prefix + translation);
                }
            }
        }
    }

    @Override
    public void setActiveMatch(int activeMatch) {
        UIThreadsUtil.mustBeSwingThread();
        if (activeMatch < 0 || activeMatch >= this.matches.size() || this.activeMatch == activeMatch) {
            return;
        }
        this.activeMatch = activeMatch;
        StyledDocument doc = (StyledDocument)this.getDocument();
        doc.setCharacterAttributes(0, doc.getLength(), ATTRIBUTES_EMPTY, true);
        int start = this.delimiters.get(activeMatch);
        int end = this.delimiters.get(activeMatch + 1);
        NearString match = this.matches.get(activeMatch);
        ITokenizer tokenizer = Core.getProject().getSourceTokenizer();
        if (tokenizer == null) {
            return;
        }
        if (this.sourcePos.get(activeMatch) != -1) {
            Token[] tokens = tokenizer.tokenizeVerbatim(match.source);
            byte[] attributes = match.attr;
            for (int i = 0; i < tokens.length; ++i) {
                Token token = tokens[i];
                int tokstart = start + this.sourcePos.get(activeMatch) + token.getOffset();
                int toklength = token.getLength();
                if ((attributes[i] & 1) != 0) {
                    doc.setCharacterAttributes(tokstart, toklength, ATTRIBUTES_CHANGED, false);
                    continue;
                }
                if ((attributes[i] & 2) == 0) continue;
                doc.setCharacterAttributes(tokstart, toklength, ATTRIBUTES_UNCHANGED, false);
            }
        }
        for (int i = 0; i < this.diffInfos.size(); ++i) {
            Map<Integer, List<DiffDriver.TextRun>> diffInfo = this.diffInfos.get(i);
            for (Map.Entry<Integer, List<DiffDriver.TextRun>> e : diffInfo.entrySet()) {
                int diffPos = e.getKey();
                if (diffPos == -1) continue;
                for (DiffDriver.TextRun r : e.getValue()) {
                    int tokstart = this.delimiters.get(i) + diffPos + r.start;
                    switch (r.type) {
                        case DELETE: {
                            doc.setCharacterAttributes(tokstart, r.length, i == activeMatch ? ATTRIBUTES_DELETED_ACTIVE : ATTRIBUTES_DELETED_INACTIVE, false);
                            break;
                        }
                        case INSERT: {
                            doc.setCharacterAttributes(tokstart, r.length, i == activeMatch ? ATTRIBUTES_INSERTED_ACTIVE : ATTRIBUTES_INSERTED_INACTIVE, false);
                        }
                    }
                }
            }
        }
        doc.setCharacterAttributes(start, end - start, ATTRIBUTES_SELECTED, false);
        this.setCaretPosition(end - 2);
        final int fstart = start;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MatchesTextArea.this.setCaretPosition(fstart);
            }
        });
    }

    public void clear() {
        UIThreadsUtil.mustBeSwingThread();
        this.setFoundResult((SourceTextEntry)null, (List<NearString>)new ArrayList<NearString>());
    }

    private void mouseRightClick(final int clickedItem, Point clickedPoint) {
        String proj;
        JMenuItem item;
        JPopupMenu popup = new JPopupMenu();
        NearString m = this.matches.get(clickedItem);
        if (m.projs.length > 1) {
            item = popup.add(OStrings.getString("MATCHES_PROJECTS"));
            item.setEnabled(false);
            for (int i = 0; i < m.projs.length; ++i) {
                proj = m.projs[i];
                StringBuilder b = new StringBuilder();
                if (proj.equals("")) {
                    b.append(OStrings.getString("MATCHES_THIS_PROJECT"));
                } else {
                    b.append(proj);
                }
                b.append(" ");
                b.append(m.scores[i].toString());
                JMenuItem pItem = popup.add(b.toString());
                pItem.setEnabled(false);
            }
            popup.addSeparator();
        }
        item = popup.add(OStrings.getString("MATCHES_INSERT"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StringUtil.isEmpty(MatchesTextArea.this.getSelectedText())) {
                    MatchesTextArea.this.setActiveMatch(clickedItem);
                }
                MatchesTextArea.this.mw.doInsertTrans();
            }
        });
        item = popup.add(OStrings.getString("MATCHES_REPLACE"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StringUtil.isEmpty(MatchesTextArea.this.getSelectedText())) {
                    MatchesTextArea.this.setActiveMatch(clickedItem);
                }
                MatchesTextArea.this.mw.doRecycleTrans();
            }
        });
        popup.addSeparator();
        final NearString ns = this.matches.get(clickedItem);
        proj = ns.projs[0];
        item = popup.add(OStrings.getString("MATCHES_GO_TO_SEGMENT_SOURCE"));
        if (StringUtil.isEmpty(proj)) {
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Core.getEditor().gotoEntry(ns.source, ns.key);
                }
            });
        } else {
            item.setEnabled(false);
        }
        popup.show(this, clickedPoint.x, clickedPoint.y);
    }

    @Override
    public void setNextActiveMatch() {
        if (this.activeMatch < this.matches.size() - 1) {
            this.setActiveMatch(this.activeMatch + 1);
        }
    }

    @Override
    public void setPrevActiveMatch() {
        if (this.activeMatch > 0) {
            this.setActiveMatch(this.activeMatch - 1);
        }
    }
}

