/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.multtrans;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.JTextComponent;
import org.omegat.core.Core;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.gui.common.EntryInfoThreadPane;
import org.omegat.gui.editor.IPopupMenuConstructor;
import org.omegat.gui.editor.SegmentBuilder;
import org.omegat.gui.main.DockableScrollPane;
import org.omegat.gui.multtrans.MultipleTransFindThread;
import org.omegat.gui.multtrans.MultipleTransFoundEntry;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.AlwaysVisibleCaret;
import org.omegat.util.gui.UIThreadsUtil;

public class MultipleTransPane
extends EntryInfoThreadPane<List<MultipleTransFoundEntry>> {
    private static final String EXPLANATION = OStrings.getString("GUI_MULTIPLETRANSLATIONSWINDOW_explanation");
    private List<DisplayedEntry> entries = new ArrayList<DisplayedEntry>();
    protected MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.isPopupTrigger() || e.getButton() == 3) {
                if (MultipleTransPane.this.entries.isEmpty()) {
                    return;
                }
                int mousepos = MultipleTransPane.this.viewToModel(e.getPoint());
                for (DisplayedEntry de : MultipleTransPane.this.entries) {
                    if (de.start > mousepos || de.end < mousepos) continue;
                    MultipleTransPane.this.mouseRightClick(de, e.getPoint());
                    break;
                }
            }
        }
    };

    public MultipleTransPane() {
        super(true);
        String title = OStrings.getString("MULT_TITLE");
        Core.getMainWindow().addDockable(new DockableScrollPane("MULTIPLE_TRANS", title, this, true));
        this.setEditable(false);
        AlwaysVisibleCaret.apply(this);
        this.setText(EXPLANATION);
        this.setMinimumSize(new Dimension(100, 50));
        Core.getEditor().registerPopupMenuConstructors(600, new IPopupMenuConstructor(){

            @Override
            public void addItems(JPopupMenu menu, JTextComponent comp, int mousepos, boolean isInActiveEntry, boolean isInActiveTranslation, SegmentBuilder sb) {
                if (isInActiveEntry && Core.getProject().getProjectProperties().isSupportDefaultTranslations()) {
                    JMenuItem miDefault = menu.add(OStrings.getString("MULT_MENU_DEFAULT"));
                    JMenuItem miMultiple = menu.add(OStrings.getString("MULT_MENU_MULTIPLE"));
                    miDefault.setEnabled(!sb.isDefaultTranslation());
                    miMultiple.setEnabled(sb.isDefaultTranslation());
                    miDefault.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Core.getEditor().setAlternateTranslationForCurrentEntry(false);
                            Core.getEditor().commitAndLeave();
                        }
                    });
                    miMultiple.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Core.getEditor().setAlternateTranslationForCurrentEntry(true);
                        }
                    });
                }
            }
        });
        this.addMouseListener(this.mouseListener);
    }

    @Override
    protected void setFoundResult(SourceTextEntry processedEntry, List<MultipleTransFoundEntry> data) {
        UIThreadsUtil.mustBeSwingThread();
        this.entries.clear();
        String o = "";
        if (data.size() == 1 && data.get((int)0).key == null) {
            this.setText(o);
            return;
        }
        for (MultipleTransFoundEntry e : data) {
            DisplayedEntry de = new DisplayedEntry();
            de.entry = e;
            de.start = o.length();
            if (e.entry.translation == null) continue;
            if (e.key != null) {
                o = o + e.entry.translation + '\n';
                o = o + "<" + e.key.file;
                if (e.key.id != null) {
                    o = o + "/" + e.key.id;
                }
                o = o + ">\n";
                if (e.key.prev != null && e.key.next != null) {
                    o = o + "(" + StringUtil.firstN(e.key.prev, 10) + " <...> " + StringUtil.firstN(e.key.next, 10) + ")\n";
                }
            } else {
                o = o + e.entry.translation + '\n';
            }
            de.end = o.length();
            this.entries.add(de);
            o = o + "\n";
        }
        this.setText(o);
    }

    @Override
    protected void onProjectOpen() {
        UIThreadsUtil.mustBeSwingThread();
        this.entries.clear();
        this.setText("");
    }

    @Override
    protected void onProjectClose() {
        UIThreadsUtil.mustBeSwingThread();
        this.entries.clear();
        this.setText(EXPLANATION);
    }

    @Override
    protected void startSearchThread(SourceTextEntry newEntry) {
        new MultipleTransFindThread(this, Core.getProject(), newEntry).start();
    }

    private void mouseRightClick(final DisplayedEntry de, Point clickedPoint) {
        JMenuItem item;
        JPopupMenu popup = new JPopupMenu();
        if (de.entry.key != null) {
            item = popup.add(OStrings.getString("MULT_POPUP_DEFAULT"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Core.getEditor().replaceEditText(de.entry.entry.translation);
                    Core.getEditor().setAlternateTranslationForCurrentEntry(false);
                    Core.getEditor().commitAndLeave();
                }
            });
        }
        item = popup.add(OStrings.getString("MULT_POPUP_REPLACE"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Core.getEditor().replaceEditText(de.entry.entry.translation);
            }
        });
        item = popup.add(OStrings.getString("MULT_POPUP_GOTO"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Core.getEditor().gotoEntry(de.entry.sourceText, de.entry.key);
            }
        });
        popup.show(this, clickedPoint.x, clickedPoint.y);
    }

    protected static class DisplayedEntry {
        int start;
        int end;
        MultipleTransFoundEntry entry;

        protected DisplayedEntry() {
        }
    }
}

