/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.scripting;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.JList;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.events.IApplicationEventListener;
import org.omegat.core.events.IEditorEventListener;
import org.omegat.core.events.IEntryEventListener;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.gui.scripting.ScriptItem;
import org.omegat.gui.scripting.ScriptingWindow;
import org.omegat.util.DirectoryMonitor;

public class ScriptsMonitor
implements DirectoryMonitor.DirectoryCallback,
DirectoryMonitor.Callback {
    private static final boolean SCRIPTING_EVENTS = true;
    private static boolean applicationStartupEventScriptsExecuted = false;
    private final JList m_list;
    private final FilenameFilter m_filter;
    private File m_scriptDir;
    private List<String> m_extensions;
    protected DirectoryMonitor m_monitor;
    private ScriptingWindow m_scriptingWindow;
    private IEntryEventListener m_entryEventListener;
    private IProjectEventListener m_projectEventListener;
    private IApplicationEventListener m_applicationEventListener;
    private IEditorEventListener m_editorEventListener;
    private HashMap<EventType, ArrayList<ScriptItem>> m_eventsScript = new HashMap();

    public ScriptsMonitor(ScriptingWindow scriptingWindow, JList list, List<String> extensions) {
        this.m_list = list;
        this.m_scriptingWindow = scriptingWindow;
        this.m_extensions = extensions;
        this.m_filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String ext = ScriptingWindow.getFileExtension(name);
                return ScriptsMonitor.this.m_extensions.contains(ext.toLowerCase());
            }
        };
        for (EventType t : EventType.values()) {
            this.m_eventsScript.put(t, new ArrayList());
        }
    }

    public void start(File scriptDir) {
        this.m_scriptDir = scriptDir;
        this.m_monitor = new DirectoryMonitor(scriptDir, this, this);
        this.m_monitor.start();
        if (!applicationStartupEventScriptsExecuted) {
            applicationStartupEventScriptsExecuted = true;
            this.addEventScripts(EventType.APPLICATION_STARTUP);
            ArrayList<ScriptItem> scripts = this.m_eventsScript.get((Object)EventType.APPLICATION_STARTUP);
            for (ScriptItem si : scripts) {
                this.m_scriptingWindow.executeScriptFile(si, true);
            }
            scripts.clear();
        }
    }

    public void stop() {
        if (this.m_monitor != null) {
            this.m_monitor.fin();
        }
    }

    @Override
    public void fileChanged(File file) {
    }

    @Override
    public void directoryChanged(File file) {
        if (!this.m_scriptDir.isDirectory()) {
            return;
        }
        ArrayList<ScriptItem> scriptsList = new ArrayList<ScriptItem>();
        for (File script : this.m_scriptDir.listFiles(this.m_filter)) {
            scriptsList.add(new ScriptItem(script));
        }
        Collections.sort(scriptsList, new ScriptItem.ScriptItemComparator());
        this.m_list.setListData(scriptsList.toArray(new ScriptItem[scriptsList.size()]));
        this.hookApplicationEvent();
        this.hookEntryEvent();
        this.hookProjectEvent();
        this.hookEditorEvent();
    }

    private void hookEntryEvent() {
        if (this.m_entryEventListener != null) {
            CoreEvents.unregisterEntryEventListener(this.m_entryEventListener);
        }
        this.addEventScripts(EventType.ENTRY_ACTIVATED);
        this.addEventScripts(EventType.NEW_FILE);
        this.m_entryEventListener = new IEntryEventListener(){

            @Override
            public void onNewFile(String activeFileName) {
                HashMap<String, Object> binding = new HashMap<String, Object>();
                binding.put("activeFileName", activeFileName);
                for (ScriptItem si : (ArrayList)ScriptsMonitor.this.m_eventsScript.get((Object)EventType.NEW_FILE)) {
                    ScriptsMonitor.this.m_scriptingWindow.executeScriptFile(si, true, binding);
                }
            }

            @Override
            public void onEntryActivated(SourceTextEntry newEntry) {
                HashMap<String, Object> binding = new HashMap<String, Object>();
                binding.put("newEntry", newEntry);
                for (ScriptItem si : (ArrayList)ScriptsMonitor.this.m_eventsScript.get((Object)EventType.ENTRY_ACTIVATED)) {
                    ScriptsMonitor.this.m_scriptingWindow.executeScriptFile(si, true, binding);
                }
            }
        };
        CoreEvents.registerEntryEventListener(this.m_entryEventListener);
    }

    private void hookProjectEvent() {
        if (this.m_projectEventListener != null) {
            CoreEvents.unregisterProjectChangeListener(this.m_projectEventListener);
        }
        this.addEventScripts(EventType.PROJECT_CHANGED);
        this.m_projectEventListener = new IProjectEventListener(){

            @Override
            public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
                HashMap<String, Object> binding = new HashMap<String, Object>();
                binding.put("eventType", (Object)eventType);
                for (ScriptItem si : (ArrayList)ScriptsMonitor.this.m_eventsScript.get((Object)EventType.PROJECT_CHANGED)) {
                    ScriptsMonitor.this.m_scriptingWindow.executeScriptFile(si, true, binding);
                }
            }
        };
        CoreEvents.registerProjectChangeListener(this.m_projectEventListener);
    }

    private void hookApplicationEvent() {
        if (this.m_applicationEventListener != null) {
            CoreEvents.unregisterApplicationEventListener(this.m_applicationEventListener);
        }
        this.addEventScripts(EventType.APPLICATION_SHUTDOWN);
        this.m_applicationEventListener = new IApplicationEventListener(){

            @Override
            public void onApplicationStartup() {
            }

            @Override
            public void onApplicationShutdown() {
                for (ScriptItem si : (ArrayList)ScriptsMonitor.this.m_eventsScript.get((Object)EventType.APPLICATION_SHUTDOWN)) {
                    ScriptsMonitor.this.m_scriptingWindow.executeScriptFile(si, true);
                }
            }
        };
        CoreEvents.registerApplicationEventListener(this.m_applicationEventListener);
    }

    private void hookEditorEvent() {
        if (this.m_editorEventListener != null) {
            CoreEvents.unregisterEditorEventListener(this.m_editorEventListener);
        }
        this.addEventScripts(EventType.NEW_WORD);
        this.m_editorEventListener = new IEditorEventListener(){

            @Override
            public void onNewWord(String newWord) {
                HashMap<String, Object> binding = new HashMap<String, Object>();
                binding.put("newWord", newWord);
                for (ScriptItem si : (ArrayList)ScriptsMonitor.this.m_eventsScript.get((Object)EventType.NEW_WORD)) {
                    ScriptsMonitor.this.m_scriptingWindow.executeScriptFile(si, true, binding);
                }
            }
        };
        CoreEvents.registerEditorEventListener(this.m_editorEventListener);
    }

    private void addEventScripts(EventType eventType) {
        String entryDirName = eventType.name().toLowerCase();
        File entryActivatedDir = new File(this.m_scriptDir, entryDirName);
        if (!entryActivatedDir.isDirectory()) {
            return;
        }
        ArrayList<ScriptItem> eventScripts = this.m_eventsScript.get((Object)eventType);
        eventScripts.clear();
        for (File script : entryActivatedDir.listFiles(this.m_filter)) {
            ScriptItem scriptItem = new ScriptItem(script);
            if (eventScripts.contains(scriptItem)) continue;
            eventScripts.add(scriptItem);
        }
    }

    private static enum EventType {
        APPLICATION_STARTUP,
        APPLICATION_SHUTDOWN,
        NEW_WORD,
        PROJECT_CHANGED,
        ENTRY_ACTIVATED,
        NEW_FILE;

    }
}

