/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.search;

import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.UndoManager;
import org.omegat.core.Core;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.search.SearchExpression;
import org.omegat.core.search.SearchMode;
import org.omegat.core.search.Searcher;
import org.omegat.core.threads.SearchThread;
import org.omegat.gui.editor.EditorController;
import org.omegat.gui.editor.IEditor;
import org.omegat.gui.editor.IEditorFilter;
import org.omegat.gui.editor.filter.ReplaceFilter;
import org.omegat.gui.editor.filter.SearchFilter;
import org.omegat.gui.main.MainWindow;
import org.omegat.gui.search.EntryListPane;
import org.omegat.gui.search.HistoryManager;
import org.omegat.gui.search.SearchWindowForm;
import org.omegat.gui.shortcuts.PropertiesShortcuts;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.OmegaTFileChooser;
import org.omegat.util.gui.StaticUIUtils;
import org.omegat.util.gui.UIThreadsUtil;
import org.openide.awt.Mnemonics;

public class SearchWindowController {
    private final SearchWindowForm form;
    private final SearchMode mode;
    private final int initialEntry;
    private final EditorController.CaretPosition initialCaret;
    ActionListener searchFieldRequestFocus = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ((SearchWindowController)SearchWindowController.this).form.m_searchField.requestFocus();
        }
    };
    MainWindow m_parent;
    private SimpleDateFormat m_dateFormat;
    private SpinnerDateModel m_dateFromModel;
    private SpinnerDateModel m_dateToModel;
    private SearchThread m_thread;
    private static final String SAVED_DATE_FORMAT = "yyyy/MM/dd HH:mm";

    public SearchWindowController(MainWindow par, String startText, SearchMode mode) {
        this.form = new SearchWindowForm();
        this.mode = mode;
        this.initialEntry = Core.getEditor().getCurrentEntryNumber();
        this.initialCaret = this.getCurrentPositionInEntryTranslationInEditor(Core.getEditor());
        this.m_parent = par;
        this.m_dateFormat = new SimpleDateFormat(SAVED_DATE_FORMAT);
        this.form.m_searchField.setModel(new DefaultComboBoxModel<String>(HistoryManager.getSearchItems()));
        if (this.form.m_searchField.getModel().getSize() > 0) {
            this.form.m_searchField.setSelectedIndex(-1);
        }
        if (!StringUtil.isEmpty(startText)) {
            ((JTextField)this.form.m_searchField.getEditor().getEditorComponent()).setText(startText);
        }
        this.form.m_replaceField.setModel(new DefaultComboBoxModel<String>(HistoryManager.getReplaceItems()));
        if (this.form.m_replaceField.getModel().getSize() > 0) {
            this.form.m_replaceField.setSelectedIndex(-1);
        }
        Calendar calendar = Calendar.getInstance();
        Date initDate = calendar.getTime();
        calendar.add(1, -100);
        Date earliestDate = calendar.getTime();
        Date latestDate = initDate;
        this.m_dateFromModel = new SpinnerDateModel(initDate, earliestDate, latestDate, 1);
        this.form.m_dateFromSpinner.setModel(this.m_dateFromModel);
        this.m_dateToModel = new SpinnerDateModel(initDate, earliestDate, latestDate, 1);
        this.form.m_dateToSpinner.setModel(this.m_dateToModel);
        SpinnerNumberModel m_numberModel = new SpinnerNumberModel(1000, 1, Integer.MAX_VALUE, 1);
        this.form.m_numberOfResults.setModel(m_numberModel);
        this.loadPreferences();
        if (!Core.getProject().isProjectLoaded()) {
            this.form.m_rbDir.setSelected(true);
            this.form.m_rbProject.setEnabled(false);
        } else {
            this.form.m_rbProject.setSelected(true);
        }
        this.updateOptionStatus();
        this.initActions();
        switch (mode) {
            case SEARCH: {
                this.form.setTitle(OStrings.getString("SW_TITLE"));
                this.form.m_replaceLabel.setVisible(false);
                this.form.m_replaceField.setVisible(false);
                this.form.m_replaceAllButton.setVisible(false);
                this.form.m_replaceButton.setVisible(false);
                this.form.m_panelSearch.setVisible(true);
                this.form.m_panelReplace.setVisible(false);
                break;
            }
            case REPLACE: {
                this.form.setTitle(OStrings.getString("SW_TITLE_REPLACE"));
                this.form.m_SearchInPane.setVisible(false);
                this.form.m_allResultsCB.setVisible(false);
                this.form.m_fileNamesCB.setVisible(false);
                this.form.m_filterButton.setVisible(false);
                this.form.m_numberLabel.setVisible(false);
                this.form.m_numberOfResults.setVisible(false);
                this.form.m_panelSearch.setVisible(false);
                this.form.m_panelReplace.setVisible(true);
            }
        }
        this.form.setVisible(true);
        this.form.m_searchField.requestFocus();
    }

    final void initActions() {
        this.form.m_dismissButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchWindowController.this.doCancel();
            }
        });
        this.form.m_filterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchWindowController.this.doFilter();
            }
        });
        this.form.m_replaceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchWindowController.this.doReplace();
            }
        });
        this.form.m_replaceAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchWindowController.this.doReplaceAll();
            }
        });
        this.form.m_searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchWindowController.this.doSearch();
            }
        });
        this.form.m_advancedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchWindowController.this.setAdvancedOptionsVisible(!((SearchWindowController)SearchWindowController.this).form.m_advancedVisiblePane.isVisible());
            }
        });
        this.form.m_authorCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchWindowController.this.enableDisableAuthor();
            }
        });
        this.form.m_authorField.enterActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchWindowController.this.doSearch();
            }
        };
        this.form.m_dateToCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchWindowController.this.enableDisableDateTo();
            }
        });
        this.form.m_dateToButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchWindowController.this.doResetDateTo();
            }
        });
        this.form.m_dateFromButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchWindowController.this.doResetDateFrom();
            }
        });
        this.form.m_dateFromCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchWindowController.this.enableDisableDateFrom();
            }
        });
        this.form.m_dirButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchWindowController.this.doBrowseDirectory();
            }
        });
        StaticUIUtils.setEscapeAction(this.form, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchWindowController.this.doCancel();
            }
        });
        ActionMap actionMap = this.form.getRootPane().getActionMap();
        InputMap inputMap = this.form.getRootPane().getInputMap(2);
        actionMap.put("editFindInProjectMenuItem", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ((SearchWindowController)SearchWindowController.this).form.m_searchField.requestFocus();
                ((SearchWindowController)SearchWindowController.this).form.m_searchField.getEditor().selectAll();
            }
        });
        actionMap.put("editCreateGlossaryEntryMenuItem", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Core.getGlossary().showCreateGlossaryEntryDialog(SearchWindowController.this.form);
            }
        });
        PropertiesShortcuts shortcuts = new PropertiesShortcuts("/org/omegat/gui/main/MainMenuShortcuts.properties");
        shortcuts.bindKeyStrokes(inputMap, actionMap.keys());
        this.configureHistoryComboBox(this.form.m_searchField);
        this.configureHistoryComboBox(this.form.m_replaceField);
        this.form.m_searchExactSearchRB.addActionListener(this.searchFieldRequestFocus);
        this.form.m_searchKeywordSearchRB.addActionListener(this.searchFieldRequestFocus);
        this.form.m_searchRegexpSearchRB.addActionListener(this.searchFieldRequestFocus);
        this.form.m_searchCase.addActionListener(this.searchFieldRequestFocus);
        this.form.m_searchSpaceMatchNbsp.addActionListener(this.searchFieldRequestFocus);
        this.form.m_searchSource.addActionListener(this.searchFieldRequestFocus);
        this.form.m_searchTranslation.addActionListener(this.searchFieldRequestFocus);
        this.form.m_searchTranslatedUntranslated.addActionListener(this.searchFieldRequestFocus);
        this.form.m_searchTranslated.addActionListener(this.searchFieldRequestFocus);
        this.form.m_searchUntranslated.addActionListener(this.searchFieldRequestFocus);
        this.form.m_searchNotesCB.addActionListener(this.searchFieldRequestFocus);
        this.form.m_searchCommentsCB.addActionListener(this.searchFieldRequestFocus);
        this.form.m_cbSearchInGlossaries.addActionListener(this.searchFieldRequestFocus);
        this.form.m_cbSearchInMemory.addActionListener(this.searchFieldRequestFocus);
        this.form.m_cbSearchInTMs.addActionListener(this.searchFieldRequestFocus);
        this.form.m_allResultsCB.addActionListener(this.searchFieldRequestFocus);
        this.form.m_fileNamesCB.addActionListener(this.searchFieldRequestFocus);
        this.form.m_autoSyncWithEditor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EntryListPane viewer = (EntryListPane)((SearchWindowController)SearchWindowController.this).form.m_viewer;
                viewer.setAutoSyncWithEditor(((SearchWindowController)SearchWindowController.this).form.m_autoSyncWithEditor.isSelected());
            }
        });
        this.form.m_rbDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchWindowController.this.updateOptionStatus();
                if (((SearchWindowController)SearchWindowController.this).form.m_rbDir.isSelected()) {
                    ((SearchWindowController)SearchWindowController.this).form.m_dirField.requestFocus();
                } else {
                    ((SearchWindowController)SearchWindowController.this).form.m_searchField.requestFocus();
                }
            }
        });
        this.form.m_rbProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchWindowController.this.updateOptionStatus();
                ((SearchWindowController)SearchWindowController.this).form.m_searchField.requestFocus();
            }
        });
        this.form.m_numberOfResults.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ((SearchWindowController)SearchWindowController.this).form.m_searchField.requestFocus();
            }
        });
        this.form.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                SearchWindowController.this.savePreferences();
                SearchWindowController.this.m_parent.removeSearchWindow(SearchWindowController.this);
                if (SearchWindowController.this.m_thread != null) {
                    SearchWindowController.this.m_thread.fin();
                }
                int currentEntry = Core.getEditor().getCurrentEntryNumber();
                if (SearchWindowController.this.initialEntry > 0 && ((SearchWindowController)SearchWindowController.this).form.m_backToInitialSegment.isSelected() && SearchWindowController.this.initialEntry != currentEntry) {
                    boolean isSegDisplayed = SearchWindowController.this.isSegmentDisplayed(SearchWindowController.this.initialEntry);
                    if (isSegDisplayed) {
                        ((EditorController)Core.getEditor()).gotoEntry(SearchWindowController.this.initialEntry, SearchWindowController.this.initialCaret);
                    } else {
                        Core.getEditor().gotoEntry(SearchWindowController.this.initialEntry);
                    }
                }
            }
        });
    }

    private void configureHistoryComboBox(final JComboBox box) {
        JTextField field = (JTextField)box.getEditor().getEditorComponent();
        InputMap map = field.getInputMap();
        final UndoManager undoManager = new UndoManager();
        field.getDocument().addUndoableEditListener(undoManager);
        KeyStroke undoKey = KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false);
        map.put(undoKey, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (undoManager.canUndo()) {
                    undoManager.undo();
                }
            }
        });
        KeyStroke redoKey = KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false);
        map.put(redoKey, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (undoManager.canRedo()) {
                    undoManager.redo();
                }
            }
        });
        map.put(KeyStroke.getKeyStroke("ESCAPE"), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (box.isPopupVisible()) {
                    box.hidePopup();
                } else {
                    SearchWindowController.this.doCancel();
                }
            }
        });
        field.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!((SearchWindowController)SearchWindowController.this).form.m_searchField.getEditor().getItem().toString().isEmpty()) {
                    SearchWindowController.this.doSearch();
                }
            }
        });
    }

    private void loadPreferences() {
        try {
            String dx = Preferences.getPreference("search_window_x");
            String dy = Preferences.getPreference("search_window_y");
            int x = Integer.parseInt(dx);
            int y = Integer.parseInt(dy);
            this.form.setLocation(x, y);
            String dw = Preferences.getPreference("search_window_width");
            String dh = Preferences.getPreference("search_window_height");
            int w = Integer.parseInt(dw);
            int h = Integer.parseInt(dh);
            this.form.setSize(w, h);
        }
        catch (NumberFormatException nfe) {
            this.form.setSize(800, 700);
        }
        if (Preferences.isPreferenceDefault("search_window_search_files", false)) {
            this.form.m_rbDir.setSelected(true);
        } else {
            this.form.m_rbProject.setSelected(true);
        }
        this.form.m_dirField.setText(Preferences.getPreferenceDefault("search_window_dir", ""));
        this.form.m_recursiveCB.setSelected(Preferences.isPreferenceDefault("search_window_search_recursive", true));
        SearchExpression.SearchExpressionType searchType = Preferences.getPreferenceEnumDefault("search_window_search_type", SearchExpression.SearchExpressionType.EXACT);
        switch (searchType) {
            default: {
                this.form.m_searchExactSearchRB.setSelected(true);
                break;
            }
            case KEYWORD: {
                this.form.m_searchKeywordSearchRB.setSelected(true);
                break;
            }
            case REGEXP: {
                this.form.m_searchRegexpSearchRB.setSelected(true);
            }
        }
        this.form.m_searchCase.setSelected(Preferences.isPreferenceDefault("search_window_case_sensitive", false));
        this.form.m_searchSpaceMatchNbsp.setSelected(Preferences.isPreferenceDefault("search_window_space_match_nbsp", false));
        this.form.m_searchSource.setSelected(Preferences.isPreferenceDefault("search_window_search_source", true));
        this.form.m_searchTranslation.setSelected(Preferences.isPreferenceDefault("search_window_search_translation", true));
        SearchExpression.SearchState searchState = SearchExpression.SearchState.valueOf(Preferences.getPreferenceEnumDefault("search_window_search_state", SearchExpression.SearchState.TRANSLATED_UNTRANSLATED).name());
        switch (searchState) {
            default: {
                this.form.m_searchTranslatedUntranslated.setSelected(true);
                break;
            }
            case TRANSLATED: {
                this.form.m_searchTranslated.setSelected(true);
                break;
            }
            case UNTRANSLATED: {
                this.form.m_searchUntranslated.setSelected(true);
            }
        }
        this.form.m_replaceCase.setSelected(Preferences.isPreferenceDefault("search_window_case_sensitive_replace", false));
        this.form.m_replaceSpaceMatchNbsp.setSelected(Preferences.isPreferenceDefault("search_window_space_match_nbsp_replace", false));
        SearchExpression.SearchExpressionType replaceType = SearchExpression.SearchExpressionType.valueOf(Preferences.getPreferenceEnumDefault("search_window_replace_type", SearchExpression.SearchExpressionType.EXACT).name());
        switch (replaceType) {
            default: {
                this.form.m_replaceExactSearchRB.setSelected(true);
                break;
            }
            case REGEXP: {
                this.form.m_replaceRegexpSearchRB.setSelected(true);
            }
        }
        this.form.m_replaceUntranslated.setSelected(Preferences.isPreferenceDefault("search_window_replace_untranslated", true));
        this.form.m_searchNotesCB.setSelected(Preferences.isPreferenceDefault("search_window_search_notes", true));
        this.form.m_searchCommentsCB.setSelected(Preferences.isPreferenceDefault("search_window_search_comments", true));
        this.form.m_cbSearchInGlossaries.setSelected(Preferences.isPreferenceDefault("search_window_glossary_search", true));
        this.form.m_cbSearchInMemory.setSelected(Preferences.isPreferenceDefault("search_window_memory_search", true));
        this.form.m_cbSearchInTMs.setSelected(Preferences.isPreferenceDefault("search_window_tm_search", true));
        this.form.m_allResultsCB.setSelected(Preferences.isPreferenceDefault("search_window_all_results", false));
        this.form.m_fileNamesCB.setSelected(Preferences.isPreferenceDefault("search_window_file_names", false));
        this.form.m_autoSyncWithEditor.setSelected(Preferences.isPreferenceDefault("search_window_auto_sync", false));
        this.form.m_backToInitialSegment.setSelected(Preferences.isPreferenceDefault("search_window_back_to_initial_segment", false));
        this.updateOptionStatus();
        this.loadAdvancedOptionPreferences();
        this.updateAdvancedOptionStatus();
    }

    private void savePreferences() {
        Preferences.setPreference("search_window_width", this.form.getWidth());
        Preferences.setPreference("search_window_height", this.form.getHeight());
        Preferences.setPreference("search_window_x", this.form.getX());
        Preferences.setPreference("search_window_y", this.form.getY());
        if (this.form.m_searchExactSearchRB.isSelected()) {
            Preferences.setPreference("search_window_search_type", SearchExpression.SearchExpressionType.EXACT);
        } else if (this.form.m_searchKeywordSearchRB.isSelected()) {
            Preferences.setPreference("search_window_search_type", SearchExpression.SearchExpressionType.KEYWORD);
        } else if (this.form.m_searchRegexpSearchRB.isSelected()) {
            Preferences.setPreference("search_window_search_type", SearchExpression.SearchExpressionType.REGEXP);
        }
        Preferences.setPreference("search_window_case_sensitive", this.form.m_searchCase.isSelected());
        Preferences.setPreference("search_window_space_match_nbsp", this.form.m_searchSpaceMatchNbsp.isSelected());
        Preferences.setPreference("search_window_search_source", this.form.m_searchSource.isSelected());
        Preferences.setPreference("search_window_search_translation", this.form.m_searchTranslation.isSelected());
        if (this.form.m_searchTranslatedUntranslated.isSelected()) {
            Preferences.setPreference("search_window_search_state", SearchExpression.SearchState.TRANSLATED_UNTRANSLATED.name());
        } else if (this.form.m_searchTranslated.isSelected()) {
            Preferences.setPreference("search_window_search_state", SearchExpression.SearchState.TRANSLATED.name());
        } else if (this.form.m_searchUntranslated.isSelected()) {
            Preferences.setPreference("search_window_search_state", SearchExpression.SearchState.UNTRANSLATED.name());
        }
        Preferences.setPreference("search_window_case_sensitive_replace", this.form.m_replaceCase.isSelected());
        Preferences.setPreference("search_window_space_match_nbsp_replace", this.form.m_replaceSpaceMatchNbsp.isSelected());
        if (this.form.m_replaceExactSearchRB.isSelected()) {
            Preferences.setPreference("search_window_replace_type", SearchExpression.SearchExpressionType.EXACT);
        } else if (this.form.m_replaceRegexpSearchRB.isSelected()) {
            Preferences.setPreference("search_window_replace_type", SearchExpression.SearchExpressionType.REGEXP);
        }
        Preferences.setPreference("search_window_replace_untranslated", this.form.m_replaceUntranslated.isSelected());
        Preferences.setPreference("search_window_search_notes", this.form.m_searchNotesCB.isSelected());
        Preferences.setPreference("search_window_search_comments", this.form.m_searchCommentsCB.isSelected());
        Preferences.setPreference("search_window_glossary_search", this.form.m_cbSearchInGlossaries.isSelected());
        Preferences.setPreference("search_window_memory_search", this.form.m_cbSearchInMemory.isSelected());
        Preferences.setPreference("search_window_tm_search", this.form.m_cbSearchInTMs.isSelected());
        Preferences.setPreference("search_window_all_results", this.form.m_allResultsCB.isSelected());
        Preferences.setPreference("search_window_file_names", this.form.m_fileNamesCB.isSelected());
        Preferences.setPreference("search_window_advanced_visible", this.form.m_advancedVisiblePane.isVisible());
        Preferences.setPreference("search_window_search_author", this.form.m_authorCB.isSelected());
        Preferences.setPreference("search_window_author_name", this.form.m_authorField.getText());
        Preferences.setPreference("search_window_date_from", this.form.m_dateFromCB.isSelected());
        Preferences.setPreference("search_window_date_from_value", this.m_dateFormat.format(this.m_dateFromModel.getDate()));
        Preferences.setPreference("search_window_date_to", this.form.m_dateToCB.isSelected());
        Preferences.setPreference("search_window_date_to_value", this.m_dateFormat.format(this.m_dateToModel.getDate()));
        Preferences.setPreference("search_window_number_of_results", (Integer)this.form.m_numberOfResults.getValue());
        Preferences.setPreference("search_window_exclude_orphans", this.form.m_excludeOrphans.isSelected());
        Preferences.setPreference("search_window_dir", this.form.m_dirField.getText());
        Preferences.setPreference("search_window_search_files", this.form.m_rbDir.isSelected());
        Preferences.setPreference("search_window_search_recursive", this.form.m_recursiveCB.isSelected());
        Preferences.setPreference("search_window_auto_sync", this.form.m_autoSyncWithEditor.isSelected());
        Preferences.setPreference("search_window_back_to_initial_segment", this.form.m_backToInitialSegment.isSelected());
        HistoryManager.save();
        Preferences.save();
    }

    private void updateOptionStatus() {
        this.setEnabled(this.form.m_SearchInProjectPane, this.form.m_rbProject.isSelected());
        this.form.m_rbProject.setEnabled(true);
        this.setEnabled(this.form.m_SearchInDirPane, this.form.m_rbDir.isSelected());
        this.form.m_rbDir.setEnabled(true);
    }

    public void displaySearchResult(final Searcher searcher) {
        UIThreadsUtil.executeInSwingThread(new Runnable(){

            @Override
            public void run() {
                EntryListPane viewer = (EntryListPane)((SearchWindowController)SearchWindowController.this).form.m_viewer;
                viewer.displaySearchResult(searcher, (Integer)((SearchWindowController)SearchWindowController.this).form.m_numberOfResults.getValue());
                ((SearchWindowController)SearchWindowController.this).form.m_resultsLabel.setText(StringUtil.format(OStrings.getString("SW_NR_OF_RESULTS"), viewer.getNrEntries()));
                ((SearchWindowController)SearchWindowController.this).form.m_filterButton.setEnabled(true);
                ((SearchWindowController)SearchWindowController.this).form.m_replaceButton.setEnabled(true);
                ((SearchWindowController)SearchWindowController.this).form.m_replaceAllButton.setEnabled(true);
                if (searcher.getSearchResults().isEmpty()) {
                    ((SearchWindowController)SearchWindowController.this).form.m_searchField.requestFocus();
                    ((SearchWindowController)SearchWindowController.this).form.m_searchField.getEditor().selectAll();
                } else {
                    viewer.requestFocus();
                }
            }
        });
    }

    private void doBrowseDirectory() {
        File dir;
        OmegaTFileChooser browser = new OmegaTFileChooser();
        browser.setDialogTitle(OStrings.getString("SW_TITLE"));
        browser.setFileSelectionMode(1);
        String curDir = this.form.m_dirField.getText();
        if (!curDir.equals("") && (dir = new File(curDir)).exists() && dir.isDirectory()) {
            browser.setCurrentDirectory(dir);
        }
        browser.showOpenDialog(this.form);
        dir = browser.getSelectedFile();
        if (dir == null) {
            return;
        }
        String str = dir.getAbsolutePath() + File.separator;
        this.form.m_dirField.setText(str);
    }

    private void doFilter() {
        EntryListPane viewer = (EntryListPane)this.form.m_viewer;
        Core.getEditor().commitAndLeave();
        Core.getEditor().setFilter(new SearchFilter(viewer.getEntryList()));
    }

    private void doReplace() {
        String replaceString = this.form.m_replaceField.getEditor().getItem().toString();
        HistoryManager.addReplaceItem(replaceString);
        this.form.m_replaceField.setModel(new DefaultComboBoxModel<String>(HistoryManager.getReplaceItems()));
        EntryListPane viewer = (EntryListPane)this.form.m_viewer;
        Core.getEditor().commitAndLeave();
        Core.getEditor().setFilter(new ReplaceFilter(viewer.getEntryList(), viewer.getSearcher(), replaceString));
    }

    private void doReplaceAll() {
        String replaceString = this.form.m_replaceField.getEditor().getItem().toString();
        HistoryManager.addReplaceItem(replaceString);
        this.form.m_replaceField.setModel(new DefaultComboBoxModel<String>(HistoryManager.getReplaceItems()));
        EntryListPane viewer = (EntryListPane)this.form.m_viewer;
        Core.getEditor().commitAndDeactivate();
        int count = viewer.getEntryList().size();
        String msg = MessageFormat.format(OStrings.getString("SW_REPLACE_ALL_CONFIRM"), count);
        int r = JOptionPane.showConfirmDialog(this.form, msg, OStrings.getString("CONFIRM_DIALOG_TITLE"), 0);
        if (r == 0) {
            new ReplaceFilter(viewer.getEntryList(), viewer.getSearcher(), replaceString).replaceAll();
        }
        Core.getEditor().activateEntry();
        this.form.m_replaceButton.setEnabled(false);
        this.form.m_replaceAllButton.setEnabled(false);
    }

    private void doSearch() {
        UIThreadsUtil.mustBeSwingThread();
        if (this.m_thread != null) {
            this.m_thread.fin();
        }
        EntryListPane viewer = (EntryListPane)this.form.m_viewer;
        String queryString = this.form.m_searchField.getEditor().getItem().toString();
        HistoryManager.addSearchItem(queryString);
        this.form.m_searchField.setModel(new DefaultComboBoxModel<String>(HistoryManager.getSearchItems()));
        this.form.m_searchField.requestFocus();
        viewer.reset();
        String root = null;
        if (this.form.m_rbDir.isSelected()) {
            File f;
            root = this.form.m_dirField.getText();
            if (!root.endsWith(File.separator)) {
                root = root + File.separator;
            }
            if (!(f = new File(root)).exists() || !f.isDirectory()) {
                String error = StringUtil.format(OStrings.getString("SW_ERROR_BAD_DIR"), this.form.m_dirField.getText());
                this.form.m_viewer.setText(error);
                Log.log(error);
                return;
            }
        }
        this.savePreferences();
        if (StringUtil.isEmpty(queryString)) {
            this.form.setTitle(OStrings.getString("SW_TITLE"));
        } else {
            this.form.setTitle(queryString + " - OmegaT");
        }
        SearchExpression s = new SearchExpression();
        s.mode = this.mode;
        s.text = queryString;
        s.rootDir = root;
        s.recursive = this.form.m_recursiveCB.isSelected();
        switch (this.mode) {
            case SEARCH: {
                if (this.form.m_searchExactSearchRB.isSelected()) {
                    s.searchExpressionType = SearchExpression.SearchExpressionType.EXACT;
                } else if (this.form.m_searchKeywordSearchRB.isSelected()) {
                    s.searchExpressionType = SearchExpression.SearchExpressionType.KEYWORD;
                } else if (this.form.m_searchRegexpSearchRB.isSelected()) {
                    s.searchExpressionType = SearchExpression.SearchExpressionType.REGEXP;
                }
                s.caseSensitive = this.form.m_searchCase.isSelected();
                s.spaceMatchNbsp = this.form.m_searchSpaceMatchNbsp.isSelected();
                s.glossary = this.mode == SearchMode.SEARCH ? this.form.m_cbSearchInGlossaries.isSelected() : false;
                s.memory = this.mode == SearchMode.SEARCH ? this.form.m_cbSearchInMemory.isSelected() : true;
                s.tm = this.mode == SearchMode.SEARCH ? this.form.m_cbSearchInTMs.isSelected() : false;
                s.allResults = this.mode == SearchMode.SEARCH ? this.form.m_allResultsCB.isSelected() : true;
                s.fileNames = this.mode == SearchMode.SEARCH ? this.form.m_fileNamesCB.isSelected() : true;
                s.searchSource = this.form.m_searchSource.isSelected();
                s.searchTarget = this.form.m_searchTranslation.isSelected();
                if (this.form.m_searchTranslatedUntranslated.isSelected()) {
                    s.searchTranslated = true;
                    s.searchUntranslated = true;
                    break;
                }
                if (this.form.m_searchTranslated.isSelected()) {
                    s.searchTranslated = true;
                    s.searchUntranslated = false;
                    break;
                }
                if (!this.form.m_searchUntranslated.isSelected()) break;
                s.searchTranslated = false;
                s.searchUntranslated = true;
                break;
            }
            case REPLACE: {
                if (this.form.m_replaceExactSearchRB.isSelected()) {
                    s.searchExpressionType = SearchExpression.SearchExpressionType.EXACT;
                } else if (this.form.m_replaceRegexpSearchRB.isSelected()) {
                    s.searchExpressionType = SearchExpression.SearchExpressionType.REGEXP;
                }
                s.caseSensitive = this.form.m_replaceCase.isSelected();
                s.spaceMatchNbsp = this.form.m_replaceSpaceMatchNbsp.isSelected();
                s.glossary = false;
                s.memory = true;
                s.tm = false;
                s.allResults = true;
                s.fileNames = Core.getProject().getProjectFiles().size() > 1;
                s.searchSource = false;
                s.searchTarget = false;
                s.searchTranslated = false;
                s.searchUntranslated = false;
                s.replaceTranslated = true;
                s.replaceUntranslated = this.form.m_replaceUntranslated.isSelected();
            }
        }
        s.searchNotes = this.form.m_searchNotesCB.isSelected();
        s.searchComments = this.form.m_searchCommentsCB.isSelected();
        s.searchAuthor = this.form.m_authorCB.isSelected();
        s.author = this.form.m_authorField.getText();
        s.searchDateAfter = this.form.m_dateFromCB.isSelected();
        s.dateAfter = this.m_dateFromModel.getDate().getTime();
        s.searchDateBefore = this.form.m_dateToCB.isSelected();
        s.dateBefore = this.m_dateToModel.getDate().getTime();
        s.numberOfResults = this.mode == SearchMode.SEARCH ? (Integer)this.form.m_numberOfResults.getValue() : Integer.MAX_VALUE;
        s.excludeOrphans = this.form.m_excludeOrphans.isSelected();
        Searcher searcher = new Searcher(Core.getProject(), s);
        this.m_thread = new SearchThread(this, searcher);
        this.m_thread.start();
    }

    private void doCancel() {
        UIThreadsUtil.mustBeSwingThread();
        if (this.m_thread != null) {
            this.m_thread.fin();
        }
        this.form.dispose();
    }

    public void dispose() {
        this.form.dispose();
    }

    private boolean isSegmentDisplayed(int entry) {
        IEditorFilter filter = Core.getEditor().getFilter();
        if (filter == null) {
            return true;
        }
        SourceTextEntry ste = Core.getProject().getAllEntries().get(entry - 1);
        return filter.allowed(ste);
    }

    private void setAdvancedOptionsVisible(boolean visible) {
        this.form.m_advancedVisiblePane.setVisible(visible);
        Mnemonics.setLocalizedText(this.form.m_advancedButton, visible ? OStrings.getString("SW_HIDE_ADVANCED_OPTIONS") : OStrings.getString("SW_SHOW_ADVANCED_OPTIONS"));
        this.updateAdvancedOptionStatus();
    }

    private void enableDisableAuthor() {
        boolean editable = this.form.m_authorCB.isSelected();
        this.form.m_authorField.setEditable(editable);
        if (editable) {
            this.form.m_authorField.requestFocus();
        } else {
            this.form.m_searchField.requestFocus();
        }
    }

    private void enableDisableDateFrom() {
        boolean enable = this.form.m_dateFromCB.isSelected();
        this.form.m_dateFromSpinner.setEnabled(enable);
        this.form.m_dateFromButton.setEnabled(enable);
        if (enable) {
            this.form.m_dateFromSpinner.requestFocus();
        } else {
            this.form.m_searchField.requestFocus();
        }
    }

    private void doResetDateFrom() {
        Calendar calendar = Calendar.getInstance();
        Date now = calendar.getTime();
        this.m_dateFromModel.setEnd(now);
        this.m_dateFromModel.setValue(now);
    }

    private void doResetDateTo() {
        Calendar calendar = Calendar.getInstance();
        Date now = calendar.getTime();
        this.m_dateToModel.setEnd(now);
        this.m_dateToModel.setValue(now);
    }

    private void enableDisableDateTo() {
        boolean enable = this.form.m_dateToCB.isSelected();
        this.form.m_dateToSpinner.setEnabled(enable);
        this.form.m_dateToButton.setEnabled(enable);
        if (enable) {
            this.form.m_dateToSpinner.requestFocus();
        } else {
            this.form.m_searchField.requestFocus();
        }
    }

    private void loadAdvancedOptionPreferences() {
        this.setAdvancedOptionsVisible(Preferences.isPreference("search_window_advanced_visible"));
        this.form.m_authorCB.setSelected(Preferences.isPreference("search_window_search_author"));
        this.form.m_authorField.setText(Preferences.getPreference("search_window_author_name"));
        try {
            this.form.m_dateFromCB.setSelected(Preferences.isPreference("search_window_date_from"));
            String dateFromValue = Preferences.getPreference("search_window_date_from_value");
            if (!StringUtil.isEmpty(dateFromValue)) {
                this.m_dateFromModel.setValue(this.m_dateFormat.parse(dateFromValue));
            }
            this.form.m_dateToCB.setSelected(Preferences.isPreference("search_window_date_to"));
            String dateToValue = Preferences.getPreference("search_window_date_to_value");
            if (!StringUtil.isEmpty(dateToValue)) {
                this.m_dateToModel.setValue(this.m_dateFormat.parse(dateToValue));
            }
        }
        catch (ParseException e) {
            this.form.m_dateFromCB.setSelected(false);
            this.form.m_dateToCB.setSelected(false);
        }
        this.form.m_numberOfResults.setValue(Preferences.getPreferenceDefault("search_window_number_of_results", 1000));
        this.form.m_excludeOrphans.setSelected(Preferences.isPreference("search_window_exclude_orphans"));
        if (this.form.m_authorCB.isSelected() || this.form.m_dateFromCB.isSelected() || this.form.m_dateToCB.isSelected() || this.form.m_excludeOrphans.isSelected()) {
            this.setAdvancedOptionsVisible(true);
        }
    }

    private void updateAdvancedOptionStatus() {
        this.form.m_authorField.setEditable(this.form.m_authorCB.isSelected());
        this.form.m_dateFromSpinner.setEnabled(this.form.m_dateFromCB.isSelected());
        this.form.m_dateFromButton.setEnabled(this.form.m_dateFromCB.isSelected());
        this.form.m_dateToSpinner.setEnabled(this.form.m_dateToCB.isSelected());
        this.form.m_dateToButton.setEnabled(this.form.m_dateToCB.isSelected());
    }

    private void setEnabled(Container component, boolean enabled) {
        component.setEnabled(enabled);
        for (int i = 0; i < component.getComponentCount(); ++i) {
            Component c = component.getComponent(i);
            c.setEnabled(enabled);
            if (!(c instanceof Container)) continue;
            this.setEnabled((Container)c, enabled);
        }
    }

    private EditorController.CaretPosition getCurrentPositionInEntryTranslationInEditor(IEditor editor) {
        if (editor instanceof EditorController) {
            EditorController c = (EditorController)editor;
            int selectionEnd = c.getCurrentPositionInEntryTranslation();
            String selection = c.getSelectedText();
            String translation = c.getCurrentTranslation();
            if (StringUtil.isEmpty(translation) || StringUtil.isEmpty(selection)) {
                return new EditorController.CaretPosition(selectionEnd);
            }
            int selectionStart = selectionEnd;
            int pos = 0;
            do {
                if ((pos = translation.indexOf(selection, pos)) == selectionEnd) {
                    selectionStart = pos;
                    selectionEnd = pos + selection.length();
                    break;
                }
                if (pos + selection.length() != selectionEnd) continue;
                selectionStart = pos;
                break;
            } while (++pos > 0);
            return new EditorController.CaretPosition(selectionStart, selectionEnd);
        }
        return EditorController.CaretPosition.startOfEntry();
    }

    public void displayErrorRB(final Throwable ex, final String errorKey, final Object ... params) {
        UIThreadsUtil.executeInSwingThread(new Runnable(){

            @Override
            public void run() {
                String msg = params != null ? StringUtil.format(OStrings.getString(errorKey), params) : OStrings.getString(errorKey);
                String fulltext = msg;
                if (ex != null) {
                    fulltext = fulltext + "\n" + ex.getLocalizedMessage();
                }
                JOptionPane.showMessageDialog(SearchWindowController.this.form, fulltext, OStrings.getString("TF_ERROR"), 0);
            }
        });
    }
}

