/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.tokenizer;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.snowball.SnowballAnalyzer;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.omegat.tokenizer.BaseTokenizer;
import org.omegat.tokenizer.Tokenizer;

@Tokenizer(languages={"en"})
public class SnowballEnglishTokenizer
extends BaseTokenizer {
    public static final String[] STOP_WORDS;

    @Override
    protected TokenStream getTokenStream(String strOrig, boolean stemsAllowed, boolean stopWordsAllowed) {
        if (stemsAllowed) {
            return new SnowballAnalyzer(this.getBehavior(), "English", stopWordsAllowed ? STOP_WORDS : new String[]{}).tokenStream(null, new StringReader(strOrig));
        }
        return new StandardTokenizer(this.getBehavior(), (Reader)new StringReader(strOrig));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        try {
            InputStream in = SnowballEnglishTokenizer.class.getResourceAsStream("StopList_en.txt");
            try {
                String s;
                BufferedReader rd = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                ArrayList<String> words = new ArrayList<String>();
                while ((s = rd.readLine()) != null) {
                    if ((s = s.trim()).isEmpty() || s.startsWith("#")) continue;
                    words.add(s);
                }
                STOP_WORDS = words.toArray(new String[words.size()]);
            }
            finally {
                in.close();
            }
        }
        catch (Exception ex) {
            throw new ExceptionInInitializerError("Error load stopwords in SnowballEnglishTokenizer: " + ex.getMessage());
        }
    }
}

