/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import gen.core.project.Masks;
import gen.core.project.Omegat;
import gen.core.project.Project;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.segmentation.SRX;
import org.omegat.filters2.TranslationException;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.filters2.master.PluginUtils;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;

public class ProjectFileStorage {
    private static final JAXBContext CONTEXT;

    public static ProjectProperties loadProjectProperties(File projectDir) throws Exception {
        ProjectProperties result = new ProjectProperties(projectDir);
        File inFile = new File(projectDir, "omegat.project");
        Omegat om = (Omegat)CONTEXT.createUnmarshaller().unmarshal(inFile);
        if (!"1.0".equals(om.getProject().getVersion())) {
            throw new TranslationException(StringUtil.format(OStrings.getString("PFR_ERROR_UNSUPPORTED_PROJECT_VERSION"), om.getProject().getVersion()));
        }
        String m_root = inFile.getParentFile().getAbsolutePath() + File.separator;
        result.setTargetRoot(ProjectFileStorage.computeAbsolutePath(m_root, om.getProject().getTargetDir(), "target"));
        result.setSourceRoot(ProjectFileStorage.computeAbsolutePath(m_root, om.getProject().getSourceDir(), "source"));
        result.getSourceRootExcludes().clear();
        if (om.getProject().getSourceDirExcludes() != null) {
            result.getSourceRootExcludes().addAll(om.getProject().getSourceDirExcludes().getMask());
        } else {
            result.getSourceRootExcludes().addAll(Arrays.asList(ProjectProperties.DEFAULT_EXCLUDES));
        }
        result.setTMRoot(ProjectFileStorage.computeAbsolutePath(m_root, om.getProject().getTmDir(), "tm"));
        result.setGlossaryRoot(ProjectFileStorage.computeAbsolutePath(m_root, om.getProject().getGlossaryDir(), "glossary"));
        String glossaryFile = om.getProject().getGlossaryFile();
        if (StringUtil.isEmpty(glossaryFile)) {
            glossaryFile = "__DEFAULT__";
        }
        if (glossaryFile.equalsIgnoreCase("__DEFAULT__")) {
            glossaryFile = result.computeDefaultWriteableGlossaryFile();
        } else if (!new File(glossaryFile).isAbsolute()) {
            String absGlossaryRoot = ProjectFileStorage.computeAbsolutePath(m_root, result.getGlossaryRoot(), "glossary");
            glossaryFile = new File(absGlossaryRoot, glossaryFile).getPath();
        }
        result.setWriteableGlossary(glossaryFile);
        result.setDictRoot(ProjectFileStorage.computeAbsolutePath(m_root, om.getProject().getDictionaryDir(), "dictionary"));
        result.setSourceLanguage(om.getProject().getSourceLang());
        result.setTargetLanguage(om.getProject().getTargetLang());
        result.setSourceTokenizer(ProjectFileStorage.loadTokenizer(om.getProject().getSourceTok(), result.getSourceLanguage()));
        result.setTargetTokenizer(ProjectFileStorage.loadTokenizer(om.getProject().getTargetTok(), result.getTargetLanguage()));
        if (om.getProject().isSentenceSeg() != null) {
            result.setSentenceSegmentingEnabled(om.getProject().isSentenceSeg());
        }
        if (om.getProject().isSupportDefaultTranslations() != null) {
            result.setSupportDefaultTranslations(om.getProject().isSupportDefaultTranslations());
        }
        if (om.getProject().isRemoveTags() != null) {
            result.setRemoveTags(om.getProject().isRemoveTags());
        }
        if (om.getProject().getExternalCommand() != null) {
            result.setExternalCommand(om.getProject().getExternalCommand());
        }
        return result;
    }

    public static void writeProjectFile(ProjectProperties props) throws Exception {
        File outFile = new File(props.getProjectRoot(), "omegat.project");
        String m_root = outFile.getParentFile().getAbsolutePath() + File.separator;
        Omegat om = new Omegat();
        om.setProject(new Project());
        om.getProject().setVersion("1.0");
        om.getProject().setSourceDir(ProjectFileStorage.computeRelativePath(m_root, props.getSourceRoot(), "source"));
        om.getProject().setSourceDirExcludes(new Masks());
        om.getProject().getSourceDirExcludes().getMask().addAll(props.getSourceRootExcludes());
        om.getProject().setTargetDir(ProjectFileStorage.computeRelativePath(m_root, props.getTargetRoot(), "target"));
        om.getProject().setTmDir(ProjectFileStorage.computeRelativePath(m_root, props.getTMRoot(), "tm"));
        om.getProject().setGlossaryDir(ProjectFileStorage.computeRelativePath(m_root, props.getGlossaryRoot(), "glossary"));
        String glossaryFile = ProjectFileStorage.computeRelativePath(props.getGlossaryRoot(), props.getWriteableGlossary(), null);
        String glossaryDir = ProjectFileStorage.computeRelativePath(m_root, props.getGlossaryRoot(), "glossary");
        if (glossaryDir.equalsIgnoreCase("__DEFAULT__") && props.isDefaultWriteableGlossaryFile()) {
            glossaryFile = "__DEFAULT__";
        }
        om.getProject().setGlossaryFile(glossaryFile);
        om.getProject().setDictionaryDir(ProjectFileStorage.computeRelativePath(m_root, props.getDictRoot(), "dictionary"));
        om.getProject().setSourceLang(props.getSourceLanguage().toString());
        om.getProject().setTargetLang(props.getTargetLanguage().toString());
        om.getProject().setSourceTok(props.getSourceTokenizer().getCanonicalName());
        om.getProject().setTargetTok(props.getTargetTokenizer().getCanonicalName());
        om.getProject().setSentenceSeg(props.isSentenceSegmentingEnabled());
        om.getProject().setSupportDefaultTranslations(props.isSupportDefaultTranslations());
        om.getProject().setRemoveTags(props.isRemoveTags());
        om.getProject().setExternalCommand(props.getExternalCommand());
        Marshaller m = CONTEXT.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        m.marshal((Object)om, outFile);
        SRX.saveTo(props.getProjectSRX(), new File(props.getProjectInternal(), "segmentation.conf"));
        FilterMaster.saveConfig(props.getProjectFilters(), props.getProjectInternal());
    }

    private static String computeAbsolutePath(String m_root, String relativePath, String defaultName) {
        if (relativePath == null) {
            return m_root + defaultName + File.separator;
        }
        if ("__DEFAULT__".equals(relativePath)) {
            return m_root + defaultName + File.separator;
        }
        try {
            boolean startsWithRoot = false;
            for (File root : File.listRoots()) {
                try {
                    String platformRelativePath = relativePath.replace('/', File.separatorChar);
                    startsWithRoot = platformRelativePath.startsWith(root.getCanonicalPath());
                }
                catch (IOException e) {
                    startsWithRoot = false;
                }
                if (!startsWithRoot) continue;
                return new File(relativePath).getCanonicalPath() + File.separator;
            }
            return new File(m_root, relativePath).getCanonicalPath() + File.separator;
        }
        catch (IOException e) {
            return relativePath;
        }
    }

    private static String computeRelativePath(String m_root, String absolutePath, String defaultName) {
        if (defaultName != null && new File(absolutePath).equals(new File(m_root, defaultName))) {
            return "__DEFAULT__";
        }
        try {
            String res = absolutePath;
            File abs = new File(absolutePath).getCanonicalFile();
            File root = new File(m_root).getCanonicalFile();
            String prefix = "";
            for (int i = 0; i <= 5; ++i) {
                if ((abs.getPath() + File.separator).startsWith(root.getPath() + File.separator)) {
                    res = prefix + abs.getPath().substring(root.getPath().length());
                    if (!res.startsWith(File.separator)) break;
                    res = res.substring(1);
                    break;
                }
                root = root.getParentFile();
                prefix = prefix + File.separator + "..";
                if (root == null) break;
            }
            return res.replace(File.separatorChar, '/');
        }
        catch (IOException e) {
            return absolutePath.replace(File.separatorChar, '/');
        }
    }

    private static Class<?> loadTokenizer(String className, Language fallback) {
        if (!StringUtil.isEmpty(className)) {
            try {
                return ProjectFileStorage.class.getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                Log.log(e.toString());
            }
        }
        return PluginUtils.getTokenizerClassForLanguage(fallback);
    }

    static {
        try {
            CONTEXT = JAXBContext.newInstance((Class[])new Class[]{Omegat.class});
        }
        catch (Exception ex) {
            throw new ExceptionInInitializerError(ex);
        }
    }
}

