/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.awt.GraphicsEnvironment;
import java.awt.event.KeyEvent;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.regex.Pattern;
import org.omegat.util.LFileCopy;
import org.omegat.util.Log;
import org.omegat.util.OConsts;
import org.omegat.util.Platform;
import org.omegat.util.RuntimePreferences;
import org.omegat.util.StringUtil;

public class StaticUtils {
    private static final String WINDOWS_CONFIG_DIR = "\\OmegaT\\";
    private static final String UNIX_CONFIG_DIR = "/.omegat/";
    private static final String OSX_CONFIG_DIR = "/Library/Preferences/OmegaT/";
    private static final String SCRIPT_DIR = "script";
    public static final char TAG_REPLACEMENT_CHAR = '\b';
    public static final String TAG_REPLACEMENT = "\b";
    private static String m_configDir = null;
    private static String m_scriptDir = null;
    private static String INSTALLDIR = null;

    public static boolean isKey(KeyEvent e, int code, int modifiers) {
        return e.getKeyCode() == code && e.getModifiers() == modifiers;
    }

    public static void buildFileList(final List<String> lst, File rootDir, boolean recursive) {
        try {
            StaticUtils.iterateFileTree(rootDir.getAbsoluteFile(), recursive, new ITreeIteratorCallback(){

                @Override
                public void processFile(File file) {
                    lst.add(file.getPath());
                }
            });
        }
        catch (Exception ex) {
            // empty catch block
        }
        final Collator localCollator = Collator.getInstance(Locale.getDefault());
        localCollator.setStrength(0);
        Collections.sort(lst, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return localCollator.compare(o1, o2);
            }
        });
    }

    public static void removeFilesByMasks(List<String> lst, List<String> excludeMasks) {
        for (String mask : excludeMasks) {
            Pattern re = StaticUtils.compileFileMask(mask);
            Iterator<String> it = lst.iterator();
            while (it.hasNext()) {
                String fn = "/" + it.next();
                if (!re.matcher(fn).matches()) continue;
                it.remove();
            }
        }
    }

    static Pattern compileFileMask(String mask) {
        int cp;
        StringBuilder m = new StringBuilder();
        for (int i = 0; i < mask.length(); i += Character.charCount(cp)) {
            cp = mask.codePointAt(i);
            if (cp >= 65 && cp <= 90) {
                m.appendCodePoint(cp);
                continue;
            }
            if (cp >= 97 && cp <= 122) {
                m.appendCodePoint(cp);
                continue;
            }
            if (cp >= 48 && cp <= 57) {
                m.appendCodePoint(cp);
                continue;
            }
            if (cp == 47) {
                m.appendCodePoint(cp);
                continue;
            }
            if (cp == 63) {
                m.append('.');
                continue;
            }
            if (cp == 42) {
                if (mask.codePointCount(i, mask.length()) > 1 && mask.codePointAt(mask.offsetByCodePoints(i, 1)) == 42) {
                    m.append(".*");
                    ++i;
                    continue;
                }
                m.append("[^/]*");
                continue;
            }
            m.append('\\').appendCodePoint(cp);
        }
        return Pattern.compile(m.toString());
    }

    public static void sortByList(List<String> list, final List<String> order) {
        Collections.sort(list, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int pos2;
                int pos1;
                if (order != null) {
                    pos1 = order.indexOf(o1);
                    pos2 = order.indexOf(o2);
                } else {
                    pos1 = 0;
                    pos2 = 0;
                }
                if (pos1 < 0) {
                    pos1 = Integer.MAX_VALUE;
                }
                if (pos2 < 0) {
                    pos2 = Integer.MAX_VALUE;
                }
                if (pos1 < pos2) {
                    return -1;
                }
                if (pos1 > pos2) {
                    return 1;
                }
                return o1.compareToIgnoreCase(o2);
            }
        });
    }

    public static void iterateFileTree(File rootDir, boolean recursive, ITreeIteratorCallback cb) throws Exception {
        StaticUtils.iterateFileTree(rootDir, recursive, new HashSet<File>(), cb);
    }

    private static void iterateFileTree(File rootDir, boolean recursive, Set<File> visited, ITreeIteratorCallback cb) throws Exception {
        if (!rootDir.isDirectory()) {
            return;
        }
        File canonical = rootDir.getCanonicalFile();
        if (visited.contains(canonical)) {
            return;
        }
        visited.add(canonical);
        for (File file : rootDir.listFiles()) {
            if (file.isDirectory() && recursive) {
                StaticUtils.iterateFileTree(file.getAbsoluteFile(), recursive, visited, cb);
            }
            if (!file.isFile()) continue;
            cb.processFile(file.getAbsoluteFile());
        }
    }

    public static String[] getFontNames() {
        GraphicsEnvironment graphics = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return graphics.getAvailableFontFamilyNames();
    }

    private static String classPathElement(String fullcp, int posInsideElement) {
        int semicolon1 = fullcp.lastIndexOf(File.pathSeparatorChar, posInsideElement);
        int semicolon2 = fullcp.indexOf(File.pathSeparatorChar, posInsideElement);
        if (semicolon1 < 0) {
            semicolon1 = -1;
        }
        if (semicolon2 < 0) {
            semicolon2 = fullcp.length();
        }
        return fullcp.substring(semicolon1 + 1, semicolon2);
    }

    private static String extractClasspathElement(String cp, String ending) {
        try {
            int pos = cp.indexOf(ending);
            if (pos >= 0) {
                String path = StaticUtils.classPathElement(cp, pos);
                return path.substring(0, path.indexOf(ending));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String installDir() {
        if (INSTALLDIR == null) {
            String cp = System.getProperty("java.class.path");
            String path = StaticUtils.extractClasspathElement(cp, File.separator + "OmegaT.jar");
            if (path == null) {
                path = StaticUtils.extractClasspathElement(cp, OConsts.DEBUG_CLASSPATH);
            }
            if (path == null) {
                path = ".";
            }
            INSTALLDIR = new File(path).getAbsolutePath();
        }
        return INSTALLDIR;
    }

    public static String getConfigDir() {
        String home;
        if (m_configDir != null) {
            return m_configDir;
        }
        String cd = RuntimePreferences.getConfigDir();
        if (cd != null) {
            m_configDir = new File(cd).getAbsolutePath() + File.separator;
            return m_configDir;
        }
        Platform.OsType os = Platform.getOsType();
        try {
            home = System.getProperty("user.home");
        }
        catch (SecurityException e) {
            m_configDir = new File(".").getAbsolutePath() + File.separator;
            Log.logErrorRB("SU_USERHOME_PROP_ACCESS_ERROR", new Object[0]);
            Log.log(e.toString());
            return m_configDir;
        }
        if (os == null || StringUtil.isEmpty(home)) {
            m_configDir = new File(".").getAbsolutePath() + File.separator;
            return m_configDir;
        }
        if (os == Platform.OsType.WIN32 || os == Platform.OsType.WIN64) {
            String appData = null;
            File appDataFile = new File(home, "AppData\\Roaming");
            if (appDataFile.exists()) {
                appData = appDataFile.getAbsolutePath();
            } else {
                appDataFile = new File(home, "Application Data");
                if (appDataFile.exists()) {
                    appData = appDataFile.getAbsolutePath();
                }
            }
            m_configDir = !StringUtil.isEmpty(appData) ? appData + WINDOWS_CONFIG_DIR : home + WINDOWS_CONFIG_DIR;
        } else {
            m_configDir = os == Platform.OsType.LINUX32 || os == Platform.OsType.LINUX64 || os == Platform.OsType.OTHER ? home + UNIX_CONFIG_DIR : (Platform.isMacOSX() ? home + OSX_CONFIG_DIR : home + File.separator);
        }
        if (!m_configDir.isEmpty()) {
            try {
                boolean created;
                File dir = new File(m_configDir);
                if (!dir.exists() && !(created = dir.mkdirs())) {
                    Log.logErrorRB("SU_CONFIG_DIR_CREATE_ERROR", new Object[0]);
                    m_configDir = new File(".").getAbsolutePath() + File.separator;
                }
            }
            catch (SecurityException e) {
                m_configDir = new File(".").getAbsolutePath() + File.separator;
                Log.logErrorRB("SU_CONFIG_DIR_CREATE_ERROR", new Object[0]);
                Log.log(e.toString());
            }
        }
        return m_configDir;
    }

    static void setConfigDir(String path) {
        m_configDir = path;
    }

    public static String getScriptDir() {
        if (m_scriptDir != null) {
            return m_scriptDir;
        }
        m_scriptDir = StaticUtils.getConfigDir() + SCRIPT_DIR + File.separator;
        try {
            boolean created;
            File dir = new File(m_scriptDir);
            if (!dir.exists() && !(created = dir.mkdirs())) {
                Log.logErrorRB("SU_SCRIPT_DIR_CREATE_ERROR", new Object[0]);
                m_scriptDir = StaticUtils.getConfigDir();
            }
        }
        catch (SecurityException e) {
            m_scriptDir = StaticUtils.getConfigDir();
            Log.logErrorRB("SU_SCRIPT_DIR_CREATE_ERROR", new Object[0]);
            Log.log(e.toString());
        }
        return m_scriptDir;
    }

    public static String uuencode(byte[] buf) {
        if (buf.length <= 0) {
            return "";
        }
        StringBuilder res = new StringBuilder();
        res.append(buf[0]);
        for (int i = 1; i < buf.length; ++i) {
            res.append('#');
            res.append(buf[i]);
        }
        return res.toString();
    }

    public static byte[] uudecode(String buf) {
        String[] bytes = buf.split("#");
        byte[] res = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            try {
                res[i] = Byte.parseByte(bytes[i]);
                continue;
            }
            catch (NumberFormatException e) {
                res[i] = 0;
            }
        }
        return res;
    }

    public static String makeFilenameRelative(String filename, String path) {
        if (filename.toLowerCase().startsWith(path.toLowerCase())) {
            return filename.substring(path.length());
        }
        return filename;
    }

    public static String escapeNonRegex(String text) {
        return StaticUtils.escapeNonRegex(text, true);
    }

    public static String escapeNonRegex(String text, boolean escapeWildcards) {
        text = text.replaceAll("\\\\", "\\\\\\\\");
        text = text.replace("$", "\\$");
        for (char c : "^.+[]{}()&|-:=!<>".toCharArray()) {
            text = text.replaceAll("\\" + c, "\\\\" + c);
        }
        if (escapeWildcards) {
            text = text.replaceAll("\\?", "\\\\?");
            text = text.replaceAll("\\*", "\\\\*");
        } else {
            text = text.replaceAll("\\?", "\\\\S");
            text = text.replaceAll("\\*", "\\\\S*");
        }
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String downloadFileToString(String urlString) throws IOException {
        URL url = new URL(urlString);
        URLConnection urlConn = url.openConnection();
        urlConn.setConnectTimeout(10000);
        InputStream in = urlConn.getInputStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            LFileCopy.copy(in, (OutputStream)out);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {}
        }
        return new String(out.toByteArray(), "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadFileToDisk(String address, String filename) throws MalformedURLException {
        InputStream in = null;
        OutputStream out = null;
        try {
            int numRead;
            URL url = new URL(address);
            URLConnection urlConn = url.openConnection();
            in = urlConn.getInputStream();
            out = new BufferedOutputStream(new FileOutputStream(filename));
            byte[] byteBuffer = new byte[1024];
            while ((numRead = in.read(byteBuffer)) != -1) {
                out.write(byteBuffer, 0, numRead);
            }
        }
        catch (IOException ex) {
            Log.logErrorRB("IO exception", new Object[0]);
            Log.log(ex);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    public static void extractFileFromJar(File archive, List<String> filenames, String destination) throws IOException {
        FileInputStream is = new FileInputStream(archive);
        StaticUtils.extractFileFromJar(is, filenames, destination);
        ((InputStream)is).close();
    }

    public static void extractFileFromJar(InputStream in, List<String> filenames, String destination) throws IOException {
        JarEntry entry;
        if (filenames == null || filenames.isEmpty()) {
            throw new IllegalArgumentException("Caller must provide non-empty list of files to extract.");
        }
        ArrayList<String> toExtract = new ArrayList<String>(filenames);
        JarInputStream jis = new JarInputStream(in);
        while ((entry = jis.getNextJarEntry()) != null) {
            int numRead;
            if (!toExtract.contains(entry.getName())) continue;
            File f = new File(destination, entry.getName());
            f.getParentFile().mkdirs();
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));
            byte[] byteBuffer = new byte[1024];
            while ((numRead = jis.read(byteBuffer)) != -1) {
                out.write(byteBuffer, 0, numRead);
            }
            out.close();
            toExtract.remove(entry.getName());
        }
        jis.close();
        if (!toExtract.isEmpty()) {
            throw new FileNotFoundException("Failed to extract all of the specified files.");
        }
    }

    public static String[] parseCLICommand(String cmd) {
        int cp;
        if ((cmd = cmd.trim()).isEmpty()) {
            return new String[]{""};
        }
        StringBuilder arg = new StringBuilder();
        ArrayList<String> result = new ArrayList<String>();
        boolean noQuote = false;
        int currentQuote = 0;
        for (int i = 0; i < cmd.length(); i += Character.charCount(cp)) {
            cp = cmd.codePointAt(i);
            if (cp == currentQuote) {
                currentQuote = 0;
                continue;
            }
            if (cp == 34 && currentQuote == 0) {
                currentQuote = 34;
                continue;
            }
            if (cp == 39 && currentQuote == 0) {
                currentQuote = 39;
                continue;
            }
            if (cp == 92 && i + 1 < cmd.length()) {
                int ncp = cmd.codePointAt(cmd.offsetByCodePoints(i, 1));
                if (currentQuote == 0 && Character.isWhitespace(ncp) || currentQuote == 34 && ncp == 34) {
                    arg.appendCodePoint(ncp);
                    i += Character.charCount(ncp);
                    continue;
                }
                arg.appendCodePoint(cp);
                continue;
            }
            if (Character.isWhitespace(cp) && currentQuote == 0) {
                if (arg.length() <= 0) continue;
                result.add(arg.toString());
                arg = new StringBuilder();
                continue;
            }
            arg.appendCodePoint(cp);
        }
        if (arg.length() > 0) {
            result.add(arg.toString());
        }
        return result.toArray(new String[result.size()]);
    }

    public static boolean isProjectDir(File f) {
        if (f == null || f.getName().isEmpty()) {
            return false;
        }
        File projFile = new File(f.getAbsolutePath(), "omegat.project");
        File internal = new File(f.getAbsolutePath(), "omegat");
        return projFile.exists() && internal.isDirectory();
    }

    public static interface ITreeIteratorCallback {
        public void processFile(File var1) throws Exception;
    }
}

