/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.gui;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public class FontFallbackManager {
    private static final String FONT_BLACKLIST = "Apple Color Emoji;";
    private static final Font FONT_UNAVAILABLE = new Font("", 0, 0);
    private static final Logger LOGGER = Logger.getLogger(FontFallbackManager.class.getName());
    private static Font[] recentFonts = new Font[8];
    private static int lastFontIndex = 0;
    private static Map<Integer, Font> cache = new ConcurrentHashMap<Integer, Font>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Font getCapableFont(int cp) {
        if (cp >= 65024 && cp <= 65039) {
            return null;
        }
        if (cache.isEmpty()) {
            Map<Integer, Font> map = cache;
            synchronized (map) {
                return FontFallbackManager.getCapableFontInternal(cp);
            }
        }
        return FontFallbackManager.getCapableFontInternal(cp);
    }

    private static Font getCapableFontInternal(int cp) {
        for (int i = 0; i < recentFonts.length; ++i) {
            int testIndex = (lastFontIndex - i + recentFonts.length) % recentFonts.length;
            Font font = recentFonts[testIndex];
            if (font == null || !font.canDisplay(cp)) continue;
            lastFontIndex = testIndex;
            cache.put(cp, font);
            return font;
        }
        Font cachedFont = cache.get(cp);
        if (cachedFont == FONT_UNAVAILABLE) {
            return null;
        }
        if (cachedFont != null) {
            FontFallbackManager.addRecentFont(cachedFont);
            return cachedFont;
        }
        LOGGER.fine("Searching for font supporting U+" + Integer.toHexString(cp) + " " + String.valueOf(Character.toChars(cp)));
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (Font font : ge.getAllFonts()) {
            if (!font.canDisplay(cp) || FONT_BLACKLIST.contains(font.getFamily() + ";")) continue;
            LOGGER.fine("Search found " + font.getFamily());
            cache.put(cp, font);
            FontFallbackManager.addRecentFont(font);
            return font;
        }
        cache.put(cp, FONT_UNAVAILABLE);
        return null;
    }

    private static void addRecentFont(Font font) {
        lastFontIndex = (lastFontIndex + 1) % recentFonts.length;
        FontFallbackManager.recentFonts[FontFallbackManager.lastFontIndex] = font;
    }
}

