/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TableColumnSizer {
    private int[] optimalColWidths;
    private int remainderColReferenceWidth = -1;
    private boolean didManuallyAdjustCols;
    private int remainderColumn = 0;
    private final boolean fitTableToWidth;
    private boolean didApplySizes;
    private final JTable table;
    private final List<ActionListener> listeners = new ArrayList<ActionListener>();
    private final TableModelListener modelListener = new TableModelListener(){

        @Override
        public void tableChanged(TableModelEvent e) {
            TableColumnSizer.this.reset();
            TableColumnSizer.this.adjustTableColumns();
        }
    };
    private final TableColumnModelListener colListener = new TableColumnModelListener(){

        @Override
        public void columnAdded(TableColumnModelEvent e) {
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
            TableColumn col = TableColumnSizer.this.table.getTableHeader().getResizingColumn();
            if (col != null) {
                TableColumnSizer.this.didManuallyAdjustCols = true;
                TableColumnSizer.this.adjustTableColumns();
            }
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
            if (TableColumnSizer.this.optimalColWidths != null) {
                int to;
                int from = TableColumnSizer.this.optimalColWidths[e.getFromIndex()];
                ((TableColumnSizer)TableColumnSizer.this).optimalColWidths[e.getFromIndex()] = to = TableColumnSizer.this.optimalColWidths[e.getToIndex()];
                ((TableColumnSizer)TableColumnSizer.this).optimalColWidths[e.getToIndex()] = from;
            }
            TableColumnSizer.this.adjustTableColumns();
        }

        @Override
        public void columnRemoved(TableColumnModelEvent e) {
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent e) {
        }
    };

    public static TableColumnSizer autoSize(JTable table, int remainderColumn, boolean fitTableToWidth) {
        TableColumnSizer colSizer = new TableColumnSizer(table, remainderColumn, fitTableToWidth);
        colSizer.init();
        colSizer.adjustTableColumns();
        return colSizer;
    }

    private TableColumnSizer(JTable table, int remainderColumn, boolean fitTableToWidth) {
        this.table = table;
        this.remainderColumn = Math.max(remainderColumn, 0);
        this.fitTableToWidth = fitTableToWidth;
    }

    private void init() {
        this.table.getColumnModel().addColumnModelListener(this.colListener);
        this.table.getModel().addTableModelListener(this.modelListener);
        this.table.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object oldVal = evt.getOldValue();
                Object newVal = evt.getNewValue();
                if (newVal != null && newVal.equals(evt.getOldValue())) {
                    return;
                }
                boolean shouldAdjust = false;
                if (evt.getPropertyName().equals("columnModel")) {
                    if (newVal != null && newVal instanceof TableColumnModel) {
                        ((TableColumnModel)newVal).addColumnModelListener(TableColumnSizer.this.colListener);
                        shouldAdjust = true;
                    }
                    if (oldVal != null && oldVal instanceof TableColumnModel) {
                        ((TableColumnModel)oldVal).removeColumnModelListener(TableColumnSizer.this.colListener);
                    }
                } else if (evt.getPropertyName().equals("model")) {
                    if (newVal != null && newVal instanceof TableModel) {
                        ((TableModel)newVal).addTableModelListener(TableColumnSizer.this.modelListener);
                        shouldAdjust = true;
                    }
                    if (oldVal != null && oldVal instanceof TableModel) {
                        ((TableModel)oldVal).removeTableModelListener(TableColumnSizer.this.modelListener);
                    }
                } else if (evt.getPropertyName().equals("font") && (newVal != null && !newVal.equals(oldVal) || oldVal != null && !oldVal.equals(newVal))) {
                    shouldAdjust = true;
                }
                if (shouldAdjust) {
                    TableColumnSizer.this.reset();
                    TableColumnSizer.this.adjustTableColumns();
                }
            }
        });
        this.table.addHierarchyBoundsListener(new HierarchyBoundsAdapter(){

            @Override
            public void ancestorResized(HierarchyEvent e) {
                TableColumnSizer.this.adjustTableColumns();
            }
        });
    }

    private void calculateRemainderColReferenceWidth() {
        if (this.remainderColReferenceWidth != -1) {
            return;
        }
        this.table.setAutoResizeMode(2);
        this.remainderColReferenceWidth = this.table.getColumnModel().getColumn(this.remainderColumn).getWidth();
    }

    private void calculateOptimalColWidths() {
        if (this.optimalColWidths != null) {
            return;
        }
        this.optimalColWidths = new int[this.table.getColumnCount()];
        for (int column = 0; column < this.table.getColumnCount(); ++column) {
            int startRow;
            TableColumn col = this.table.getColumnModel().getColumn(column);
            col.setMaxWidth(Short.MAX_VALUE);
            int preferredWidth = col.getMinWidth();
            int maxWidth = col.getMaxWidth();
            for (int row = startRow = this.table.getTableHeader() == null ? 0 : -1; row < this.table.getRowCount(); ++row) {
                Component c;
                TableCellRenderer cellRenderer;
                int margin = 5;
                if (row == -1) {
                    cellRenderer = col.getHeaderRenderer();
                    if (cellRenderer == null) {
                        cellRenderer = col.getCellRenderer();
                    }
                    if (cellRenderer == null) {
                        cellRenderer = this.table.getDefaultRenderer(String.class);
                    }
                    c = cellRenderer.getTableCellRendererComponent(this.table, col.getHeaderValue(), false, false, 0, column);
                    c.setFont(this.table.getTableHeader().getFont());
                    margin = 10;
                } else {
                    cellRenderer = this.table.getCellRenderer(row, column);
                    c = this.table.prepareRenderer(cellRenderer, row, column);
                }
                c.setBounds(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
                int width = c.getPreferredSize().width + this.table.getIntercellSpacing().width + margin;
                preferredWidth = Math.max(preferredWidth, width);
                if (preferredWidth < maxWidth) continue;
                preferredWidth = maxWidth;
                break;
            }
            this.optimalColWidths[column] = preferredWidth;
        }
    }

    private int calculateProposedRemainderColWidth() {
        int otherCols = 0;
        for (int i = 0; i < this.optimalColWidths.length; ++i) {
            if (i == this.remainderColumn) continue;
            otherCols += this.optimalColWidths[i];
        }
        Container parent = this.table.getParent();
        return parent == null ? 0 : parent.getWidth() - otherCols;
    }

    public void reset() {
        this.optimalColWidths = null;
        this.remainderColReferenceWidth = -1;
        this.didApplySizes = false;
    }

    public void setRestoreAutoSizing() {
        this.didManuallyAdjustCols = false;
        this.didApplySizes = false;
    }

    public void adjustTableColumns() {
        if (this.table.getColumnCount() == 0) {
            return;
        }
        this.calculateOptimalColWidths();
        this.ensureTableResizeMode(this.fitTableToWidth ? 2 : 0);
        int proposedRemainderWidth = this.calculateProposedRemainderColWidth();
        if (this.shouldAutoSize(proposedRemainderWidth)) {
            this.doAutoSize(proposedRemainderWidth);
        } else if (this.didApplySizes) {
            this.undoAutoSize();
        }
        this.notifyListeners();
    }

    private void doAutoSize(int proposedRemainderWidth) {
        int width;
        if (!this.fitTableToWidth) {
            width = Math.max(proposedRemainderWidth, this.optimalColWidths[this.remainderColumn]);
            this.table.getColumnModel().getColumn(this.remainderColumn).setPreferredWidth(width);
        }
        if (this.didApplySizes) {
            return;
        }
        for (int i = 0; i < this.optimalColWidths.length; ++i) {
            width = this.optimalColWidths[i];
            TableColumn col = this.table.getColumnModel().getColumn(i);
            if (i == this.remainderColumn) continue;
            if (this.fitTableToWidth) {
                col.setMaxWidth(width);
            }
            col.setPreferredWidth(width);
        }
        this.didApplySizes = true;
    }

    private void undoAutoSize() {
        if (!this.didApplySizes) {
            return;
        }
        if (!this.fitTableToWidth) {
            this.didApplySizes = false;
            return;
        }
        for (int i = 0; i < this.optimalColWidths.length; ++i) {
            if (i == this.remainderColumn) continue;
            TableColumn col = this.table.getColumnModel().getColumn(i);
            col.setMaxWidth(Short.MAX_VALUE);
        }
        this.didApplySizes = false;
    }

    private void ensureTableResizeMode(int mode) {
        if (this.table.getAutoResizeMode() == mode) {
            return;
        }
        this.table.setAutoResizeMode(mode);
    }

    private boolean shouldAutoSize(int proposedRemainderWidth) {
        if (this.didManuallyAdjustCols) {
            return false;
        }
        if (!this.fitTableToWidth) {
            return true;
        }
        if (proposedRemainderWidth >= this.optimalColWidths[this.remainderColumn]) {
            return true;
        }
        this.calculateRemainderColReferenceWidth();
        return proposedRemainderWidth >= this.remainderColReferenceWidth;
    }

    public void addColumnAdjustmentListener(ActionListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.add(listener);
    }

    public void removeColumnAdjustmentListener(ActionListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    private void notifyListeners() {
        ActionEvent event = new ActionEvent(this, 1001, "columnsAdjusted");
        for (ActionListener listener : this.listeners) {
            listener.actionPerformed(event);
        }
    }
}

