/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.xml;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.omegat.filters2.TranslationException;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;
import org.omegat.util.xml.DefaultEntityFilter;
import org.omegat.util.xml.XMLBlock;
import org.omegat.util.xml.XMLReader;

public class XMLStreamReader {
    private DefaultEntityFilter entityFilter;
    private boolean cdata_flag = false;
    private boolean end_cdata_flag = false;
    private static final int type_text = 1;
    private static final int type_ws = 2;
    private static final int type_apos = 3;
    private static final int type_quote = 4;
    private static final int type_lt = 5;
    private static final int type_gt = 6;
    private static final int type_amp = 7;
    private static final int type_equals = 8;
    private static final int type_ques = 9;
    private static final int type_opBrac = 10;
    private static final int type_clBrac = 11;
    private static final int type_slash = 12;
    private static final int type_backSlash = 13;
    private static final int type_dash = 14;
    private BufferedReader m_bufferedReader;
    private String m_stringStream = "";
    private XMLBlock m_headBlock = null;
    private int m_pos = -1;
    private Stack<Integer> m_charStack = new Stack();
    private List<Integer> m_charCache = new ArrayList<Integer>();
    private boolean m_killEmptyBlocks = false;
    private boolean m_ignoreWhiteSpace = false;
    private boolean m_breakWhitespace = false;
    private boolean m_compressWhitespace = false;

    public void setStream(File name) throws FileNotFoundException, UnsupportedEncodingException, IOException, TranslationException {
        this.setStream(name, "UTF-8");
    }

    public void setStream(String name, String encoding) throws FileNotFoundException, UnsupportedEncodingException, IOException, TranslationException {
        this.setStream(new File(name), encoding);
    }

    private void setStream(File file, String encoding) throws FileNotFoundException, UnsupportedEncodingException, IOException, TranslationException {
        XMLReader ear = new XMLReader(file.getAbsolutePath(), encoding);
        this.m_bufferedReader = new BufferedReader(ear);
        this._setStream();
    }

    public void setStream(BufferedReader rdr) throws IOException, TranslationException {
        this.m_bufferedReader = rdr;
        this._setStream();
    }

    private void _setStream() throws IOException, TranslationException {
        this.m_pos = -1;
        XMLBlock blk = this.getNextBlock();
        if (blk == null) {
            throw new IOException(OStrings.getString("XSR_ERROR_NONVALID_XML") + "\n" + OStrings.getString("XSR_ERROR_UNABLE_INIT_READ_XML"));
        }
        if (blk.getTagName().equals("xml")) {
            String ver = blk.getAttribute("version");
            if (ver != null && !ver.equals("") && !ver.equals("1.0")) {
                throw new IOException(OStrings.getString("XSR_ERROR_NONVALID_XML") + "\n" + StringUtil.format(OStrings.getString("XSR_ERROR_UNSUPPORTED_XML_VERSION"), ver));
            }
        } else {
            throw new IOException(OStrings.getString("XSR_ERROR_NONVALID_XML") + "\n" + OStrings.getString("XSR_ERROR_NONVALID_XML"));
        }
        this.m_headBlock = blk;
    }

    public XMLBlock getNextBlock() throws TranslationException {
        int cp = this.getNextChar();
        if (cp == 0) {
            return null;
        }
        if (cp == 60) {
            cp = this.getNextChar();
            this.pushChar(cp);
            if (cp != 32) {
                XMLBlock b = this.getNextTag();
                return b;
            }
        } else if (cp == 93 && this.end_cdata_flag) {
            XMLBlock b = this.getNextTagCDATAEnd();
            return b;
        }
        this.pushChar(cp);
        XMLBlock blk = this.getNextText();
        if (blk != null && this.m_killEmptyBlocks) {
            String str = blk.getText();
            if ((str = str.trim()).isEmpty()) {
                blk = this.getNextBlock();
            }
        }
        return blk;
    }

    public void killEmptyBlocks() {
        this.m_killEmptyBlocks = true;
    }

    public void breakOnWhitespace(boolean brk) {
        this.m_breakWhitespace = brk;
    }

    public void compressWhitespace(boolean tof) {
        this.m_compressWhitespace = tof;
    }

    public void setEntityFilter(DefaultEntityFilter filter) {
        this.entityFilter = filter;
    }

    private void pushChar(int cp) {
        this.m_charStack.push(cp);
    }

    private int getNextCharCache() {
        int c = this.getNextChar();
        this.m_charCache.add(c);
        return c;
    }

    private void clearCache() {
        this.m_charCache.clear();
    }

    private void revertToCached() {
        for (int i = this.m_charCache.size() - 1; i >= 0; --i) {
            this.m_charStack.push(this.m_charCache.get(i));
        }
    }

    private int getNextChar() {
        if (!this.m_charStack.empty()) {
            Integer ch = this.m_charStack.pop();
            return ch;
        }
        if (this.m_pos >= 0) {
            if (this.m_pos < this.m_stringStream.length()) {
                int cp = this.m_stringStream.codePointAt(this.m_pos);
                this.m_pos += Character.charCount(cp);
                if (cp == 13) {
                    cp = this.m_stringStream.codePointAt(this.m_pos);
                    if (cp == 10) {
                        this.m_pos += Character.charCount(cp);
                    } else {
                        cp = 10;
                    }
                }
                return cp;
            }
            return 0;
        }
        char[] c = new char[2];
        try {
            char b;
            int res = this.m_bufferedReader.read(c, 0, 1);
            if (res > 0) {
                b = c[0];
                if (b == '\r') {
                    res = this.m_bufferedReader.read(c, 0, 1);
                    if (res > 0) {
                        b = c[0];
                        if (b != '\n' && b == '\r') {
                            this.pushChar(10);
                        }
                    } else {
                        b = '\u0000';
                    }
                }
            } else {
                return 0;
            }
            return b;
        }
        catch (IOException e) {
            Log.logErrorRB("XSR_ERROR_IOEXCEPTION", new Object[0]);
            Log.log(e);
            return 0;
        }
    }

    private XMLBlock getNextText() throws TranslationException {
        int cp;
        XMLBlock blk = new XMLBlock();
        StringBuilder strBuf = new StringBuilder();
        boolean wsCnt = false;
        boolean wsBreak = false;
        while ((cp = this.getNextChar()) != 60 && cp != 0) {
            if (cp == 38) {
                wsCnt = false;
                if (wsBreak) {
                    this.pushChar(cp);
                    break;
                }
                int cp2 = this.getEscChar();
                if (cp2 == 0) {
                    strBuf.append('&');
                    continue;
                }
                strBuf.appendCodePoint(cp2);
                continue;
            }
            if (cp == 32 || cp == 10 || cp == 13 || cp == 9) {
                if (this.m_ignoreWhiteSpace) continue;
                if (this.m_compressWhitespace) {
                    if (this.m_breakWhitespace) {
                        if (strBuf.length() > 0) {
                            if (wsBreak) continue;
                            this.pushChar(cp);
                            break;
                        }
                        wsCnt = true;
                        strBuf.setLength(0);
                        strBuf.append(" ");
                        wsBreak = true;
                        continue;
                    }
                    if (wsCnt) continue;
                    strBuf.append(' ');
                    wsCnt = true;
                    continue;
                }
                strBuf.appendCodePoint(cp);
                continue;
            }
            wsCnt = false;
            if (wsBreak) {
                this.pushChar(cp);
                break;
            }
            if (cp == 93 && this.cdata_flag) {
                int cp1 = this.getNextChar();
                int cp2 = this.getNextChar();
                this.pushChar(cp2);
                this.pushChar(cp1);
                if (cp1 == 93 && cp2 == 62) {
                    this.cdata_flag = false;
                    this.end_cdata_flag = true;
                    this.pushChar(cp);
                    break;
                }
            }
            strBuf.appendCodePoint(cp);
        }
        if (cp == 60) {
            this.pushChar(cp);
        }
        blk.setText(strBuf.toString());
        return blk;
    }

    private XMLBlock getNextTagCDATAEnd() {
        this.end_cdata_flag = false;
        XMLBlock blk = new XMLBlock();
        blk.setTypeChar('!');
        blk.setTagName("]]");
        this.getNextChar();
        this.getNextChar();
        return blk;
    }

    private XMLBlock getNextTagExclamation() throws TranslationException {
        int cp;
        boolean state_start = true;
        int state_name = 2;
        int state_finish = 3;
        int state_record = 4;
        int state_recordSingle = 5;
        int state_recordDouble = 6;
        int state_escSingle = 7;
        int state_escDouble = 8;
        int state_cdata = 9;
        int state_commentStart = 10;
        int state_comment = 11;
        XMLBlock blk = new XMLBlock();
        blk.setTypeChar('!');
        StringBuilder name = new StringBuilder();
        StringBuilder data = new StringBuilder();
        int state = 1;
        boolean err = false;
        String msg = "";
        int dashCnt = 0;
        while ((cp = this.getNextChar()) != 0) {
            int type = this.getCharType(cp);
            block0 : switch (state) {
                case 1: {
                    switch (type) {
                        case 2: {
                            break block0;
                        }
                        case 1: {
                            state = 2;
                            name.appendCodePoint(cp);
                            break block0;
                        }
                        case 10: {
                            blk.setTagName("CDATA");
                            state = 9;
                            break block0;
                        }
                        case 14: {
                            state = 10;
                            blk.setComment();
                            break block0;
                        }
                    }
                    err = true;
                    msg = StringUtil.format(OStrings.getString("XSR_ERROR_UNEXPECTED_CHAR"), String.valueOf(Character.toChars(cp)), state);
                    break;
                }
                case 10: {
                    if (cp == 45) {
                        state = 11;
                        break;
                    }
                    err = true;
                    msg = OStrings.getString("XSR_ERROR_CONFUSED");
                    break;
                }
                case 11: {
                    switch (type) {
                        case 14: {
                            if (dashCnt >= 2) {
                                data.appendCodePoint(cp);
                                break block0;
                            }
                            ++dashCnt;
                            break block0;
                        }
                        case 6: {
                            if (dashCnt < 2) break block0;
                            blk.setText(data.toString());
                            state = 3;
                            break block0;
                        }
                    }
                    if (dashCnt > 0) {
                        while (dashCnt > 0) {
                            data.append('-');
                            --dashCnt;
                        }
                    }
                    data.appendCodePoint(cp);
                    break;
                }
                case 9: {
                    switch (type) {
                        case 10: {
                            state = 3;
                            this.cdata_flag = true;
                            break block0;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (type) {
                        case 1: {
                            name.appendCodePoint(cp);
                            break block0;
                        }
                        case 2: {
                            blk.setTagName(name.toString());
                            state = 4;
                            break block0;
                        }
                        case 6: {
                            state = 3;
                            break block0;
                        }
                    }
                    err = true;
                    msg = StringUtil.format(OStrings.getString("XSR_ERROR_UNEXPECTED_CHAR"), String.valueOf(Character.toChars(cp)), state);
                    break;
                }
                case 4: {
                    switch (type) {
                        case 3: {
                            state = 5;
                            data.appendCodePoint(cp);
                            break block0;
                        }
                        case 4: {
                            state = 6;
                            data.appendCodePoint(cp);
                            break block0;
                        }
                        case 6: {
                            state = 3;
                            blk.setAttribute(data.toString(), "");
                            break block0;
                        }
                    }
                    data.appendCodePoint(cp);
                    break;
                }
                case 5: {
                    switch (type) {
                        case 3: {
                            state = 4;
                            data.appendCodePoint(cp);
                            break block0;
                        }
                        case 13: {
                            state = 7;
                            data.appendCodePoint(cp);
                            break block0;
                        }
                    }
                    data.appendCodePoint(cp);
                    break;
                }
                case 7: {
                    data.appendCodePoint(cp);
                    state = 5;
                    break;
                }
                case 6: {
                    switch (type) {
                        case 4: {
                            state = 4;
                            data.appendCodePoint(cp);
                            break block0;
                        }
                        case 13: {
                            state = 8;
                            data.appendCodePoint(cp);
                            break block0;
                        }
                    }
                    data.appendCodePoint(cp);
                    break;
                }
                case 8: {
                    data.appendCodePoint(cp);
                    state = 6;
                }
            }
            if (err) {
                String str = OStrings.getString("XSR_ERROR_TAG_NAME") + blk.getTagName() + " ";
                if (blk.isComment()) {
                    str = str + OStrings.getString("XSR_ERROR_COMMENT_TAG");
                }
                if (blk.numAttributes() > 0) {
                    str = str + blk.getAttribute((int)0).name;
                }
                throw new TranslationException(msg + str + "::" + data);
            }
            if (state != 3) continue;
            break;
        }
        return blk;
    }

    private void throwErrorInGetNextTag(XMLBlock blk, String msg) throws TranslationException {
        String data = OStrings.getString("XSR_ERROR_TAG_NAME") + blk.getTagName() + " ";
        if (blk.isStandalone()) {
            data = data + OStrings.getString("XSR_ERROR_EMPTY_TAG");
        } else if (blk.isClose()) {
            data = data + OStrings.getString("XSR_ERROR_CLOSE_TAG");
        }
        if (blk.numAttributes() > 0) {
            data = data + OStrings.getString("XSR_ERROR_LOADED") + blk.numAttributes() + OStrings.getString("XSR_ERROR_ATTRIBUTES");
        }
        throw new TranslationException(msg + data);
    }

    private XMLBlock getNextTag() throws TranslationException {
        int cp = this.getNextChar();
        if (cp == 0) {
            return null;
        }
        if (cp == 33) {
            return this.getNextTagExclamation();
        }
        boolean state_start = true;
        int state_buildName = 2;
        int state_setCloseFlag = 3;
        int state_setStandaloneFlag = 4;
        int state_attrStandby = 5;
        int state_buildAttr = 6;
        int state_transitionFromAttr = 7;
        int state_buildValue = 8;
        int state_closeValueQuote = 9;
        int state_finish = 10;
        int state_xmlDeclaration = 11;
        XMLBlock blk = new XMLBlock();
        if (cp == 63) {
            cp = this.getNextChar();
            blk.setTypeChar('?');
        }
        int state = 1;
        StringBuilder name = new StringBuilder();
        StringBuilder attr = new StringBuilder();
        StringBuilder val = new StringBuilder();
        int buildValueStartType = 0;
        while (cp != 0) {
            int type = this.getCharType(cp);
            block0 : switch (state) {
                case 1: {
                    switch (type) {
                        case 12: {
                            blk.setCloseFlag();
                            state = 3;
                            break block0;
                        }
                        case 1: {
                            name.appendCodePoint(cp);
                            state = 2;
                            break block0;
                        }
                    }
                    this.throwErrorInGetNextTag(blk, StringUtil.format(OStrings.getString("XSR_ERROR_UNEXPECTED_CHAR"), String.valueOf(Character.toChars(cp)), state));
                    break;
                }
                case 2: {
                    switch (type) {
                        case 1: 
                        case 14: {
                            name.appendCodePoint(cp);
                            break block0;
                        }
                        case 2: {
                            state = 5;
                            blk.setTagName(name.toString());
                            break block0;
                        }
                        case 12: {
                            blk.setTagName(name.toString());
                            blk.setStandaloneFlag();
                            state = 4;
                            break block0;
                        }
                        case 6: {
                            blk.setTagName(name.toString());
                            state = 10;
                            break block0;
                        }
                    }
                    this.throwErrorInGetNextTag(blk, StringUtil.format(OStrings.getString("XSR_ERROR_UNEXPECTED_CHAR"), String.valueOf(Character.toChars(cp)), state));
                    break;
                }
                case 3: {
                    switch (type) {
                        case 1: {
                            name.appendCodePoint(cp);
                            state = 2;
                            break block0;
                        }
                        case 2: {
                            break block0;
                        }
                    }
                    this.throwErrorInGetNextTag(blk, StringUtil.format(OStrings.getString("XSR_ERROR_UNEXPECTED_CHAR"), String.valueOf(Character.toChars(cp)), state));
                    break;
                }
                case 4: {
                    switch (type) {
                        case 2: {
                            break block0;
                        }
                        case 6: {
                            state = 10;
                            break block0;
                        }
                    }
                    this.throwErrorInGetNextTag(blk, StringUtil.format(OStrings.getString("XSR_ERROR_UNEXPECTED_CHAR"), String.valueOf(Character.toChars(cp)), state));
                    break;
                }
                case 5: {
                    switch (type) {
                        case 1: {
                            attr.appendCodePoint(cp);
                            state = 6;
                            break block0;
                        }
                        case 9: {
                            state = 11;
                            break block0;
                        }
                        case 2: {
                            break block0;
                        }
                        case 12: {
                            blk.setStandaloneFlag();
                            state = 4;
                            break block0;
                        }
                    }
                    this.throwErrorInGetNextTag(blk, StringUtil.format(OStrings.getString("XSR_ERROR_UNEXPECTED_CHAR"), String.valueOf(Character.toChars(cp)), state));
                    break;
                }
                case 11: {
                    if (cp != 62) {
                        this.throwErrorInGetNextTag(blk, OStrings.getString("XSR_ERROR_FLOATING_QUESTION_MARK"));
                        break;
                    }
                    state = 10;
                    break;
                }
                case 6: {
                    switch (type) {
                        case 1: 
                        case 14: {
                            attr.appendCodePoint(cp);
                            break block0;
                        }
                        case 8: {
                            state = 7;
                            break block0;
                        }
                    }
                    this.throwErrorInGetNextTag(blk, StringUtil.format(OStrings.getString("XSR_ERROR_UNEXPECTED_CHAR"), String.valueOf(Character.toChars(cp)), state));
                    break;
                }
                case 7: {
                    switch (type) {
                        case 3: 
                        case 4: {
                            state = 8;
                            buildValueStartType = type;
                            break block0;
                        }
                    }
                    this.throwErrorInGetNextTag(blk, StringUtil.format(OStrings.getString("XSR_ERROR_UNEXPECTED_CHAR"), String.valueOf(Character.toChars(cp)), state));
                    break;
                }
                case 8: {
                    switch (type) {
                        case 3: 
                        case 4: {
                            if (type == buildValueStartType) {
                                blk.setAttribute(attr.toString(), val.toString());
                                attr = new StringBuilder();
                                val = new StringBuilder();
                                state = 9;
                                break block0;
                            }
                            val.appendCodePoint(cp);
                            break block0;
                        }
                    }
                    val.appendCodePoint(cp);
                    break;
                }
                case 9: {
                    switch (type) {
                        case 1: {
                            attr.appendCodePoint(cp);
                            state = 6;
                            break block0;
                        }
                        case 2: {
                            break block0;
                        }
                        case 12: {
                            blk.setStandaloneFlag();
                            state = 4;
                            break block0;
                        }
                        case 6: {
                            state = 10;
                            break block0;
                        }
                        case 9: {
                            state = 11;
                            break block0;
                        }
                    }
                    this.throwErrorInGetNextTag(blk, StringUtil.format(OStrings.getString("XSR_ERROR_UNEXPECTED_CHAR"), String.valueOf(Character.toChars(cp)), state));
                    break;
                }
                default: {
                    Log.log("INTERNAL ERROR untrapped parse state " + state);
                }
            }
            if (state == 10) break;
            cp = this.getNextChar();
        }
        return blk;
    }

    private int getCharType(int cp) {
        int type = 1;
        switch (cp) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                type = 2;
                break;
            }
            case 34: {
                type = 4;
                break;
            }
            case 39: {
                type = 3;
                break;
            }
            case 38: {
                type = 7;
                break;
            }
            case 60: {
                type = 5;
                break;
            }
            case 62: {
                type = 6;
                break;
            }
            case 63: {
                type = 9;
                break;
            }
            case 47: {
                type = 12;
                break;
            }
            case 61: {
                type = 8;
                break;
            }
            case 91: {
                type = 10;
                break;
            }
            case 93: {
                type = 11;
                break;
            }
            case 45: {
                type = 14;
                break;
            }
            case 92: {
                type = 13;
            }
        }
        return type;
    }

    public String makeValidXML(int cp) {
        String res = StringUtil.escapeXMLChars(cp);
        if (res.codePointCount(0, res.length()) == 1 && this.entityFilter != null) {
            return this.entityFilter.convertToEntity(cp);
        }
        return res;
    }

    public String makeValidXML(String plaintext) {
        int cp;
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < plaintext.length(); i += Character.charCount(cp)) {
            cp = plaintext.codePointAt(i);
            out.append(this.makeValidXML(cp));
        }
        return out.toString();
    }

    public List<XMLBlock> closeBlock(XMLBlock block) throws TranslationException {
        return this.closeBlock(block, false);
    }

    public List<XMLBlock> closeBlock(XMLBlock block, boolean includeTerminationBlock) throws TranslationException {
        ArrayList<XMLBlock> lst = new ArrayList<XMLBlock>();
        if (block == null) {
            return lst;
        }
        if (block.isStandalone()) {
            return lst;
        }
        int depth = 0;
        while (true) {
            XMLBlock blk;
            if ((blk = this.getNextBlock()) == null) {
                throw new TranslationException(OStrings.getString("XSR_ERROR_END_OF_STREAM"));
            }
            if (blk.isTag() && blk.getTagName().equals(block.getTagName())) {
                if (blk.isClose()) {
                    if (depth == 0) {
                        if (!includeTerminationBlock) break;
                        lst.add(blk);
                        break;
                    }
                    --depth;
                } else {
                    ++depth;
                }
                lst.add(blk);
                continue;
            }
            lst.add(blk);
        }
        return lst.isEmpty() ? null : lst;
    }

    public XMLBlock advanceToTag(String tagname) throws TranslationException {
        XMLBlock blk;
        while (!((blk = this.getNextBlock()) == null || blk.isTag() && blk.getTagName().equals(tagname))) {
        }
        return blk;
    }

    private int getEscChar() throws TranslationException {
        this.clearCache();
        int cp = this.getNextCharCache();
        StringBuilder val = new StringBuilder();
        boolean hex = false;
        if (cp == 35) {
            cp = this.getNextCharCache();
            if (cp == 120 || cp == 88) {
                cp = this.getNextCharCache();
                hex = true;
            }
        } else if (cp == 32) {
            this.revertToCached();
            return 0;
        }
        int ctr = 0;
        while (cp != 59) {
            val.appendCodePoint(cp);
            if (cp == 0) {
                throw new TranslationException(OStrings.getString("XSR_ERROR_UNTERMINATED_ESCAPE_CHAR"));
            }
            cp = this.getNextCharCache();
            if (ctr++ <= 13) continue;
            this.revertToCached();
            return 0;
        }
        this.clearCache();
        String valString = val.toString();
        if (valString.equals("amp")) {
            return 38;
        }
        if (valString.equals("lt")) {
            return 60;
        }
        if (valString.equals("gt")) {
            return 62;
        }
        if (valString.equals("apos")) {
            return 39;
        }
        if (valString.equals("quot")) {
            return 34;
        }
        if (this.entityFilter != null) {
            return this.entityFilter.convertToSymbol(val.toString());
        }
        if (hex) {
            try {
                cp = Integer.valueOf(valString, 16);
            }
            catch (NumberFormatException ex) {
                throw new TranslationException(StringUtil.format(OStrings.getString("XSR_ERROR_BAD_BINARY_CHAR"), val), ex);
            }
            if (!StringUtil.isValidXMLChar(cp)) {
                throw new TranslationException(StringUtil.format(OStrings.getString("XSR_ERROR_BAD_BINARY_CHAR"), val));
            }
        } else {
            try {
                cp = Integer.valueOf(valString, 10);
            }
            catch (NumberFormatException ex) {
                throw new TranslationException(StringUtil.format(OStrings.getString("XSR_ERROR_BAD_DECIMAL_CHAR"), val), ex);
            }
            if (!StringUtil.isValidXMLChar(cp)) {
                throw new TranslationException(StringUtil.format(OStrings.getString("XSR_ERROR_BAD_DECIMAL_CHAR"), val));
            }
        }
        return cp;
    }

    public XMLBlock getHeadBlock() {
        return this.m_headBlock;
    }

    public void close() throws IOException {
        if (this.m_bufferedReader != null) {
            this.m_bufferedReader.close();
        }
    }
}

