/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.docking;

import com.vlsolutions.swing.docking.AutoHidePolicy;
import com.vlsolutions.swing.docking.ShadowBorder;
import com.vlsolutions.swing.docking.ui.DockingUISettings;
import java.awt.Color;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JPopupMenu;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;

public class DockingPreferences {
    private static boolean isLightWeightUsageEnabled = true;
    private static boolean isSingleHeavyWeightComponent = false;

    private DockingPreferences() {
    }

    public static final AutoHidePolicy getAutoHidePolicy() {
        return AutoHidePolicy.getPolicy();
    }

    public static void setLightweigthComponentEnabled(boolean lightweight) {
        isLightWeightUsageEnabled = lightweight;
    }

    public static boolean isLightWeightUsageEnabled() {
        return isLightWeightUsageEnabled;
    }

    public static void setSingleHeavyWeightComponent(boolean single) {
        isSingleHeavyWeightComponent = single;
    }

    public static boolean isSingleHeavyWeightComponent() {
        return isSingleHeavyWeightComponent;
    }

    public static void initHeavyWeightUsage() {
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        DockingPreferences.setLightweigthComponentEnabled(false);
        DockingPreferences.getAutoHidePolicy().setExpansionDuration(0);
    }

    public static void initHeavyWeightUsage(boolean isSingleHeavyWeightComponent) {
        DockingPreferences.initHeavyWeightUsage();
        DockingPreferences.setSingleHeavyWeightComponent(isSingleHeavyWeightComponent);
    }

    public static void setShadowDesktopStyle() {
        DockingUISettings.getInstance().installUI();
        UIManager.put("DockView.singleDockableBorder", new ShadowBorder());
        UIManager.put("DockView.tabbedDockableBorder", new ShadowBorder(false));
        UIManager.put("TabbedDockableContainer.tabPlacement", new Integer(3));
    }

    public static void setFlatDesktopStyle() {
        DockingUISettings.getInstance().installUI();
        Color shadow = UIManager.getColor("VLDocking.shadow");
        Color highlight = UIManager.getColor("VLDocking.highlight");
        CompoundBorder innerFlatSingleBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 0, 0, highlight), BorderFactory.createMatteBorder(0, 0, 1, 1, shadow));
        CompoundBorder flatSingleBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), innerFlatSingleBorder);
        UIManager.put("DockView.singleDockableBorder", flatSingleBorder);
        UIManager.put("DockView.tabbedDockableBorder", null);
        UIManager.put("TabbedDockableContainer.tabPlacement", new Integer(1));
    }

    public static void setDottedDesktopStyle() {
        DockingUISettings.getInstance().installUI();
        Color shadow = UIManager.getColor("VLDocking.shadow");
        Color highlight = UIManager.getColor("VLDocking.highlight");
        CompoundBorder innerFlatSingleBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 0, 0, highlight), BorderFactory.createMatteBorder(0, 0, 1, 1, shadow));
        UIManager.put("DockView.singleDockableBorder", innerFlatSingleBorder);
        UIManager.put("DockView.tabbedDockableBorder", null);
        UIManager.put("TabbedDockableContainer.tabPlacement", new Integer(1));
        UIManager.put("SplitContainer.drawDotsDelimitors", Boolean.TRUE);
    }

    public static void setCustomSplitDesktopStyle(BufferedImage horizontalTile, BufferedImage verticalTile) {
        DockingUISettings.getInstance().installUI();
        UIManager.put("DockView.tabbedDockableBorder", null);
        UIManager.put("TabbedDockableContainer.tabPlacement", new Integer(1));
        UIManager.put("SplitContainer.drawDotsDelimitors", Boolean.FALSE);
        UIManager.put("SplitContainer.hImage", horizontalTile);
        UIManager.put("SplitContainer.vImage", verticalTile);
        UIManager.put("SplitContainer.useCustomImages", Boolean.TRUE);
    }
}

