/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.kr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.kr.KoreanTokenizer;
import org.apache.lucene.analysis.kr.morph.AnalysisOutput;
import org.apache.lucene.analysis.kr.morph.CompoundEntry;
import org.apache.lucene.analysis.kr.morph.CompoundNounAnalyzer;
import org.apache.lucene.analysis.kr.morph.MorphAnalyzer;
import org.apache.lucene.analysis.kr.morph.MorphException;
import org.apache.lucene.analysis.kr.morph.WordEntry;
import org.apache.lucene.analysis.kr.morph.WordSpaceAnalyzer;
import org.apache.lucene.analysis.kr.utils.DictionaryUtil;
import org.apache.lucene.analysis.kr.utils.HanjaUtils;
import org.apache.lucene.analysis.standard.ClassicTokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KoreanFilter
extends TokenFilter {
    private LinkedList<String> morphQueue;
    private MorphAnalyzer morph;
    private WordSpaceAnalyzer wsAnal;
    private boolean bigrammable = true;
    private boolean hasOrigin = true;
    private boolean exactMatch = false;
    private char[] curTermBuffer;
    private int curTermLength;
    private String curType;
    private String curSource;
    private int tokStart;
    private CompoundNounAnalyzer cnAnalyzer = new CompoundNounAnalyzer();
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private final TypeAttribute typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
    private static final String APOSTROPHE_TYPE = ClassicTokenizer.TOKEN_TYPES[1];
    private static final String ACRONYM_TYPE = ClassicTokenizer.TOKEN_TYPES[2];

    public KoreanFilter(TokenStream input) {
        super(input);
        this.morphQueue = new LinkedList();
        this.morph = new MorphAnalyzer();
        this.wsAnal = new WordSpaceAnalyzer();
        this.cnAnalyzer.setExactMach(false);
    }

    public KoreanFilter(TokenStream input, boolean bigram) {
        this(input);
        this.bigrammable = bigram;
    }

    public KoreanFilter(TokenStream input, boolean bigram, boolean has) {
        this(input, bigram);
        this.hasOrigin = has;
    }

    public KoreanFilter(TokenStream input, boolean bigram, boolean has, boolean match) {
        this(input, bigram, has);
        this.exactMatch = match;
    }

    public boolean incrementToken() throws IOException {
        if (this.curTermBuffer != null && this.morphQueue.size() > 0) {
            this.setTermBufferByQueue();
            return true;
        }
        if (!this.input.incrementToken()) {
            return false;
        }
        this.curTermBuffer = (char[])this.termAtt.buffer().clone();
        this.curTermLength = this.termAtt.length();
        this.tokStart = this.offsetAtt.startOffset();
        this.curType = this.typeAtt.type();
        try {
            if (KoreanTokenizer.TOKEN_TYPES[9].equals(this.curType)) {
                this.analysisKorean(new String(this.curTermBuffer, 0, this.termAtt.length()));
            } else if (KoreanTokenizer.TOKEN_TYPES[10].equals(this.curType)) {
                this.analysisChinese(new String(this.curTermBuffer, 0, this.termAtt.length()));
            } else {
                this.analysisETC(new String(this.curTermBuffer, 0, this.termAtt.length()));
            }
        }
        catch (MorphException e) {
            throw new IOException("Korean Filter MorphException\n" + e.getMessage());
        }
        if (this.morphQueue == null || this.morphQueue.size() == 0) {
            return false;
        }
        this.setTermBufferByQueue();
        return true;
    }

    private void setTermBufferByQueue() {
        this.clearAttributes();
        String term = this.morphQueue.removeFirst();
        int pos = new String(this.curTermBuffer).indexOf(term);
        this.termAtt.copyBuffer(term.toCharArray(), 0, term.length());
        this.offsetAtt.setOffset(this.tokStart + pos, this.tokStart + pos + term.length());
    }

    private void analysisKorean(String input) throws MorphException {
        List outputs = this.morph.analyze(input);
        if (outputs.size() == 0) {
            return;
        }
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
        if (this.hasOrigin) {
            map.put(input, new Integer(1));
        }
        if (((AnalysisOutput)outputs.get(0)).getScore() == 100) {
            this.extractKeyword(outputs, map);
        } else {
            try {
                List list = this.wsAnal.analyze(input);
                ArrayList<AnalysisOutput> results = new ArrayList<AnalysisOutput>();
                if (list.size() > 1) {
                    for (AnalysisOutput o : list) {
                        if (this.hasOrigin) {
                            map.put(o.getSource(), new Integer(1));
                        }
                        results.addAll(this.morph.analyze(o.getSource()));
                    }
                } else {
                    results.addAll(list);
                }
                this.extractKeyword(results, map);
            }
            catch (Exception e) {
                this.extractKeyword(outputs, map);
            }
        }
        Iterator iter = map.keySet().iterator();
        boolean i = false;
        while (iter.hasNext()) {
            String text = (String)iter.next();
            if (text.length() <= 1) continue;
            this.morphQueue.add(text);
        }
    }

    private void extractKeyword(List<AnalysisOutput> outputs, Map<String, Integer> map) throws MorphException {
        for (AnalysisOutput output : outputs) {
            if (output.getPos() != 'V') {
                map.put(output.getStem(), new Integer(1));
            }
            if (this.exactMatch) continue;
            if (output.getScore() >= 70) {
                List<CompoundEntry> cnouns = output.getCNounList();
                int jj = 0;
                while (jj < cnouns.size()) {
                    CompoundEntry cnoun = cnouns.get(jj);
                    if (cnoun.getWord().length() > 1) {
                        map.put(cnoun.getWord(), new Integer(0));
                    }
                    if (jj == 0 && cnoun.getWord().length() == 1) {
                        map.put(String.valueOf(cnoun.getWord()) + cnouns.get(jj + 1).getWord(), new Integer(0));
                    } else if (jj > 1 && cnoun.getWord().length() == 1) {
                        map.put(String.valueOf(cnouns.get(jj).getWord()) + cnoun.getWord(), new Integer(0));
                    }
                    ++jj;
                }
                continue;
            }
            if (!this.bigrammable) continue;
            this.addBiagramToMap(output.getStem(), map);
        }
    }

    private void addBiagramToMap(String input, Map map) {
        int offset = 0;
        int strlen = input.length();
        while (offset < strlen - 1) {
            String text;
            if (this.isAlphaNumChar(input.charAt(offset))) {
                text = this.findAlphaNumeric(input.substring(offset));
                map.put(text, new Integer(0));
                offset += text.length();
                continue;
            }
            text = input.substring(offset, offset + 2 > strlen ? strlen : offset + 2);
            map.put(text, new Integer(0));
            ++offset;
        }
    }

    private String findAlphaNumeric(String text) {
        int pos = 0;
        int i = 0;
        while (i < text.length()) {
            if (!this.isAlphaNumChar(text.charAt(i))) break;
            ++pos;
            ++i;
        }
        return text.substring(0, pos);
    }

    private void analysisChinese(String term) throws MorphException {
        this.morphQueue.add(term);
        if (term.length() < 2) {
            return;
        }
        ArrayList<StringBuffer> candiList = new ArrayList<StringBuffer>();
        candiList.add(new StringBuffer());
        int i = 0;
        while (i < term.length()) {
            char[] chs = HanjaUtils.convertToHangul(term.charAt(i));
            if (chs.length >= 1) {
                int caniSize = candiList.size();
                int j = 0;
                while (j < caniSize) {
                    StringBuffer sb = (StringBuffer)candiList.get(j);
                    int k = 1;
                    while (k < chs.length) {
                        if (k == 1) break;
                        StringBuffer cpSb = new StringBuffer(sb);
                        cpSb.append(chs[k]);
                        candiList.add(cpSb);
                        ++k;
                    }
                    sb.append(chs[0]);
                    ++j;
                }
            }
            ++i;
        }
        int maxCandidate = 5;
        if (candiList.size() < maxCandidate) {
            maxCandidate = candiList.size();
        }
        int i2 = 0;
        while (i2 < maxCandidate) {
            this.morphQueue.add(((StringBuffer)candiList.get(i2)).toString());
            ++i2;
        }
        HashMap<String, String> cnounMap = new HashMap<String, String>();
        int i3 = 0;
        while (i3 < maxCandidate) {
            List results = this.confirmCNoun(((StringBuffer)candiList.get(i3)).toString());
            int pos = 0;
            for (CompoundEntry entry : results) {
                pos += entry.getWord().length();
                if (cnounMap.get(entry.getWord()) != null) continue;
                this.morphQueue.add(term.substring(pos - entry.getWord().length(), pos));
                cnounMap.put(entry.getWord(), entry.getWord());
                if (entry.getWord().length() < 2) continue;
                this.morphQueue.add(entry.getWord());
            }
            ++i3;
        }
    }

    private List confirmCNoun(String input) throws MorphException {
        WordEntry cnoun = DictionaryUtil.getCNoun(input);
        if (cnoun != null && cnoun.getFeature(0) == '2') {
            return cnoun.getCompounds();
        }
        return this.cnAnalyzer.analyze(input);
    }

    private void analysisETC(String term) throws MorphException {
        char[] buffer = this.termAtt.buffer();
        int bufferLength = this.termAtt.length();
        String type = this.typeAtt.type();
        if (type == APOSTROPHE_TYPE && bufferLength >= 2 && buffer[bufferLength - 2] == '\'' && (buffer[bufferLength - 1] == 's' || buffer[bufferLength - 1] == 'S')) {
            this.morphQueue.add(term.substring(0, bufferLength - 2));
        } else if (type == ACRONYM_TYPE) {
            int upto = 0;
            int i = 0;
            while (i < bufferLength) {
                char c = buffer[i];
                if (c != '.') {
                    buffer[upto++] = c;
                }
                ++i;
            }
            this.morphQueue.add(term.substring(0, upto));
        } else {
            this.morphQueue.add(term);
        }
    }

    private boolean isAlphaNumChar(int c) {
        return c >= 48 && c <= 57 || c >= 65 && c <= 122;
    }

    public void setHasOrigin(boolean has) {
        this.hasOrigin = has;
    }

    public void setExactMatch(boolean match) {
        this.exactMatch = match;
    }
}

