/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.kr.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.analysis.kr.morph.CompoundEntry;
import org.apache.lucene.analysis.kr.morph.MorphException;
import org.apache.lucene.analysis.kr.morph.WordEntry;
import org.apache.lucene.analysis.kr.utils.FileUtil;
import org.apache.lucene.analysis.kr.utils.KoreanEnv;
import org.apache.lucene.analysis.kr.utils.StringUtil;
import org.apache.lucene.analysis.kr.utils.Trie;

public class DictionaryUtil {
    private static Trie<String, WordEntry> dictionary;
    private static HashMap josas;
    private static HashMap eomis;
    private static HashMap prefixs;
    private static HashMap suffixs;
    private static HashMap<String, WordEntry> uncompounds;
    private static HashMap<String, String> cjwords;

    public static synchronized void loadDictionary() throws MorphException {
        WordEntry entry;
        String[] infos;
        dictionary = new Trie(true);
        List strList = null;
        List compounds = null;
        try {
            strList = FileUtil.readLines(KoreanEnv.getInstance().getValue("dictionary.dic"), "UTF-8");
            strList.addAll(FileUtil.readLines(KoreanEnv.getInstance().getValue("extension.dic"), "UTF-8"));
            compounds = FileUtil.readLines(KoreanEnv.getInstance().getValue("compounds.dic"), "UTF-8");
        }
        catch (IOException e) {
            new MorphException(e.getMessage(), e);
        }
        catch (Exception e) {
            new MorphException(e.getMessage(), e);
        }
        if (strList == null) {
            throw new MorphException("dictionary is null");
        }
        for (String str : strList) {
            infos = StringUtil.split(str, ",");
            if (infos.length != 2) continue;
            infos[1] = infos[1].trim();
            if (infos[1].length() == 6) {
                infos[1] = String.valueOf(infos[1].substring(0, 5)) + "000" + infos[1].substring(5);
            }
            entry = new WordEntry(infos[0].trim(), infos[1].trim().toCharArray());
            dictionary.add(entry.getWord(), entry);
        }
        for (String compound : compounds) {
            infos = StringUtil.split(compound, ":");
            if (infos.length != 2) continue;
            entry = new WordEntry(infos[0].trim(), "20000000X".toCharArray());
            entry.setCompounds(DictionaryUtil.compoundArrayToList(infos[1], StringUtil.split(infos[1], ",")));
            dictionary.add(entry.getWord(), entry);
        }
    }

    public static Iterator findWithPrefix(String prefix) throws MorphException {
        if (dictionary == null) {
            DictionaryUtil.loadDictionary();
        }
        return dictionary.getPrefixedBy(prefix);
    }

    public static WordEntry getWord(String key) throws MorphException {
        if (dictionary == null) {
            DictionaryUtil.loadDictionary();
        }
        if (key.length() == 0) {
            return null;
        }
        return (WordEntry)dictionary.get(key);
    }

    public static WordEntry getWordExceptVerb(String key) throws MorphException {
        WordEntry entry = DictionaryUtil.getWord(key);
        if (entry == null) {
            return null;
        }
        if (entry.getFeature(0) == '1' || entry.getFeature(2) == '1') {
            return entry;
        }
        return null;
    }

    public static WordEntry getNoun(String key) throws MorphException {
        WordEntry entry = DictionaryUtil.getWord(key);
        if (entry == null) {
            return null;
        }
        if (entry.getFeature(0) == '1') {
            return entry;
        }
        return null;
    }

    public static WordEntry getCNoun(String key) throws MorphException {
        WordEntry entry = DictionaryUtil.getWord(key);
        if (entry == null) {
            return null;
        }
        if (entry.getFeature(0) == '1' || entry.getFeature(0) == '2') {
            return entry;
        }
        return null;
    }

    public static WordEntry getVerb(String key) throws MorphException {
        WordEntry entry = DictionaryUtil.getWord(key);
        if (entry == null) {
            return null;
        }
        if (entry.getFeature(1) == '1') {
            return entry;
        }
        return null;
    }

    public static WordEntry getAdverb(String key) throws MorphException {
        WordEntry entry = DictionaryUtil.getWord(key);
        if (entry == null) {
            return null;
        }
        if (entry.getFeature(2) == '1') {
            return entry;
        }
        return null;
    }

    public static WordEntry getBusa(String key) throws MorphException {
        WordEntry entry = DictionaryUtil.getWord(key);
        if (entry == null) {
            return null;
        }
        if (entry.getFeature(2) == '1' && entry.getFeature(0) == '0') {
            return entry;
        }
        return null;
    }

    public static WordEntry getIrrVerb(String key, char irrType) throws MorphException {
        WordEntry entry = DictionaryUtil.getWord(key);
        if (entry == null) {
            return null;
        }
        if (entry.getFeature(1) == '1' && entry.getFeature(9) == irrType) {
            return entry;
        }
        return null;
    }

    public static WordEntry getBeVerb(String key) throws MorphException {
        WordEntry entry = DictionaryUtil.getWord(key);
        if (entry == null) {
            return null;
        }
        if (entry.getFeature(4) == '1') {
            return entry;
        }
        return null;
    }

    public static WordEntry getDoVerb(String key) throws MorphException {
        WordEntry entry = DictionaryUtil.getWord(key);
        if (entry == null) {
            return null;
        }
        if (entry.getFeature(3) == '1') {
            return entry;
        }
        return null;
    }

    public static WordEntry getUncompound(String key) throws MorphException {
        try {
            if (uncompounds == null) {
                uncompounds = new HashMap();
                List lines = FileUtil.readLines(KoreanEnv.getInstance().getValue("uncompounds.dic"), "UTF-8");
                for (String compound : lines) {
                    String[] infos = StringUtil.split(compound, ":");
                    if (infos.length != 2) continue;
                    WordEntry entry = new WordEntry(infos[0].trim(), "90000X".toCharArray());
                    entry.setCompounds(DictionaryUtil.compoundArrayToList(infos[1], StringUtil.split(infos[1], ",")));
                    uncompounds.put(entry.getWord(), entry);
                }
            }
        }
        catch (Exception e) {
            throw new MorphException(e);
        }
        return uncompounds.get(key);
    }

    public static String getCJWord(String key) throws MorphException {
        try {
            if (cjwords == null) {
                cjwords = new HashMap();
                List lines = FileUtil.readLines(KoreanEnv.getInstance().getValue("cj.dic"), "UTF-8");
                for (String cj : lines) {
                    String[] infos = StringUtil.split(cj, ":");
                    if (infos.length != 2) continue;
                    cjwords.put(infos[0], infos[1]);
                }
            }
        }
        catch (Exception e) {
            throw new MorphException(e);
        }
        return cjwords.get(key);
    }

    public static boolean existJosa(String str) throws MorphException {
        if (josas == null) {
            josas = new HashMap();
            DictionaryUtil.readFile(josas, "josa.dic");
        }
        return josas.get(str) != null;
    }

    public static boolean existEomi(String str) throws MorphException {
        if (eomis == null) {
            eomis = new HashMap();
            DictionaryUtil.readFile(eomis, "eomi.dic");
        }
        return eomis.get(str) != null;
    }

    public static boolean existPrefix(String str) throws MorphException {
        if (prefixs == null) {
            prefixs = new HashMap();
            DictionaryUtil.readFile(prefixs, "prefix.dic");
        }
        return prefixs.get(str) != null;
    }

    public static boolean existSuffix(String str) throws MorphException {
        if (suffixs == null) {
            suffixs = new HashMap();
            DictionaryUtil.readFile(suffixs, "suffix.dic");
        }
        return suffixs.get(str) != null;
    }

    public static String combineAndEomiCheck(char s, String eomi) throws MorphException {
        if (eomi == null) {
            eomi = "";
        }
        if (DictionaryUtil.existEomi(eomi = s == '\u3134' ? "\uc740" + eomi : (s == '\u3139' ? "\uc744" + eomi : (s == '\u3141' ? "\uc74c" + eomi : (s == '\u3142' ? "\uc2b5" + eomi : String.valueOf(s) + eomi))))) {
            return eomi;
        }
        return null;
    }

    private static synchronized void readFile(HashMap map, String dic) throws MorphException {
        String path = KoreanEnv.getInstance().getValue(dic);
        try {
            List line = FileUtil.readLines(path, "UTF-8");
            int i = 1;
            while (i < line.size()) {
                map.put(((String)line.get(i)).trim(), line.get(i));
                ++i;
            }
        }
        catch (IOException e) {
            throw new MorphException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new MorphException(e.getMessage(), e);
        }
    }

    private static List compoundArrayToList(String source, String[] arr) {
        ArrayList<CompoundEntry> list = new ArrayList<CompoundEntry>();
        String[] stringArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            CompoundEntry ce = new CompoundEntry(str);
            ce.setOffset(source.indexOf(str));
            list.add(ce);
            ++n2;
        }
        return list;
    }
}

