/*
 * Decompiled with CFR 0.152.
 */
package org.madlonkay.supertmxmerge;

import java.awt.GraphicsEnvironment;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.madlonkay.supertmxmerge.DiffController;
import org.madlonkay.supertmxmerge.data.JAXB.JAXBTmx;
import org.madlonkay.supertmxmerge.data.WriteFailedException;
import org.madlonkay.supertmxmerge.gui.ProgressWindow;
import org.madlonkay.supertmxmerge.util.FileUtil;
import org.madlonkay.supertmxmerge.util.GuiUtil;
import org.madlonkay.supertmxmerge.util.LocString;

public class DiffIOController {
    private static final Logger LOGGER = Logger.getLogger(DiffIOController.class.getName());
    public static final String PROP_FILE1 = "file1";
    public static final String PROP_FILE2 = "file2";
    public static final String PROP_INPUTISVALID = "inputIsValid";
    public static final String PROP_OUTPUTFILE = "outputFile";
    private File file1;
    private File file2;
    private File outputFile;
    protected PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public File getFile1() {
        return this.file1;
    }

    public void setFile1(File file1) {
        File oldFile1 = this.file1;
        this.file1 = file1;
        this.propertySupport.firePropertyChange(PROP_FILE1, oldFile1, file1);
        this.propertySupport.firePropertyChange(PROP_INPUTISVALID, null, null);
    }

    public File getFile2() {
        return this.file2;
    }

    public void setFile2(File file2) {
        File oldFile2 = this.file2;
        this.file2 = file2;
        this.propertySupport.firePropertyChange(PROP_FILE2, oldFile2, file2);
        this.propertySupport.firePropertyChange(PROP_INPUTISVALID, null, null);
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        File oldOutputFile = this.outputFile;
        this.outputFile = outputFile;
        this.propertySupport.firePropertyChange(PROP_OUTPUTFILE, oldOutputFile, outputFile);
    }

    public boolean getInputIsValid() {
        return FileUtil.validateFile(this.getFile1()) && FileUtil.validateFile(this.getFile2()) && !this.getFile1().equals(this.getFile2());
    }

    public void go() {
        JAXBTmx tmx2;
        JAXBTmx tmx1;
        DiffController differ = new DiffController();
        ProgressWindow progress = null;
        if (!GraphicsEnvironment.isHeadless()) {
            progress = new ProgressWindow();
            progress.setMaximum(2);
        }
        try {
            this.updateProgress(progress, 0, LocString.getFormat("STM_FILE_PROGRESS", this.getFile1().getName(), 1, 2));
            tmx1 = new JAXBTmx(this.getFile1());
            this.updateProgress(progress, 1, LocString.getFormat("STM_FILE_PROGRESS", this.getFile2().getName(), 2, 2));
            tmx2 = new JAXBTmx(this.getFile2());
            this.updateProgress(progress, 2, null);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (progress != null) {
                GuiUtil.closeWindow(progress);
            }
        }
        if (this.outputFile != null) {
            JAXBTmx outTmx = JAXBTmx.createFromDiff(tmx1, tmx2);
            try {
                outTmx.writeTo(this.outputFile);
            }
            catch (WriteFailedException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
        } else {
            differ.diff(tmx1, tmx2);
        }
    }

    protected void updateProgress(ProgressWindow window, int value, String message) {
        if (window != null) {
            window.setValue(value);
            if (message != null) {
                window.setMessage(message);
            }
        }
    }
}

