/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.data;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.madlonkay.supertmxmerge.data.ITmx;
import org.madlonkay.supertmxmerge.data.ITu;
import org.madlonkay.supertmxmerge.data.ITuv;
import org.madlonkay.supertmxmerge.data.Key;
import org.madlonkay.supertmxmerge.data.ResolutionSet;
import org.madlonkay.supertmxmerge.data.WriteFailedException;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.OmTTu;
import org.omegat.core.data.ProjectTMX;
import org.omegat.core.data.TMXEntry;

public class OmTTmx
implements ITmx {
    private ProjectTMX tmx;
    private final String name;
    private final String sourceLanguage;
    private final String targetLanguage;
    private Map<Key, ITu> tuMap;
    private Map<Key, ITuv> tuvMap;

    public OmTTmx(ProjectTMX tmx, String name, String sourceLanguage, String targetLanguage) {
        this.tmx = tmx;
        this.name = name;
        this.sourceLanguage = sourceLanguage;
        this.targetLanguage = targetLanguage;
        this.generateMaps();
    }

    private void generateMaps() {
        Key key;
        OmTTu tu;
        this.tuvMap = new HashMap<Key, ITuv>();
        this.tuMap = new HashMap<Key, ITu>();
        for (Map.Entry e : this.tmx.defaults.entrySet()) {
            tu = new OmTTu((TMXEntry)e.getValue(), this.targetLanguage);
            key = this.makeKey(e.getKey(), (TMXEntry)e.getValue());
            assert (!this.tuMap.containsKey(key));
            assert (!this.tuvMap.containsKey(key));
            this.tuMap.put(key, tu);
            this.tuvMap.put(key, tu.getTargetTuv());
        }
        for (Map.Entry e : this.tmx.alternatives.entrySet()) {
            tu = new OmTTu((TMXEntry)e.getValue(), this.targetLanguage);
            key = this.makeKey(e.getKey(), (TMXEntry)e.getValue());
            assert (!this.tuMap.containsKey(key));
            assert (!this.tuvMap.containsKey(key));
            this.tuMap.put(key, tu);
            this.tuvMap.put(key, tu.getTargetTuv());
        }
    }

    private Key makeKey(Object entryKey, TMXEntry tmxEntry) {
        Key key = new Key(tmxEntry.source, entryKey);
        if (entryKey instanceof EntryKey) {
            EntryKey ek = (EntryKey)entryKey;
            key.addProp("file", ek.file);
            key.addProp("id", ek.id);
            key.addProp("next", ek.next);
            key.addProp("path", ek.path);
            key.addProp("prev", ek.prev);
        }
        return key;
    }

    @Override
    public String getSourceLanguage() {
        return this.sourceLanguage;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getSize() {
        return this.tmx.alternatives.size() + this.tmx.defaults.size();
    }

    @Override
    public Map<String, String> getMetadata() {
        return Collections.EMPTY_MAP;
    }

    @Override
    public ITmx applyChanges(ResolutionSet resolution) {
        ProjectTMX originalData = OmTTmx.clone(this.tmx);
        for (Key key : resolution.toDelete) {
            this.remove(key);
        }
        for (Map.Entry entry : resolution.toReplace.entrySet()) {
            this.remove((Key)entry.getKey());
            this.add((Key)entry.getKey(), (TMXEntry)((ITuv)entry.getValue()).getUnderlyingRepresentation());
        }
        for (Map.Entry entry : resolution.toAdd.entrySet()) {
            this.add((Key)entry.getKey(), (TMXEntry)((ITu)entry.getValue()).getUnderlyingRepresentation());
        }
        ProjectTMX modifiedData = this.tmx;
        this.tmx = originalData;
        this.tuvMap = null;
        this.tuMap = null;
        return new OmTTmx(modifiedData, this.name, this.sourceLanguage, this.targetLanguage);
    }

    private void add(Key key, TMXEntry tuv) {
        if (key.foreignKey instanceof String) {
            this.tmx.defaults.put((String)key.foreignKey, tuv);
        } else if (key.foreignKey instanceof EntryKey) {
            this.tmx.alternatives.put((EntryKey)key.foreignKey, tuv);
        } else {
            throw new IllegalArgumentException("Cannot add key of type " + key.getClass().getName() + " to a " + this.getClass().getName());
        }
    }

    private void remove(Key key) {
        if (key.foreignKey instanceof String) {
            this.tmx.defaults.remove((String)key.foreignKey);
        } else if (key.foreignKey instanceof EntryKey) {
            this.tmx.alternatives.remove((EntryKey)key.foreignKey);
        } else {
            throw new IllegalArgumentException("Cannot remove key of type " + key.getClass().getName() + " from a " + this.getClass().getName());
        }
    }

    private static ProjectTMX clone(ProjectTMX tmx) {
        ProjectTMX newTmx = new ProjectTMX();
        for (Map.Entry e : tmx.alternatives.entrySet()) {
            newTmx.alternatives.put(e.getKey(), e.getValue());
        }
        for (Map.Entry e : tmx.defaults.entrySet()) {
            newTmx.defaults.put(e.getKey(), e.getValue());
        }
        return newTmx;
    }

    @Override
    public void writeTo(File outputFile) throws WriteFailedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object getUnderlyingRepresentation() {
        return this.tmx;
    }

    @Override
    public ITu getTu(Key key) {
        return this.tuMap.get(key);
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean containsKey(Object key) {
        return this.tuvMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ITuv get(Object key) {
        return this.tuvMap.get(key);
    }

    @Override
    public ITuv put(Key key, ITuv value) {
        return this.tuvMap.put(key, value);
    }

    @Override
    public ITuv remove(Object key) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void putAll(Map<? extends Key, ? extends ITuv> m) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Set<Key> keySet() {
        return this.tuvMap.keySet();
    }

    @Override
    public Collection<ITuv> values() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Set<Map.Entry<Key, ITuv>> entrySet() {
        return this.tuvMap.entrySet();
    }
}

