/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.NumberFormatConverter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;

public class BigDecimalConverter
extends NumberFormatConverter {
    public BigDecimalConverter() {
        super(new DecimalFormat("#,##0.00"));
    }

    public Object fromString(String string, ConverterContext context) {
        Object value = super.fromString(string, context);
        if (value instanceof Double) {
            return new BigDecimal((Double)value);
        }
        if (value instanceof Long) {
            return new BigDecimal((Long)value);
        }
        if (value instanceof Integer) {
            return new BigDecimal((Integer)value);
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        return value;
    }

    public String toString(Object obj, ConverterContext convertercontext) {
        if (obj instanceof BigDecimal) {
            BigDecimal decimal = (BigDecimal)obj;
            if (decimal.doubleValue() == Double.NaN) {
                return "";
            }
            return super.toString(decimal, convertercontext);
        }
        return "";
    }
}

