/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.eclipse;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;

public class EclipseUtils {
    private static final BasicStroke DOTTED_STROKE = new BasicStroke(1.0f, 2, 1, 1.0f, new float[]{0.0f, 2.0f, 0.0f, 2.0f}, 0.0f);
    static final double RATIO1 = 0.67;
    static final double RATIO2 = 0.78;
    static final double RATIO3 = 0.86;

    static Color getLighterColor(Color backColor) {
        int r = EclipseUtils.getLighterColor(backColor.getRed());
        int g = EclipseUtils.getLighterColor(backColor.getGreen());
        int b2 = EclipseUtils.getLighterColor(backColor.getBlue());
        if (r >= 255) {
            r = 255;
        }
        if (g >= 255) {
            g = 255;
        }
        if (b2 >= 255) {
            b2 = 255;
        }
        return new Color(r, g, b2);
    }

    static int getLighterColor(int x) {
        return (int)((double)x * 36.0 / 255.0 + 219.5);
    }

    static Color getMenuSelectionColor(Color backColor) {
        int r = EclipseUtils.getMenuSelectionValue(backColor.getRed());
        int g = EclipseUtils.getMenuSelectionValue(backColor.getGreen());
        int b2 = EclipseUtils.getMenuSelectionValue(backColor.getBlue());
        if (r >= 255) {
            r = 255;
        }
        if (g >= 255) {
            g = 255;
        }
        if (b2 >= 255) {
            b2 = 255;
        }
        return new Color(r, g, b2);
    }

    static int getMenuSelectionValue(int x) {
        return (int)((double)x * 76.0 / 255.0 + 179.5);
    }

    static Color getMenuBackgroundColor(Color backColor) {
        int r = EclipseUtils.getMenuValue(backColor.getRed());
        int g = EclipseUtils.getMenuValue(backColor.getGreen());
        int b2 = EclipseUtils.getMenuValue(backColor.getBlue());
        if (r >= 255) {
            r = 255;
        }
        if (g >= 255) {
            g = 255;
        }
        if (b2 >= 255) {
            b2 = 255;
        }
        return new Color(r, g, b2);
    }

    static int getMenuValue(int x) {
        return (int)((double)x * 36.0 / 255.0 + 219.5);
    }

    static Color getDefaultBackgroundColor(Color backColor) {
        Color backIDE;
        if (backColor.getRed() == 212 && backColor.getGreen() == 208 && backColor.getBlue() == 200) {
            backIDE = new Color(247, 243, 233);
        } else if (backColor.getRed() == 236 && backColor.getGreen() == 233 && backColor.getBlue() == 216) {
            backIDE = new Color(255, 251, 233);
        } else {
            int r = backColor.getRed() + 35;
            int g = backColor.getGreen() + 35;
            int b2 = backColor.getBlue() + 35;
            if (r >= 255) {
                r = 255;
            }
            if (g >= 255) {
                g = 255;
            }
            if (b2 >= 255) {
                b2 = 255;
            }
            backIDE = new Color(r, g, b2);
        }
        return backIDE;
    }

    public static void fillRectWithHatch(Graphics2D g, Rectangle rect, Color color) {
        Stroke oldStroke = g.getStroke();
        g.setColor(Color.white);
        g.fillRect(rect.x, rect.y, rect.width, rect.height);
        g.setColor(color);
        g.setStroke(DOTTED_STROKE);
        for (int i = 0; i < rect.width; ++i) {
            if (i % 2 == 0) {
                g.drawLine(rect.x + i, rect.y, rect.x + i, rect.y + rect.height - 1);
                continue;
            }
            g.drawLine(rect.x + i, rect.y + 1, rect.x + i, rect.y + rect.height - 1);
        }
        g.setStroke(oldStroke);
    }

    static int getLightColor(int x, double ratio) {
        return (int)((double)(255 - x) * ratio + (double)x);
    }

    static Color getLighterColor(Color backColor, double ratio) {
        int r = EclipseUtils.getLightColor(backColor.getRed(), ratio);
        int g = EclipseUtils.getLightColor(backColor.getGreen(), ratio) + 1;
        int b2 = EclipseUtils.getLightColor(backColor.getBlue(), ratio);
        if (r >= 255) {
            r = 255;
        }
        if (g >= 255) {
            g = 255;
        }
        if (b2 >= 255) {
            b2 = 255;
        }
        return new Color(r, g, b2);
    }

    static Color getSelectedAndFocusedButtonColor(Color backColor) {
        return EclipseUtils.getLighterColor(backColor, 0.67);
    }

    static Color getFocusedButtonColor(Color backColor) {
        return EclipseUtils.getLighterColor(backColor, 0.78);
    }

    static Color getSelectedButtonColor(Color backColor) {
        return EclipseUtils.getLighterColor(backColor, 0.86);
    }
}

