/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.spinner;

import java.awt.event.ActionEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.Action;
import javax.swing.JSpinner;

public class SpinnerWheelSupport {
    public static final String CLIENT_PROPERTY_MOUSE_WHEEL_LISTENER = "mouseWheelListener";
    protected static final String ACTION_NAME_INCREMENT = "increment";
    protected static final String ACTION_NAME_DECREMENT = "decrement";

    public static void installMouseWheelSupport(final JSpinner spinner) {
        MouseWheelListener l = new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                Action action;
                int rotation = e.getWheelRotation();
                if (rotation < 0) {
                    Action action2 = spinner.getActionMap().get(SpinnerWheelSupport.ACTION_NAME_INCREMENT);
                    if (action2 != null) {
                        action2.actionPerformed(new ActionEvent(e.getSource(), 0, SpinnerWheelSupport.ACTION_NAME_INCREMENT));
                    }
                } else if (rotation > 0 && (action = spinner.getActionMap().get(SpinnerWheelSupport.ACTION_NAME_DECREMENT)) != null) {
                    action.actionPerformed(new ActionEvent(e.getSource(), 0, SpinnerWheelSupport.ACTION_NAME_DECREMENT));
                }
            }
        };
        spinner.addMouseWheelListener(l);
        spinner.putClientProperty(CLIENT_PROPERTY_MOUSE_WHEEL_LISTENER, l);
    }

    public static void uninstallMouseWheelSupport(JSpinner spinner) {
        MouseWheelListener l = (MouseWheelListener)spinner.getClientProperty(CLIENT_PROPERTY_MOUSE_WHEEL_LISTENER);
        if (l != null) {
            spinner.removeMouseWheelListener(l);
        }
    }
}

