/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.cli.svn.SVNCommand;
import org.tmatesoft.svn.cli.svn.SVNNotifyPrinter;
import org.tmatesoft.svn.cli.svn.SVNOption;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.wc.SVNChangelistClient;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNChangeListCommand
extends SVNCommand {
    public SVNChangeListCommand() {
        super("changelist", new String[]{"cl"});
    }

    protected Collection createSupportedOptions() {
        LinkedList<SVNOption> options = new LinkedList<SVNOption>();
        options.add(SVNOption.QUIET);
        options.add(SVNOption.RECURSIVE);
        options.add(SVNOption.DEPTH);
        options.add(SVNOption.REMOVE);
        options.add(SVNOption.TARGETS);
        options.add(SVNOption.CHANGELIST);
        return options;
    }

    public void run() throws SVNException {
        List targets = new ArrayList();
        String changelist = null;
        if (this.getSVNEnvironment().getTargets() != null) {
            targets.addAll(this.getSVNEnvironment().getTargets());
        }
        targets = this.getSVNEnvironment().combineTargets(targets, true);
        if (this.getSVNEnvironment().isRemove()) {
            if (targets.size() < 1) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS), SVNLogType.CLIENT);
            }
            changelist = null;
        } else {
            if (targets.size() < 2) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS), SVNLogType.CLIENT);
            }
            changelist = (String)targets.remove(0);
        }
        ArrayList<File> paths = new ArrayList<File>();
        for (String targetName : targets) {
            SVNPath target = new SVNPath(targetName);
            paths.add(target.getFile());
        }
        File[] files = paths.toArray(new File[paths.size()]);
        SVNDepth depth = this.getSVNEnvironment().getDepth();
        if (depth == SVNDepth.UNKNOWN) {
            depth = SVNDepth.EMPTY;
        }
        SVNChangelistClient client = this.getSVNEnvironment().getClientManager().getChangelistClient();
        if (!this.getSVNEnvironment().isQuiet()) {
            client.setEventHandler(new SVNNotifyPrinter(this.getSVNEnvironment()));
        }
        try {
            if (changelist != null) {
                client.doAddToChangelist(files, depth, changelist, this.getSVNEnvironment().getChangelists());
            } else {
                client.doRemoveFromChangelist(files, depth, this.getSVNEnvironment().getChangelists());
            }
        }
        catch (SVNException e) {
            this.getSVNEnvironment().handleWarning(e.getErrorMessage(), new SVNErrorCode[]{SVNErrorCode.UNVERSIONED_RESOURCE, SVNErrorCode.WC_PATH_NOT_FOUND}, this.getSVNEnvironment().isQuiet());
        }
    }
}

