/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.javahl;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.javahl.SVNClientImpl;

public class SVNClientImplTracker
implements Runnable {
    private static ReferenceQueue ourQueue;
    private static Map ourReferences;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerClient(SVNClientImpl client) {
        Object object = SVNClientImplTracker.class;
        synchronized (object) {
            if (ourQueue == null) {
                ourQueue = new ReferenceQueue();
                Thread th = new Thread(new SVNClientImplTracker());
                th.setDaemon(true);
                th.start();
            }
        }
        object = ourReferences;
        synchronized (object) {
            SVNClientImpl oldClient = null;
            Iterator refs = ourReferences.keySet().iterator();
            while (refs.hasNext()) {
                WeakReference reference = (WeakReference)refs.next();
                if (reference.get() != Thread.currentThread()) continue;
                oldClient = (SVNClientImpl)ourReferences.get(reference);
                if (oldClient != null) {
                    oldClient.dispose();
                }
                refs.remove();
            }
            WeakReference<Thread> ref = new WeakReference<Thread>(Thread.currentThread(), ourQueue);
            oldClient = ourReferences.put(ref, client);
            if (oldClient != null) {
                oldClient.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            Reference reference = null;
            try {
                reference = ourQueue.remove();
            }
            catch (IllegalArgumentException e) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (reference == null) continue;
            Map map = ourReferences;
            synchronized (map) {
                SVNClientImpl oldClient = (SVNClientImpl)ourReferences.remove(reference);
                if (oldClient != null) {
                    oldClient.dispose();
                }
            }
        }
    }

    static {
        ourReferences = new SVNHashMap();
    }
}

