/*
 * Decompiled with CFR 0.152.
 */
package com.ice.config;

import com.ice.config.ConfigureSpec;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class ConfigureTreeNode
extends DefaultMutableTreeNode {
    private ConfigureSpec spec = null;

    public ConfigureTreeNode(String name) {
        super(name);
    }

    public ConfigureTreeNode(String name, ConfigureSpec spec) {
        super(name);
        this.spec = spec;
    }

    public void add(ConfigureTreeNode node) {
        int chCnt = this.getChildCount();
        int i = 0;
        while (i < chCnt) {
            ConfigureTreeNode chNode = (ConfigureTreeNode)this.getChildAt(i);
            if (node.getName().compareTo(chNode.getName()) < 0) {
                this.insert(node, i);
                return;
            }
            ++i;
        }
        super.add(node);
    }

    public String getName() {
        return (String)this.getUserObject();
    }

    public String getPathName() {
        StringBuffer result = new StringBuffer();
        TreeNode[] path = this.getPath();
        int i = 1;
        while (i < path.length) {
            result.append(((ConfigureTreeNode)path[i]).getName());
            if (i < path.length - 1) {
                result.append(".");
            }
            ++i;
        }
        return result.toString();
    }

    public ConfigureSpec getConfigureSpec() {
        return this.spec;
    }

    public void setPropertySpec(ConfigureSpec spec) {
        this.spec = spec;
    }

    public ConfigureTreeNode getChild(String name) {
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            ConfigureTreeNode node = (ConfigureTreeNode)enumeration.nextElement();
            if (!node.toString().equals(name)) continue;
            return node;
        }
        return null;
    }
}

