/*
 * Decompiled with CFR 0.152.
 */
package com.ice.config;

import com.ice.config.ConfigureConstants;
import com.ice.config.ConfigureEditor;
import com.ice.config.ConfigureEditorFactory;
import com.ice.config.editor.ConfigBooleanEditor;
import com.ice.config.editor.ConfigChoiceEditor;
import com.ice.config.editor.ConfigColorEditor;
import com.ice.config.editor.ConfigComboEditor;
import com.ice.config.editor.ConfigDimensionEditor;
import com.ice.config.editor.ConfigDoubleEditor;
import com.ice.config.editor.ConfigFloatEditor;
import com.ice.config.editor.ConfigFontEditor;
import com.ice.config.editor.ConfigIntegerEditor;
import com.ice.config.editor.ConfigLongEditor;
import com.ice.config.editor.ConfigPointEditor;
import com.ice.config.editor.ConfigRectangleEditor;
import com.ice.config.editor.ConfigStringArrayEditor;
import com.ice.config.editor.ConfigStringEditor;
import com.ice.config.editor.ConfigTokenEditor;
import com.ice.config.editor.ConfigTupleTableEditor;
import com.ice.pref.UserPrefs;
import java.util.Hashtable;

public class DefaultConfigureEditorFactory
implements ConfigureEditorFactory,
ConfigureConstants {
    protected Hashtable editors;
    protected UserPrefs editSpecs;

    public DefaultConfigureEditorFactory(UserPrefs specs) {
        this.editSpecs = specs;
        this.editors = new Hashtable();
        this.editors.put("DEFAULT", this.createDefaultEditor("string"));
        this.editors.put("string", this.createDefaultEditor("string"));
    }

    public ConfigureEditor createEditor(String propertyType) {
        ConfigureEditor result = (ConfigureEditor)this.editors.get(propertyType);
        if (result == null && (result = this.createDefaultEditor(propertyType)) != null) {
            this.editors.put(propertyType, result);
        }
        return result;
    }

    public void addEditor(String propertyType, ConfigureEditor editor) {
        this.editors.put(propertyType, editor);
    }

    public void removeEditor(String propertyType) {
        this.editors.remove(propertyType);
    }

    private ConfigureEditor createDefaultEditor(String propertyType) {
        if (propertyType.equalsIgnoreCase("string")) {
            return new ConfigStringEditor();
        }
        if (propertyType.equalsIgnoreCase("point")) {
            return new ConfigPointEditor();
        }
        if (propertyType.equalsIgnoreCase("dimension")) {
            return new ConfigDimensionEditor();
        }
        if (propertyType.equalsIgnoreCase("rectangle")) {
            return new ConfigRectangleEditor();
        }
        if (propertyType.equalsIgnoreCase("boolean")) {
            return new ConfigBooleanEditor();
        }
        if (propertyType.equalsIgnoreCase("integer")) {
            return new ConfigIntegerEditor();
        }
        if (propertyType.equalsIgnoreCase("long")) {
            return new ConfigLongEditor();
        }
        if (propertyType.equalsIgnoreCase("float")) {
            return new ConfigFloatEditor();
        }
        if (propertyType.equalsIgnoreCase("double")) {
            return new ConfigDoubleEditor();
        }
        if (propertyType.equalsIgnoreCase("color")) {
            return new ConfigColorEditor();
        }
        if (propertyType.equalsIgnoreCase("font")) {
            return new ConfigFontEditor();
        }
        if (propertyType.equalsIgnoreCase("choice")) {
            return new ConfigChoiceEditor();
        }
        if (propertyType.equalsIgnoreCase("combo")) {
            return new ConfigComboEditor();
        }
        if (propertyType.equalsIgnoreCase("stringarray")) {
            return new ConfigStringArrayEditor();
        }
        if (propertyType.equalsIgnoreCase("tokens")) {
            return new ConfigTokenEditor();
        }
        if (propertyType.equalsIgnoreCase("tupletable")) {
            return new ConfigTupleTableEditor();
        }
        return null;
    }
}

