/*
 * Decompiled with CFR 0.152.
 */
package com.ice.config.editor;

import com.ice.config.ConfigureEditor;
import com.ice.config.ConfigureSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public abstract class ConfigArrayEditor
extends ConfigureEditor
implements FocusListener {
    protected JButton insertButton;
    protected JButton appendButton;
    protected JButton deleteButton;
    protected JTable table;
    protected SAETableModel model;
    static /* synthetic */ Class class$java$lang$String;

    public ConfigArrayEditor(String typeName) {
        super(typeName);
    }

    public void requestInitialFocus() {
    }

    public void focusGained(FocusEvent event) {
    }

    public void focusLost(FocusEvent event) {
    }

    public boolean isTupleTable(ConfigureSpec spec) {
        return false;
    }

    public boolean isStringArray(ConfigureSpec spec) {
        return true;
    }

    protected JPanel createEditPanel() {
        JPanel result = new JPanel();
        result.setLayout(new BorderLayout());
        result.setBorder(new CompoundBorder(new EmptyBorder(7, 7, 7, 7), new CompoundBorder(new EtchedBorder(0), new EmptyBorder(2, 2, 2, 2))));
        result.setPreferredSize(new Dimension(150, 225));
        this.insertButton = new JButton("Insert");
        this.model = new SAETableModel();
        this.table = new JTable(this.model){

            public Component getNextFocusableComponent() {
                return ConfigArrayEditor.this.insertButton;
            }
        };
        this.table.setIntercellSpacing(new Dimension(3, 3));
        JScrollPane scroller = new JScrollPane(this.table);
        result.add("Center", scroller);
        JPanel ctlPan = new JPanel();
        ctlPan.setLayout(new GridLayout(1, 3, 5, 5));
        result.add("South", ctlPan);
        this.insertButton.addActionListener(new ActionAdapter(this, this){
            private final /* synthetic */ ConfigArrayEditor this$0;
            {
                ConfigArrayEditor configArrayEditor = x0;
                configArrayEditor.getClass();
                this.this$0 = this$0;
            }

            public void actionPerformed(ActionEvent e) {
                this.this$0.insertElement();
            }
        });
        ctlPan.add(this.insertButton);
        this.appendButton = new JButton("Append");
        this.appendButton.addActionListener(new ActionAdapter(this, this){
            private final /* synthetic */ ConfigArrayEditor this$0;
            {
                ConfigArrayEditor configArrayEditor = x0;
                configArrayEditor.getClass();
                this.this$0 = this$0;
            }

            public void actionPerformed(ActionEvent e) {
                this.this$0.appendElement();
            }
        });
        ctlPan.add(this.appendButton);
        this.deleteButton = new JButton("Delete");
        this.deleteButton.addActionListener(new ActionAdapter(this, this){
            private final /* synthetic */ ConfigArrayEditor this$0;
            {
                ConfigArrayEditor configArrayEditor = x0;
                configArrayEditor.getClass();
                this.this$0 = this$0;
            }

            public void actionPerformed(ActionEvent e) {
                this.this$0.deleteElement();
            }
        });
        ctlPan.add(this.deleteButton);
        this.descOffset = 5;
        return result;
    }

    public void insertElement() {
        int row = this.table.getSelectedRow();
        this.model.insertElement("New String", row);
        this.table.setRowSelectionInterval(row, row);
        this.table.repaint(250L);
    }

    public void appendElement() {
        this.model.appendElement("New String");
        int row = this.model.getRowCount() - 1;
        this.table.setRowSelectionInterval(row, row);
        this.table.repaint(250L);
    }

    public void deleteElement() {
        this.table.removeEditor();
        int row = this.table.getSelectedRow();
        if (row >= 0 && row < this.model.getRowCount()) {
            this.model.deleteElement(row);
            if (row >= this.model.getRowCount()) {
                row = this.model.getRowCount() - 1;
            }
            this.table.setRowSelectionInterval(row, row);
            this.table.repaint(250L);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ActionAdapter
    implements ActionListener {
        private ActionAdapter() {
        }

        public void actionPerformed(ActionEvent event) {
        }
    }

    public class SAETableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{"Value"};
        private Class[] columnTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ConfigArrayEditor.class$("java.lang.String")) : class$java$lang$String};
        private Vector data = null;

        public Vector getData() {
            return this.data;
        }

        public void setData(Vector data) {
            this.data = data;
            this.fireTableChanged(new TableModelEvent(this));
        }

        public void insertElement(String val, int row) {
            this.data.insertElementAt(val, row);
            this.fireTableRowsInserted(row, row);
        }

        public void appendElement(String val) {
            this.data.addElement(val);
            this.fireTableRowsInserted(this.data.size(), this.data.size());
        }

        public void deleteElement(int row) {
            this.data.removeElementAt(row);
            this.fireTableRowsDeleted(row, row);
        }

        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public Class getColumnClass(int column) {
            return this.columnTypes[column];
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            if (this.data == null) {
                return 0;
            }
            return this.data.size();
        }

        public Object getValueAt(int aRow, int aColumn) {
            return this.data.elementAt(aRow);
        }

        public void setValueAt(Object value, int row, int column) {
            this.data.setElementAt(value, row);
        }

        public boolean isCellEditable(int row, int column) {
            return true;
        }
    }
}

