/*
 * Decompiled with CFR 0.152.
 */
package com.ice.cvsc;

import com.ice.cvsc.CVSArgumentVector;
import com.ice.cvsc.CVSEntry;
import com.ice.cvsc.CVSEntryVector;
import com.ice.cvsc.CVSLog;
import com.ice.cvsc.CVSResponseHandler;
import com.ice.cvsc.CVSUserInterface;
import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class CVSRequest {
    public static final String RCS_ID = "$Id: CVSRequest.java,v 2.9 2003/07/27 01:08:32 time Exp $";
    public static final String RCS_REV = "$Revision: 2.9 $";
    public static final int METHOD_INETD = 1;
    public static final int METHOD_RSH = 2;
    public static final int METHOD_SSH = 3;
    private static final int ES_FIRST = 0;
    public static final int ES_NONE = 0;
    public static final int ES_ALL = 1;
    public static final int ES_SEL = 2;
    public static final int ES_SELALL = 3;
    public static final int ES_ALLMOD = 4;
    public static final int ES_SELMOD = 5;
    public static final int ES_ALLLOST = 6;
    public static final int ES_SELLOST = 7;
    public static final int ES_ALLUNC = 8;
    public static final int ES_SELUNC = 9;
    public static final int ES_USER = 10;
    public static final int ES_NEW = 11;
    public static final int ES_POPUP = 12;
    private static final int ES_LAST = 12;
    private PrintStream traceStream = null;
    public boolean traceRequest = false;
    public boolean traceResponse = false;
    public boolean traceProcessing = false;
    public boolean traceTCPData = false;
    private String vfReason = null;
    public boolean useUnchanged = false;
    public boolean useDirectory = true;
    public boolean execInCurDir = false;
    public boolean sendEntries = false;
    public boolean sendModifieds = false;
    public boolean sendEmptyMods = false;
    public boolean sendArguments = false;
    public boolean sendEntryFiles = false;
    public boolean sendModule = false;
    public boolean sendRootDirectory = true;
    public boolean includeNotifies = true;
    public boolean verificationOnly = false;
    public boolean guaranteeMsg = false;
    public boolean redirectOutput = false;
    public boolean displayReponse = false;
    public boolean handleUpdated = false;
    public boolean handleMerged = false;
    public boolean handleCopyFile = false;
    public boolean handleEntries = false;
    public boolean handleFlags = false;
    public boolean ignoreResult;
    public boolean allowOverWrites = false;
    public boolean saveTempFiles = false;
    public boolean stickyIsSet = false;
    public boolean staticDirIsSet = false;
    public String validRequests;
    public boolean queueResponse = true;
    public CVSResponseHandler responseHandler = null;
    public boolean forceModifieds = false;
    public int gzipStreamLevel = 0;
    public boolean allowGzipFileMode = true;
    public boolean gzipFileMode = false;
    public Vector notifies;
    private Hashtable stickys = null;
    private Hashtable statics;
    private String[] setVars = null;
    private int connMethod = 1;
    private String rshProcess = null;
    private boolean isPServer = false;
    private String userName = "";
    private String password = "";
    private String serverCommand = "";
    private String updateProg = null;
    private String checkInProg = null;
    private int port = 2401;
    private String hostName = null;
    private String repository = null;
    private String rootDirectory = null;
    private String rootRepository;
    private String localDirectory = null;
    private String command = null;
    private int entrySelector = 2;
    private CVSEntry dirEntry = null;
    private CVSEntryVector entries = null;
    private CVSArgumentVector arguments = null;
    private CVSArgumentVector globalargs = null;
    private CVSUserInterface ui = null;
    private PrintWriter redirectWriter = null;

    public static String getConnMethodName(int method) {
        return method == 1 ? "pserver" : (method == 3 ? "ssh" : "rsh");
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.endRedirection();
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isPServer() {
        return this.isPServer;
    }

    public void setPServer(boolean isPServer) {
        this.isPServer = isPServer;
    }

    public CVSUserInterface getUserInterface() {
        return this.ui;
    }

    public void setUserInterface(CVSUserInterface ui) {
        this.ui = ui;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getServerCommand() {
        return this.serverCommand;
    }

    public void setServerCommand(String command) {
        this.serverCommand = command;
    }

    public int getConnectionMethod() {
        return this.connMethod;
    }

    public void setConnectionMethod(int method) {
        this.connMethod = method;
    }

    public String getRshProcess() {
        return this.rshProcess;
    }

    public void setRshProcess(String rshProcess) {
        this.rshProcess = rshProcess;
    }

    public int getGzipStreamLevel() {
        return this.gzipStreamLevel;
    }

    public void setGzipStreamLevel(int level) {
        this.gzipStreamLevel = level;
    }

    public CVSEntry getDirEntry() {
        return this.dirEntry;
    }

    public void setDirEntry(CVSEntry dirEntry) {
        this.dirEntry = dirEntry;
    }

    public String getLocalDirectory() {
        return this.localDirectory;
    }

    public void setLocalDirectory(String localDirectory) {
        this.localDirectory = localDirectory;
    }

    public File getLocalFile(CVSEntry entry) {
        File result = new File(this.localDirectory + "/" + entry.getFullName());
        return result;
    }

    public String getRootDirectory() {
        return this.rootDirectory;
    }

    public void setRootDirectory(String rootDirectory) {
        this.rootDirectory = rootDirectory;
    }

    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public String getRootRepository() {
        return this.rootRepository;
    }

    public void setRootRepository(String repository) {
        this.rootRepository = repository;
    }

    public CVSResponseHandler getResponseHandler() {
        return this.responseHandler;
    }

    public void setResponseHandler(CVSResponseHandler responseHandler) {
        this.responseHandler = responseHandler;
    }

    public CVSEntryVector getEntries() {
        return this.entries;
    }

    public void setEntries(CVSEntryVector entries) {
        this.entries = entries;
    }

    public int getEntrySelector() {
        return this.entrySelector;
    }

    public CVSArgumentVector getArguments() {
        return this.arguments;
    }

    public void setArguments(CVSArgumentVector arguments) {
        this.arguments = arguments;
    }

    public void appendArguments(CVSArgumentVector newArgs) {
        if (this.arguments == null) {
            this.arguments = new CVSArgumentVector();
        }
        int i = 0;
        while (newArgs != null && i < newArgs.size()) {
            this.arguments.appendArgument(newArgs.argumentAt(i));
            ++i;
        }
    }

    public CVSArgumentVector getGlobalArguments() {
        return this.globalargs;
    }

    public void setGlobalArguments(CVSArgumentVector arguments) {
        this.globalargs = arguments;
    }

    public void appendGlobalArguments(CVSArgumentVector newArgs) {
        if (this.globalargs == null) {
            this.globalargs = new CVSArgumentVector();
        }
        int i = 0;
        while (i < newArgs.size()) {
            this.globalargs.appendArgument(newArgs.argumentAt(i));
            ++i;
        }
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String[] getSetVariables() {
        return this.setVars;
    }

    public void setSetVariables(String[] vars) {
        this.setVars = vars;
    }

    public Hashtable getStickys() {
        return this.stickys;
    }

    public void setStickys(Hashtable stickys) {
        this.stickys = stickys;
    }

    public Hashtable getStatics() {
        return this.statics;
    }

    public void setStatics(Hashtable statics) {
        this.statics = statics;
    }

    public String getCheckInProgram() {
        return this.checkInProg;
    }

    public void setCheckInProgram(String program) {
        this.checkInProg = program;
    }

    public String getUpdateProgram() {
        return this.updateProg;
    }

    public void setUpdateProgram(String program) {
        this.updateProg = program;
    }

    public boolean isRedirected() {
        return this.redirectOutput && this.redirectWriter != null;
    }

    public void redirectLine(String line) {
        if (this.redirectOutput && this.redirectWriter != null) {
            this.redirectWriter.println(line);
        }
    }

    public void setRedirectWriter(PrintWriter writer) {
        this.redirectWriter = writer;
        this.redirectOutput = writer != null;
    }

    public void endRedirection() {
        if (this.redirectWriter != null) {
            this.redirectWriter.flush();
            this.redirectWriter.close();
            this.redirectWriter = null;
            this.redirectOutput = false;
        }
    }

    public static int parseEntriesSelector(char selectCh) {
        int result = 2;
        switch (selectCh) {
            case 'N': {
                result = 0;
                break;
            }
            case 'A': {
                result = 1;
                break;
            }
            case 'a': {
                result = 2;
                break;
            }
            case 'e': {
                result = 3;
                break;
            }
            case 'M': {
                result = 4;
                break;
            }
            case 'm': {
                result = 5;
                break;
            }
            case 'L': {
                result = 6;
                break;
            }
            case 'l': {
                result = 7;
                break;
            }
            case 'U': {
                result = 8;
                break;
            }
            case 'u': {
                result = 9;
                break;
            }
            case 'G': {
                result = 10;
                break;
            }
            case 'g': {
                result = 11;
                break;
            }
            case 'p': {
                result = 12;
                break;
            }
            default: {
                result = 2;
                CVSLog.logMsg("CVSRequest.parseEntriesSelector: 'ERROR bad entries selector '" + selectCh + "'");
            }
        }
        return result;
    }

    public void parseArgumentString(String argStr) {
        CVSArgumentVector args;
        int bktidx;
        if (argStr.startsWith("[") && (bktidx = argStr.indexOf("]")) > 0) {
            CVSArgumentVector gArgs;
            String gArgStr = argStr.substring(1, bktidx).trim();
            argStr = argStr.substring(bktidx + 1).trim();
            if (gArgStr.length() > 0 && (gArgs = CVSArgumentVector.parseArgumentString(gArgStr)) != null && gArgs.size() > 0) {
                if (this.globalargs == null) {
                    this.globalargs = gArgs;
                } else {
                    this.globalargs.appendArguments(gArgs);
                }
            }
        }
        if ((args = CVSArgumentVector.parseArgumentString(argStr)) != null && args.size() > 0) {
            if (this.arguments == null) {
                this.arguments = args;
            } else {
                this.arguments.appendArguments(args);
            }
        }
    }

    public boolean parseControlString(String specification) {
        boolean result = true;
        String commandStr = null;
        String selectorStr = null;
        String requestStr = null;
        String responseStr = null;
        String argumentStr = null;
        StringTokenizer toker = new StringTokenizer(specification, ":");
        int tokenCount = toker.countTokens();
        if (tokenCount >= 4) {
            try {
                commandStr = toker.nextToken();
                selectorStr = toker.nextToken();
                requestStr = toker.nextToken();
                responseStr = toker.nextToken();
                argumentStr = toker.nextToken("");
                if (argumentStr != null) {
                    argumentStr = argumentStr.substring(1);
                }
            }
            catch (NoSuchElementException ex) {
                result = false;
            }
            if (result) {
                this.command = commandStr;
                int i = 0;
                while (i < selectorStr.length()) {
                    char selectCh = selectorStr.charAt(i);
                    this.entrySelector = CVSRequest.parseEntriesSelector(selectCh);
                    ++i;
                }
                i = 0;
                while (requestStr != null && i < requestStr.length()) {
                    char cmdChar = requestStr.charAt(i);
                    switch (cmdChar) {
                        case 'D': {
                            this.sendRootDirectory = false;
                            break;
                        }
                        case 'E': {
                            this.sendEntries = true;
                            break;
                        }
                        case 'S': {
                            this.sendEmptyMods = true;
                            break;
                        }
                        case 'U': {
                            this.sendModifieds = true;
                            break;
                        }
                        case 'A': {
                            this.sendArguments = true;
                            break;
                        }
                        case 'F': {
                            this.sendEntryFiles = true;
                            break;
                        }
                        case 'M': {
                            this.sendModule = true;
                            break;
                        }
                        case 'N': {
                            this.includeNotifies = false;
                            break;
                        }
                        case 'G': {
                            this.guaranteeMsg = true;
                            break;
                        }
                        case 'P': {
                            this.queueResponse = false;
                            break;
                        }
                        case 'R': {
                            this.redirectOutput = true;
                            break;
                        }
                        case 'V': {
                            this.verificationOnly = true;
                            break;
                        }
                        case 'X': {
                            this.execInCurDir = true;
                            break;
                        }
                        case 'O': {
                            this.traceRequest = true;
                            break;
                        }
                        case 'I': {
                            this.traceResponse = true;
                            break;
                        }
                        case 'T': {
                            this.traceTCPData = true;
                            break;
                        }
                        default: {
                            CVSLog.logMsg("While parsing CVSRequest '" + specification + "', found invalid request flag '" + cmdChar + "'");
                        }
                    }
                    ++i;
                }
                i = 0;
                while (responseStr != null && i < responseStr.length()) {
                    char cmdChar = responseStr.charAt(i);
                    switch (cmdChar) {
                        case 'c': {
                            this.handleCopyFile = true;
                            break;
                        }
                        case 'd': {
                            this.displayReponse = true;
                            break;
                        }
                        case 'e': {
                            this.handleEntries = true;
                            break;
                        }
                        case 'f': {
                            this.handleFlags = true;
                            break;
                        }
                        case 'i': {
                            this.ignoreResult = true;
                            break;
                        }
                        case 'm': {
                            this.handleMerged = true;
                            break;
                        }
                        case 'o': {
                            this.allowOverWrites = true;
                            break;
                        }
                        case 'u': {
                            this.handleUpdated = true;
                            break;
                        }
                        case 'k': {
                            this.saveTempFiles = true;
                            break;
                        }
                        case 't': {
                            this.traceProcessing = true;
                            break;
                        }
                        default: {
                            CVSLog.logMsg("While parsing CVSRequest '" + specification + "', found invalid response flag '" + cmdChar + "'");
                        }
                    }
                    ++i;
                }
                if (argumentStr != null) {
                    this.parseArgumentString(argumentStr);
                }
            }
        } else {
            result = false;
        }
        return result;
    }

    public String getVerifyFailReason() {
        return this.vfReason;
    }

    public void setVerifyFailReason(String reason) {
        this.vfReason = reason;
    }

    public boolean verifyRequest() {
        if (this.hostName == null) {
            this.setVerifyFailReason("hostname is null");
            return false;
        }
        if (this.repository == null) {
            this.setVerifyFailReason("repository name is null");
            return false;
        }
        if (this.rootDirectory == null) {
            this.setVerifyFailReason("root directory is null");
            return false;
        }
        if (this.localDirectory == null && (this.sendModifieds || this.handleMerged || this.handleUpdated || this.handleCopyFile)) {
            this.setVerifyFailReason("local directory is null");
            return false;
        }
        if (this.entries == null && (this.sendEntries || this.sendEntryFiles)) {
            this.setVerifyFailReason("entries list is null");
            return false;
        }
        if (this.sendArguments && this.arguments == null) {
            this.setVerifyFailReason("arguments list is null.");
            return false;
        }
        if (this.entrySelector < 0 || this.entrySelector > 12) {
            this.setVerifyFailReason("invalid entry selector");
            return false;
        }
        if (this.sendEntryFiles && this.sendModule) {
            this.setVerifyFailReason("can not send both 'files...' and 'module'");
            return false;
        }
        this.setVerifyFailReason("request is valid");
        return true;
    }

    public String toString() {
        return "CVSRequest: command=" + this.command;
    }
}

