/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jcvsii;

import com.ice.cvsc.CVSCUtilities;
import com.ice.cvsc.CVSEntry;
import com.ice.cvsc.CVSEntryVector;
import com.ice.cvsc.CVSTimestamp;
import com.ice.jcvsii.EntryRootNode;
import com.ice.jcvsii.EntryTreeModel;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class EntryNode
extends DefaultMutableTreeNode
implements CVSEntry.ChildEventListener {
    private static String tsFormatStr = null;
    private static SimpleDateFormat timeStampFormat = null;
    protected boolean hasLoaded;
    protected CVSEntry entry;
    protected String tsCache;

    public static void setTimestampFormat(String fmtStr) {
        tsFormatStr = fmtStr;
        if (tsFormatStr == null) {
            timeStampFormat = null;
        } else {
            SimpleDateFormat format = new SimpleDateFormat(fmtStr, Locale.US);
            format.setTimeZone(TimeZone.getDefault());
            timeStampFormat = format;
        }
    }

    public EntryNode(CVSEntry entry) {
        this.entry = entry;
        this.tsCache = null;
        this.hasLoaded = false;
        if (this.entry != null) {
            this.entry.addChildEventListener(this);
        }
    }

    public String toString() {
        EntryRootNode root = (EntryRootNode)this.getRoot();
        return "[EntryNode  hasLoaded=" + this.hasLoaded + " entry=" + this.entry + " entryPath='" + this.entry.getFullPathName() + "' localFile='" + CVSCUtilities.exportPath(root.getLocalRootPath()) + File.separator + CVSCUtilities.exportPath(this.entry.getFullPathName()) + "']";
    }

    public File getLocalFile() {
        EntryRootNode root = (EntryRootNode)this.getRoot();
        return new File(CVSCUtilities.exportPath(root.getLocalRootPath()), CVSCUtilities.exportPath(this.entry.getFullPathName()));
    }

    public String getEntryVersion() {
        return this.entry.getVersion();
    }

    public String getEntryTag() {
        return this.entry.getTag();
    }

    public void resetDisplayCaches() {
        this.tsCache = null;
        if (this.hasLoaded) {
            Enumeration<TreeNode> enumeration = this.children();
            while (enumeration.hasMoreElements()) {
                EntryNode node = (EntryNode)enumeration.nextElement();
                node.resetDisplayCaches();
            }
        }
    }

    public String getEntryTimestamp() {
        if (this.tsCache == null) {
            CVSTimestamp ts = this.entry.getCVSTime();
            if (ts != null) {
                this.tsCache = timeStampFormat.format(ts);
            }
            if (this.tsCache == null) {
                this.tsCache = this.entry.getTimestamp();
            }
        }
        return this.tsCache == null ? "" : this.tsCache;
    }

    public CVSEntry getEntry() {
        return this.entry;
    }

    public boolean isLeaf() {
        return !this.entry.isDirectory();
    }

    public boolean hasLoadedChildren() {
        return this.hasLoaded;
    }

    public int getChildCount() {
        if (!this.hasLoaded) {
            this.loadChildren();
        }
        return super.getChildCount();
    }

    protected void loadChildren() {
        if (!this.isLeaf()) {
            CVSEntryVector entries = this.entry.getEntryList();
            entries = this.sortEntryVector(entries);
            int i = 0;
            int sz = entries.size();
            while (i < sz) {
                this.insert(new EntryNode(entries.entryAt(i)), i);
                ++i;
            }
        }
        this.hasLoaded = true;
    }

    private CVSEntryVector sortEntryVector(CVSEntryVector entries) {
        Vector<CVSEntry> v = null;
        Vector dirV = new Vector();
        Vector<CVSEntry> fileV = new Vector<CVSEntry>();
        int i = 0;
        int sz = entries.size();
        while (i < sz) {
            CVSEntry entry = entries.entryAt(i);
            String entryName = entry.getName();
            boolean inserted = false;
            v = entry.isDirectory() ? dirV : fileV;
            int j = 0;
            int jsz = v.size();
            while (j < jsz) {
                CVSEntry jEntry = (CVSEntry)v.elementAt(j);
                if (entryName.compareTo(jEntry.getName()) < 0) {
                    v.insertElementAt(entry, j);
                    inserted = true;
                    break;
                }
                ++j;
            }
            if (!inserted) {
                v.addElement(entry);
            }
            ++i;
        }
        CVSEntryVector result = new CVSEntryVector();
        v = fileV;
        int i2 = 0;
        int sz2 = v.size();
        while (i2 < sz2) {
            CVSEntry entry = (CVSEntry)v.elementAt(i2);
            result.appendEntry(entry);
            ++i2;
        }
        v = dirV;
        int i3 = 0;
        int sz3 = v.size();
        while (i3 < sz3) {
            CVSEntry entry = (CVSEntry)v.elementAt(i3);
            result.appendEntry(entry);
            ++i3;
        }
        return result;
    }

    public void cvsEntryAddedChild(CVSEntry.ChildEvent event) {
        int idx = event.getChildIndex();
        EntryRootNode rootNode = (EntryRootNode)this.getRoot();
        EntryTreeModel model = (EntryTreeModel)rootNode.getEntryTree().getModel();
        CVSEntry entry = event.getChildEntry();
        EntryNode chNode = null;
        if (!this.hasLoaded) {
            this.loadChildren();
            chNode = (EntryNode)this.getChildAt(idx);
        } else {
            chNode = new EntryNode(entry);
            this.insert(chNode, idx);
        }
        model.fireEntryNodeInserted(this, idx, chNode);
    }

    public void cvsEntryRemovedChild(CVSEntry.ChildEvent event) {
        int idx = event.getChildIndex();
        EntryRootNode rootNode = (EntryRootNode)this.getRoot();
        EntryTreeModel model = (EntryTreeModel)rootNode.getEntryTree().getModel();
        if (idx == -1) {
            this.removeAllChildren();
            model.fireStructureChanged(this);
        } else {
            EntryNode remNode = null;
            CVSEntry remEntry = event.getChildEntry();
            if (!this.hasLoaded) {
                remNode = null;
                this.loadChildren();
            } else {
                int i = 0;
                int sz = this.getChildCount();
                while (i < sz) {
                    EntryNode node = (EntryNode)this.getChildAt(i);
                    if (remEntry.getName().equals(node.getEntry().getName())) {
                        idx = i;
                        remNode = node;
                        this.remove(i);
                        break;
                    }
                    ++i;
                }
            }
            if (remNode != null) {
                model.fireEntryNodeRemoved(this, idx, remNode);
            }
        }
    }
}

