/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jcvsii;

import com.ice.cvsc.CVSEntry;
import com.ice.cvsc.CVSEntryVector;
import com.ice.jcvsii.ColumnHeader;
import com.ice.jcvsii.Config;
import com.ice.jcvsii.EntryColumnModel;
import com.ice.jcvsii.EntryNode;
import com.ice.jcvsii.EntryRootNode;
import com.ice.jcvsii.EntryTree;
import com.ice.jcvsii.EntryTreeModel;
import com.ice.jcvsii.JAFUtilities;
import com.ice.pref.MenuPrefs;
import com.ice.pref.UserPrefs;
import com.ice.util.JFCUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Enumeration;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class EntryPanel
extends JPanel
implements ActionListener,
FocusListener,
PropertyChangeListener,
ColumnHeader.ResizeListener {
    private ColumnHeader entriesHeader;
    private EntryTree entriesTree;
    private EntryTreeModel entriesModel;
    private EntryColumnModel columnModel;
    private JScrollPane entriesScroller;
    private JPopupMenu dirPopup;
    private JPopupMenu filePopup;
    private ActionListener popupListener;
    private Border actBorder;
    private Border deActBorder;

    public EntryPanel(CVSEntry rootEntry, String localRoot, ActionListener popupListener) {
        this.setLayout(new GridBagLayout());
        EntryRootNode rootNode = new EntryRootNode(rootEntry, localRoot);
        this.columnModel = new EntryColumnModel();
        this.entriesModel = new EntryTreeModel(rootNode);
        this.entriesTree = new EntryTree(this.entriesModel, this.columnModel);
        UserPrefs prefs = Config.getPreferences();
        String lineStyle = prefs.getProperty("project.tree.linestyle", "Angled");
        this.entriesTree.putClientProperty("JTree.lineStyle", lineStyle);
        this.popupListener = popupListener;
        this.dirPopup = MenuPrefs.loadPopupMenu(prefs, "dirPopup", this);
        this.filePopup = MenuPrefs.loadPopupMenu(prefs, "filePopup", this);
        this.entriesTree.addMouseListener(new EntryPanelMouser());
        rootNode.setEntryTree(this.entriesTree);
        this.entriesHeader = new ColumnHeader(this.columnModel);
        this.entriesHeader.addResizeListener(this);
        this.actBorder = new CompoundBorder(new EtchedBorder(0), new LineBorder(Color.black, 1));
        this.deActBorder = new CompoundBorder(new EtchedBorder(0), new EmptyBorder(1, 1, 1, 1));
        this.entriesScroller = new JScrollPane(this.entriesTree);
        this.entriesScroller.setColumnHeaderView(this.entriesHeader);
        this.entriesScroller.setBorder(this.deActBorder);
        this.setLayout(new BorderLayout());
        this.add("Center", this.entriesScroller);
        this.entriesTree.addFocusListener(this);
        ToolTipManager.sharedInstance().registerComponent(this.entriesTree);
        prefs.addPropertyChangeListener("project.tree.font", this);
        prefs.addPropertyChangeListener("project.tree.linestyle", this);
        prefs.addPropertyChangeListener("project.modified.format", this);
    }

    public void loadPreferences(UserPrefs prefs) {
        int totalW = 0;
        Font f = prefs.getFont("project.tree.font", this.getFont());
        this.entriesTree.setFont(f);
        int w = prefs.getInteger("project.name.width", 275);
        this.columnModel.setNameWidth(w);
        totalW += w;
        w = prefs.getInteger("project.version.width", 50);
        this.columnModel.setVersionWidth(w);
        totalW += w;
        w = prefs.getInteger("project.tag.width", 50);
        this.columnModel.setTagWidth(w);
        totalW += w;
        w = prefs.getInteger("project.modified.width", 175);
        this.columnModel.setModifiedWidth(w);
        totalW += w;
        this.entriesTree.resetCachedSizes();
        this.entriesTree.revalidate();
        this.entriesHeader.revalidate();
        this.repaint();
    }

    public void savePreferences(UserPrefs prefs) {
        prefs.setInteger("project.name.width", this.columnModel.getNameWidth());
        prefs.setInteger("project.version.width", this.columnModel.getVersionWidth());
        prefs.setInteger("project.tag.width", this.columnModel.getTagWidth());
        prefs.setInteger("project.modified.width", this.columnModel.getModifiedWidth());
        Config.getPreferences().removePropertyChangeListener("project.tree.font", this);
        Config.getPreferences().removePropertyChangeListener("project.tree.linestyle", this);
        Config.getPreferences().removePropertyChangeListener("project.modified.format", this);
        ToolTipManager.sharedInstance().unregisterComponent(this.entriesTree);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        UserPrefs p = (UserPrefs)evt.getSource();
        if (propName.equals("project.tree.font")) {
            Font f = p.getFont("project.tree.font", this.entriesTree.getFont());
            this.entriesTree.setFont(f);
            this.entriesTree.revalidate();
            this.entriesTree.repaint();
        } else if (propName.equals("project.tree.linestyle")) {
            this.entriesTree.putClientProperty("JTree.lineStyle", evt.getNewValue());
            this.entriesTree.repaint();
        } else if (propName.equals("project.modified.format")) {
            this.entriesTree.resetDisplayCaches();
            this.entriesTree.repaint();
        }
    }

    public void focusGained(FocusEvent e) {
        this.entriesScroller.setBorder(this.actBorder);
    }

    public void focusLost(FocusEvent e) {
        this.entriesScroller.setBorder(this.deActBorder);
    }

    public void clearSelection() {
        this.entriesTree.clearSelection();
    }

    public void clearSelection(TreePath selPath) {
        this.entriesTree.removeSelectionPath(selPath);
    }

    public void selectAll() {
        this.selectAll(this.entriesModel.getEntryRootNode());
    }

    public void selectAll(EntryNode root) {
        int cnt = root.getChildCount();
        TreePath rootPath = new TreePath(root.getPath());
        this.entriesTree.expandPath(rootPath);
        Enumeration<TreeNode> enumeration = root.children();
        while (enumeration.hasMoreElements()) {
            EntryNode node = (EntryNode)enumeration.nextElement();
            if (node.isLeaf()) {
                TreePath path = new TreePath(node.getPath());
                this.entriesTree.addSelectionPath(path);
                continue;
            }
            this.selectAll(node);
        }
    }

    public void selectModified() {
        this.selectModified(this.entriesModel.getEntryRootNode());
    }

    public void selectModified(EntryNode root) {
        int cnt = root.getChildCount();
        Enumeration<TreeNode> enumeration = root.children();
        while (enumeration.hasMoreElements()) {
            EntryNode node = (EntryNode)enumeration.nextElement();
            if (node.isLeaf()) {
                CVSEntry entry = node.getEntry();
                if (!entry.isLocalFileModified(node.getLocalFile()) && !entry.isNewUserFile() && !entry.isToBeRemoved() && !entry.isInConflict()) continue;
                TreePath path = new TreePath(node.getPath());
                this.entriesTree.addSelectionPath(path);
                this.entriesTree.expandPath(path);
                continue;
            }
            this.selectModified(node);
        }
    }

    public void expandAll(boolean expand) {
        EntryRootNode root = this.entriesModel.getEntryRootNode();
        if (expand) {
            this.expandAll(root);
        } else {
            Enumeration<TreeNode> enumeration = root.depthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                EntryNode node = (EntryNode)enumeration.nextElement();
                if (node == root || node.isLeaf()) continue;
                this.entriesTree.collapsePath(new TreePath(node.getPath()));
            }
        }
    }

    public void expandAll(EntryNode root) {
        int cnt = root.getChildCount();
        Enumeration<TreeNode> enumeration = root.children();
        while (enumeration.hasMoreElements()) {
            EntryNode node = (EntryNode)enumeration.nextElement();
            if (node.isLeaf()) continue;
            this.entriesTree.expandPath(new TreePath(node.getPath()));
            this.expandAll(node);
        }
    }

    public void actionPerformed(ActionEvent event) {
        TreePath[] selPaths;
        Object source = event.getSource();
        String command = event.getActionCommand();
        if (source instanceof JMenuItem && this.popupListener != null && (selPaths = this.getSelectionPaths()) != null && selPaths.length > 0) {
            EntryNode node = (EntryNode)selPaths[0].getLastPathComponent();
            char selectCh = command.charAt(0);
            command = command.substring(2);
            CVSEntryVector vector = new CVSEntryVector();
            if (selectCh == 'L') {
                node.getEntry().addFileEntries(vector);
            } else if (selectCh == 'R') {
                node.getEntry().addAllSubTreeEntries(vector);
            } else if (selectCh == 'X') {
                vector.addElement(node.getEntry());
                node.getEntry().addFileEntries(vector);
            } else if (selectCh == 'Z') {
                vector.addElement(node.getEntry());
                node.getEntry().addAllSubTreeEntries(vector);
            } else {
                vector.addElement(node.getEntry());
            }
            if (this.popupListener != null) {
                ActionEvent aEvent = new ActionEvent(vector, 1001, "POPUP:" + command);
                this.popupListener.actionPerformed(aEvent);
            }
        }
    }

    public void columnHeadersNeedUpdate(ColumnHeader.ResizeEvent event) {
        this.entriesTree.revalidate();
        this.entriesTree.repaint();
    }

    public void columnHeadersResized(ColumnHeader.ResizeEvent event) {
        this.entriesTree.resetCachedSizes();
        this.entriesTree.revalidate();
    }

    public void setRoot(TreeNode root) {
        this.entriesModel.setRoot(root);
    }

    public EntryRootNode getRootNode() {
        return this.entriesModel.getEntryRootNode();
    }

    public TreePath[] getSelectionPaths() {
        return this.entriesTree.getSelectionPaths();
    }

    public void setTreeEntries(CVSEntry root) {
        this.setRoot(new EntryNode(root));
        this.entriesTree.repaint(500L);
    }

    private EntryNode getSelectedNode() {
        EntryNode result = null;
        TreePath path = this.entriesTree.getSelectionPath();
        if (path != null) {
            Object obj = path.getLastPathComponent();
            result = (EntryNode)obj;
        }
        return result;
    }

    private EntryNode[] getSelectedNodes() {
        TreePath[] paths = this.entriesTree.getSelectionPaths();
        if (paths == null) {
            paths = new TreePath[]{};
        }
        EntryNode[] result = new EntryNode[paths.length];
        int i = 0;
        while (i < paths.length) {
            result[i] = (EntryNode)paths[i].getLastPathComponent();
            ++i;
        }
        return result;
    }

    private class EntryPanelMouser
    extends MouseAdapter {
        private boolean isPopupClick = false;

        public void mousePressed(MouseEvent event) {
            this.isPopupClick = false;
            if (event.isPopupTrigger()) {
                int selRow = EntryPanel.this.entriesTree.getRowForLocation(event.getX(), event.getY());
                this.isPopupClick = true;
                if (selRow != -1) {
                    EntryPanel.this.entriesTree.setSelectionRow(selRow);
                    JPopupMenu popup = EntryPanel.this.getSelectedNode().isLeaf() ? EntryPanel.this.filePopup : EntryPanel.this.dirPopup;
                    Point pt = JFCUtilities.computePopupLocation(event, (Component)event.getSource(), popup);
                    popup.show(EntryPanel.this.entriesTree, pt.x, pt.y);
                }
            }
        }

        public void mouseReleased(MouseEvent event) {
            if (this.isPopupClick) {
                return;
            }
            if (event.isPopupTrigger()) {
                int selRow = EntryPanel.this.entriesTree.getRowForLocation(event.getX(), event.getY());
                this.isPopupClick = true;
                if (selRow != -1) {
                    EntryPanel.this.entriesTree.setSelectionRow(selRow);
                    JPopupMenu popup = EntryPanel.this.getSelectedNode().isLeaf() ? EntryPanel.this.filePopup : EntryPanel.this.dirPopup;
                    Point pt = JFCUtilities.computePopupLocation(event, (Component)event.getSource(), popup);
                    popup.show(EntryPanel.this.entriesTree, pt.x, pt.y);
                }
            }
        }

        public void mouseClicked(MouseEvent event) {
            if (this.isPopupClick) {
                this.isPopupClick = false;
                return;
            }
            if (event.getClickCount() == 2) {
                this.processDoubleClick();
            }
        }

        private void processDoubleClick() {
            EntryNode node = EntryPanel.this.getSelectedNode();
            if (node == null) {
                return;
            }
            if (!node.isLeaf()) {
                return;
            }
            File selF = node.getLocalFile();
            String verb = Config.getPreferences().getProperty("project.tree.doubleClickVerb", "open");
            JAFUtilities.openFile(node.getEntry().getName(), selF, verb);
        }
    }
}

