/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jcvsii;

import com.ice.jcvsii.EntryColumnModel;
import com.ice.jcvsii.EntryTreeModel;
import com.ice.jcvsii.EntryTreeRenderer;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JTree;

public class EntryTree
extends JTree {
    protected EntryTreeRenderer renderer;

    public EntryTree(EntryTreeModel model) {
        this(model, new EntryColumnModel());
    }

    public EntryTree(EntryTreeModel model, EntryColumnModel columnModel) {
        super(model);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setScrollsOnExpand(false);
        this.setRowHeight(18);
        this.renderer = new EntryTreeRenderer(model.getEntryRootNode().getLocalRootPath(), columnModel);
        this.setCellRenderer(this.renderer);
    }

    public Dimension getPreferredSize() {
        Dimension sz = super.getPreferredSize();
        sz.width = this.renderer.getPreferredSize().width + 3;
        return sz;
    }

    public void resetCachedSizes() {
        int h = this.getRowHeight();
        this.setRowHeight(h - 1);
        this.setRowHeight(h);
    }

    public void resetDisplayCaches() {
        EntryTreeModel model = (EntryTreeModel)this.getModel();
        model.getEntryRootNode().resetDisplayCaches();
    }

    public void setFont(Font f) {
        super.setFont(f);
        int h = f.getSize() + 5;
        if (h < 18) {
            h = 18;
        }
        this.setRowHeight(h);
    }

    public int getNameWidth() {
        return this.renderer.getNameWidth();
    }

    public void setNameWidth(int w) {
        this.renderer.setNameWidth(w);
        Dimension sz = this.renderer.getPreferredSize();
        this.setSize(new Dimension(sz.width, this.getSize().height));
    }

    public int getVersionWidth() {
        return this.renderer.getVersionWidth();
    }

    public void setVersionWidth(int w) {
        this.renderer.setVersionWidth(w);
        Dimension sz = this.renderer.getPreferredSize();
        this.setSize(new Dimension(sz.width, this.getSize().height));
    }

    public int getTagWidth() {
        return this.renderer.getTagWidth();
    }

    public void setTagWidth(int w) {
        this.renderer.setTagWidth(w);
        Dimension sz = this.renderer.getPreferredSize();
        this.setSize(new Dimension(sz.width, this.getSize().height));
    }

    public int getModifiedWidth() {
        return this.renderer.getModifiedWidth();
    }

    public void setModifiedWidth(int w) {
        this.renderer.setModifiedWidth(w);
        Dimension sz = this.renderer.getPreferredSize();
        this.setSize(new Dimension(sz.width, this.getSize().height));
    }
}

