/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jcvsii;

import com.ice.cvsc.CVSCUtilities;
import com.ice.cvsc.CVSEntry;
import com.ice.cvsc.CVSLog;
import com.ice.cvsc.CVSTracer;
import com.ice.jcvsii.EntryColumnModel;
import com.ice.jcvsii.EntryNode;
import com.ice.util.AWTUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;

public class EntryTreeRenderer
extends JComponent
implements TreeCellRenderer {
    protected EntryColumnModel model;
    protected String localRoot;
    protected boolean isLeaf;
    protected boolean isExpanded;
    protected boolean isSelected;
    protected boolean hasFocus;
    protected boolean hasTreeFocus;
    protected int iconWidth;
    protected int iconHeight;
    protected int nameOffset = 2;
    protected int handleIndent = 8;
    protected Icon icon;
    protected CVSEntry entry;
    protected EntryNode node;
    protected Icon openFolder;
    protected Icon closedFolder;
    protected Icon addedFile;
    protected Icon conflictFile;
    protected Icon conModFile;
    protected Icon lostFile;
    protected Icon removedFile;
    protected Icon modifiedFile;
    protected Icon unchangedFile;

    public EntryTreeRenderer(String localRoot, EntryColumnModel columnModel) {
        this.model = columnModel;
        this.handleIndent = 8;
        this.loadIconImages();
        this.setPreferredSize(new Dimension(500, 18));
        this.localRoot = localRoot;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.isLeaf = leaf;
        this.isExpanded = expanded;
        this.isSelected = selected;
        this.hasFocus = hasFocus;
        this.hasTreeFocus = tree.hasFocus();
        this.node = (EntryNode)value;
        this.entry = this.node.getEntry();
        if (leaf) {
            this.setIcon(this.determineIcon(this.entry));
            this.setToolTipText(this.entry.getName());
        } else {
            this.setIcon(expanded ? this.openFolder : this.closedFolder);
            this.setToolTipText(null);
        }
        return this;
    }

    public String getLocalRoot() {
        return this.localRoot;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public int getHandleIndent() {
        return this.handleIndent;
    }

    public void setHandleIndent(int indent) {
        this.handleIndent = indent;
    }

    public CVSEntry getEntry() {
        return this.entry;
    }

    public void setEntry(CVSEntry entry) {
        this.entry = entry;
    }

    public int getNameWidth() {
        return this.model.getNameWidth();
    }

    public void setNameWidth(int w) {
        this.model.setNameWidth(w);
    }

    public int getVersionWidth() {
        return this.model.getVersionWidth();
    }

    public void setVersionWidth(int w) {
        this.model.setVersionWidth(w);
    }

    public int getTagWidth() {
        return this.model.getTagWidth();
    }

    public void setTagWidth(int w) {
        this.model.setTagWidth(w);
    }

    public int getModifiedWidth() {
        return this.model.getModifiedWidth();
    }

    public void setModifiedWidth(int w) {
        this.model.setModifiedWidth(w);
    }

    public Dimension getPreferredSize() {
        Insets ins = this.getInsets();
        int w = this.getNameWidth() + this.getVersionWidth() + this.getTagWidth() + this.getModifiedWidth() + ins.left + ins.right;
        return new Dimension(w, 18);
    }

    public void paint(Graphics g) {
        int w;
        int textY;
        int textX;
        int tl;
        String text = null;
        Insets ins = this.getInsets();
        FontMetrics fm = g.getFontMetrics();
        Shape saveClip = g.getClip();
        Rectangle clipBounds = g.getClipBounds();
        Rectangle bounds = this.getBounds();
        int fAscent = fm.getAscent();
        int fHeight = fm.getHeight();
        int insH = ins.left + ins.right;
        int insV = ins.top + ins.bottom;
        int width = bounds.width - insH;
        int height = bounds.height - insV;
        int baseLine = ins.top + (height - fHeight + 1) / 2 + fAscent;
        Rectangle iconR = new Rectangle(ins.left, ins.top, 2, height);
        if (this.icon != null) {
            int iconH = this.icon.getIconHeight();
            iconR.y = iconH <= baseLine - ins.top ? baseLine - iconH : ins.top + (bounds.height - iconH) / 2;
            iconR.width = this.iconWidth;
        }
        int nameW = this.getNameWidth() - (bounds.x + ins.left + this.handleIndent);
        Rectangle nameR = new Rectangle(iconR.x + iconR.width, ins.top, nameW, height);
        if (this.icon != null && (tl = iconR.x + this.nameOffset + this.icon.getIconWidth()) > nameR.x) {
            nameR.x = tl;
        }
        Rectangle versR = new Rectangle(nameR.x + nameR.width, ins.top, this.getVersionWidth(), height);
        Rectangle tagR = new Rectangle(versR.x + versR.width, ins.top, this.getTagWidth(), height);
        Rectangle modfR = new Rectangle(tagR.x + tagR.width, ins.top, this.getModifiedWidth(), height);
        g.setFont(this.getFont());
        if (this.icon != null) {
            this.icon.paintIcon(this, g, iconR.x, iconR.y);
        }
        if ((text = this.entry.getName()) != null) {
            textX = nameR.x + 1;
            textY = nameR.y + baseLine;
            g.setClip(nameR.intersection(clipBounds));
            if (this.isSelected) {
                w = fm.stringWidth(text) + 3;
                Rectangle hiR = new Rectangle(nameR.x, textY - fAscent, w, fHeight);
                g.setColor(Color.lightGray);
                g.fillRect(hiR.x, hiR.y, hiR.width, hiR.height);
                if (this.hasFocus) {
                    g.setColor(Color.gray);
                    g.drawRect(hiR.x, hiR.y, hiR.width, hiR.height);
                }
            }
            g.setColor(Color.black);
            g.drawString(text, textX, textY);
        }
        if (this.isLeaf) {
            int y;
            int x2;
            text = this.node.getEntryVersion();
            if (text != null) {
                g.setClip(versR.intersection(clipBounds));
                textX = versR.x + 1;
                textY = versR.y + baseLine;
                g.setColor(Color.black);
                g.drawString(text, textX, textY);
                if (this.isSelected && this.hasFocus) {
                    w = fm.stringWidth(text) + 1;
                    int x1 = versR.x;
                    x2 = versR.x + w;
                    y = textY + 1;
                    g.setColor(Color.gray);
                    g.drawLine(x1, y, x2, y);
                }
            }
            if ((text = this.node.getEntryTag()) != null) {
                g.setClip(tagR.intersection(clipBounds));
                textX = tagR.x + 1;
                textY = tagR.y + baseLine;
                g.setColor(Color.black);
                g.drawString(text, textX, textY);
                if (this.isSelected && this.hasFocus) {
                    w = fm.stringWidth(text) + 1;
                    int x1 = tagR.x;
                    x2 = tagR.x + w;
                    y = textY + 1;
                    g.setColor(Color.gray);
                    g.drawLine(x1, y, x2, y);
                }
            }
            if ((text = this.node.getEntryTimestamp()) != null) {
                g.setClip(modfR.intersection(clipBounds));
                textX = modfR.x + 1;
                textY = modfR.y + baseLine;
                g.setColor(Color.black);
                g.drawString(text, textX, textY);
                if (this.isSelected && this.hasFocus) {
                    w = fm.stringWidth(text) + 1;
                    int x1 = modfR.x;
                    x2 = modfR.x + w;
                    y = textY + 1;
                    g.setColor(Color.gray);
                    g.drawLine(x1, y, x2, y);
                }
            }
        }
        g.setClip(saveClip);
    }

    private Icon determineIcon(CVSEntry entry) {
        String path = this.localRoot + File.separator + this.entry.getFullName();
        File eFile = new File(CVSCUtilities.exportPath(path));
        if (entry.isToBeRemoved()) {
            return this.removedFile;
        }
        if (entry.isNewUserFile()) {
            return this.addedFile;
        }
        if (!eFile.exists()) {
            return this.lostFile;
        }
        if (entry.isInConflict()) {
            return this.conflictFile;
        }
        if (entry.isLocalFileModified(eFile)) {
            return this.modifiedFile;
        }
        return this.unchangedFile;
    }

    public void loadIconImages() {
        Image image = null;
        Vector<String> names = new Vector<String>();
        Hashtable<String, Image> iconTable = new Hashtable<String, Image>();
        names.addElement("openFolder");
        names.addElement("closedFolder");
        names.addElement("unchangedFile");
        names.addElement("modifiedFile");
        names.addElement("removedFile");
        names.addElement("lostFile");
        names.addElement("addedFile");
        names.addElement("conflictFile");
        names.addElement("conModFile");
        Toolkit tk = this.getToolkit();
        int maxWidth = 0;
        int maxHeight = 0;
        MediaTracker tracker = new MediaTracker(this);
        int i = 0;
        while (i < names.size()) {
            String iconName = (String)names.elementAt(i);
            String imageURLName = "/com/ice/jcvsii/images/icons/" + iconName + ".gif";
            try {
                image = AWTUtilities.getImageResource(imageURLName);
            }
            catch (IOException ex) {
                image = null;
                CVSLog.logMsg("EntryTreeRenderer.loadIconImages: IO error loading icon '" + iconName + "', " + ex.getMessage());
            }
            if (image != null) {
                tracker.addImage(image, 0);
                iconTable.put(iconName, image);
            } else {
                CVSTracer.traceIf(true, "EntryTreeRenderer.loadIconImages: ERROR icon '" + iconName + " failed to load " + "from URL '" + imageURLName + "'");
            }
            ++i;
        }
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException ex) {
            CVSTracer.traceWithStack("EntryTreeRenderer.loadIconImages: media tracker interrupted!\n   " + ex.getMessage());
        }
        Enumeration enumeration = iconTable.elements();
        while (enumeration.hasMoreElements()) {
            image = (Image)enumeration.nextElement();
            int width = image.getWidth(null);
            int height = image.getHeight(null);
            if (width < 0 || height < 0) {
                CVSTracer.traceWithStack("EntryTreeRenderer.loadIconImages: NEGATIVE DIMENSION:  Width " + width + " Height " + height);
                continue;
            }
            if (width > maxWidth) {
                maxWidth = width;
            }
            if (height <= maxHeight) continue;
            maxHeight = height;
        }
        this.iconWidth = maxWidth;
        this.iconHeight = maxHeight;
        this.openFolder = new ImageIcon((Image)iconTable.get("openFolder"));
        this.closedFolder = new ImageIcon((Image)iconTable.get("closedFolder"));
        this.addedFile = new ImageIcon((Image)iconTable.get("addedFile"));
        this.conflictFile = new ImageIcon((Image)iconTable.get("conflictFile"));
        this.conModFile = new ImageIcon((Image)iconTable.get("conModFile"));
        this.lostFile = new ImageIcon((Image)iconTable.get("lostFile"));
        this.removedFile = new ImageIcon((Image)iconTable.get("removedFile"));
        this.modifiedFile = new ImageIcon((Image)iconTable.get("modifiedFile"));
        this.unchangedFile = new ImageIcon((Image)iconTable.get("unchangedFile"));
    }
}

