/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jcvsii;

import com.ice.jcvsii.Config;
import com.ice.jcvsii.ResourceMgr;
import com.ice.pref.UserPrefs;
import com.ice.util.AWTUtilities;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class MessageDialog
extends JDialog
implements ActionListener {
    private String messageString = null;
    private JTextArea messageText;

    public MessageDialog(Frame parent, boolean modal, String prompt) {
        super(parent, "Message Argument", modal);
        this.establishDialogContents(prompt);
        Dimension sz = this.getPreferredSize();
        if (sz.width < 360) {
            sz.width = 360;
        }
        if (sz.height < 240) {
            sz.height = 240;
        }
        this.setSize(sz);
        Point location = AWTUtilities.centerDialogInParent(this, parent);
        this.setLocation(location.x, location.y);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent evt) {
                MessageDialog.this.messageText.requestFocus();
            }
        });
    }

    public String getMessage() {
        return this.messageString;
    }

    public void actionPerformed(ActionEvent evt) {
        String command = evt.getActionCommand();
        if (command.compareTo("OK") == 0) {
            this.messageString = this.messageText.getText();
        } else if (command.compareTo("CANCEL") == 0) {
            this.messageString = null;
        }
        this.dispose();
    }

    public void establishDialogContents(String prompt) {
        UserPrefs prefs = Config.getPreferences();
        ResourceMgr rmgr = ResourceMgr.getInstance();
        JLabel promptLabel = new JLabel(prompt);
        promptLabel.setBorder(new EmptyBorder(2, 2, 0, 0));
        promptLabel.setFont(prefs.getFont("messageDialog.prompt.font", new Font("Dialog", 1, 14)));
        this.messageText = new JTextArea();
        this.messageText.setMargin(new Insets(4, 4, 4, 4));
        this.messageText.setEditable(true);
        this.messageText.setFont(prefs.getFont("messageDialog.text.font", new Font("Serif", 0, 14)));
        JScrollPane scroller = new JScrollPane(this.messageText);
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new GridLayout(1, 2, 20, 20));
        JButton button = new JButton(rmgr.getUIString("name.for.ok"));
        button.addActionListener(this);
        button.setActionCommand("OK");
        controlPanel.add(button);
        button = new JButton(rmgr.getUIString("name.for.cancel"));
        button.addActionListener(this);
        button.setActionCommand("CANCEL");
        controlPanel.add(button);
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        JPanel contPan = new JPanel();
        contPan.setLayout(new BorderLayout(2, 2));
        contPan.setBorder(new EmptyBorder(3, 5, 5, 5));
        content.add("Center", contPan);
        JPanel southPan = new JPanel();
        southPan.setLayout(new BorderLayout());
        southPan.add("East", controlPanel);
        southPan.setBorder(new EmptyBorder(8, 0, 5, 0));
        contPan.add("North", promptLabel);
        contPan.add("Center", scroller);
        contPan.add("South", southPan);
    }
}

