/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jcvsii;

import com.ice.jcvsii.Config;
import com.ice.jcvsii.ResourceMgr;
import com.ice.pref.UserPrefs;
import com.ice.util.AWTUtilities;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

public class PasswordDialog
extends JDialog
implements ActionListener {
    private String userName;
    private String password;
    private JTextField userNameField;
    private JPasswordField passwordField;

    public PasswordDialog(Frame parent, String userName) {
        super(parent, "Login Information", true);
        this.userName = userName;
        this.establishDialogContents(userName);
        this.pack();
        Dimension sz = this.getSize();
        Point location = AWTUtilities.computeDialogLocation(this, sz.width, sz.height);
        this.setLocation(location.x, location.y);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                PasswordDialog.this.passwordField.requestFocus();
            }
        });
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void actionPerformed(ActionEvent event) {
        boolean doDispose = true;
        String command = event.getActionCommand();
        if (event.getSource() == this.passwordField) {
            this.userName = this.userNameField.getText();
            this.password = new String(this.passwordField.getPassword());
        } else if (event.getSource() == this.userNameField) {
            this.passwordField.requestFocus();
            this.passwordField.selectAll();
            doDispose = false;
        } else if (command.compareTo("OK") == 0) {
            this.userName = this.userNameField.getText();
            this.password = new String(this.passwordField.getPassword());
        } else if (command.compareTo("CANCEL") == 0) {
            this.userName = null;
            this.password = null;
        }
        if (doDispose) {
            this.dispose();
        }
    }

    public void establishDialogContents(String userName) {
        UserPrefs prefs = Config.getPreferences();
        ResourceMgr rmgr = ResourceMgr.getInstance();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        mainPanel.setBorder(new CompoundBorder(new EtchedBorder(1), new EmptyBorder(3, 3, 3, 3)));
        Font lblFont = prefs.getFont("passwordDialog.label.font", new Font("Dialog", 1, 14));
        JLabel label = new JLabel(rmgr.getUIString("name.for.user.name"));
        label.setFont(lblFont);
        AWTUtilities.constrain(mainPanel, label, 0, 17, 0, 0, 1, 1, 1.0, 1.0, new Insets(1, 3, 1, 5));
        this.userNameField = new JTextField(16);
        this.userNameField.setEditable(true);
        if (userName != null) {
            this.userNameField.setText(userName);
        }
        this.userNameField.addActionListener(this);
        AWTUtilities.constrain(mainPanel, this.userNameField, 0, 17, 1, 0, 1, 1, 1.0, 1.0, new Insets(10, 1, 5, 1));
        label = new JLabel(rmgr.getUIString("name.for.user.pass"));
        label.setFont(lblFont);
        AWTUtilities.constrain(mainPanel, label, 0, 17, 0, 1, 1, 1, 1.0, 1.0, new Insets(1, 3, 1, 5));
        this.passwordField = new JPasswordField(16);
        this.passwordField.setEditable(true);
        this.passwordField.setEchoChar('*');
        this.passwordField.addActionListener(this);
        AWTUtilities.constrain(mainPanel, this.passwordField, 0, 17, 1, 1, 1, 1, 1.0, 1.0, new Insets(5, 1, 10, 1));
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new GridLayout(1, 2, 5, 5));
        JButton button = new JButton(rmgr.getUIString("name.for.ok"));
        button.addActionListener(this);
        button.setActionCommand("OK");
        controlPanel.add(button);
        button = new JButton(rmgr.getUIString("name.for.cancel"));
        button.addActionListener(this);
        button.setActionCommand("CANCEL");
        controlPanel.add(button);
        JPanel southPan = new JPanel();
        southPan.setLayout(new BorderLayout());
        southPan.add("East", controlPanel);
        southPan.setBorder(new EmptyBorder(12, 0, 2, 0));
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        JPanel contPan = new JPanel();
        contPan.setLayout(new BorderLayout(2, 2));
        contPan.setBorder(new EmptyBorder(3, 5, 5, 5));
        content.add("Center", contPan);
        contPan.add("Center", mainPanel);
        contPan.add("South", southPan);
    }
}

