/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jcvsii;

import com.ice.cvsc.CVSLog;
import com.ice.jcvsii.ProjectFrame;
import java.util.Enumeration;
import java.util.Hashtable;

public class ProjectFrameMgr {
    private static boolean debug = false;
    private static Hashtable frames = new Hashtable();

    public static void addProject(ProjectFrame frame, String localRootPath) {
        if (debug) {
            CVSLog.logMsgStderr("PROJECT_FRAME_MGR: ADD: " + localRootPath);
        }
        frames.put(localRootPath, frame);
    }

    public static void removeProject(ProjectFrame frame, String localRootPath) {
        if (debug) {
            CVSLog.logMsgStderr("PROJECT_FRAME_MGR: REMOVE: " + localRootPath);
        }
        Enumeration keys = frames.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            ProjectFrame frm = (ProjectFrame)frames.get(key);
            if (frm != frame) continue;
            if (debug) {
                CVSLog.logMsgStderr("PROJECT_FRAME_MGR: REMOVE: Matched " + key);
            }
            frames.remove(key);
            break;
        }
    }

    public static boolean checkProjectOpen(String localRootPath) {
        ProjectFrame frame;
        if (debug) {
            CVSLog.logMsgStderr("PROJECT_FRAME_MGR: CHECK: " + localRootPath);
        }
        if ((frame = (ProjectFrame)frames.get(localRootPath)) != null && frame.isShowing()) {
            frame.toFront();
            frame.requestFocus();
        }
        return frame != null;
    }

    public static Enumeration enumerateProjectFrames() {
        return frames.elements();
    }

    public static void closeAllProjects() {
        Enumeration enumeration = frames.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (debug) {
                CVSLog.logMsgStderr("PROJECT_FRAME_MGR: CLOSE: " + key);
            }
            ProjectFrame frame = (ProjectFrame)frames.get(key);
            frame.dispose();
        }
    }
}

