/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jcvsii;

import com.ice.cvsc.CVSArgumentVector;
import com.ice.cvsc.CVSClient;
import com.ice.cvsc.CVSEntryVector;
import com.ice.cvsc.CVSRequest;
import com.ice.cvsc.CVSResponse;
import com.ice.cvsc.CVSScramble;
import com.ice.cvsc.CVSTracer;
import com.ice.cvsc.CVSUserInterface;
import com.ice.jcvsii.CVSThread;
import com.ice.jcvsii.CVSUtilities;
import com.ice.jcvsii.Config;
import com.ice.jcvsii.ConnectInfoPanel;
import com.ice.jcvsii.MainPanel;
import com.ice.jcvsii.MainTabPanel;
import com.ice.pref.UserPrefs;
import com.ice.util.AWTUtilities;
import java.awt.Color;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class TestConnectPanel
extends MainTabPanel
implements ActionListener,
CVSUserInterface {
    protected ConnectInfoPanel info;
    protected CVSClient client;
    protected CVSRequest request;
    protected JTextField argumentsText;
    protected JTextField exportDirText;
    protected JTextArea outputText;
    protected JLabel feedback;
    protected JButton actionButton;

    public TestConnectPanel(MainPanel parent) {
        super(parent);
        this.establishContents();
    }

    public void loadPreferences() {
        this.info.loadPreferences("testconn");
    }

    public void savePreferences() {
        this.info.savePreferences("testconn");
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equalsIgnoreCase("TESTCONN")) {
            this.performTest();
        } else if (command.equalsIgnoreCase("CANCEL")) {
            this.cancelTest();
        }
    }

    private void cancelTest() {
        this.client.setCanceled(true);
    }

    private void performTest() {
        Config cfg = Config.getInstance();
        UserPrefs prefs = cfg.getPreferences();
        Point location = this.getLocationOnScreen();
        String userName = this.info.getUserName();
        String passWord = this.info.getPassword();
        String hostname = this.info.getServer();
        String rootDirectory = this.info.getRepository();
        boolean isPServer = this.info.isPServer();
        int connMethod = this.info.getConnectionMethod();
        int cvsPort = CVSUtilities.computePortNum(hostname, connMethod, isPServer);
        if (hostname.length() < 1 || rootDirectory.length() < 1) {
            JOptionPane.showMessageDialog((Frame)this.getTopLevelAncestor(), "The connection test requires that the " + (hostname.length() < 1 ? "cvs server hostname" : "cvs repository") + " be specified.", "Notice", 0);
            return;
        }
        if (userName.length() < 1 && (connMethod == 2 || connMethod == 3)) {
            JOptionPane.showMessageDialog((Frame)this.getTopLevelAncestor(), "You must enter a user name for 'rsh' connections.", "Error", 0);
            return;
        }
        this.getMainPanel().setAllTabsEnabled(false);
        this.client = CVSUtilities.createCVSClient(hostname, cvsPort);
        this.request = new CVSRequest();
        this.request.setPServer(isPServer);
        this.request.setUserName(userName);
        this.request.setHostName(this.client.getHostName());
        if (isPServer) {
            String scrambled = CVSScramble.scramblePassword(new String(passWord), 'A');
            this.request.setPassword(scrambled);
        } else if (connMethod == 3) {
            this.request.setPassword(passWord);
        }
        this.request.setConnectionMethod(connMethod);
        this.request.setServerCommand(CVSUtilities.establishServerCommand(hostname, connMethod, isPServer));
        if (connMethod == 2) {
            CVSUtilities.establishRSHProcess(this.request);
        }
        this.request.setPort(this.client.getPort());
        this.request.setRepository("");
        this.request.setRootDirectory(rootDirectory);
        this.request.setRootRepository(rootDirectory);
        this.request.setLocalDirectory("");
        this.request.setCommand("noop");
        this.request.includeNotifies = false;
        this.request.execInCurDir = true;
        this.request.setDirEntry(null);
        this.request.traceRequest = true;
        this.request.traceResponse = true;
        this.request.traceProcessing = true;
        this.request.traceTCPData = true;
        this.request.allowGzipFileMode = prefs.getBoolean("global.allowGzipFileMode", true);
        this.request.setGzipStreamLevel(prefs.getInteger("global.gzipStreamLevel", 0));
        if (connMethod == 3) {
            this.request.setGzipStreamLevel(0);
            this.request.allowGzipFileMode = false;
        }
        this.request.setEntries(new CVSEntryVector());
        this.request.setArguments(new CVSArgumentVector());
        this.request.setUserInterface(this);
        this.setWaitCursor();
        StringBuffer outputBuf = new StringBuffer();
        CVSTracer.accumulateInBuffer(outputBuf);
        CVSTracer.setEchoAccumulation(true);
        CVSResponse response = new CVSResponse();
        TestConnectPanel testConnectPanel = this;
        testConnectPanel.getClass();
        MyRunner myRunner = testConnectPanel.new MyRunner(this.client, this.request, response);
        TestConnectPanel testConnectPanel2 = this;
        testConnectPanel2.getClass();
        CVSThread thread = new CVSThread("TestConnect", (Runnable)myRunner, testConnectPanel2.new MyMonitor(this.request, response, outputBuf));
        thread.start();
    }

    public void uiDisplayProgressMsg(String message) {
        this.feedback.setText(message);
        this.feedback.repaint(0L);
    }

    public void uiDisplayProgramError(String error) {
    }

    public void uiDisplayResponse(CVSResponse response) {
    }

    private void establishContents() {
        this.setLayout(new GridBagLayout());
        this.info = new ConnectInfoPanel("test");
        this.info.setPServerMode(true);
        this.info.setUsePassword(true);
        int row = 0;
        AWTUtilities.constrain(this, this.info, 2, 17, 0, row++, 1, 1, 1.0, 0.0);
        this.actionButton = new JButton("Perform Test");
        this.actionButton.setActionCommand("TESTCONN");
        this.actionButton.addActionListener(this);
        AWTUtilities.constrain(this, this.actionButton, 0, 10, 0, row++, 1, 1, 0.0, 0.0, new Insets(5, 5, 5, 5));
        this.feedback = new JLabel("Ready.");
        this.feedback.setOpaque(true);
        this.feedback.setBackground(Color.white);
        this.feedback.setBorder(new CompoundBorder(new LineBorder(Color.darkGray), new EmptyBorder(1, 3, 1, 3)));
        AWTUtilities.constrain(this, this.feedback, 2, 10, 0, row++, 1, 1, 1.0, 0.0, new Insets(4, 0, 3, 0));
        this.outputText = new JTextArea(){

            public boolean isFocusTraversable() {
                return false;
            }
        };
        this.outputText.setEditable(false);
        JScrollPane scroller = new JScrollPane(this.outputText);
        scroller.setVerticalScrollBarPolicy(22);
        AWTUtilities.constrain(this, scroller, 1, 10, 0, row++, 1, 1, 1.0, 1.0);
    }

    private class MyMonitor
    implements CVSThread.Monitor {
        private StringBuffer buf;
        private CVSRequest request;
        private CVSResponse response;

        public MyMonitor(CVSRequest request, CVSResponse response, StringBuffer buf) {
            this.buf = buf;
            this.request = request;
            this.response = response;
        }

        public void threadStarted() {
            TestConnectPanel.this.actionButton.setText("Cancel Test");
            TestConnectPanel.this.actionButton.setActionCommand("CANCEL");
        }

        public void threadCanceled() {
        }

        public void threadFinished() {
            CVSTracer.turnOffAccumulation();
            TestConnectPanel.this.actionButton.setText("Perform Test");
            TestConnectPanel.this.actionButton.setActionCommand("TESTCONN");
            if (this.response.getStatus() == 0) {
                TestConnectPanel.this.uiDisplayProgressMsg("The test was completed successfully.");
            } else {
                TestConnectPanel.this.uiDisplayProgressMsg("The test encountered an error.");
            }
            TestConnectPanel.this.outputText.setText(this.buf + "\n" + this.response.getDisplayResults());
            TestConnectPanel.this.outputText.revalidate();
            TestConnectPanel.this.outputText.repaint();
            if (this.response != null && !this.request.saveTempFiles) {
                this.response.deleteTempFiles();
            }
            TestConnectPanel.this.getMainPanel().setAllTabsEnabled(true);
            TestConnectPanel.this.resetCursor();
        }
    }

    private class MyRunner
    implements Runnable {
        private CVSClient client;
        private CVSRequest request;
        private CVSResponse response;

        public MyRunner(CVSClient client, CVSRequest request, CVSResponse response) {
            this.client = client;
            this.request = request;
            this.response = response;
        }

        public void run() {
            this.client.processCVSRequest(this.request, this.response);
        }
    }
}

