/*
 * Decompiled with CFR 0.152.
 */
package com.ice.pref;

import com.ice.pref.PrefsTuple;
import com.ice.pref.PrefsTupleTable;
import com.ice.util.StringUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class UserPrefs
extends Properties {
    private static UserPrefs instance;
    private static Hashtable propsTable;
    private boolean debug;
    private String name;
    private String prefix;
    private String userHome;
    private String osSuffix;
    private String userSuffix;
    private String delim;
    protected Hashtable subScribers;

    public static UserPrefs getInstance() {
        return instance;
    }

    public static UserPrefs getInstance(String name) {
        return (UserPrefs)propsTable.get(name);
    }

    public static void setInstance(UserPrefs inst) {
        instance = inst;
    }

    public static String getLineSeparator() {
        return System.getProperty("line.separator", "\n");
    }

    public static String setLineSeparator(String sep) {
        return (String)System.getProperties().put("line.separator", sep);
    }

    private UserPrefs() {
        throw new Error("DO NOT USE THIS CONSTRUCTOR!");
    }

    public UserPrefs(String name) {
        this(name, System.getProperties());
    }

    public UserPrefs(String nm, Properties defProps) {
        super(defProps);
        this.initializePrefs(nm);
        propsTable.put(nm, this);
    }

    private void initializePrefs(String nm) {
        this.name = nm;
        this.debug = false;
        this.delim = ":";
        this.prefix = this.name + ".";
        this.userHome = System.getProperty("user.home", null);
        if (this.userHome == null) {
            this.userHome = File.separatorChar == ':' ? "" : ".";
        }
        this.osSuffix = this.normalizeSuffix(System.getProperty("os.name", ""));
        this.userSuffix = this.normalizeSuffix(System.getProperty("user.name", ""));
        this.subScribers = new Hashtable();
    }

    public UserPrefs createWorkingCopy(String nm) {
        UserPrefs result = new UserPrefs(nm, this);
        result.setPropertyPrefix(this.getPropertyPrefix());
        return result;
    }

    public String getName() {
        return this.name;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setDelimiter(String delim) {
        this.delim = delim;
    }

    public String getOSSuffix() {
        return this.osSuffix;
    }

    public void setOSSuffix(String suffix) {
        this.osSuffix = this.normalizeSuffix(suffix);
    }

    public String getUserSuffix() {
        return this.userSuffix;
    }

    public void setUserSuffix(String suffix) {
        this.userSuffix = this.normalizeSuffix(suffix);
    }

    public void setPropertyPrefix(String prefix) {
        this.prefix = prefix == null || prefix.length() == 0 ? "." : (prefix.endsWith(".") ? prefix : prefix + ".");
        if (this.debug) {
            System.err.println("UserPrefs.setPropertyPrefix: prefix set to '" + this.prefix + "'");
        }
    }

    public String getDelimiter() {
        return this.delim;
    }

    public String getPropertyPrefix() {
        return this.prefix;
    }

    public String getCurrentDirectory() {
        String result = System.getProperty("user.dir", null);
        if (result == null) {
            result = File.separatorChar == ':' ? "" : ".";
        }
        return result;
    }

    public String getUserHome() {
        return this.userHome;
    }

    public void setUserHome(String newHome) {
        this.userHome = newHome;
        System.getProperties().put("user.home", newHome);
    }

    public String getBaseName(String propName) {
        if (this.prefix == null || this.prefix.length() == 0 || this.prefix.equals(".") || propName.startsWith(".")) {
            return propName;
        }
        if (propName.startsWith(this.prefix)) {
            return propName.substring(this.prefix.length());
        }
        return propName;
    }

    private String normalizeKey(String key) {
        StringBuffer kBuf = new StringBuffer(key.length() + 8);
        int i = 0;
        int sz = key.length();
        while (i < sz) {
            char ch = key.charAt(i);
            if (Character.isLetterOrDigit(ch)) {
                kBuf.append(ch);
            } else {
                int chVal = Character.getNumericValue(ch);
                kBuf.append("%");
                int hexDig = chVal & 0xF;
                kBuf.append(hexDig < 9 ? (char)(48 + hexDig) : (char)(65 + (hexDig - 10)));
                hexDig = chVal >> 4 & 0xF;
                kBuf.append(hexDig < 9 ? (char)(48 + hexDig) : (char)(65 + (hexDig - 10)));
            }
            ++i;
        }
        return kBuf.toString();
    }

    private String normalizeSuffix(String name) {
        return name.replace(' ', '_').replace('.', '_').replace(',', '_').replace('/', '_');
    }

    public String prefixedPropertyName(String name) {
        if (this.debug) {
            System.err.println("UserPrefs.prefixedPropertyName: prefix '" + this.prefix + "' name '" + name + "'");
        }
        StringBuffer result = new StringBuffer();
        if (!this.prefix.equals(".")) {
            result.append(this.prefix);
        }
        result.append(name);
        return result.toString();
    }

    public String normalizedPropertyName(String name) {
        if (name.startsWith(".")) {
            return name.substring(1);
        }
        return this.prefixedPropertyName(name);
    }

    private String locateProperty(Properties props, String normName) {
        String value = null;
        String overName = null;
        if (this.osSuffix != null && this.userSuffix != null) {
            overName = normName + "." + this.osSuffix + "." + this.userSuffix;
            value = (String)props.get(overName);
            if (this.debug) {
                System.err.println("UserPrefs.getOverridableProperty: " + overName + " = '" + value + "'");
            }
            if (value != null) {
                return value;
            }
        }
        if (this.userSuffix != null) {
            overName = normName + "." + this.userSuffix;
            value = (String)props.get(overName);
            if (this.debug) {
                System.err.println("UserPrefs.getOverridableProperty: " + overName + " = '" + value + "'");
            }
            if (value != null) {
                return value;
            }
        }
        if (this.osSuffix != null) {
            overName = normName + "." + this.osSuffix;
            value = (String)props.get(overName);
            if (this.debug) {
                System.err.println("UserPrefs.getOverridableProperty: " + overName + " = '" + value + "'");
            }
            if (value != null) {
                return value;
            }
        }
        if (value == null) {
            value = (String)props.get(normName);
            if (this.debug) {
                System.err.println("UserPrefs.getOverridableProperty: " + normName + " = '" + value + "'");
            }
        }
        return value;
    }

    private synchronized String getOverridableProperty(String name, String defval) {
        String value = null;
        String normName = this.normalizedPropertyName(name);
        if (this.debug) {
            System.err.println("UserPrefs.getOverridableProperty: Normalized name '" + normName + "'");
        }
        if (normName.endsWith(".")) {
            normName = normName.substring(0, normName.length() - 1);
            value = super.getProperty(normName, defval);
            if (this.debug) {
                System.err.println("UserPrefs.getOverridableProperty: " + normName + " = '" + value + "'");
            }
            return value;
        }
        if (this.debug) {
            System.err.println("UserPrefs.getOverridableProperty: Looking in '" + this.name + "'...");
        }
        value = this.locateProperty(this, normName);
        Properties defs = this.defaults;
        while (value == null && defs != null) {
            String dNorm = normName;
            String dnm = "System.Properties";
            if (defs instanceof UserPrefs) {
                dnm = ((UserPrefs)defs).name;
                dNorm = ((UserPrefs)defs).normalizedPropertyName(name);
            }
            if (this.debug) {
                System.err.println("UserPrefs.getOverridableProperty: Looking in defaults '" + dnm + "'...");
            }
            value = this.locateProperty(defs, dNorm);
            if (defs instanceof UserPrefs) {
                defs = ((UserPrefs)defs).defaults;
                continue;
            }
            if (this.debug) {
                System.err.println("UserPrefs.getOverridableProperty: Last ditch call to defs.getProperty() on '" + dnm + "'...");
            }
            if (value == null) {
                value = defs.getProperty(dNorm, null);
            }
            defs = null;
        }
        if (value == null) {
            value = defval;
            if (this.debug) {
                System.err.println("UserPrefs.getOverridableProperty: " + name + " defaulted to '" + value + "'");
            }
        }
        return value;
    }

    public String getProperty(String name) {
        String result = this.getOverridableProperty(name, null);
        return result;
    }

    public String getProperty(String name, String defval) {
        String result = this.getOverridableProperty(name, defval);
        return result;
    }

    public int getInteger(String name, int defval) {
        int result;
        block2: {
            result = defval;
            String val = this.getProperty(name, null);
            if (val == null) break block2;
            try {
                result = Integer.parseInt(val);
            }
            catch (NumberFormatException ex) {
                result = defval;
            }
        }
        return result;
    }

    public long getLong(String name, long defval) {
        long result;
        block2: {
            result = defval;
            String val = this.getProperty(name, null);
            if (val == null) break block2;
            try {
                result = Long.parseLong(val);
            }
            catch (NumberFormatException ex) {
                result = defval;
            }
        }
        return result;
    }

    public float getFloat(String name, float defval) {
        float result;
        block2: {
            result = defval;
            String val = this.getProperty(name, null);
            if (val == null) break block2;
            try {
                result = Float.valueOf(val).floatValue();
            }
            catch (NumberFormatException ex) {
                result = defval;
            }
        }
        return result;
    }

    public double getDouble(String name, double defval) {
        double result;
        block2: {
            result = defval;
            String val = this.getProperty(name, null);
            if (val == null) break block2;
            try {
                result = Double.valueOf(val);
            }
            catch (NumberFormatException ex) {
                result = defval;
            }
        }
        return result;
    }

    public boolean getBoolean(String name, boolean defval) {
        boolean result = defval;
        String val = this.getProperty(name, null);
        if (val != null) {
            if (val.equalsIgnoreCase("T") || val.equalsIgnoreCase("TRUE") || val.equalsIgnoreCase("Y") || val.equalsIgnoreCase("YES") || val.equalsIgnoreCase("1")) {
                result = true;
            } else if (val.equalsIgnoreCase("F") || val.equalsIgnoreCase("FALSE") || val.equalsIgnoreCase("N") || val.equalsIgnoreCase("NO") || val.equalsIgnoreCase("0")) {
                result = false;
            }
        }
        return result;
    }

    public Font getFont(String name, Font defaultFont) {
        Font result;
        block20: {
            String[] flds;
            block22: {
                block21: {
                    result = defaultFont;
                    String val = this.getProperty(name, null);
                    if (this.debug) {
                        System.err.println("UserPrefs.getFont: property = " + val);
                    }
                    if (val == null) break block20;
                    flds = UserPrefs.splitString(val, "-");
                    if (this.debug) {
                        System.err.println("UserPrefs.getFont: flds.length = " + flds.length);
                    }
                    if (flds.length != 1) break block21;
                    if (this.debug) {
                        System.err.println("UserPrefs.getFont: [0] " + flds[0]);
                    }
                    result = new Font(flds[0], 0, 12);
                    break block20;
                }
                if (flds.length != 3) break block22;
                if (this.debug) {
                    System.err.println("UserPrefs.getFont: [0] " + flds[0] + " [1] " + flds[1] + " [2] " + flds[2]);
                }
                try {
                    int style = 0;
                    int size = Integer.parseInt(flds[2]);
                    if (flds[1].equalsIgnoreCase("BOLD")) {
                        style = 1;
                    } else if (flds[1].equalsIgnoreCase("ITALIC")) {
                        style = 2;
                    } else if (flds[1].equalsIgnoreCase("BOLDITALIC")) {
                        style = 3;
                    }
                    result = new Font(flds[0], style, size);
                }
                catch (NumberFormatException ex) {
                    if (!this.debug) break block20;
                    System.err.println("UserPrefs.getFont: SIZE NumberFormatException: " + ex.getMessage());
                }
                break block20;
            }
            if (flds.length != 2) break block20;
            if (this.debug) {
                System.err.println("UserPrefs.getFont: [0] " + flds[0] + " [1] " + flds[1]);
            }
            try {
                int size = Integer.parseInt(flds[1]);
                result = new Font(flds[0], 0, size);
            }
            catch (NumberFormatException ex) {
                if (this.debug) {
                    System.err.println("UserPrefs.getFont: SIZE NumberFormatException: " + ex.getMessage());
                }
                int style = 0;
                if (flds[1].equalsIgnoreCase("BOLD")) {
                    style = 1;
                } else if (flds[1].equalsIgnoreCase("ITALIC")) {
                    style = 2;
                } else if (flds[1].equalsIgnoreCase("BOLDITALIC")) {
                    style = 3;
                }
                result = new Font(flds[0], style, 12);
            }
        }
        return result;
    }

    public Color getColor(String name, Color defaultColor) {
        Color result;
        block2: {
            result = defaultColor;
            String val = this.getProperty(name, null);
            if (val == null) break block2;
            try {
                int rgb = Integer.parseInt(val);
                result = new Color(rgb);
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    public Point getPoint(String name, Point defval) {
        Point result;
        block3: {
            result = defval;
            String val = this.getProperty(name, null);
            if (val == null) break block3;
            String[] flds = UserPrefs.splitString(val, this.delim);
            if (flds.length == 2) {
                try {
                    Point p = new Point();
                    p.x = Integer.parseInt(flds[0]);
                    p.y = Integer.parseInt(flds[1]);
                    result = p;
                }
                catch (NumberFormatException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return result;
    }

    public Point getLocation(String name, Point defval) {
        return this.getPoint(name, defval);
    }

    public Dimension getDimension(String name, Dimension defval) {
        Dimension result;
        block3: {
            result = defval;
            String val = this.getProperty(name, null);
            if (val == null) break block3;
            String[] flds = UserPrefs.splitString(val, this.delim);
            if (flds.length == 2) {
                try {
                    Dimension dim = new Dimension();
                    dim.width = Integer.parseInt(flds[0]);
                    dim.height = Integer.parseInt(flds[1]);
                    result = dim;
                }
                catch (NumberFormatException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return result;
    }

    public Rectangle getBounds(String name, Rectangle defval) {
        Rectangle result;
        block3: {
            result = defval;
            String val = this.getProperty(name, null);
            if (val == null) break block3;
            String[] flds = UserPrefs.splitString(val, this.delim);
            if (flds.length == 4) {
                try {
                    Rectangle rect = new Rectangle();
                    rect.x = Integer.parseInt(flds[0]);
                    rect.y = Integer.parseInt(flds[1]);
                    rect.width = Integer.parseInt(flds[2]);
                    rect.height = Integer.parseInt(flds[3]);
                    result = rect;
                }
                catch (NumberFormatException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return result;
    }

    public String[] getStringArray(String name, String[] defval) {
        Object[] result = defval;
        Vector v = this.getStringVector(name, null);
        if (v != null) {
            result = new String[v.size()];
            v.copyInto(result);
        }
        return result;
    }

    public Vector getStringVector(String name, Vector defval) {
        Vector<String> result = defval;
        int size = this.getInteger(name + ".size", 0);
        if (size > 0) {
            result = new Vector<String>();
            int i = 0;
            while (i < size) {
                String idxName = name + "." + i;
                String val = this.getProperty(idxName, "");
                result.addElement(val);
                ++i;
            }
        }
        return result;
    }

    public String[] getTokens(String name, String[] defval) {
        String[] result = defval;
        String val = this.getProperty(name, null);
        if (val != null) {
            result = UserPrefs.splitString(val, this.delim);
        }
        return result;
    }

    public static String[] splitString(String splitStr, String delim) {
        Vector sv = StringUtilities.vectorString(splitStr, delim);
        Object[] result = new String[sv.size()];
        sv.copyInto(result);
        return result;
    }

    public PrefsTupleTable getTupleTable(String name, PrefsTupleTable defval) {
        PrefsTupleTable result = defval;
        int size = this.getInteger(name + ".size", 0);
        if (size > 0) {
            result = new PrefsTupleTable();
            int row = 0;
            while (row < size) {
                String key = this.getProperty(name + "." + row + ".key", null);
                int rowSz = this.getInteger(name + "." + row + ".size", 0);
                if (key != null && rowSz > 0) {
                    Vector<String> tupV = new Vector<String>();
                    int iv = 0;
                    while (iv < rowSz) {
                        String val = this.getProperty(name + "." + row + "." + iv, null);
                        if (val == null) break;
                        tupV.addElement(val);
                        ++iv;
                    }
                    PrefsTuple tup = new PrefsTuple(key, tupV);
                    result.putTuple(tup);
                } else if (key != null) {
                    result.putTuple(new PrefsTuple(key, new Vector()));
                } else {
                    new Throwable("BAD tuple property '" + name + "'").printStackTrace();
                }
                ++row;
            }
        }
        return result;
    }

    public boolean isModified(String propName) {
        String obj;
        String def = null;
        if (this.defaults != null) {
            def = this.defaults.getProperty(propName);
        }
        if ((obj = this.getProperty(propName)) == null) {
            return false;
        }
        if (def != null) {
            return !obj.equals(def);
        }
        return true;
    }

    public String escapeString(String propStr) {
        StringBuffer result = new StringBuffer(propStr.length());
        int offset = 0;
        while (true) {
            int idx;
            if ((idx = propStr.indexOf(this.delim, offset)) == -1) break;
            result.append(propStr.substring(offset, idx));
            result.append('\\');
            result.append(this.delim);
            offset = idx + 1;
        }
        result.append(propStr.substring(offset));
        return result.toString();
    }

    public void addPropertyChangeListener(String propName, PropertyChangeListener pL) {
        PropertyChangeSupport pList = (PropertyChangeSupport)this.subScribers.get(propName);
        if (pList == null) {
            pList = new PropertyChangeSupport(this);
            this.subScribers.put(propName, pList);
        }
        pList.addPropertyChangeListener(pL);
    }

    public void removePropertyChangeListener(String propName, PropertyChangeListener pL) {
        PropertyChangeSupport pList = (PropertyChangeSupport)this.subScribers.get(propName);
        if (pList != null) {
            pList.removePropertyChangeListener(pL);
        }
    }

    protected void firePropertyChange(String propName, String oldVal, String newVal) {
        PropertyChangeSupport pList = (PropertyChangeSupport)this.subScribers.get(propName);
        if (pList != null) {
            pList.firePropertyChange(propName, oldVal, newVal);
        }
    }

    protected synchronized String setPropertyNoFire(String name, String value) {
        String normName = this.normalizedPropertyName(name);
        String result = (String)this.put(normName, value);
        return result;
    }

    public Object setProperty(String name, String value) {
        String result = this.setPropertyNoFire(name, value);
        this.firePropertyChange(name, result, value);
        return result;
    }

    public void setInteger(String name, int value) {
        String valStr = "" + value;
        this.setProperty(name, valStr);
    }

    public void setLong(String name, long value) {
        String valStr = Long.toString(value);
        this.setProperty(name, valStr);
    }

    public void setFloat(String name, float value) {
        String valStr = Float.toString(value);
        this.setProperty(name, valStr);
    }

    public void setDouble(String name, double value) {
        String valStr = Double.toString(value);
        this.setProperty(name, valStr);
    }

    public void setBoolean(String name, boolean value) {
        String valStr = value ? "true" : "false";
        this.setProperty(name, valStr);
    }

    public void setPoint(String name, Point value) {
        String valStr = value.x + this.delim + value.y;
        this.setProperty(name, valStr);
    }

    public void setLocation(String name, Point value) {
        this.setPoint(name, value);
    }

    public void setDimension(String name, Dimension value) {
        String valStr = value.width + this.delim + value.height;
        this.setProperty(name, valStr);
    }

    public void setBounds(String name, Rectangle value) {
        String valStr = value.x + this.delim + value.y + this.delim + value.width + this.delim + value.height;
        this.setProperty(name, valStr);
    }

    public void setFont(String name, Font value) {
        int style = value.getStyle();
        String styleStr = style == 0 ? null : (style == 1 ? "BOLD" : (style == 2 ? "ITALIC" : "BOLDITALIC"));
        String valStr = value.getName() + "-" + (styleStr == null ? "" : styleStr + "-") + value.getSize();
        this.setProperty(name, valStr);
    }

    public void setColor(String name, Color value) {
        String valStr = "" + value.getRGB();
        this.setProperty(name, valStr);
    }

    public void setStringArray(String name, String[] strings) {
        this.setInteger(name + ".size", strings.length);
        int i = 0;
        while (i < strings.length) {
            this.setProperty(name + "." + i, strings[i]);
            ++i;
        }
    }

    public void setTokens(String name, String[] tokes) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < tokes.length) {
            buf.append(tokes[i]);
            if (i < tokes.length - 1) {
                buf.append(this.delim);
            }
            ++i;
        }
        this.setProperty(name, buf.toString());
    }

    public void setTupleTable(String name, PrefsTupleTable table) {
        Vector kv = table.getKeyOrder();
        this.setInteger(name + ".size", kv.size());
        int i = 0;
        while (i < kv.size()) {
            PrefsTuple tup = table.getTuple((String)kv.elementAt(i));
            this.setProperty(name + "." + i + ".key", tup.getKey());
            String[] vals = tup.getValues();
            this.setInteger(name + "." + i + ".size", vals.length);
            int j = 0;
            while (j < vals.length) {
                String propName = name + "." + i + "." + j;
                this.setProperty(propName, vals[j]);
                ++j;
            }
            ++i;
        }
    }

    public void removeProperty(String propName) {
        String normName = this.normalizedPropertyName(propName);
        if (normName.endsWith(".")) {
            normName = normName.substring(0, normName.length() - 1);
        }
        Object object = this.remove(normName);
    }

    public void removeStringArray(String propName) {
        int size = this.getInteger(propName + ".size", 0);
        this.removeProperty(propName + ".size");
        int i = 0;
        while (i < size) {
            this.removeProperty(propName + "." + i);
            ++i;
        }
    }

    public void removeTupleTable(String propName) {
        int size = this.getInteger(propName + ".size", 0);
        this.removeProperty(propName + ".size");
        int row = 0;
        while (row < size) {
            this.removeProperty(propName + "." + row + ".key");
            int cols = this.getInteger(propName + "." + row + ".size", 0);
            this.removeProperty(propName + "." + row + ".size");
            int col = 0;
            while (col < cols) {
                this.removeProperty(propName + "." + row + "." + col);
                ++col;
            }
            ++row;
        }
    }

    public synchronized void loadProperties(Properties ap) {
        Enumeration<Object> enumeration = ap.keys();
        while (enumeration.hasMoreElements()) {
            String nm = (String)enumeration.nextElement();
            String val = ap.getProperty(nm);
            this.put(nm, val);
        }
    }

    public synchronized void loadProperties(InputStream in) throws IOException {
        super.load(in);
    }

    public synchronized void storeProperties(OutputStream out, String header) throws IOException {
        this.save(out, header);
    }

    public static void main(String[] args) {
        System.err.println("UserPrefs.main: testing class...");
        UserPrefs defPrefs = UserPrefs.getInstance();
        defPrefs.setProperty("testPref.1.1", "Pref '1.1' set directly on 'DEFAULT'");
        UserPrefs.getInstance().setProperty("testPref.1.2", "Pref '1.2' set via getInstance");
        UserPrefs prefsTwo = new UserPrefs("TestTwo", defPrefs);
        prefsTwo.setProperty("testPref.2.1", "Pref '2.1' set directly on 'TestTwo'");
        UserPrefs.getInstance().setProperty("testPref.2.2", "Pref '2.2' set via getInstance");
        System.out.println("======== Preferences 'DEFAULT' ========");
        try {
            defPrefs.storeProperties(System.out, "DEFAULT PROPERTIES");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        System.out.println("======== ======= END 'DEFAULT' ========");
        System.out.println("");
        System.out.println("");
        System.out.println("======== Preferences 'TestTwo' ========");
        try {
            prefsTwo.storeProperties(System.out, "TestTwo PROPERTIES");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        System.out.println("======== ======= END 'DEFAULT' ========");
    }

    static {
        propsTable = new Hashtable();
        UserPrefs.setInstance(new UserPrefs("DEFAULT"));
    }

    public class Tuple {
        private String key;
        private String[] values;

        public Tuple(String key, String[] Values) {
            this.key = key;
            this.values = this.values;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String[] getValues() {
            return this.values;
        }

        public void setValues(String[] values) {
            this.values = values;
        }

        public void setValues(Vector values) {
            this.values = new String[values.size()];
            int i = 0;
            while (i < this.values.length) {
                this.values[i] = (String)values.elementAt(i);
                ++i;
            }
        }
    }

    public class Pair {
        private String key;
        private String value;

        public Pair(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

