/*
 * Decompiled with CFR 0.152.
 */
package com.ice.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileUtilities {
    public static final String RCS_ID = "$Id: FileUtilities.java,v 1.4 1999/03/09 19:44:39 time Exp $";
    public static final String RCS_REV = "$Revision: 1.4 $";
    public static final String RCS_NAME = "$Name:  $";

    public static void copyFile(File from, File to) throws IOException {
        long fileSize;
        int bytes;
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            in = new BufferedInputStream(new FileInputStream(from));
        }
        catch (IOException ex) {
            throw new IOException("FileUtilities.copyFile: opening input stream '" + from.getPath() + "', " + ex.getMessage());
        }
        try {
            out = new BufferedOutputStream(new FileOutputStream(to));
        }
        catch (Exception ex) {
            try {
                in.close();
            }
            catch (IOException ex1) {
                // empty catch block
            }
            throw new IOException("FileUtilities.copyFile: opening output stream '" + to.getPath() + "', " + ex.getMessage());
        }
        byte[] buffer = new byte[8192];
        for (long length = fileSize = from.length(); length > 0L; length -= (long)bytes) {
            bytes = (int)(length > 8192L ? 8192L : length);
            try {
                bytes = in.read(buffer, 0, bytes);
            }
            catch (IOException ex) {
                try {
                    in.close();
                    out.close();
                }
                catch (IOException ex1) {
                    // empty catch block
                }
                throw new IOException("FileUtilities.copyFile: reading input stream, " + ex.getMessage());
            }
            if (bytes < 0) break;
            try {
                out.write(buffer, 0, bytes);
                continue;
            }
            catch (IOException ex) {
                try {
                    in.close();
                    out.close();
                }
                catch (IOException ex1) {
                    // empty catch block
                }
                throw new IOException("FileUtilities.copyFile: writing output stream, " + ex.getMessage());
            }
        }
        try {
            in.close();
            out.close();
        }
        catch (IOException ex) {
            throw new IOException("FileUtilities.copyFile: closing file streams, " + ex.getMessage());
        }
    }

    public static boolean fileEqualsExtension(String fileName, String extension) {
        int exLen;
        boolean result = false;
        int fnLen = fileName.length();
        if (fnLen > (exLen = extension.length())) {
            String fileSuffix = fileName.substring(fnLen - exLen);
            result = FileUtilities.caseSensitivePathNames() ? fileSuffix.equals(extension) : fileSuffix.equalsIgnoreCase(extension);
        }
        return result;
    }

    public static boolean caseSensitivePathNames() {
        boolean result = true;
        String osname = System.getProperty("os.name");
        if (osname != null) {
            if (osname.startsWith("macos")) {
                result = false;
            } else if (osname.startsWith("Windows")) {
                result = false;
            }
        }
        return result;
    }

    public static boolean isPatternString(String pattern) {
        if (pattern.indexOf("*") >= 0) {
            return true;
        }
        if (pattern.indexOf("?") >= 0) {
            return true;
        }
        int index = pattern.indexOf("[");
        return index >= 0 && pattern.indexOf("]") > index + 1;
    }

    public static boolean matchPattern(String fileName, String pattern) {
        return FileUtilities.recurseMatchPattern(fileName, pattern, 0, 0);
    }

    /*
     * Unable to fully structure code
     */
    private static boolean recurseMatchPattern(String string, String pattern, int sIdx, int pIdx) {
        pLen = pattern.length();
        sLen = string.length();
        while (true) {
            block16: {
                if (pIdx >= pLen) {
                    return sIdx >= sLen;
                }
                if (sIdx >= sLen && pattern.charAt(pIdx) != '*') {
                    return false;
                }
                if (pattern.charAt(pIdx) == '*') {
                    if (++pIdx >= pLen) {
                        return true;
                    }
                    while (true) {
                        if (FileUtilities.recurseMatchPattern(string, pattern, sIdx, pIdx)) {
                            return true;
                        }
                        if (sIdx >= sLen) {
                            return false;
                        }
                        ++sIdx;
                    }
                }
                if (pattern.charAt(pIdx) == '?') {
                    ++pIdx;
                    ++sIdx;
                    continue;
                }
                if (pattern.charAt(pIdx) != '[') break block16;
                ++pIdx;
                while (true) {
                    block17: {
                        if (pIdx >= pLen || pattern.charAt(pIdx) == ']') {
                            return false;
                        }
                        if (pattern.charAt(pIdx) == string.charAt(sIdx)) ** GOTO lbl43
                        if (pIdx >= pLen - 1 || pattern.charAt(pIdx + 1) != '-') break block17;
                        if (pIdx >= pLen - 2) {
                            return false;
                        }
                        chStr = string.charAt(sIdx);
                        chPtn = pattern.charAt(pIdx);
                        chPtn2 = pattern.charAt(pIdx + 2);
                        if (chPtn <= chStr && chPtn2 >= chStr || chPtn >= chStr && chPtn2 <= chStr) ** GOTO lbl43
                        pIdx += 2;
                    }
                    ++pIdx;
                }
lbl-1000:
                // 1 sources

                {
                    if (pIdx >= pLen) {
                        --pIdx;
                        break;
                    }
                    ++pIdx;
lbl43:
                    // 3 sources

                    ** while (pattern.charAt((int)pIdx) != ']')
                }
lbl44:
                // 2 sources

                ++pIdx;
                ++sIdx;
                continue;
            }
            if (pattern.charAt(pIdx) == '\\' && ++pIdx >= pLen) {
                return false;
            }
            if (pIdx < pLen && sIdx < sLen && pattern.charAt(pIdx) != string.charAt(sIdx)) {
                return false;
            }
            ++pIdx;
            ++sIdx;
        }
    }

    public static String getUserHomeDirectory() {
        String userDirName = System.getProperty("user.home", null);
        if (userDirName == null) {
            userDirName = System.getProperty("user.dir", null);
        }
        return userDirName;
    }
}

