/*
 * Decompiled with CFR 0.152.
 */
package com.ice.util;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class FormatResourceBundle
extends ResourceBundle {
    private static Hashtable alias = new Hashtable();
    private static Hashtable cache = new Hashtable();
    private boolean debug = true;
    private ResourceBundle bundle;

    public static void addAlias(String alias, String baseName) {
        FormatResourceBundle.alias.put(alias, baseName);
    }

    public static void unCache(String alias, String baseName) {
        String name = (String)FormatResourceBundle.alias.get(baseName);
        if (name == null) {
            name = baseName;
        }
        cache.remove(name);
    }

    public static FormatResourceBundle getFormatBundle(String baseName) {
        ResourceBundle bundle;
        FormatResourceBundle result;
        String name = (String)alias.get(baseName);
        if (name == null) {
            name = baseName;
        }
        if ((result = (FormatResourceBundle)cache.get(name)) == null && (bundle = ResourceBundle.getBundle(name)) != null) {
            result = new FormatResourceBundle(bundle);
            cache.put(name, result);
        }
        return result;
    }

    public static FormatResourceBundle getFormatBundle(String baseName, Locale locale) {
        ResourceBundle bundle;
        FormatResourceBundle result;
        String name = (String)alias.get(baseName);
        if (name == null) {
            name = baseName;
        }
        if ((result = (FormatResourceBundle)cache.get(name)) == null && (bundle = ResourceBundle.getBundle(name, locale)) != null) {
            result = new FormatResourceBundle(bundle);
            cache.put(name, result);
        }
        return result;
    }

    public FormatResourceBundle(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    public String getString(String key, String defValue) {
        String rsrcStr = defValue;
        try {
            rsrcStr = this.bundle.getString(key);
        }
        catch (MissingResourceException ex) {
            if (this.debug) {
                System.err.println("MISSING RESOURCE: '" + key + "'");
            }
            rsrcStr = defValue;
        }
        return rsrcStr;
    }

    public String getFormatString(String key, Object[] args) {
        String fmtStr = this.bundle.getString(key);
        return fmtStr == null ? null : this.format(fmtStr, args);
    }

    public Enumeration getKeys() {
        return this.bundle.getKeys();
    }

    protected Object handleGetObject(String key) {
        return this.bundle.getObject(key);
    }

    private static String filterQuotes(String str) {
        StringBuffer buf = new StringBuffer();
        while (true) {
            int idx;
            if ((idx = str.indexOf("''")) == -1) break;
            buf.append(str.substring(0, idx));
            buf.append("'");
            str = str.substring(idx + 2);
        }
        buf.append(str);
        return buf.toString();
    }

    private String format(String formatStr, Object[] fmtArgs) {
        int lcbIdx;
        StringBuffer result = new StringBuffer(formatStr.length() + 256);
        String workStr = formatStr;
        while ((lcbIdx = workStr.indexOf("{")) != -1) {
            if (lcbIdx > 0) {
                char lqt = workStr.charAt(lcbIdx - 1);
                char num = workStr.charAt(lcbIdx + 1);
                char rcb = workStr.charAt(lcbIdx + 2);
                String leftStr = workStr.substring(0, lcbIdx);
                if (lqt == '\'' && num == '\'') {
                    result.append(FormatResourceBundle.filterQuotes(workStr.substring(0, lcbIdx - 1)));
                    result.append("{");
                    workStr = workStr.substring(lcbIdx + 2);
                    continue;
                }
                if (num >= '0' && num <= '9' && rcb == '}') {
                    result.append(FormatResourceBundle.filterQuotes(leftStr));
                    String fmtStr = "{" + num + "}";
                    result.append(MessageFormat.format(fmtStr, fmtArgs));
                    workStr = workStr.substring(lcbIdx + 3);
                    continue;
                }
                result.append(FormatResourceBundle.filterQuotes(leftStr));
                result.append("ERR{ERR");
                workStr = workStr.substring(lcbIdx + 1);
                continue;
            }
            char num = workStr.charAt(1);
            char rcb = workStr.charAt(2);
            if (rcb == '}' && num >= '0' && num <= '9') {
                String fmtStr = "{" + num + "}";
                result.append(MessageFormat.format(fmtStr, fmtArgs));
                workStr = workStr.substring(3);
                continue;
            }
            result.append("{");
            workStr = workStr.substring(1);
        }
        if (workStr.length() > 0) {
            result.append(FormatResourceBundle.filterQuotes(workStr));
        }
        return result.toString();
    }
}

