/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh;

import com.sshtools.j2ssh.DirectoryOperation;
import com.sshtools.j2ssh.FileTransferProgress;
import com.sshtools.j2ssh.SshClient;
import com.sshtools.j2ssh.SshException;
import com.sshtools.j2ssh.TransferCancelledException;
import com.sshtools.j2ssh.connection.ChannelEventListener;
import com.sshtools.j2ssh.io.IOUtil;
import com.sshtools.j2ssh.io.UnsignedInteger32;
import com.sshtools.j2ssh.sftp.FileAttributes;
import com.sshtools.j2ssh.sftp.SftpFile;
import com.sshtools.j2ssh.sftp.SftpFileInputStream;
import com.sshtools.j2ssh.sftp.SftpFileOutputStream;
import com.sshtools.j2ssh.sftp.SftpSubsystemClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class SftpClient {
    SftpSubsystemClient sftp;
    String cwd;
    String lcwd;
    private int BLOCKSIZE = 65535;
    int umask = 18;
    int default_permissions = 511;

    SftpClient(SshClient sshClient) throws IOException {
        this(sshClient, null);
    }

    SftpClient(SshClient sshClient, ChannelEventListener channelEventListener) throws IOException {
        if (!sshClient.isConnected()) {
            throw new IOException("SshClient is not connected");
        }
        this.sftp = sshClient.openSftpChannel(channelEventListener);
        this.cwd = this.sftp.getDefaultDirectory();
        this.lcwd = System.getProperty("user.home");
    }

    public int umask(int n) {
        int n2 = n;
        this.umask = n;
        return n2;
    }

    public void cd(String string) throws IOException {
        try {
            String string2;
            if (string.equals("")) {
                string2 = this.sftp.getDefaultDirectory();
            } else {
                string2 = this.resolveRemotePath(string);
                string2 = this.sftp.getAbsolutePath(string2);
            }
            FileAttributes fileAttributes = this.sftp.getAttributes(string2);
            if (!fileAttributes.isDirectory()) {
                throw new IOException(string + " is not a directory");
            }
            this.cwd = string2;
        }
        catch (IOException iOException) {
            throw new FileNotFoundException(string + " could not be found");
        }
    }

    private File resolveLocalPath(String string) throws IOException {
        File file = new File(string);
        if (!file.isAbsolute()) {
            file = new File(this.lcwd, string);
        }
        return file;
    }

    private String resolveRemotePath(String string) throws IOException {
        this.verifyConnection();
        String string2 = !string.startsWith("/") ? this.cwd + (this.cwd.endsWith("/") ? "" : "/") + string : string;
        return string2;
    }

    private void verifyConnection() throws SshException {
        if (this.sftp.isClosed()) {
            throw new SshException("The SFTP connection has been closed");
        }
    }

    public void mkdir(String string) throws IOException {
        String string2 = this.resolveRemotePath(string);
        try {
            FileAttributes fileAttributes = this.stat(string2);
            if (!fileAttributes.isDirectory()) {
                throw new IOException("File already exists named " + string);
            }
        }
        catch (IOException iOException) {
            this.sftp.makeDirectory(string2);
            this.chmod(this.default_permissions ^ this.umask, string2);
        }
    }

    public void mkdirs(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        String string2 = string.startsWith("/") ? "/" : "";
        while (stringTokenizer.hasMoreElements()) {
            string2 = string2 + (String)stringTokenizer.nextElement();
            try {
                this.stat(string2);
            }
            catch (IOException iOException) {
                try {
                    this.mkdir(string2);
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
            string2 = string2 + "/";
        }
    }

    public String pwd() {
        return this.cwd;
    }

    public List ls() throws IOException {
        return this.ls(this.cwd);
    }

    public List ls(String string) throws IOException {
        String string2 = this.resolveRemotePath(string);
        FileAttributes fileAttributes = this.sftp.getAttributes(string2);
        if (!fileAttributes.isDirectory()) {
            throw new IOException(string + " is not a directory");
        }
        SftpFile sftpFile = this.sftp.openDirectory(string2);
        Vector vector = new Vector();
        while (this.sftp.listChildren(sftpFile, vector) > -1) {
        }
        sftpFile.close();
        return vector;
    }

    public void lcd(String string) throws IOException {
        File file = !SftpClient.isLocalAbsolutePath(string) ? new File(this.lcwd, string) : new File(string);
        if (!file.isDirectory()) {
            throw new IOException(string + " is not a directory");
        }
        this.lcwd = file.getCanonicalPath();
    }

    private static boolean isLocalAbsolutePath(String string) {
        return new File(string).isAbsolute();
    }

    public String lpwd() {
        return this.lcwd;
    }

    public FileAttributes get(String string, FileTransferProgress fileTransferProgress) throws IOException, TransferCancelledException {
        String string2 = string.lastIndexOf("/") > -1 ? string.substring(string.lastIndexOf("/") + 1) : string;
        return this.get(string, string2, fileTransferProgress);
    }

    public FileAttributes get(String string) throws IOException {
        return this.get(string, (FileTransferProgress)null);
    }

    private void transferFile(InputStream inputStream, OutputStream outputStream) throws IOException, TransferCancelledException {
        this.transferFile(inputStream, outputStream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transferFile(InputStream inputStream, OutputStream outputStream, FileTransferProgress fileTransferProgress) throws IOException, TransferCancelledException {
        try {
            int n;
            long l = 0L;
            byte[] byArray = new byte[this.BLOCKSIZE];
            while ((n = inputStream.read(byArray)) > -1) {
                if (fileTransferProgress != null && fileTransferProgress.isCancelled()) {
                    throw new TransferCancelledException();
                }
                if (n <= 0) continue;
                outputStream.write(byArray, 0, n);
                l += (long)n;
                if (fileTransferProgress == null) continue;
                fileTransferProgress.progressed(l);
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            try {
                inputStream.close();
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            inputStream.close();
            outputStream.close();
        }
        catch (IOException iOException) {}
    }

    public FileAttributes get(String string, String string2, FileTransferProgress fileTransferProgress) throws IOException, TransferCancelledException {
        File file = this.resolveLocalPath(string2);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        return this.get(string, fileOutputStream, fileTransferProgress);
    }

    public FileAttributes get(String string, String string2) throws IOException {
        return this.get(string, string2, null);
    }

    public FileAttributes get(String string, OutputStream outputStream, FileTransferProgress fileTransferProgress) throws IOException, TransferCancelledException {
        String string2 = this.resolveRemotePath(string);
        FileAttributes fileAttributes = this.stat(string2);
        if (fileTransferProgress != null) {
            fileTransferProgress.started(fileAttributes.getSize().longValue(), string2);
        }
        SftpFileInputStream sftpFileInputStream = new SftpFileInputStream(this.sftp.openFile(string2, 1));
        this.transferFile(sftpFileInputStream, outputStream, fileTransferProgress);
        if (fileTransferProgress != null) {
            fileTransferProgress.completed();
        }
        return fileAttributes;
    }

    public FileAttributes get(String string, OutputStream outputStream) throws IOException {
        return this.get(string, outputStream, null);
    }

    public boolean isClosed() {
        return this.sftp.isClosed();
    }

    public void put(String string, FileTransferProgress fileTransferProgress) throws IOException, TransferCancelledException {
        File file = new File(string);
        this.put(string, file.getName(), fileTransferProgress);
    }

    public void put(String string) throws IOException {
        this.put(string, (FileTransferProgress)null);
    }

    public void put(String string, String string2, FileTransferProgress fileTransferProgress) throws IOException, TransferCancelledException {
        File file = this.resolveLocalPath(string);
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            FileAttributes fileAttributes = this.stat(string2);
            if (fileAttributes.isDirectory()) {
                File file2 = new File(string);
                string2 = string2 + (string2.endsWith("/") ? "" : "/") + file2.getName();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.put(fileInputStream, string2, fileTransferProgress);
    }

    public void put(String string, String string2) throws IOException {
        this.put(string, string2, null);
    }

    public void put(InputStream inputStream, String string, FileTransferProgress fileTransferProgress) throws IOException, TransferCancelledException {
        SftpFileOutputStream sftpFileOutputStream;
        String string2 = this.resolveRemotePath(string);
        boolean bl = false;
        try {
            FileAttributes fileAttributes = this.stat(string2);
            sftpFileOutputStream = new SftpFileOutputStream(this.sftp.openFile(string2, 26));
        }
        catch (IOException iOException) {
            FileAttributes fileAttributes = new FileAttributes();
            bl = true;
            fileAttributes.setPermissions(new UnsignedInteger32(this.default_permissions ^ this.umask));
            sftpFileOutputStream = new SftpFileOutputStream(this.sftp.openFile(string2, 10, fileAttributes));
        }
        if (fileTransferProgress != null) {
            fileTransferProgress.started(inputStream.available(), string2);
        }
        this.transferFile(inputStream, sftpFileOutputStream, fileTransferProgress);
        if (fileTransferProgress != null) {
            fileTransferProgress.completed();
        }
        if (bl) {
            this.chmod(this.default_permissions ^ this.umask, string2);
        }
    }

    public void put(InputStream inputStream, String string) throws IOException {
        this.put(inputStream, string, null);
    }

    public void chown(int n, String string) throws IOException {
        String string2 = this.resolveRemotePath(string);
        FileAttributes fileAttributes = this.sftp.getAttributes(string2);
        fileAttributes.setUID(new UnsignedInteger32(n));
        this.sftp.setAttributes(string2, fileAttributes);
    }

    public void chgrp(int n, String string) throws IOException {
        String string2 = this.resolveRemotePath(string);
        FileAttributes fileAttributes = this.sftp.getAttributes(string2);
        fileAttributes.setGID(new UnsignedInteger32(n));
        this.sftp.setAttributes(string2, fileAttributes);
    }

    public void chmod(int n, String string) throws IOException {
        String string2 = this.resolveRemotePath(string);
        this.sftp.changePermissions(string2, n);
    }

    public void umask(String string) throws IOException {
        try {
            this.umask = Integer.parseInt(string, 8);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("umask must be 4 digit octal number e.g. 0022");
        }
    }

    public void rename(String string, String string2) throws IOException {
        String string3 = this.resolveRemotePath(string);
        String string4 = this.resolveRemotePath(string2);
        this.sftp.renameFile(string3, string4);
    }

    public void rm(String string) throws IOException {
        String string2 = this.resolveRemotePath(string);
        FileAttributes fileAttributes = this.sftp.getAttributes(string2);
        if (fileAttributes.isDirectory()) {
            this.sftp.removeDirectory(string2);
        } else {
            this.sftp.removeFile(string2);
        }
    }

    public void rm(String string, boolean bl, boolean bl2) throws IOException {
        String string2 = this.resolveRemotePath(string);
        FileAttributes fileAttributes = this.sftp.getAttributes(string2);
        if (fileAttributes.isDirectory()) {
            List list = this.ls(string);
            if (!bl && list.size() > 0) {
                throw new IOException("You cannot delete non-empty directory, use force=true to overide");
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                SftpFile sftpFile = (SftpFile)iterator.next();
                if (sftpFile.isDirectory() && !sftpFile.getFilename().equals(".") && !sftpFile.getFilename().equals("..")) {
                    if (bl2) {
                        this.rm(sftpFile.getAbsolutePath(), bl, bl2);
                        continue;
                    }
                    throw new IOException("Directory has contents, cannot delete without recurse=true");
                }
                if (!sftpFile.isFile()) continue;
                this.sftp.removeFile(sftpFile.getAbsolutePath());
            }
            this.sftp.removeDirectory(string2);
        } else {
            this.sftp.removeFile(string2);
        }
    }

    public void symlink(String string, String string2) throws IOException {
        String string3 = this.resolveRemotePath(string);
        String string4 = this.resolveRemotePath(string2);
        this.sftp.createSymbolicLink(string3, string4);
    }

    public FileAttributes stat(String string) throws IOException {
        String string2 = this.resolveRemotePath(string);
        return this.sftp.getAttributes(string2);
    }

    public String getAbsolutePath(String string) throws IOException {
        String string2 = this.resolveRemotePath(string);
        return this.sftp.getAbsolutePath(string);
    }

    public void quit() throws IOException {
        this.sftp.close();
    }

    public DirectoryOperation copyLocalDirectory(String string, String string2, boolean bl, boolean bl2, boolean bl3, FileTransferProgress fileTransferProgress) throws IOException {
        Object object;
        Object object2;
        DirectoryOperation directoryOperation = new DirectoryOperation();
        String string3 = this.pwd();
        String string4 = this.lpwd();
        File file = this.resolveLocalPath(string);
        string2 = this.resolveRemotePath(string2);
        string2 = string2 + (string2.endsWith("/") ? "" : "/");
        string2 = string2 + file.getName();
        string2 = string2 + (string2.endsWith("/") ? "" : "/");
        if (bl3) {
            try {
                object2 = this.stat(string2);
            }
            catch (IOException iOException) {
                this.mkdir(string2);
            }
        }
        if ((object2 = file.listFiles()) != null) {
            int n = 0;
            while (n < ((File[])object2).length) {
                if (object2[n].isDirectory() && !object2[n].getName().equals(".") && !object2[n].getName().equals("..")) {
                    if (bl) {
                        object = new File(file, object2[n].getName());
                        directoryOperation.addDirectoryOperation(this.copyLocalDirectory(((File)object).getAbsolutePath(), string2, bl, bl2, bl3, fileTransferProgress), (File)object);
                    }
                } else if (object2[n].isFile()) {
                    try {
                        object = this.stat(string2 + object2[n].getName());
                        if (object2[n].length() == ((FileAttributes)object).getSize().longValue() && object2[n].lastModified() / 1000L == ((FileAttributes)object).getModifiedTime().longValue()) {
                            directoryOperation.addUnchangedFile(object2[n]);
                        } else {
                            directoryOperation.addUpdatedFile(object2[n]);
                        }
                    }
                    catch (IOException iOException) {
                        directoryOperation.addNewFile(object2[n]);
                    }
                    if (bl3) {
                        this.put(object2[n].getAbsolutePath(), string2 + object2[n].getName(), fileTransferProgress);
                        object = this.stat(string2 + object2[n].getName());
                        ((FileAttributes)object).setTimes(new UnsignedInteger32(object2[n].lastModified() / 1000L), new UnsignedInteger32(object2[n].lastModified() / 1000L));
                        this.sftp.setAttributes(string2 + object2[n].getName(), (FileAttributes)object);
                    }
                }
                ++n;
            }
        }
        if (bl2) {
            try {
                List list = this.ls(string2);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    object = (SftpFile)iterator.next();
                    File file2 = new File(file, ((SftpFile)object).getFilename());
                    if (directoryOperation.containsFile((SftpFile)object) || ((SftpFile)object).getFilename().equals(".") || ((SftpFile)object).getFilename().equals("..")) continue;
                    directoryOperation.addDeletedFile((SftpFile)object);
                    if (!bl3) continue;
                    if (((SftpFile)object).isDirectory()) {
                        this.recurseMarkForDeletion((SftpFile)object, directoryOperation);
                        if (!bl3) continue;
                        this.rm(((SftpFile)object).getAbsolutePath(), true, true);
                        continue;
                    }
                    if (!((SftpFile)object).isFile()) continue;
                    this.rm(((SftpFile)object).getAbsolutePath());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return directoryOperation;
    }

    public void addEventListener(ChannelEventListener channelEventListener) {
        this.sftp.addEventListener(channelEventListener);
    }

    private void recurseMarkForDeletion(SftpFile sftpFile, DirectoryOperation directoryOperation) throws IOException {
        List list = this.ls(sftpFile.getAbsolutePath());
        directoryOperation.addDeletedFile(sftpFile);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            sftpFile = (SftpFile)iterator.next();
            if (sftpFile.isDirectory() && !sftpFile.getFilename().equals(".") && !sftpFile.getFilename().equals("..")) {
                this.recurseMarkForDeletion(sftpFile, directoryOperation);
                continue;
            }
            if (!sftpFile.isFile()) continue;
            directoryOperation.addDeletedFile(sftpFile);
        }
    }

    private void recurseMarkForDeletion(File file, DirectoryOperation directoryOperation) throws IOException {
        File[] fileArray = file.listFiles();
        directoryOperation.addDeletedFile(file);
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                file = fileArray[n];
                if (file.isDirectory() && !file.getName().equals(".") && !file.getName().equals("..")) {
                    this.recurseMarkForDeletion(file, directoryOperation);
                } else if (file.isFile()) {
                    directoryOperation.addDeletedFile(file);
                }
                ++n;
            }
        }
    }

    public DirectoryOperation copyRemoteDirectory(String string, String string2, boolean bl, boolean bl2, boolean bl3, FileTransferProgress fileTransferProgress) throws IOException {
        Object object;
        File file;
        DirectoryOperation directoryOperation = new DirectoryOperation();
        String string3 = this.pwd();
        String string4 = this.lpwd();
        this.cd(string);
        String string5 = string;
        int n = string5.lastIndexOf(47);
        if (n != -1) {
            string5 = string5.substring(n + 1);
        }
        if (!(file = new File(string2, string5)).isAbsolute()) {
            file = new File(this.lpwd(), string2);
        }
        if (!file.exists() && bl3) {
            file.mkdir();
        }
        List list = this.ls();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            File file2;
            SftpFile sftpFile = (SftpFile)iterator.next();
            if (sftpFile.isDirectory() && !sftpFile.getFilename().equals(".") && !sftpFile.getFilename().equals("..")) {
                if (!bl) continue;
                file2 = new File(file, sftpFile.getFilename());
                directoryOperation.addDirectoryOperation(this.copyRemoteDirectory(sftpFile.getFilename(), file.getAbsolutePath(), bl, bl2, bl3, fileTransferProgress), file2);
                continue;
            }
            if (!sftpFile.isFile()) continue;
            file2 = new File(file, sftpFile.getFilename());
            if (file2.exists() && file2.length() == sftpFile.getAttributes().getSize().longValue() && file2.lastModified() / 1000L == sftpFile.getAttributes().getModifiedTime().longValue()) {
                if (bl3) {
                    directoryOperation.addUnchangedFile(file2);
                    continue;
                }
                directoryOperation.addUnchangedFile(sftpFile);
                continue;
            }
            if (file2.exists()) {
                if (bl3) {
                    directoryOperation.addUpdatedFile(file2);
                } else {
                    directoryOperation.addUpdatedFile(sftpFile);
                }
            } else if (bl3) {
                directoryOperation.addNewFile(file2);
            } else {
                directoryOperation.addNewFile(sftpFile);
            }
            if (!bl3) continue;
            object = this.get(sftpFile.getFilename(), file2.getAbsolutePath(), fileTransferProgress);
            file2.setLastModified(((FileAttributes)object).getModifiedTime().longValue() * 1000L);
        }
        if (bl2 && (object = file.listFiles()) != null) {
            int n2 = 0;
            while (n2 < ((File[])object).length) {
                if (!directoryOperation.containsFile(object[n2])) {
                    directoryOperation.addDeletedFile(object[n2]);
                    if (object[n2].isDirectory() && !object[n2].getName().equals(".") && !object[n2].getName().equals("..")) {
                        this.recurseMarkForDeletion((File)object[n2], directoryOperation);
                        if (bl3) {
                            IOUtil.recurseDeleteDirectory((File)object[n2]);
                        }
                    } else if (bl3) {
                        object[n2].delete();
                    }
                }
                ++n2;
            }
        }
        this.cd(string3);
        return directoryOperation;
    }
}

